<HTML>
<HEAD>
<TITLE>SRC Modula-3: sortedtable/src/SortedTable.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>sortedtable/src/SortedTable.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>SortedTable</CODE> is a generic interface defining partial maps over
   a totally ordered domain.
   \index{map!updatable}


<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="SortedTable.mg">SortedTable</A></genericInterface>(Key, Tbl);
</PRE><BLOCKQUOTE><EM> Where <CODE>Key.T</CODE> is not an open array type, <CODE>Tbl</CODE> is a generic
   instance <CODE>Table(Key, Value)</CODE> (for some <CODE>Value</CODE> defining a type
   <CODE>T</CODE> that is not an open array type), both <CODE>Key</CODE> and <CODE>Tbl</CODE> contain
<P>
<PRE>
      CONST Brand = &lt;text-constant&gt;;
</PRE>
   and <CODE>Key</CODE> additionally contains
<P>
<PRE>
      PROCEDURE Compare(k1, k2: Key.T): [-1..1];
</PRE>
   <CODE>Brand</CODE> must be a text constant. It will be used to construct a brand for
   the opaque type <CODE>SortedTable.Default</CODE> and any generic types instantiated
   with the <CODE>SortedTable</CODE> interface. For a non-generic interface, we recommend
   choosing the name of the interface.
<P>
   <CODE>Compare</CODE> must be a total order.
<P>
   <CODE>Compare</CODE> may be declared with a parameter mode of either <CODE>VALUE</CODE>
   or <CODE>READONLY</CODE>, but not <CODE>VAR</CODE>.
</EM></BLOCKQUOTE><PRE>

CONST
  Brand = &quot;(Sorted &quot; &amp; Tbl.Brand &amp; &quot;)&quot;;
  DefaultBrand = &quot;(Default &quot; &amp; Brand &amp; &quot;)&quot;;
  (* A &quot;SortedTable.Default&quot; is revealed to have the brand &quot;DefaultBrand&quot;. *)

TYPE
  T = Tbl.T OBJECT METHODS
    iterateOrdered(up: BOOLEAN := TRUE): Iterator
  END;
  Iterator = Tbl.Iterator OBJECT METHODS
    seek(READONLY key: Key.T)
  END;
  <A HREF="SortedTable.mg#Default">Default</A> &lt;: T OBJECT METHODS
    init(): Default;
    keyCompare(READONLY k1, k2: Key.T): [-1..1]
  END;
END SortedTable.
</PRE> A <CODE>SortedTable(Key, Table(Key, Value)).T</CODE>, or sorted table, is a
   <CODE>Table(Key, Value).T</CODE> together with a total (linear) order on the
   keys of the table.  Formally, a sorted table <CODE>tbl</CODE> has the
   additional component:
<P>
<PRE>
      le(tbl) <KBD>a total order on the values of </KBD>Key.T<KBD></KBD>
</PRE>
   The total order <CODE>le(tbl)</CODE> must be time-invariant.
<P>
   The methods have the following specifications: 
<P>
   The call <CODE>tbl.iterateOrdered(up)</CODE> returns an iterator, which is an
   object that can be used to iterate over all the key-value pairs in
   <CODE>tbl</CODE>, ordered by key.  The order is increasing if <CODE>up</CODE> is <CODE>TRUE</CODE>,
   decreasing otherwise.
<P>
   If <CODE>i</CODE> is the result of the call <CODE>tbl.iterateOrdered(up)</CODE>, then the
   call <CODE>i.next(k, v)</CODE> sets <CODE>k</CODE> and <CODE>v</CODE> to the key and value of the
   next pair and returns <CODE>TRUE</CODE>.  If no entries remain, the call
   returns <CODE>FALSE</CODE> without setting <CODE>k</CODE> or <CODE>v</CODE>.  It is a checked
   runtime error to call <CODE>next</CODE> or <CODE>seek</CODE> after <CODE>next</CODE> has returned
   <CODE>FALSE</CODE>.  The client must ensure that while an iterator is in use,
   the parent table is not modified.
   <P>
   The call <CODE>i.seek(k)</CODE> skips past zero or more key-value pairs
   (either forward or backward) so that a subsequent call of <CODE>next</CODE>
   returns the first pair with key greater than or equal to <CODE>k</CODE> if <CODE>i</CODE>
   is in increasing order or with key less than or equal to <CODE>k</CODE> if <CODE>i</CODE>
   is in decreasing order.
<P>
   The type <CODE>Default</CODE> is an implementation of <CODE>T</CODE> using randomized
   heap-ordered binary trees or ``treaps'' (see \cite{Aragon}).  In
   this implementation, seeking forward (relative to the iterator's
   order) is more efficient than seeking backward.  If a forward seek
   skips over <CODE>d</CODE> key-value pairs, the expected time for the seek is
   <CODE>O(log d)</CODE>.  The time for a backward seek is
   <CODE>O(log(table.size()))</CODE>, no matter how far back it skips.
<P>
   The call <CODE>dflt.init()</CODE> returns <CODE>dflt</CODE> after initializing it to an
   empty table.
<P>
   The call <CODE>dflt.keyCompare(k1, k2)</CODE> returns <CODE>Key.Compare(k1, k2)</CODE>.
   The other methods call <CODE>keyCompare</CODE> whenever they need to consult
   <CODE>le(tbl)</CODE>.  This means a subtype of <CODE>Default</CODE> can determine
   <CODE>le(tbl)</CODE> by overriding <CODE>keyCompare</CODE>, providing <CODE>keyCompare</CODE>
   implements a total order.
<P>
   For efficiency, sorted tables and their iterators are not
   monitored, so a client accessing a table from multiple threads must
   ensure that if two operations are active concurrently, then neither
   of them has side effects on the same table or iterator.  The
   <CODE>T.put</CODE>, <CODE>T.delete</CODE>, and <CODE>Default.init</CODE> methods are the only ones
   with side effects on the table.  An iterator's <CODE>next</CODE> method has
   side-effects on the iterator.
<P>


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
