<HTML>
<HEAD>
<TITLE>SRC Modula-3: sqrt/src/FloatExtras.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>sqrt/src/FloatExtras.mg</H2></A><HR>
<inModule>
<PRE></PRE><P>
     FloatExtras.mg
        Some useful routines for floating-point
        David Goldberg, Xerox PARC
        goldberg@parc.xerox.com
        November, 1993


<P> Copyright (c) 1993 Xerox Corporation.  All rights reserved.
<P>
   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. 

<P>
<P><PRE>GENERIC MODULE <genericModule><A HREF="FloatExtras.ig">FloatExtras</A></genericModule>(Real, Float);

IMPORT <A HREF="#x1">FloatMode</A>;
FROM <A HREF="#x1">FloatMode</A> IMPORT RoundingMode, Flag;

CONST
  Zero = FLOAT(0.0, T);
  One  = FLOAT(1.0, T);
  Two  = FLOAT(2.0, T);

PROCEDURE <A NAME="RaiseInvalid"><procedure>RaiseInvalid</procedure></A> (): T
  RAISES {FloatMode.Trap&lt;*NOWARN*&gt;} =
  BEGIN
    RETURN (ZeroFn() / ZeroFn());
  END RaiseInvalid;

PROCEDURE <A NAME="RaiseDivByZero"><procedure>RaiseDivByZero</procedure></A> (sign: [-1 .. 1]): T
  RAISES {FloatMode.Trap&lt;*NOWARN*&gt;} =
  BEGIN
    (* XXX: what if sign = 0? *)
    RETURN (FLOAT(sign, T) / ZeroFn());
  END RaiseDivByZero;
</PRE> reduce temptation to compiler to evaluate Inf and Nan at compile time 
<PRE>PROCEDURE <A NAME="ZeroFn"><procedure>ZeroFn</procedure></A> (): T =
  BEGIN
    RETURN (Zero);
  END ZeroFn;
</PRE><P>
 *  Should really call dec to binary for next two routines, since standard
 *  requires it to deliver NaN to trap handler when too large to wrap around
 
<PRE>PROCEDURE <A NAME="RaiseLargeOverflow"><procedure>RaiseLargeOverflow</procedure></A> (sign: [-1 .. 1] := 1): T
  RAISES {FloatMode.Trap} =
  BEGIN
    (*
     * In single precision, largest number that can be handled is
     * 1.111...  * 2^(maxexp + alpha) = 1.11...  * 2^(127 + 192) = 2^320
     *
     * In general, 2^(3*maxexp) is big enough.
     *)
    RETURN
      (FLOAT(sign, T) * Float.Scalb(One, 3 * Float.ILogb(Real.MaxFinite)));
  END RaiseLargeOverflow;

PROCEDURE <A NAME="RaiseLargeUnderflow"><procedure>RaiseLargeUnderflow</procedure></A> (sign: [-1 .. 1] := 1): T
  RAISES {FloatMode.Trap} =
  BEGIN
    RETURN (FLOAT(sign, T) * Float.Scalb(
              One, 3 * Float.ILogb(Real.MinPosNormal)));
  END RaiseLargeUnderflow;

PROCEDURE <A NAME="Round"><procedure>Round</procedure></A> (x: T): INTEGER =
  BEGIN
    CASE FloatMode.GetRounding() OF
    | RoundingMode.TowardMinusInfinity =&gt; RETURN (FLOOR(x));
    | RoundingMode.TowardPlusInfinity  =&gt; RETURN (CEILING(x));
    | RoundingMode.TowardZero          =&gt; RETURN (TRUNC(x));
    | RoundingMode.NearestElseEven,
      RoundingMode.NearestElseAwayFromZero, (*== VAX*)
      RoundingMode.IBM370,
      RoundingMode.Other               =&gt; RETURN (ROUND(x));
    END;
  END Round;

PROCEDURE <A NAME="SetBehaviors"><procedure>SetBehaviors</procedure></A> (f: SET OF Flag; b: FloatMode.Behavior)
  RAISES {FloatMode.Failure} =
  BEGIN
    FOR i := FIRST(Flag) TO LAST(Flag) DO
      IF i IN f THEN FloatMode.SetBehavior(i, b); END;
    END;
  END SetBehaviors;
</PRE><P>
 * this should be implemented in terms of machine-dependent primitives,
 * to be more efficient.
 
<PRE>PROCEDURE <A NAME="SetFlag"><procedure>SetFlag</procedure></A> (f: FloatMode.Flag) RAISES {FloatMode.Failure} =
  BEGIN
    WITH flgs = FloatMode.GetFlags() DO
      IF NOT f IN flgs THEN
        EVAL FloatMode.SetFlags(flgs + SET OF FloatMode.Flag{f});
      END;
    END
  END SetFlag;

PROCEDURE <A NAME="ToBinary"><procedure>ToBinary</procedure></A> (x: T): Binary RAISES {FloatMode.Trap} =
  VAR
    res: Binary;
    v  : T;
    buf: ARRAY [0 .. 55] OF [0 .. 1];
    i  : CARDINAL := 0;
  BEGIN
    IF x = Zero THEN
      res.exp := 0;
      res.bits := NEW(REF ARRAY OF [0 .. 1], 1);
      res.bits[0] := 0;
    ELSE
      res.exp := Float.ILogb(x);
      v := Float.Scalb(ABS(x), -res.exp);
      WHILE v # Zero DO
        IF v &gt;= One THEN buf[i] := 1; v := v - One; ELSE buf[i] := 0; END;
        INC(i);
        v := Two * v;
      END;
      res.bits := NEW(REF ARRAY OF [0 .. 1], i);
      res.bits^ := SUBARRAY(buf, 0, i);
    END;
    RETURN res;
  END ToBinary;

BEGIN
END FloatExtras.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
