<HTML>
<HEAD>
<TITLE>SRC Modula-3: stable/src/Log.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>stable/src/Log.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> Created by Carsten Weich                                    
                                                             

<P> This is for mere debugging purposes: Do some printout so that one
   can see what the program is doing.
<P>
   There are several levels of logging: Everything with a less or lower lev-
   parameter than the global 'level'-variable will be printed.
   Use 'Log.level:= 0' to switch off logging 

<P><PRE>INTERFACE <interface><A HREF="Log.m3">Log</A></interface>;

PROCEDURE <A HREF="Log.m3#InProc">InProc</A>(name: TEXT; lev:= 1);
  (* Write out something to indicate that program is in procedure 'name'
     the following output will be intendet by a few spaces (so use Nl()!) *)

PROCEDURE <A HREF="Log.m3#ExitProc">ExitProc</A>(comment: TEXT:= &quot;&quot;; lev:= 1);
  (* This is merely to end the indentation started by 'InProc'. 'comment'
     will be printed out (perhaps to specify the exit point if the procedure
     has several RETURN-statements) *)

PROCEDURE <A HREF="Log.m3#PutText">PutText</A>(t: TEXT; lev:= 1);
  (* Write out a text string *)

PROCEDURE <A HREF="Log.m3#PutInt">PutInt</A>(i: INTEGER; lev:= 1);
  (* Write out an integer *)

PROCEDURE <A HREF="Log.m3#Nl">Nl</A>(lev:= 1);
  (* Make a newline on output *)

PROCEDURE <A HREF="Log.m3#Separate">Separate</A>(lev:= 1);
  (* Write out some space or horizontal line *)
</PRE> Crash-Simulation 

<P><PRE>VAR crash:= 0;
</PRE><BLOCKQUOTE><EM> set to a number to crash at a certain point in the program </EM></BLOCKQUOTE><PRE>
  PROCEDURE <A HREF="Log.m3#CrashPoint">CrashPoint</A>(nr: INTEGER);
</PRE><BLOCKQUOTE><EM> Halts the program (uses Unix.exit) if <CODE>nr=crash</CODE>. </EM></BLOCKQUOTE><PRE>

VAR
  level:= 1;           (* default is to do logging *)
  linestart:= &quot;&gt; &quot;;    (* every logging line will start with this characters
			  in order to distiguish logging information from
			  program output *)
END Log.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
