<HTML>
<HEAD>
<TITLE>SRC Modula-3: stable/src/Log.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>stable/src/Log.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> Created by Carsten Weich                                    
                                                             

<P> This is for mere debugging purposes: Do some printout so that one
   can see what the program is doing.
<P>
   There are several levels of logging: Everything with a less or lower lev-
   parameter than the global 'level'-variable will be printed.
   Use 'Log.level:= 0' to switch off logging 

<P><PRE>MODULE <module><implements><A HREF="Log.i3">Log</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="#x1">Unix</A>;
FROM <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A> IMPORT stdout;

&lt;*FATAL Wr.Failure, Thread.Alerted*&gt;

CONST indent = &quot;  &quot;;		(* Text used for each level of indentation *)
VAR proccount: CARDINAL:= 0;	(* indendation-level (set by 'In/ExitProc') *)
  first:= TRUE;			(* first to write into a new line *)

PROCEDURE <A NAME="InProc"><procedure>InProc</procedure></A>(name: TEXT; lev:= 1) =
  BEGIN
    IF lev &lt;= level THEN
      PutText(&quot;------- &quot;&amp;name&amp;&quot;-----------&quot;);
      INC(proccount);
      Nl(lev:=lev);
    END (*IF*)
  END InProc;

PROCEDURE <A NAME="ExitProc"><procedure>ExitProc</procedure></A>(comment: TEXT:= &quot;&quot;; lev:= 1) =
  BEGIN
    IF lev &lt;= level THEN
      DEC(proccount);
      PutText(&quot;------- &quot;&amp;comment);
      Nl(lev:= lev);
    END (*IF*)
  END ExitProc;

PROCEDURE <A NAME="PutText"><procedure>PutText</procedure></A>(t: TEXT; lev:= 1) =
  BEGIN
    IF lev &lt;= level THEN
      IF first THEN
	first:= FALSE;
        Wr.PutText(stdout, linestart);
        FOR i:= 1 TO proccount DO Wr.PutText(stdout, indent) END;
      END; (*IF*)
      Wr.PutText(stdout, t); Wr.Flush(stdout);
    END (*IF*)
  END PutText;

PROCEDURE <A NAME="PutInt"><procedure>PutInt</procedure></A>(i: INTEGER; lev:= 1) =
  BEGIN
    IF lev &lt;= level THEN
      PutText(Fmt.Int(i));
    END (*IF*)
  END PutInt;

PROCEDURE <A NAME="Nl"><procedure>Nl</procedure></A>(lev:= 1) =
  BEGIN
    IF lev &lt;= level THEN
      Wr.PutText(stdout, &quot;\n&quot;); Wr.Flush(stdout);
      first:= TRUE;
    END (*IF*)
  END Nl;

PROCEDURE <A NAME="Separate"><procedure>Separate</procedure></A>(lev:= 1) =
  BEGIN
    IF lev &lt;= level THEN
      Nl(lev:= lev);
      Wr.PutText(stdout, &quot;------------------&quot;);
      Nl(lev:= lev);
    END (*IF*)
  END Separate;

PROCEDURE <A NAME="CrashPoint"><procedure>CrashPoint</procedure></A>(nr: INTEGER) =
  BEGIN
    IF crash = nr THEN
      PutText(&quot;crash-point &quot;); PutInt(nr); PutText(&quot; reached&quot;); Nl();
      Unix.exit(nr);
    END;
  END CrashPoint;

BEGIN
  level := 0
END Log.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Unix is in:
</A><UL>
<LI><A HREF="../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
