<HTML>
<HEAD>
<TITLE>SRC Modula-3: stable/src/LogManager.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>stable/src/LogManager.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> Created by Carsten Weich and Greg Nelson                    
                                                             

<P> A <CODE>LogManager</CODE> provides an object which manages readers and writers
   for the log and checkpoint files used by stable objects.
<P>
   The default log manager stores the stable state in the file system.
   Since the default is satisfactory for most applications, 
   most clients of stable objects don't need to use the LogManager 
   interface directly.  
   <P>
   A situation in which you might want to use this interface is 
   if you want to test whether a checkpoint is available before initializing 
   a stable object.  In this case the <CODE>recoverable</CODE> method of the 
   log manager will be useful to you.  As another example, if you 
   don't want to use the file system for storing the stable state, 
   you will need to study the specifications in this interface and 
   implement your own log manager that stores the stable state in 
   your preferred form of stable storage.  

<P><PRE>INTERFACE <interface><A HREF="LogManager.m3">LogManager</A></interface>;

  IMPORT <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>;

  TYPE <A HREF="LogManager.m3#T">T</A> &lt;: Public;

    Public = OBJECT METHODS
        beginCheckpoint(nm: Pathname.T): Wr.T (* new checkpoint *)
            RAISES {OSError.E};
        endCheckpoint(nm: Pathname.T):Wr.T (* new log *)
            RAISES {OSError.E};
        reOpenLog(nm: Pathname.T): Wr.T RAISES {OSError.E};
        recover(nm: Pathname.T; VAR log, checkp: Rd.T)
            RAISES {OSError.E};
        recoverable(nm: Pathname.T): BOOLEAN
            RAISES {OSError.E};
        emptyLog(nm: Pathname.T): BOOLEAN
            RAISES {OSError.E};
        dispose(nm: Pathname.T)
            RAISES {OSError.E};
      END;

    DefaultPublic = T OBJECT METHODS init(): Default END;
    <A HREF="LogManager.m3#Default">Default</A> &lt;: DefaultPublic;

    VAR default: Default;

END LogManager.
</PRE> A <CODE>LogManager.T</CODE> manages a repository of named stable snapshots. 
   A snapshot consists of two sequences of bytes, a {\it checkpoint} 
   and a {\it redo log}.  The repository must be stable; that is, 
   it must survive program crashes.  Here are specifications for 
   the methods of a <CODE>LogManager.T</CODE> named <CODE>lm</CODE>: 
<P>
   The  <CODE>beginCheckpoint</CODE> and <CODE>endCheckpoint</CODE> methods are
   used to write a new stable snapshot.  The call
<P>
<PRE>
      lm.beginCheckpoint(nm)
</PRE>
   returns a writer whose target is the checkpoint named <CODE>nm</CODE>
   in <CODE>lm</CODE>'s repository.  The call
<P>
<PRE>
       lm.endCheckpoint(nm)
</PRE>
   should be made only after a previous call to <CODE>lm.beginCheckpoint(nm)</CODE>. 
   The <CODE>endCheckpoint</CODE> method commits the bytes that have been written 
   to the writer that was returned by <CODE>beginCheckpoint</CODE>, making them 
   become the new checkpoint. The <CODE>endCheckpoint</CODE> method also empties 
   the redo log and returns a writer that can be used to extend 
   the now-empty redo log. 
<P>
   Therefore, to make a new checkpoint, you should execute the following 
   steps: 
<P>
<PRE>
      wr1 := lm.beginCheckpoint(nm);
      <KBD>write a new checkpoint to </KBD> wr1;
      wr2 := lm.endCheckpoint(nm);
      <KBD>new checkpoint is made; log updates to </KBD> wr2
</PRE>
   If the application exits or crashes before the call to <CODE>endCheckpoint</CODE>, 
   any bytes written to <CODE>wr1</CODE> will be discarded, and the previous 
   checkpoint will not be changed.  (Of course these steps are performed
   by the <CODE>Checkpoint</CODE> procedure in the generic <CODE>Stable</CODE> interface, so
   there is no reason for the typical client of stable objects to
   recode this procedure.  But if you are implementing your own
   log managers, it is important to know how the methods will
   be used by your clients.)
<P>
   An application may close the writer returned by <CODE>endCheckpoint</CODE> 
   (for example, to free up file descriptors or other resources associated 
   with inactive stable objects).  If this writer has been closed, 
   the call 
<P>
<PRE>
      lm.reopenLog(nm)
</PRE>
   will return a writer which will append to the current redo
   log.  
<P>
   The call
<P>
<PRE>
      lm.recoverable(nm)
</PRE>
   returns <CODE>TRUE</CODE> if and only if the repository managed by <CODE>lm</CODE> contains 
   a snapshot named <CODE>nm</CODE>. 
<P>
   The call
<P>
<PRE>
      lm.emptyLog(nm)
</PRE>
   returns <CODE>TRUE</CODE> if and only if the repository managed by <CODE>lm</CODE> contains 
   a snapshot <CODE>nm</CODE> which has an empty log. The log will be empty if the
    program that created a stable object did a checkpoint right
    before terminating. A non empty log might indicate a crashed program.
    <CODE>emptyLog()</CODE> will raise the exception if there is no snapshot <CODE>nm</CODE>.
<P>
   The call
<P>
<PRE>
      lm.recover(nm, cprd, logrd)
</PRE>
   sets <CODE>cprd</CODE> and <CODE>logrd</CODE> to readers whose sources are the
   checkpoint and redo log named <CODE>nm</CODE>, respectively, assuming
   a snapshot exists under that name in the repository managed
   by <CODE>lm</CODE>.
<P>
   The call
<P>
<PRE>
      lm.dispose(nm)
</PRE>
   discards any snapshot named <CODE>nm</CODE> from <CODE>lm</CODE>'s repository and
   reclaims any associated stable storage.
<P>
So much for the methods of a general <CODE>LogManager.T</CODE>.  Almost all
clients will use a <CODE>LogManager.Default</CODE>, which uses the
ordinary file system as its source of stable storage.
A <CODE>LogManager.Default</CODE> must be initialized by the client;
to obtain one, call
<P>
<PRE>
      VAR lm := NEW(LogManager.Default).init(); ...
</PRE>
The methods of a <CODE>LogManager.Default</CODE> interpret <CODE>nm</CODE> as a directory 
in the file system, in which they expects to find files containing a
checkpoint and log.  The <CODE>beginCheckpoint</CODE> method will create the
directory if necessary.  File renaming is used to make checkpoint
atomic with respect to crashes.
<P>
The variable <CODE>LogManager.default</CODE> is initialized by the
<CODE>LogManager</CODE> module to a valid <CODE>LogManager.Default</CODE>.
<P>


<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
