<HTML>
<HEAD>
<TITLE>SRC Modula-3: stable/src/Stable.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>stable/src/Stable.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> Created by Carsten Weich and Greg Nelson                    
                                                             

<P>  A {\it stable object} is an object whose state is stored on the disk
    or other medium whence its state can be recovered if a program crashes.
    <P>
    The generic interface <CODE>Stable</CODE> defines a subtype of a given object
    type that is just like that object type, but stable.  The generic
    argument to <CODE>Stable</CODE> is an interface named <CODE>Data</CODE>, which is
    assumed to contain an object type named <CODE>Data.T</CODE>.  Thus the type
    <CODE>Stable(Data).T</CODE> is like a <CODE>Data.T</CODE>, but stable.  In case of a
    failure (of either the program or the system) such objects can
    recover by resuming their last recorded state.
<P>
    The state of a stable object is stored as a checkpoint together 
    with a redo log; the log contains entries for all updates performed 
    since the last checkpoint. These updates are recorded by logging 
    a number identifying an update method, together with the arguments 
    of the method. The typical cost for an update is therefore on 
    the order of the cost of a single disk write. 
<P>
    In order to keep the redo log from growing without bound (which 
    would cause the recovery time to grow without bound), it is necessary 
    to periodically write a new checkpoint.  While writing a new 
    checkpoint the data structure is unavailable for updating.  As 
    a client of the <CODE>Stable</CODE> package, you can control how often checkpoints 
    are made. 
    <P>
    The strategy used by the <CODE>Stable</CODE> package is described more fully 
    by Andrew D. Birrell, Michael B. Jones, and Edward P. Wobber 
    in ``A simple and efficient implementation for small databases'', 
    {\it Proceedings of the 11th ACM Symposium on Operating System 
    Principles}.  This paper is also available as SRC Research Report 
    24, January 1988. 
<P>
    The stable stub generator <CODE>stablegen</CODE> will automatically produce 
    an implementation of any generic instance <CODE>Stable(Data)</CODE>. The 
    default implementation produced by <CODE>stablegen</CODE> reads and writes 
    checkpoints using the pickles package, and  reads and writes 
    the redo log using the same marshaling mechanism as the network 
    objects stub generator (<CODE>stubgen</CODE>).  This is suitable for many 
    applications, but not for all.  The comments at the end of the 
    interface explain how to customize the behavior of the stable 
    package in several different ways.  
<P>
    The initialization method for a stable object will reset it to 
    the stable state, if the stable state is present; otherwise the 
    method creates and initializes the stable state. 
 <P>
    By default, the stable state (checkpoint and log) for an object 
    is stored in a directory in the ordinary file system.  It is 
    possible to override this default.  For example, in a system 
    that contains some form of stable random access memeory, it may 
    be preferable for reasons of speed to keep the stable data in 
    the stable RAM instead of on the disk.  This flexibility is provided 
    by an abstraction called a <CODE>LogManager</CODE>, which is basically an 
    object that provides streams for logs and checkpoints.  A <CODE>LogManager</CODE> 
    may be provided when a stable object is initialized; if omitted, 
    the default log manager is used, which stores the log and checkpoint 
    in the ordinary file system. See <CODE>LogManager.i3</CODE> for details. 
<P>
    The stub generator produces overrides for all update methods 
    of the stable object. The override method writes its parameters 
    together with a method number to the log, and then calls the 
    corresponding method of its supertype.  Finally they write an 
    additional <CODE>commit</CODE> record to the log to record that the method 
    terminated. (If a crash occurs while the method is running, the 
    commit record will not be present and the call that crashed will 
    not be repeated during recovery.) 
    <P>
    The recovery process is started by <CODE>init</CODE> if a stable 
    backup is found for the object being initialized.    To recover, 
    the log manager is used to obtain a reader on the checkpoint, 
    the <CODE>readCheckpoint</CODE> method of the object is used to reconstruct 
    an object from the checkpoint.  The log manager is also used 
    to obtain a reader on the redo log.  The entries in the redo 
    log are read, and the recorded updates are replayed.  Any returned 
    values or exceptions from these methods are ignored. If update 
    methods use <CODE>VAR</CODE> parameters, the recovery procedure will pass 
    dummies to them that contain the same values the originally passed 
    variables had. Notice that if an update method reads or writes 
    any state other that the fields of the stable object itself, 
    the recovery process may not work as expected. 
    <P>
    A <CODE>Stable(Data).T</CODE> is unmonitored. The client is responsible 
    for ensuring that it is not updated concurrently nor updated 
    while a checkpoint is written.  Clients are also responsible to 
    write checkpoints periodically by calling the <CODE>Checkpoint()</CODE> 
    procedure. 


<P><PRE>GENERIC INTERFACE <genericInterface>Stable</genericInterface>(Data);
</PRE> Where <CODE>Data.T</CODE> is an object type.  Also, the <CODE>Data</CODE> interface should
contain a pragma indicating which methods of <CODE>Data.T</CODE> are update methods,
as explained in the man page for the stub generator <CODE>stablegen</CODE>. 

<P><PRE>IMPORT <A HREF="LogManager.i3">LogManager</A>, <A HREF="StableError.i3">StableError</A>, <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>;

CONST
  Brand = &quot;(Stable&quot; &amp; Data.Brand &amp; &quot;)&quot;;
  DefaultBrand = &quot;(Default &quot; &amp; Brand &amp; &quot;)&quot;;
</PRE><BLOCKQUOTE><EM> This branding is required for all generic interfaces.
   The Data interface must contain:
<P>
<PRE>
      CONST Brand = &lt;text-constant&gt;;
</PRE>
</EM></BLOCKQUOTE><PRE>

TYPE T &lt;: Public;
     Public = Data.T OBJECT METHODS
        init(nm: Pathname.T; VAR recovered: BOOLEAN;
            forceToDisk := TRUE; lm: LogManager.T := NIL): T
            RAISES {StableError.E};
        dispose() RAISES {StableError.E};
        flushLog()  RAISES {StableError.E};
        freeLog() RAISES {StableError.E};
        writeCheckpoint (wr: Wr.T) RAISES {StableError.E};
        readCheckpoint (rd: Rd.T): T RAISES {StableError.E};
     END;
</PRE> The call <CODE>st.init(nm, recovered, forceToDisk, lm)</CODE> makes the
   object <CODE>st</CODE> stable, with stable state stored by the log manager
   <CODE>lm</CODE> under the name <CODE>nm</CODE>.  If this stable state is present
   when <CODE>init</CODE> is called, then recovery is initiated,
   <CODE>recovered</CODE> is set to <CODE>TRUE</CODE>, and the recovered object is
   returned.  Otherwise, the state of <CODE>st</CODE> is recorded stably
   and <CODE>st</CODE> itself is returned.  It is a runtime error to call
   <CODE>st.init</CODE> twice without an intervening <CODE>st.dispose</CODE> (see below).
<P>
   If <CODE>forceToDisk</CODE> is <CODE>TRUE</CODE>, the log will be flushed after
   every update method.  If <CODE>forceToDisk</CODE> is false, the
   log will be flushed only when the client calls the <CODE>flushLog</CODE>
   method.  Leaving <CODE>forceToDisk</CODE> false is more efficient, but
   if <CODE>forceToDisk</CODE> is false and <CODE>flushLog</CODE> is not called
   frequently, recovery may fail to replay some update
   methods.  The number of lost updates depends on how much
   buffering is performed by the log manager.
<P>
   If <CODE>lm</CODE> is <CODE>NIL</CODE>, then the file system log manager is used.
   This means that <CODE>nm</CODE> is interpreted as the name of a file
   system directory, in which the stable state is stored as
   a checkpoint and redo log file. 
   <P>
   The method call <CODE>st.freeLog()</CODE> closes the log writer for <CODE>st</CODE>.  
   The log will be reopened by the next call to an update method. 
   Freeing the log might be necessary, for example, to prevent running 
   out of file descriptors if many stable objects are allocated but 
   few are active at once. 
   <P>
   The <CODE>readcheckpoint</CODE> method must reconstruct a data structure
   equivalent to the one written by <CODE>writecheckpoint</CODE>.  By default, 
   both of these methods use pickles, but you can override them if 
   you want to. 
   <P>
   The call <CODE>st.dispose()</CODE> deletes the stable state of <CODE>st</CODE>.  It
   should be called when stability for <CODE>st</CODE> is no longer desired. 
   The stability of an object and modifications to its state are
   orthogonal.  That is, update methods may be called after
   a call to <CODE>st.dispose.</CODE> 


<P><PRE>PROCEDURE Checkpoint(t: T) RAISES {StableError.E};
</PRE><BLOCKQUOTE><EM> Write a new checkpoint for <CODE>t</CODE> and empty its redo log. </EM></BLOCKQUOTE><PRE>
</PRE> You are responsible for calling <CODE>Checkpoint</CODE> periodically, to
   prevent the redo log from growing without bound.
   It is a runtime error to call <CODE>Checkpoint</CODE> after calling
   <CODE>st.dispose,</CODE> unless the object has subsequently been restabilized 
   with <CODE>st.init.</CODE>


<P><PRE>END Stable.
</PRE> \subsection{Exceptions}
   The <CODE>StableError.E</CODE> exception is raised in various circumstances.  The first
   element of the <CODE>AtomList.T</CODE> argument identifies the nature of the
   error.  Subsequent elements may identify further details of the
   error, especially in the case when lower-level exceptions are
   propagated by the <CODE>Stable</CODE> package. 
   <P>
<P>
\subsection{Customizations}
    \begin{itemize}
    \item  If you don't want every update to be flushed
                 to disk, set <CODE>forceToDisk</CODE> to <CODE>FALSE</CODE> when initializing the
                 stable object, and flush the log
                 manually with the <CODE>flushLog</CODE> method.
    \item  If you don't want to use <CODE>Pickle</CODE> for checkpointing, override
                 the <CODE>writeCheckpoint()</CODE> and <CODE>readCheckpoint()</CODE> methods of the stable
                 object to read and write checkpoints in your preferred format.
                 (If you are aiming at long-lived persistent state you should
                 avoid pickles, since new versions of the Modula-3 system can't always  
                 read pickles written by earlier versions.)
    \item  If you don't want to store the stable state in the ordinary file system, 
                 implement your own log manager (as explained in the <CODE>LogManager</CODE> interface)
                 and pass your own manager to the <CODE>init</CODE> method instead of the default.
    \item  If you don't want to use network-object style marshaling for recording
                 the update method calls in the redo log, you will have to write
                 you own implementation of of <CODE>Stable(Data).m3</CODE> instead of using the
                 stub generator <CODE>stablegen</CODE>.   (You may still find it
                 helpful to use the generated code as starting point.)
    \end{itemize}


<P>
<P>
<P>
<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
