<HTML>
<HEAD>
<TITLE>SRC Modula-3: stable/src/StableLog.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>stable/src/StableLog.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> Created by Carsten Weich                                    
                                                             

<P> This interface contains procedures for reading and writing logs
    for stable objects. Logs are written on <CODE>Wr.T</CODE>'s and read from <CODE>Rd.T</CODE>'s.
<P>
    To log procedures (methods usually) first <CODE>OutCall()</CODE> has to
    be called to log that the method identified by a <CODE>CARDINAL</CODE> code
    was called in the program. Afterwards the parameters of the
    method are logged by calling the corresponding <CODE>Out[Type]()</CODE>
    procedures of this interface. Now the method itself has to be
    called. If it returned (with or without exceptions),
    <CODE>OutCallEndMark()</CODE> has to be called to log the termination. 
<P>
    To recover, the analogous log reading procedures of this interface
    are called: First <CODE>InCall()</CODE> gets the code of the logged
    method followed by (possibly more than one) <CODE>In[Type]()</CODE> 
    to get the parameter values
    with which the method was originally called. Afterwards a call to
    <CODE>CheckCallEndMark()</CODE> checks wether the logged method
    terminated normally. If so, the recovery-procedure calls
    the logged method with the parameters just read. If not, the
    recovery procedure terminates (since this must be the
    end of the log).
<P>
   \paragraph{Exceptions}
   Reading something that does not correspond to the requested
   type or reading beyond the end of file is reported as exception
   <CODE>Error</CODE>. This might indicate a protocol error or just that the
   logged program was interrupted during writing the log.
   Any other reading exceptions cause a <CODE>StableError.Halt()</CODE>.
<P>
   There are no writing procedures exceptions
   since there can be no code to handle them. These procedures
   are called inside generated procedures which can not pass them
   nor handle them in a meaningful way. Thus all exceptions lead
   to a <CODE>StableError.Halt</CODE>.


<P><PRE>INTERFACE <interface><A HREF="StableLog.m3">StableLog</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

EXCEPTION Error;

PROCEDURE <A HREF="StableLog.m3#OutCall">OutCall</A>(log: Wr.T; procId: CARDINAL);
</PRE><BLOCKQUOTE><EM> Mark the beginning of a logged procedure-call. Procedures are
     identified by positive numbers (probably enumeration codes).
<P>
    <CODE>OutCall()</CODE> has to be called {\em before} logging the procedure 
    parameters. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutCallEndMark">OutCallEndMark</A>(log: Wr.T);
</PRE><BLOCKQUOTE><EM> Marks the successful completion of a logged procedure. Without
    this mark a call to a procedure is seen as unsuccessful. Such
    calls mark a possible end of a log, they will not be repeated on
    recoveries. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InCall">InCall</A>(log: Rd.T; max: CARDINAL): CARDINAL
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Read a procedure code as written with <CODE>OutCall()</CODE> from the
   log. Exception <CODE>Error</CODE> is raised if the number is greater than
   <CODE>max</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#CheckCallEndMark">CheckCallEndMark</A>(log: Rd.T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Check if the successful end of the call to a procedures was logged.
    Return <CODE>TRUE</CODE>, if so. Return of <CODE>FALSE</CODE> marks the end of a
    logfile (the call to the procedure which parameters were just read
    was not finished) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutRef">OutRef</A>(log: Wr.T; r: REFANY);
</PRE><BLOCKQUOTE><EM> Marshal the data structure reachable from <CODE>r</CODE> and write it to the log. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InRef">InRef</A>(log: Rd.T): REFANY RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal a marshaled subtype of <CODE>REFANY</CODE> as pickled by <CODE>OutRef</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection*{Procedures for generic parameters logging} 

<P><PRE>PROCEDURE <A HREF="StableLog.m3#OutChar">OutChar</A>(log: Wr.T; c: CHAR);
</PRE><BLOCKQUOTE><EM> Marshal a char </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutChars">OutChars</A>(
    log: Wr.T; READONLY chars: ARRAY OF CHAR);
</PRE><BLOCKQUOTE><EM> Marshal a char array in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutInteger">OutInteger</A>(log: Wr.T; i: INTEGER);
</PRE><BLOCKQUOTE><EM> Marshal an integer. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutCardinal">OutCardinal</A>(log: Wr.T; card: CARDINAL);
</PRE><BLOCKQUOTE><EM> Marshal a cardinal. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutBoolean">OutBoolean</A>(log: Wr.T; bool: BOOLEAN);
</PRE><BLOCKQUOTE><EM> Marshal a boolean value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutReal">OutReal</A>(log: Wr.T; r: REAL);
</PRE><BLOCKQUOTE><EM> Marshal a real in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutLongreal">OutLongreal</A>(log: Wr.T; d: LONGREAL);
</PRE><BLOCKQUOTE><EM> Marshal a longreal in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#OutExtended">OutExtended</A>(log: Wr.T; x: EXTENDED);
</PRE><BLOCKQUOTE><EM> Marshal an extended in native format. </EM></BLOCKQUOTE><PRE>
</PRE> \paragraph{Logreading procedures} \  

<P><PRE>PROCEDURE <A HREF="StableLog.m3#InChar">InChar</A>(log: Rd.T): CHAR
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal a char. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InCharsLen">InCharsLen</A>(log: Rd.T): CARDINAL
    RAISES {Error};
PROCEDURE <A HREF="StableLog.m3#InChars">InChars</A>(
    log: Rd.T; VAR chars: ARRAY OF CHAR)
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal a char array. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InInteger">InInteger</A>(
    log: Rd.T;
    min := FIRST(INTEGER);
    max := LAST(INTEGER)): INTEGER
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal an integer, checking that its value is in  <CODE>[min..max]</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InCardinal">InCardinal</A>(
    log: Rd.T; lim: CARDINAL := LAST(CARDINAL)): CARDINAL
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal a cardinal, checking that its value is in <CODE>[0..lim]</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InBoolean">InBoolean</A>(log: Rd.T): BOOLEAN
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal a boolean value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InReal">InReal</A>(log: Rd.T): REAL
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal a real value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InLongreal">InLongreal</A>(log: Rd.T): LONGREAL
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal a longreal value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableLog.m3#InExtended">InExtended</A>(log: Rd.T): EXTENDED
    RAISES {Error};
</PRE><BLOCKQUOTE><EM> Unmarshal an extended value. </EM></BLOCKQUOTE><PRE>

END StableLog.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
