<HTML>
<HEAD>
<TITLE>SRC Modula-3: stable/src/StableLog.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>stable/src/StableLog.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> Created by Carsten Weich                                    
                                                             

<P><PRE>UNSAFE MODULE <module><implements><A HREF="StableLog.i3">StableLog</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../rw/src/Common/WrClass.i3">WrClass</A>, <A HREF="../../rw/src/Common/RdClass.i3">RdClass</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../text/src/TextF.i3">TextF</A>,
       <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../pickle/src/Pickle.i3">Pickle</A>,
       <A HREF="StableError.i3">StableError</A>, <A HREF="../../rw/src/Common/RdUtils.i3">RdUtils</A>, <A HREF="../../word/src/Word.i3">Word</A>;

REVEAL
  WrClass.Private &lt;: MUTEX;
  RdClass.Private &lt;: MUTEX;

&lt;*FATAL Thread.Alerted*&gt;

CONST
  CallMark     = 27353;  (* this is Gregs birthday... *)
  EndCallMark  = 30965;  (* ...Carstens birthday...*)

  Mtext        = ORD('t');
  Mpickle      = ORD('P');

PROCEDURE <A NAME="OutCall"><procedure>OutCall</procedure></A> (log: Wr.T; procId: CARDINAL) =
  BEGIN
    OutInteger(log, CallMark);
    OutInteger(log, procId)
  END OutCall;

PROCEDURE <A NAME="OutCallEndMark"><procedure>OutCallEndMark</procedure></A> (log: Wr.T) =
  BEGIN
    OutInteger(log, EndCallMark)
  END OutCallEndMark;

PROCEDURE <A NAME="InCall"><procedure>InCall</procedure></A> (log: Rd.T; max: CARDINAL): CARDINAL RAISES {Error} =
  BEGIN
    IF InInteger(log) # CallMark THEN RAISE Error END;
    VAR res:= InInteger(log); BEGIN
      IF res &gt; max OR res &lt; 0 THEN RAISE Error END;
      RETURN res
    END
  END InCall;

PROCEDURE <A NAME="CheckCallEndMark"><procedure>CheckCallEndMark</procedure></A> (log: Rd.T): BOOLEAN =
  BEGIN
    TRY
      RETURN EndCallMark = InInteger(log)
    EXCEPT
      Error =&gt; RETURN FALSE
    END
  END CheckCallEndMark;

PROCEDURE <A NAME="OutRef"><procedure>OutRef</procedure></A>(log: Wr.T; r: REFANY) =
  BEGIN
    TYPECASE r OF
    | TEXT(x) =&gt; OutInteger(log, Mtext); OutText(log, x);
    ELSE
      TRY
        OutInteger(log, Mpickle);
        Pickle.Write(log, r)
      EXCEPT
        Wr.Failure (err) =&gt;
        StableError.Halt(
            &quot;Cannot write to logfile: &quot; &amp; RdUtils.FailureText(err))
      | Pickle.Error (msg) =&gt;
        StableError.Halt(&quot;Cannot write to logfile: Pickle error: &quot; &amp; msg)
      END
    END
  END OutRef;

PROCEDURE <A NAME="InRef"><procedure>InRef</procedure></A>(log: Rd.T): REFANY RAISES {Error} =
  VAR r: REFANY;
      code:= InInteger(log);
  BEGIN
    IF code = Mpickle THEN
      TRY
        r:= Pickle.Read(log)
      EXCEPT
      | Pickle.Error, Rd.EndOfFile =&gt; RAISE Error
      | Rd.Failure (err) =&gt;
        StableError.Halt(
            &quot;Can not read log file: &quot; &amp; RdUtils.FailureText(err))
      END
    ELSIF code = Mtext THEN
      r:= InText(log)
    ELSE
      RAISE Error
    END;
    RETURN r
  END InRef;
</PRE> Procedures for generic logging of procedure parameters 

<P><PRE>PROCEDURE <A NAME="OutChar"><procedure>OutChar</procedure></A> (log: Wr.T; c: CHAR) =
  BEGIN
    TRY
      Wr.PutChar(log, c)
    EXCEPT
      Wr.Failure (err) =&gt;
        StableError.Halt(
          &quot;Cannot write to logfile: &quot; &amp; RdUtils.FailureText(err))
    END
  END OutChar;

PROCEDURE <A NAME="OutChars"><procedure>OutChars</procedure></A> (log: Wr.T; READONLY chars: ARRAY OF CHAR) =
  VAR n:= NUMBER(chars) - NUMBER(chars) MOD BYTESIZE(Word.T);
  BEGIN
    TRY
      Wr.PutString(log, SUBARRAY(chars, 0, n));
      FOR i:= n TO LAST(chars) DO
        Wr.PutChar(log, chars[i])
      END
    EXCEPT
      Wr.Failure (err) =&gt;
        StableError.Halt(
          &quot;Cannot write to logfile: &quot; &amp; RdUtils.FailureText(err))
    END
  END OutChars;
</PRE> <CODE>OutInteger(log, i)</CODE> skips to the next word aligned byte in log,
   and then stores <CODE>i</CODE> by loopholing. See <CODE>AlignWr</CODE>.

<PRE>PROCEDURE <A NAME="OutInteger"><procedure>OutInteger</procedure></A> (log: Wr.T; i: INTEGER) =
  BEGIN
    LOCK log DO
      VAR
        ip := LOOPHOLE(AlignWr(log, BYTESIZE(INTEGER)),
                       UNTRACED REF INTEGER);
      BEGIN
        ip^ := i;
        INC(log.cur, BYTESIZE(INTEGER))
      END
    END (*LOCK*)
  END OutInteger;

PROCEDURE <A NAME="OutCardinal"><procedure>OutCardinal</procedure></A> (log: Wr.T; card: CARDINAL) =
  BEGIN
    OutInteger(log, card)
  END OutCardinal;

PROCEDURE <A NAME="OutBoolean"><procedure>OutBoolean</procedure></A> (log: Wr.T; bool: BOOLEAN) =
  BEGIN
    TRY
      Wr.PutChar(log, VAL(ORD(bool), CHAR))
    EXCEPT
      Wr.Failure (err) =&gt;
        StableError.Halt(
          &quot;Cannot write to logfile: &quot; &amp; RdUtils.FailureText(err))
    END
  END OutBoolean;

PROCEDURE <A NAME="OutReal"><procedure>OutReal</procedure></A> (log: Wr.T; r: REAL) =
  BEGIN
    LOCK log DO
      VAR
        rp := LOOPHOLE(AlignWr(log, BYTESIZE(REAL)),
                       UNTRACED REF REAL);
      BEGIN
        rp^ := r;
        INC(log.cur, BYTESIZE(REAL))
      END
    END
  END OutReal;

PROCEDURE <A NAME="OutLongreal"><procedure>OutLongreal</procedure></A> (log: Wr.T; r: LONGREAL) =
  BEGIN
    LOCK log DO
      VAR
        rp := LOOPHOLE(AlignWr(log, BYTESIZE(LONGREAL)),
                       UNTRACED REF LONGREAL);
      BEGIN
        rp^ := r;
        INC(log.cur, BYTESIZE(LONGREAL))
      END
    END
  END OutLongreal;

PROCEDURE <A NAME="OutExtended"><procedure>OutExtended</procedure></A> (log: Wr.T; r: EXTENDED) =
  BEGIN
    LOCK log DO
      VAR
        rp := LOOPHOLE(AlignWr(log, BYTESIZE(EXTENDED)),
                       UNTRACED REF EXTENDED);
      BEGIN
        rp^ := r;
        INC(log.cur, BYTESIZE(EXTENDED))
      END
    END
  END OutExtended;

PROCEDURE <A NAME="OutText"><procedure>OutText</procedure></A>(log: Wr.T; text: TEXT) =
  VAR len: INTEGER;
  BEGIN
    IF text # NIL THEN
      len := Text.Length(text)
    ELSE
      len := -1
    END;
    OutInteger(log, len);
    IF len &gt; 0 THEN OutChars(log, SUBARRAY(text^, 0, len)) END
  END OutText;

PROCEDURE <A NAME="AlignWr"><procedure>AlignWr</procedure></A>(wr: Wr.T; align: CARDINAL) : ADDRESS =
  VAR diff := wr.cur MOD align;
      res: ADDRESS;
  BEGIN
    TRY
      (* here we rely on the alignment invariants *)
      IF diff # 0 THEN INC(wr.cur, align-diff) END;
      IF wr.cur = wr.hi THEN wr.seek(wr.cur) END;
      res := ADR(wr.buff[wr.st + wr.cur - wr.lo]);
      RETURN res
    EXCEPT
      Wr.Failure (err) =&gt;
        &lt;*NOWARN*&gt; StableError.Halt(
          &quot;Cannot write to logfile: &quot; &amp; RdUtils.FailureText(err))
    END
  END AlignWr;
</PRE> The following procedures are provided in support of generic reading the
   log. 

<P><PRE>PROCEDURE <A NAME="InChar"><procedure>InChar</procedure></A> (log: Rd.T): CHAR RAISES {Error} =
  BEGIN
    TRY
      RETURN Rd.GetChar(log)
    EXCEPT
      Rd.EndOfFile =&gt; RAISE Error
    | Rd.Failure (err) =&gt;
        &lt;*NOWARN*&gt; StableError.Halt(
          &quot;Can not read log file: &quot; &amp; RdUtils.FailureText(err))
    END
  END InChar;

PROCEDURE <A NAME="InCharsLen"><procedure>InCharsLen</procedure></A> (log: Rd.T): CARDINAL RAISES {Error} =
  BEGIN
    RETURN InInteger(log)
  END InCharsLen;

PROCEDURE <A NAME="InChars"><procedure>InChars</procedure></A> (    log  : Rd.T;
                   VAR chars: ARRAY OF CHAR)
  RAISES {Error} =
  VAR n:= NUMBER(chars) - NUMBER(chars) MOD BYTESIZE(Word.T);
  BEGIN
    TRY
      IF Rd.GetSub(log, SUBARRAY(chars, 0, n)) # n THEN
        RAISE Error
      END;
      FOR i:= n TO LAST(chars) DO
        chars[i]:= Rd.GetChar(log)
      END
    EXCEPT
      Rd.EndOfFile =&gt; RAISE Error
    | Rd.Failure (err) =&gt;
        StableError.Halt(&quot;Can not read log file: &quot;
                           &amp; RdUtils.FailureText(err))
    END
  END InChars;

PROCEDURE <A NAME="InInteger"><procedure>InInteger</procedure></A> (log: Rd.T;
                     min         := FIRST(INTEGER);
                     max         := LAST(INTEGER)   ):
  INTEGER RAISES {Error} =
  BEGIN
    LOCK log DO
      VAR i: INTEGER;
      BEGIN
        i := LOOPHOLE(AlignRd(log, BYTESIZE(INTEGER)),
                      UNTRACED REF INTEGER)^;
        INC(log.cur, BYTESIZE(INTEGER));
        IF min &lt;= i AND i &lt;= max THEN
          RETURN i
        ELSE
          RAISE Error
        END (*IF*)
      END
    END (*LOCK*)
  END InInteger;

PROCEDURE <A NAME="InCardinal"><procedure>InCardinal</procedure></A> (log: Rd.T;
                      lim: CARDINAL := LAST(CARDINAL)):
  CARDINAL RAISES {Error} =
  BEGIN
    RETURN InInteger(log, 0, lim)
  END InCardinal;

PROCEDURE <A NAME="InBoolean"><procedure>InBoolean</procedure></A> (log: Rd.T): BOOLEAN RAISES {Error} =
  BEGIN
    TRY
      RETURN Rd.GetChar(log) = VAL(ORD(TRUE), CHAR)
    EXCEPT
      Rd.EndOfFile =&gt; RAISE Error
    | Rd.Failure (err) =&gt;
        &lt;*NOWARN*&gt; StableError.Halt(
          &quot;Can not read log file: &quot; &amp; RdUtils.FailureText(err))
    END
  END InBoolean;

PROCEDURE <A NAME="InReal"><procedure>InReal</procedure></A> (log: Rd.T): REAL RAISES {Error} =
  BEGIN
    LOCK log DO
      VAR r: REAL;
      BEGIN
        r := LOOPHOLE(AlignRd(log, BYTESIZE(REAL)),
                      UNTRACED REF REAL)^;
        INC(log.cur, BYTESIZE(REAL));
        RETURN r
      END
    END
  END InReal;

PROCEDURE <A NAME="InLongreal"><procedure>InLongreal</procedure></A> (log: Rd.T): LONGREAL RAISES {Error} =
  BEGIN
    LOCK log DO
      VAR r: LONGREAL;
      BEGIN
        r := LOOPHOLE(AlignRd(log, BYTESIZE(LONGREAL)),
                      UNTRACED REF LONGREAL)^;
        INC(log.cur, BYTESIZE(LONGREAL));
        RETURN r
      END
    END
  END InLongreal;

PROCEDURE <A NAME="InExtended"><procedure>InExtended</procedure></A> (log: Rd.T): EXTENDED RAISES {Error} =
  BEGIN
    LOCK log DO
      VAR r: EXTENDED;
      BEGIN
        r := LOOPHOLE(AlignRd(log, BYTESIZE(EXTENDED)),
                      UNTRACED REF EXTENDED)^;
        INC(log.cur, BYTESIZE(EXTENDED));
        RETURN r
      END
    END
  END InExtended;

PROCEDURE <A NAME="InText"><procedure>InText</procedure></A>(log: Rd.T) : TEXT
   RAISES {Error} =
  VAR len: INTEGER;
      text: TEXT;
  BEGIN
    len := InInteger(log);
    IF len = -1 THEN
      RETURN NIL
    ELSIF len &lt; 0 THEN
      RAISE Error
    ELSE
      text := NEW(TEXT, len+1);
      InChars(log, SUBARRAY(text^, 0, len));
      text[len] := '\000';
      RETURN text
    END
  END InText;

PROCEDURE <A NAME="AlignRd"><procedure>AlignRd</procedure></A>(rd: Rd.T; nb: CARDINAL) : ADDRESS
    RAISES {Error} =
  VAR diff := rd.cur MOD nb;
      res: ADDRESS;
  BEGIN
    (* here we rely on the alignment invariants *)
    IF diff # 0 THEN
      VAR n := rd.cur + nb - diff; BEGIN
        IF n &gt; rd.hi THEN RAISE Error END;
        rd.cur := n;
      END;
    END;
    IF rd.cur = rd.hi THEN
      TRY
        VAR sres:= rd.seek(rd.cur, FALSE); BEGIN
          IF sres = RdClass.SeekResult.Eof THEN
            RAISE Error
          END
        END
      EXCEPT
      | Rd.Failure (err) =&gt;
        StableError.Halt(
            &quot;Can not read log file: &quot; &amp; RdUtils.FailureText(err))
      END (*TRY*)
    END; (*IF*)
    res := ADR(rd.buff[rd.st + rd.cur - rd.lo]);
    RETURN res
  END AlignRd;

BEGIN
END StableLog.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
