<HTML>
<HEAD>
<TITLE>SRC Modula-3: stable/src/StableRep.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>stable/src/StableRep.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>
</PRE> Created by Carsten Weich                                    
                                                             

<P> The generic module <CODE>StableRep</CODE> provides the part of the implementation
   of stable objects <CODE>Stable.T</CODE> that is independent of {\tt Data.T} (see
   <CODE>Stable.ig</CODE> for a description of the methods). It is not intended that
   any client calls anything in this interface directly. Only the generated
   code references this interface.
<P>
   This code is used by the code generated by <CODE>stablegen</CODE>. It contains
   everything of the generated stable implementation that does not
   need to be generated by <CODE>stablegen</CODE>. However, it has to be generic
   because there are fields and a method added to the user object which
   are referencend in this module.
<P>
   The method <CODE>unspoolLog</CODE> is added. The method is generated by 
   <CODE>stablegen</CODE> and is called by <CODE>Recover()</CODE>. It reads the log and calls
   every method recorded on it.


<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="StableRep.mg">StableRep</A></genericInterface>(StableData);

IMPORT <A HREF="StableError.i3">StableError</A>, <A HREF="StableLog.i3">StableLog</A>, <A HREF="LogManager.i3">LogManager</A>, <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>;
IMPORT <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>;

REVEAL StableData.T &lt;: Public;

TYPE
  Public = StableData.Public BRANDED OBJECT
        nm         : Pathname.T;
        log        : Wr.T;
        lm         : LogManager.T := NIL;
        forceToDisk: BOOLEAN;
      METHODS
        replayLog(log: Rd.T);
      OVERRIDES
        init            := Init;
        dispose         := Dispose;
        flushLog        := FlushLog;
        freeLog         := FreeLog;
        writeCheckpoint := WriteCheckpoint;
        readCheckpoint  := ReadCheckpoint;
      END;
</PRE> \subsubsection*{Implementations of <CODE>Stable.ig</CODE>-methods} 

<P><PRE>PROCEDURE <A HREF="StableRep.mg#Init">Init</A> (    self       : Public;
                    dir        : Pathname.T;
                VAR recovered  : BOOLEAN;
                    forceToDisk               := TRUE;
                    lm         : LogManager.T := NIL   )
  : StableData.T
  RAISES {StableError.E};

PROCEDURE <A HREF="StableRep.mg#Dispose">Dispose</A> (self: Public) RAISES {StableError.E};

PROCEDURE <A HREF="StableRep.mg#FlushLog">FlushLog</A> (self: Public) RAISES {StableError.E};
PROCEDURE <A HREF="StableRep.mg#FreeLog">FreeLog</A> (self: Public) RAISES {StableError.E};

PROCEDURE <A HREF="StableRep.mg#ReadCheckpoint">ReadCheckpoint</A> (self: Public;
                                     cp  : Rd.T          )
  : StableData.T
  RAISES {StableError.E};
PROCEDURE <A HREF="StableRep.mg#WriteCheckpoint">WriteCheckpoint</A> (self: Public; wr: Wr.T)
  RAISES {StableError.E};
</PRE> \subsubsection*{Procedures to be called from the generated code} 

<P><PRE>PROCEDURE <A HREF="StableRep.mg#Recover">Recover</A> (t: StableData.T): StableData.T
  RAISES {StableError.E, StableLog.Error, OSError.E};
</PRE><BLOCKQUOTE><EM> Do the recovery: Only called if <CODE>t.lm.recoverable()</CODE> has returned <CODE>TRUE</CODE>.
   The procedure follows the protocol described in <CODE>LogManager.i3</CODE> to
   read in the latest checkpoint. Then it will read the log if necessary by
   calling <CODE>t.replayLog()</CODE>. </EM></BLOCKQUOTE><PRE>
PROCEDURE <A HREF="StableRep.mg#Checkpoint">Checkpoint</A> (t: StableData.T)
  RAISES {StableError.E};
</PRE><BLOCKQUOTE><EM> Write a checkpoint following the protocoll described in <CODE>LogManager.i3</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StableRep.mg#ReOpenLog">ReOpenLog</A> (self: StableData.T);
</PRE><BLOCKQUOTE><EM> Used by the generated code to open the log: The procedure tests whether
   the log is already opened for writing and reopens it (using the log manager
   object) if not. In case of an exception, it will halt (<CODE>StableError.Halt</CODE>).
</EM></BLOCKQUOTE><PRE>
END StableRep.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
