<HTML>
<HEAD>
<TITLE>SRC Modula-3: statistics/src/Stat.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>statistics/src/Stat.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="Stat.m3">Stat</A></interface>;
</PRE> Tools for elementary statistics of a sequence of real quantities
    A tiny set of tools for collecting elementary statistics (count,
    maximum, minimum, mean, and variance) of a sequence of real quantities.
    Index: statistics, collecting; printing, statistics


<P><PRE>IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  T = RECORD (* A statistics accumulator *)
        num      : LONGREAL;
        mean     : LONGREAL;
        variance : LONGREAL;
        maximum  : REAL;
        minimum  : REAL;
      END;

  (* Typical usage:
  |    VAR st: Stat.T;
  |    BEGIN
  |      Stat.Init(st);
  |      LOOP
  |        weight := ...
  |        Stat.Accum(st, weight);
  |        ...
  |      END;
  |      Wr.PrintF(stderr, &quot;Weight statistics: &quot;);
  |      Stat.Print(stderr, st);
  |      Wr.PrintF(stderr, &quot;\n&quot;);
  |    END;
  The mean is arithmetic mean.  The variance is the sum of of
  (x - mean)**2, divided by num (NOT num-1).  Thus, the standard
  deviation is sqrt(variance*num/(num-1)).  *)
</PRE>********************************************************
                                                        
 GATHERING:                                             
                                                        
********************************************************

<P><PRE>PROCEDURE <A HREF="Stat.m3#Init">Init</A> (VAR s: T);
</PRE><BLOCKQUOTE><EM> Resets the statistics accumulator s </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Stat.m3#Accum">Accum</A> (VAR s: T; x: REAL);
</PRE><BLOCKQUOTE><EM> Accumulates another observation x into the statistics accumulator s </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Stat.m3#Combine">Combine</A> (READONLY r, s: T): T;
</PRE><BLOCKQUOTE><EM> Combines statistics of two disjoint samples into a single sample </EM></BLOCKQUOTE><PRE>
</PRE>********************************************************
                                                        
 EXTRACTING:                                            
                                                        
********************************************************

<P><PRE>PROCEDURE <A HREF="Stat.m3#Num">Num</A> (READONLY s: T): REAL;
</PRE><BLOCKQUOTE><EM> The number of observations in s. Same as FLOAT(s.num). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Stat.m3#Max">Max</A> (READONLY s: T): REAL;
</PRE><BLOCKQUOTE><EM> The maximum observed value. Same as s.maximum. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Stat.m3#Min">Min</A> (READONLY s: T): REAL;
</PRE><BLOCKQUOTE><EM> The minimum observed value. Same as s.minimum. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Stat.m3#Mean">Mean</A> (READONLY s: T): REAL;
</PRE><BLOCKQUOTE><EM> The arithmetic mean. Same as FLOAT(s.mean). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Stat.m3#Var">Var</A> (READONLY s: T): REAL;
</PRE><BLOCKQUOTE><EM> The variance, i.e. sum((x[i]-mean)^2)/num. Same as FLOAT(s.variance). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Stat.m3#SDev">SDev</A> (READONLY s: T): REAL;
</PRE><BLOCKQUOTE><EM> The standard deviation, sqrt(sum((x[i]-mean)^2)/(num-1)). </EM></BLOCKQUOTE><PRE>
</PRE> Returns 0.0 if num &lt; 2 

<P><PRE>PROCEDURE <A HREF="Stat.m3#RMS">RMS</A> (READONLY s: T): REAL;
</PRE><BLOCKQUOTE><EM> The root mean square value, sqrt(sum(x[i]^2)/num) </EM></BLOCKQUOTE><PRE>
</PRE>********************************************************
                                                        
 PRINTING:                                              
                                                        
********************************************************

<P><PRE>PROCEDURE <A HREF="Stat.m3#Print">Print</A> (wr: Wr.T;  READONLY s: T) RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Prints the text string
<PRE>
          &quot;num: %d  min: %g  max: %g  mean: %g  dev: %g&quot;
   </PRE>
on the given writer.  If num=0, all other entries are omitted.
   The <CODE>dev</CODE> entry is the standard deviation, and is omitted if num&lt;=1. </EM></BLOCKQUOTE><PRE>

END Stat.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
