<HTML>
<HEAD>
<TITLE>SRC Modula-3: statistics/src/Stat.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>statistics/src/Stat.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Stat.i3">Stat</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../arith/src/Math.i3">Math</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (VAR s: T) =
  BEGIN
    WITH z = s DO
      z.num      := 0.0d+0;
      z.maximum  := 0.0;
      z.minimum  := 0.0;
      z.mean     := 0.0d+0;
      z.variance := 0.0d+0;
    END
  END Init;

PROCEDURE <A NAME="Accum"><procedure>Accum</procedure></A> (VAR s: T;  x: REAL) =
  VAR oldnum, tmp: LONGREAL;
  BEGIN
    WITH z = s DO
      IF z.num = 0.0d+0 THEN
        z.maximum := x;
        z.minimum := x
      ELSIF x &gt; z.maximum THEN
        z.maximum := x
      ELSIF x &lt; z.minimum THEN
        z.minimum := x
      END;
      oldnum := z.num;
      z.num := z.num + 1.0d+0;
      tmp := FLOAT (x, LONGREAL) - z.mean;
      z.mean := z.mean + tmp / z.num;
      z.variance := (z.variance + tmp * tmp / z.num) * oldnum / z.num;
    END;
  END Accum;

PROCEDURE <A NAME="Combine"><procedure>Combine</procedure></A> (READONLY r, s: T): T =
  VAR tmp: LONGREAL; t: T;
  BEGIN
    WITH z = t DO
      z.maximum := MAX (r.maximum, s.maximum);
      z.minimum := MIN (r.minimum, s.minimum);
      z.num := r.num + s.num;
      z.mean := (r.mean * r.num + s.mean * s.num) / z.num;
      tmp := r.mean - s.mean;
      z.variance := (r.variance * r.num + s.variance * s.num
                       + tmp * tmp * r.num * s.num / z.num) / z.num;
    END;
    RETURN t
  END Combine;

PROCEDURE <A NAME="Num"><procedure>Num</procedure></A> (READONLY s: T): REAL =
  BEGIN
    RETURN FLOAT (s.num)
  END Num;

PROCEDURE <A NAME="Max"><procedure>Max</procedure></A> (READONLY s: T): REAL =
  BEGIN
    RETURN s.maximum
  END Max;

PROCEDURE <A NAME="Min"><procedure>Min</procedure></A> (READONLY s: T): REAL =
  BEGIN
    RETURN s.minimum
  END Min;

PROCEDURE <A NAME="Mean"><procedure>Mean</procedure></A> (READONLY s: T): REAL =
  BEGIN
    RETURN FLOAT (s.mean)
  END Mean;

PROCEDURE <A NAME="Var"><procedure>Var</procedure></A> (READONLY s: T): REAL =
  BEGIN
    RETURN FLOAT (s.variance)
  END Var;

PROCEDURE <A NAME="SDev"><procedure>SDev</procedure></A> (READONLY s: T): REAL =
  BEGIN
    IF s.num = 0.0d+0 THEN RETURN 0.0 END;
    RETURN FLOAT (Math.sqrt (s.variance * s.num / (s.num - 1.0d+0)))
  END SDev;

PROCEDURE <A NAME="RMS"><procedure>RMS</procedure></A> (READONLY s: T): REAL =
  BEGIN
    IF s.num = 0.0d+0 THEN
      RETURN 0.0
    ELSE
      RETURN FLOAT (Math.sqrt (s.variance + s.mean * s.mean))
    END
  END RMS;

PROCEDURE <A NAME="Print"><procedure>Print</procedure></A> (wr: Wr.T;  READONLY s: T) RAISES {Wr.Failure, Thread.Alerted}=
  BEGIN
    WITH z = s DO
      Wr.PutText (wr, &quot;num = &quot; &amp; Fmt.Int (TRUNC (z.num)));
      IF z.num &gt; 0.0d+0 THEN
        Wr.PutText (wr, &quot; [ &quot; &amp; Fmt.Real (Min (s)) &amp; &quot; _ &quot;
                       &amp; Fmt.Real (Max (s)) &amp; &quot; ] mean = &quot;
                       &amp; Fmt.Real (Mean (s)));
        IF z.num &gt;= 2.0d+0 THEN
          Wr.PutText (wr, &quot;  dev = &quot; &amp; Fmt.Real (SDev (s)))
        END;
      END;
    END;
  END Print;

BEGIN
END Stat.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
