<HTML>
<HEAD>
<TITLE>SRC Modula-3: sx/src/Sx.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>sx/src/Sx.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> An <CODE>Sx.T</CODE> is a symbolic expression represented as a recursive
   linked list structure, as in Lisp.  This interface provides
   routines for reading and printing symbolic expressions, as well as
   some convenience procedures for manipulating them.  The syntax of
   an <CODE>Sx.T</CODE> is as follows:
<P>
<PRE>
      Sx = Char | Text | Int | Real | Longreal | Extended
         | Atom | Boolean | &quot;(&quot; List &quot;)&quot;.
      
      List =  {Sx}.
</PRE>
   \index{symbolic expression}
<P>
   A <CODE>Char</CODE> is a Modula-3 character literal; the corresponding <CODE>Sx.T</CODE>
   is of type <CODE>REF CHAR</CODE>.
<P>
   A <CODE>Text</CODE> is a Modula-3 text literal.  The corresponding <CODE>Sx.T</CODE> is
   a <CODE>TEXT</CODE>.
<P>
   An <CODE>Int</CODE> is a Modula-3 integer literal, possibly preceded by a plus
   sign (<CODE>+</CODE>) or minus sign (<CODE>-</CODE>).  The corresponding <CODE>Sx.T</CODE> is of
   type <CODE>REF INTEGER</CODE>.
<P>
   A <CODE>Real</CODE>, <CODE>Longreal</CODE>, or <CODE>Extended</CODE> is a floating-decimal
   number parsed using the grammar for <CODE>Float</CODE> specified in the <CODE>Lex</CODE>
   interface.  The corresponding <CODE>Sx.T</CODE> is of type <CODE>REF REAL</CODE>, <CODE>REF
   LONGREAL</CODE> or <CODE>REF EXTENDED</CODE>, depending on whether the letter
   introducing the exponent is <CODE>'e'</CODE>, <CODE>'d'</CODE>, or <CODE>'x'</CODE>. If there is
   no exponent, the result will be of type <CODE>REF REAL</CODE>.
<P>
   An <CODE>Atom</CODE> is either (1) a Modula-3 identifier, or (2) a non-empty
   sequence of characters from the set
<P>
<PRE>
       ! # $ % &amp; * + - . / : &lt; = &gt; ? @ [ ] ^ _ { } <KBD>{\tt ~}</KBD>
</PRE>
   or (3) a sequence of characters and escape sequences surrounded by
   vertical bars (<CODE>|</CODE>s).  The escape sequences are the same as those
   allowed in Modula-3 text literals, with the addition of
   {\def\ttSlashBackslash{{\tt \|}} \ttSlashBackslash}
   to allow an atom to contain <CODE>|</CODE>.  In all three cases, the
   corresponding <CODE>Sx.T</CODE> is an <CODE>Atom.T</CODE>.
<P>
   For example, the following are valid atoms:
<P>
<PRE>
      A1
      +=
      |1\||
</PRE>
   A <CODE>Boolean</CODE> is either <CODE>TRUE</CODE> or <CODE>FALSE</CODE>; the corresponding <CODE>Sx.T</CODE>
   is of type <CODE>Atom.T</CODE>; in other words, this is not a distinct type.
<P>
   The <CODE>Sx.T</CODE> corresponding to a <CODE>List</CODE> is a <CODE>RefList.T</CODE> containing
   the items of the list in order.
<P>
   The tokens of an <CODE>Sx.T</CODE> can be separated by arbitrary sequences of
   blanks, tabs, newlines, carriage returns, form feeds, and vertical
   tabs, which are ignored.  (These are the same whitespace characters
   that are ignored between tokens of a Modula-3 program.) They can
   also be separated by comments, which begin with a semicolon and end
   with newline.
<P>
   The syntax of tokens can be extended with the <CODE>SetReadMacro</CODE> procedure.
<P>


<P><PRE>INTERFACE <interface><A HREF="Sx.m3">Sx</A></interface>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

TYPE T = REFANY;

EXCEPTION
  ReadError(TEXT);
  PrintError(TEXT);

PROCEDURE <A HREF="Sx.m3#FromChar">FromChar</A>(c: CHAR): REF CHAR;
</PRE><BLOCKQUOTE><EM> Return a <CODE>Char</CODE> with value <CODE>c</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#FromInt">FromInt</A>(i: INTEGER): REF INTEGER;
</PRE><BLOCKQUOTE><EM> Return an <CODE>Int</CODE> with value <CODE>i</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#FromReal">FromReal</A>(r: REAL): REF REAL;
</PRE><BLOCKQUOTE><EM> Return a <CODE>Real</CODE> with value <CODE>r</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#FromLongReal">FromLongReal</A>(r: LONGREAL): REF LONGREAL;
</PRE><BLOCKQUOTE><EM> Return a <CODE>Longreal</CODE> with value <CODE>r</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#FromExtended">FromExtended</A>(r: EXTENDED): REF EXTENDED;
</PRE><BLOCKQUOTE><EM> Return an <CODE>Extended</CODE> with value <CODE>r</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#FromBool">FromBool</A>(b: BOOLEAN): Atom.T;
</PRE><BLOCKQUOTE><EM> Return a <CODE>Boolean</CODE>. If <CODE>b</CODE> is <CODE>TRUE</CODE>, return <CODE>Sx.True</CODE>.
   Otherwise, return <CODE>Sx.False</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>From...</CODE> procedures do not necessarily perform an allocation:
   if the same value is passed to two calls, the same reference may be
   returned.  As a consequence, clients should not modify the referent
   of a reference returned by any of these procedures.
<P>
   Each <CODE>REF CHAR</CODE>, <CODE>REF INTEGER</CODE>, <CODE>REF REAL</CODE>, <CODE>REF LONGREAL</CODE>, <CODE>REF
   EXTENDED</CODE>, <CODE>TEXT</CODE>, or <CODE>Atom.T</CODE>, no matter how constructed, is an
   <CODE>Sx.T</CODE>. 

<P><PRE>VAR (*CONST*) True, False: Atom.T;
</PRE><BLOCKQUOTE><EM> {\tt True = Atom.FromText("TRUE")},
    {\tt False = Atom.FromText("FALSE")}. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#Read">Read</A>(rd: Rd.T; syntax: Syntax := NIL): T
  RAISES {ReadError, Rd.EndOfFile, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Read and return a symbolic expression from <CODE>rd</CODE>, ignoring
   whitespace and comments. If <CODE>syntax</CODE> is <CODE>NIL</CODE>, use the syntax
   described above; otherwise use any read macros that have been
   registered in <CODE>syntax</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#ReadDelimitedList">ReadDelimitedList</A>(
    rd: Rd.T; delim : CHAR; syntax: Syntax := NIL): RefList.T
  RAISES {ReadError, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Repeatedly read symbolic expressions from <CODE>rd</CODE>, ignoring whitespace
   and comments, until the next character is <CODE>delim</CODE>; consume the
   delimiter and return the list of symbolic expressions that were
   read.  Raise <CODE>ReadError</CODE> if there is a syntax error, including
   unexpected end of file. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#Print">Print</A>(
    wr: Wr.T;
    sx: T;
    maxDepth: CARDINAL := LAST(CARDINAL);
    maxLength: CARDINAL := LAST(CARDINAL))
  RAISES {PrintError, Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Print the symbolic expression <CODE>sx</CODE> on the writer <CODE>wr</CODE>, assuming the
   standard syntax. </EM></BLOCKQUOTE><PRE>
</PRE> Each sublist will contain no more than <CODE>maxLength</CODE> elements; extra
   elements are replaced by an ellipsis (three dots).  Any sublist
   nested at a depth greater than <CODE>maxDepth</CODE> is also replaced by an
   ellipsis.  <CODE>Print</CODE> inserts <CODE>|</CODE> around atoms if necessary to ensure
   that they are readable.  <CODE>Print</CODE> does not insert line-breaks or
   indentation to produce a human-readable (``pretty-printed'') format
   for large symbolic expressions.
<P>
   <CODE>Print</CODE> will raise <CODE>PrintError</CODE> if it tries to print something that
   is not ``printable'' (as defined below). If a list contains an
   unprintable element that is beyond the limits established by
   <CODE>maxDepth</CODE> and <CODE>maxLength</CODE>, <CODE>PrintError</CODE> may or may not be raised.
<P>
   An object is said to be ``printable'' if it satisfies the following
   hypothetical predicate:
<PRE>
      
       PROCEDURE Printable(x: REFANY): BOOLEAN =
         BEGIN
           TYPECASE x OF
           | NULL, REF CHAR, TEXT, REF INTEGER, REF REAL,
             REF LONGREAL, REF EXTENDED, Atom.T =&gt; 
               RETURN TRUE
           | RefList.T (list) =&gt; RETURN Printable(list.head) AND 
                                        Printable(list.tail)
           ELSE
               RETURN FALSE
           END
        END Printable;
      
   <CODE></PRE>
Read(rd,NIL)</CODE> is guaranteed to return a printable value unless it
   raises an exception. Assuming the defaults for <CODE>syntax</CODE>,
   <CODE>maxDepth</CODE>, and <CODE>maxLength</CODE>, and assuming no exceptions are raised,
   <CODE>Read</CODE> and <CODE>Print</CODE> are ``inverses''.


<P><PRE>TYPE <A HREF="Sx.m3#Syntax">Syntax</A> &lt;: REFANY;
</PRE> A <CODE>Syntax</CODE> is a partial map from characters to read macros. 

<P><PRE>PROCEDURE <A HREF="Sx.m3#CopySyntax">CopySyntax</A>(s: Syntax := NIL): Syntax;
</PRE><BLOCKQUOTE><EM> Allocate and return a new syntax table whose contents are the same
   as <CODE>s</CODE> or, if <CODE>s = NIL</CODE>, the same as the standard syntax table. The
   standard syntax table has no read macros. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Sx.m3#SetReadMacro">SetReadMacro</A>(s: Syntax; ch: CHAR; m: ReadMacro);
</PRE><BLOCKQUOTE><EM> Set <CODE>s[ch] := m</CODE>. It is a checked runtime error if <CODE>s = NIL</CODE>, if
   <CODE>ch</CODE> is a whitespace character, or if <CODE>ch = ';'</CODE>. It is allowed for
   <CODE>m</CODE> to be <CODE>NIL</CODE>; this has the effect of removing the mapping, if
   any, from <CODE>ch</CODE> to a readmacro. </EM></BLOCKQUOTE><PRE>

TYPE ReadMacro = OBJECT METHODS
    read(rd: Rd.T; s: Syntax): RefList.T
      RAISES {ReadError, Thread.Alerted}
  END;
</PRE> If you pass a <CODE>Syntax</CODE> <CODE>s</CODE> to <CODE>Read</CODE> or <CODE>ReadDelimitedList</CODE>, then
   the reading algorithm is modified as follows.  After skipping
   whitespace and comments, and before reading a token, the next
   character in the input stream is consumed and examined.  If <CODE>s</CODE>
   defines a read macro for this character, then this read macro is
   called with the same arguments that were passed to <CODE>Read</CODE> or
   <CODE>ReadDelimitedList</CODE>.  The resulting list is spliced into the
   current list being built.  In particular, if the macro returns
   <CODE>NIL</CODE>, then everything it read is ignored; if the macro returns a
   single-element list, then that single element is inserted into the
   list being built.  <CODE>ReadError</CODE> is raised if the macro returns a
   non-list or if it returns a multi-element list in a context where
   no list is being built, such as at the top level of <CODE>Read</CODE>.
<P>
   For example, the following program fragment constructs a syntax
   table that extends the standard syntax in two ways.  First,
   additional comments are supported by ignoring all characters
   between <CODE>{</CODE> and <CODE>}</CODE>.  Second, an expression of the form 
   <CODE>[e1~...~en]</CODE> is turned into the list <CODE>(ARRAY e1~...~en)</CODE>:
<P>
<PRE>
      VAR syn := CopySyntax(); BEGIN
        SetReadMacro(syn, '{',
          NEW(ReadMacro, read := ReadComment));
        SetReadMacro(syn, '[',
          NEW(ReadMacro, read := ReadArray));
        ...
      
      PROCEDURE ReadComment(
          self: ReadMacro; rd: Rd.T; &lt;* UNUSED *&gt; s: Syntax)
        : RefList.T =
        BEGIN
          WHILE NOT Rd.EOF() AND Rd.GetChar(rd) # '}' DO
            (* SKIP 

<PRE>|     END;
|     RETURN NIL
|   END ReadComment;
|
| VAR (*CONST*) arrayAtm := Atom.FromText(&quot;ARRAY&quot;);
|
| PROCEDURE ReadArray(self: ReadMacro; rd: Rd.T; s: Syntax)
|   : RefList.T =
|   VAR elements := ReadDelimitedList(rd, ']', s);
|   BEGIN
|     RETURN RefList.List1(RefList.Cons(arrayAtm, elements))
|   END ReadArray;

   The call to &quot;RefList.List1&quot; in &quot;ReadArray&quot; is important.  If it were
   omitted, then the text

| (a b [c d])

   would be read as

| (a b ARRAY c d)

   instead of the intended

| (a b (ARRAY c d)).

*)

END Sx.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
