<HTML>
<HEAD>
<TITLE>SRC Modula-3: synex/src/SynParse.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>synex/src/SynParse.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="SynParse.i3">SynParse</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="SynScan.i3">SynScan</A>, <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>;

REVEAL
  <A NAME="T">T</A> =
    TPublic BRANDED &quot;SynParse.T&quot; OBJECT
      sc: SynScan.T;
      env: GrammarEnv;
      failedName: TEXT;
    OVERRIDES
      Grammar:=GetGrammarEnv; Scanner:=GetScanner;
      ReadNonTerminal:=ReadNonTerminal; Read:=Read; Lookup:=Lookup;
      Add:=Add; Extend:=Extend; ExtendIter:=ExtendIter;
    END;

  <A NAME="Grammar">Grammar</A> = Tree BRANDED &quot;Grammar&quot; OBJECT END ;
  <A NAME="GrammarEnvRoot">GrammarEnvRoot</A> =
    BRANDED &quot;GrammarEnvRoot&quot; OBJECT
      table: TextRefTbl.T;
    END;

TYPE
  ParGram =
    BRANDED OBJECT
    grammar : Grammar;
    args: Args ;
  END;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    noArgs := NEW(REF ARRAY OF INTEGER,0);
  END Setup;

VAR setupDone := FALSE;

PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() =
  BEGIN
    IF NOT setupDone THEN
      setupDone := TRUE;
      SynLocation.PackageSetup();
      SynScan.Setup();
      Setup();
    END;
  END PackageSetup;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(swr: SynWr.T; env: GrammarEnv; stackSize: CARDINAL := 1024): T =
  BEGIN
    RETURN
      NEW(T, stack := NEW(REF ARRAY OF Tree, stackSize),
          sc := SynScan.New(swr), env:=env, failedName := &quot;&quot;);
  END New;

PROCEDURE <A NAME="Msg"><procedure>Msg</procedure></A>(p: T; msg: TEXT) =
  VAR swr: SynWr.T;
  BEGIN
    swr := SynScan.GetWriter(p.sc);
    IF NOT Text.Empty(msg) THEN
      SynWr.Text(swr, msg);
      SynWr.Char(swr, '\n');
      SynWr.Flush(swr);
    END;
  END Msg;

PROCEDURE <A NAME="Fault"><procedure>Fault</procedure></A>(p: T; msg: TEXT) RAISES {Fail} =
  BEGIN
    Msg(p, msg);
    RAISE Fail;
  END Fault;
</PRE> Default methods returning NIL  <PRE>PROCEDURE <A NAME="BuildNoAction"><procedure>BuildNoAction</procedure></A>(self:
Action; g: T; base: INTEGER; READONLY info: SynLocation.Info): Tree = BEGIN
RETURN NIL END BuildNoAction;
PROCEDURE <A NAME="BuildNoGivenKeyword"><procedure>BuildNoGivenKeyword</procedure></A>(self: GivenKeyword; g: T; READONLY info:
SynLocation.Info): Tree = BEGIN RETURN NIL END BuildNoGivenKeyword;
PROCEDURE <A NAME="BuildNoGivenIdentifier"><procedure>BuildNoGivenIdentifier</procedure></A>(self: GivenIdentifier; g: T; READONLY info:
SynLocation.Info): Tree = BEGIN RETURN NIL END BuildNoGivenIdentifier;
PROCEDURE <A NAME="BuildNoGivenName"><procedure>BuildNoGivenName</procedure></A>(self: GivenName; g: T; READONLY info:
SynLocation.Info): Tree = BEGIN RETURN NIL END BuildNoGivenName;
PROCEDURE <A NAME="BuildNoGivenDelimiter"><procedure>BuildNoGivenDelimiter</procedure></A>(self: GivenDelimiter; g: T; READONLY info:
SynLocation.Info): Tree = BEGIN RETURN NIL END BuildNoGivenDelimiter;
PROCEDURE <A NAME="BuildNoIdentifier"><procedure>BuildNoIdentifier</procedure></A>(self: Identifier; g: T; name: TEXT; READONLY
info: SynLocation.Info): Tree = BEGIN RETURN NIL END
BuildNoIdentifier; PROCEDURE <A NAME="BuildNoName"><procedure>BuildNoName</procedure></A>(self: Name; g: T; name: TEXT;
READONLY info: SynLocation.Info): Tree = BEGIN RETURN NIL END
BuildNoName; PROCEDURE <A NAME="BuildNoQuotedChar"><procedure>BuildNoQuotedChar</procedure></A>(self: QuotedChar; g: T; char: CHAR;
READONLY info: SynLocation.Info): Tree = BEGIN RETURN NIL END
BuildNoQuotedChar; PROCEDURE <A NAME="BuildNoInteger"><procedure>BuildNoInteger</procedure></A>(self: Integer; g: T; int:
INTEGER; READONLY info: SynLocation.Info): Tree = BEGIN RETURN NIL END
BuildNoInteger; PROCEDURE <A NAME="BuildNoReal"><procedure>BuildNoReal</procedure></A>(self: Real; g: T; real: LONGREAL;
READONLY info: SynLocation.Info): Tree = BEGIN RETURN NIL END
BuildNoReal; PROCEDURE <A NAME="BuildNoQuotedString"><procedure>BuildNoQuotedString</procedure></A>(self: QuotedString; g: T; string:
TEXT; READONLY info: SynLocation.Info): Tree = BEGIN RETURN NIL END
BuildNoQuotedString; PROCEDURE <A NAME="BuildNoEof"><procedure>BuildNoEof</procedure></A>(self: Eof; g: T; READONLY info:
SynLocation.Info): Tree = BEGIN RETURN NIL END BuildNoEof;

  PROCEDURE <A NAME="GetScanner"><procedure>GetScanner</procedure></A>(g: T): SynScan.T =
  BEGIN
    RETURN g.sc
  END GetScanner;

  PROCEDURE <A NAME="GetGrammarEnv"><procedure>GetGrammarEnv</procedure></A>(g: T): GrammarEnv =
  BEGIN
    RETURN g.env
  END GetGrammarEnv;

  PROCEDURE <A NAME="ReadNonTerminal"><procedure>ReadNonTerminal</procedure></A>(g: T; named: TEXT)
      : Tree RAISES {Fail, SynScan.Fail, SynScan.NoReader} =
  VAR args: Args;
  BEGIN
    RETURN g.Read(g.Lookup(named, (*out*) args));
    (* -- should have zero arguments. *)
  END ReadNonTerminal;

  PROCEDURE <A NAME="Read"><procedure>Read</procedure></A>(g: T; gram: Grammar; base: INTEGER:=0)
      : Tree RAISES {Fail, SynScan.Fail, SynScan.NoReader} =
    VAR max: INTEGER; tree: Tree; failed: Grammar;
    BEGIN
      max:=0;
      tree:=Read1(g, gram, base, (*in-out*)max, (*out*)failed);
      IF failed#NIL THEN
	Reset(g, base+max);
        Error(g, failed);
        SynScan.SyntaxMsg(g.sc);
        RAISE Fail;
      END;
      RETURN tree;
    END Read;

  (* To be called when Read fails to reset the parse state without
     giving an error message. Set stackLevel=base+max, for the base given
     to, and the max returned by, Read. *)
  PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A>(g: T; stackLevel: INTEGER) =
    BEGIN
      FOR i:=0 TO stackLevel DO g.stack[i]:=NIL END;
    END Reset;

  (* To be called when Read fails, to give an error message.
     Should be followed by SynScan.SyntaxMsg(); RAISE Fail. *)
  PROCEDURE <A NAME="Error"><procedure>Error</procedure></A>(g: T; failed: Grammar) =
    VAR info: SynLocation.Info; swr: SynWr.T;
    BEGIN
      swr := SynScan.GetWriter(g.sc);
      SynScan.CurrentLocationInfo(g.sc, (*out*)info);
      SynWr.Text(swr, &quot;Parsing &quot; &amp; g.failedName &amp; &quot; &quot;, loud:=TRUE);
	SynLocation.PrintLocation(swr, failed.location);
	SynWr.Char(swr, '\n', loud:=TRUE);
      SynWr.Flush(swr, loud:=TRUE);
    END Error;

PROCEDURE <A NAME="NewEnv"><procedure>NewEnv</procedure></A>(): GrammarEnv =
  BEGIN
    RETURN NEW(GrammarEnv, table:=NEW(TextRefTbl.Default).init(100));
  END NewEnv;

PROCEDURE <A NAME="List"><procedure>List</procedure></A>(item1,item2,item3,item4,item5,item6,item7,item8,
    item9, item10, item11, item12, item13, item14, item15, item16,
    item17, item18, item19, item20: Grammar:=NIL;
  rest: GrammarList:=NIL): GrammarList =
  VAR list: GrammarList;
  BEGIN
    list:=rest;
    IF item20#NIL THEN list:=NEW(GrammarList, first:=item20, rest:=list) END;
    IF item19#NIL THEN list:=NEW(GrammarList, first:=item19, rest:=list) END;
    IF item18#NIL THEN list:=NEW(GrammarList, first:=item18, rest:=list) END;
    IF item17#NIL THEN list:=NEW(GrammarList, first:=item17, rest:=list) END;
    IF item16#NIL THEN list:=NEW(GrammarList, first:=item16, rest:=list) END;
    IF item15#NIL THEN list:=NEW(GrammarList, first:=item15, rest:=list) END;
    IF item14#NIL THEN list:=NEW(GrammarList, first:=item14, rest:=list) END;
    IF item13#NIL THEN list:=NEW(GrammarList, first:=item13, rest:=list) END;
    IF item12#NIL THEN list:=NEW(GrammarList, first:=item12, rest:=list) END;
    IF item11#NIL THEN list:=NEW(GrammarList, first:=item11, rest:=list) END;
    IF item10#NIL THEN list:=NEW(GrammarList, first:=item10, rest:=list) END;
    IF item9#NIL THEN list:=NEW(GrammarList, first:=item9, rest:=list) END;
    IF item8#NIL THEN list:=NEW(GrammarList, first:=item8, rest:=list) END;
    IF item7#NIL THEN list:=NEW(GrammarList, first:=item7, rest:=list) END;
    IF item6#NIL THEN list:=NEW(GrammarList, first:=item6, rest:=list) END;
    IF item5#NIL THEN list:=NEW(GrammarList, first:=item5, rest:=list) END;
    IF item4#NIL THEN list:=NEW(GrammarList, first:=item4, rest:=list) END;
    IF item3#NIL THEN list:=NEW(GrammarList, first:=item3, rest:=list) END;
    IF item2#NIL THEN list:=NEW(GrammarList, first:=item2, rest:=list) END;
    IF item1#NIL THEN list:=NEW(GrammarList, first:=item1, rest:=list) END;
    RETURN list;
  END List;

  PROCEDURE <A NAME="Store"><procedure>Store</procedure></A>(position: INTEGER; grammar: Grammar): Grammar =
  BEGIN
    RETURN NEW(Storage, item:=grammar, position:=position);
  END Store;

PROCEDURE <A NAME="VerifyArgs"><procedure>VerifyArgs</procedure></A>(g: T; args1,args2: Args; name: TEXT) RAISES {Fail}=
  BEGIN
    IF NUMBER(args1^) # NUMBER(args2^) THEN
      SynScan.SyntaxMsg(g.sc, &quot;Bad number of arguments: &quot;&amp;name);
      RAISE Fail;
    END;
    FOR i:= 0 TO NUMBER(args1^)-1 DO
      IF args1^[i] # args2^[i] THEN
        SynScan.SyntaxMsg(g.sc,
          &quot;Arguments number &quot;&amp;Fmt.Int(i)&amp;&quot; differ: &quot;&amp;name);
        RAISE Fail;
      END;
    END;
  END VerifyArgs;

PROCEDURE <A NAME="Lookup"><procedure>Lookup</procedure></A>(g: T; name: TEXT; VAR (*out*) args: Args): Grammar
    RAISES {Fail}=
    VAR
      value : REFANY;
    BEGIN
      IF NOT g.env.table.get(name, (*out*) value) THEN
        SynScan.SyntaxMsg(g.sc, &quot;Unbound non-terminal: &quot;&amp;name);
        RAISE Fail;
      END;
      TYPECASE value OF
      | NULL =&gt;
          SynScan.SyntaxMsg(g.sc,
           &quot;Non-Terminal bound to Nil object: &quot;&amp;name);
          RAISE Fail;
      | ParGram(node) =&gt;
        args := node.args;
        RETURN node.grammar ;
      ELSE
        SynScan.SyntaxMsg(g.sc,
         &quot;Non-Terminal not bound to ParGram object: &quot;&amp;name);
        RAISE Fail;
      END;
    END Lookup;

  PROCEDURE <A NAME="Add"><procedure>Add</procedure></A>(g: T;
                name: TEXT;
                grammar: Grammar;
                args: Args := NIL) RAISES {Fail} =
  VAR
    value: REFANY;
    newParGram: ParGram;
  BEGIN
    IF args = NIL THEN args := noArgs END;
    IF g.env.table.get(name, (*VAR OUT*) value) THEN
	SynScan.SyntaxMsg(g.sc, &quot;Duplicated non-terminal: &quot;&amp;name);
        RAISE Fail;
    END;
    newParGram := NEW(ParGram,
                      grammar := grammar,
                      args := args);
    EVAL g.env.table.put(name, newParGram);
  END Add;

  PROCEDURE <A NAME="Extend"><procedure>Extend</procedure></A>(g: T;
                   name: TEXT;
                   grammar: Grammar;
                   args: Args := NIL) RAISES {Fail} =
  VAR
    args2: Args;
    grammar2: Grammar;
  BEGIN
    IF args = NIL THEN args := noArgs END;
    grammar2 := g.Lookup(name,args2);
    VerifyArgs(g, args ,args2, name);
    TYPECASE grammar2 OF
    | Choice(node) =&gt; IF node.choice=NIL THEN RETURN END
    ELSE
    END;
    EVAL
      g.env.table.put(
            name,
            NEW(ParGram,
                args := args2 ,
                grammar := NEW(Choice,
                               choice:=
                                 NEW(GrammarList,
                                     first:=grammar2,
                                     rest:= NEW(GrammarList,
                                                first:=grammar,
                                                rest:= NIL)))));
  END Extend;

  PROCEDURE <A NAME="ExtendIter"><procedure>ExtendIter</procedure></A>(g: T;
                       name: TEXT;
                       iterPosPresent: BOOLEAN;
                       iterPos: INTEGER;
                       grammar: Grammar;
                       args: Args := NIL) RAISES {Fail} =
  VAR
    args2: Args;
  BEGIN
    IF args = NIL THEN args := noArgs END;
    TYPECASE g.Lookup(name,args2) OF
    | Iter(node) =&gt;
      VerifyArgs(g, args, args2, name);
      IF iterPosPresent AND (iterPos#node.accumPosition) THEN
        SynScan.SyntaxMsg(g.sc, &quot;Does not mach iteration position: _&quot;
          &amp; Fmt.Int(iterPos));
        RAISE Fail;
      END;
	node.iter :=
           NEW(Choice, choice:=
             NEW(GrammarList, first:=node.iter, rest:=
                                       NEW(GrammarList, first:=grammar, rest:=
                                                                 NIL)));
      ELSE
        SynScan.SyntaxMsg(g.sc, &quot;Not a grammar iteration: &quot;&amp;name);
        RAISE Fail;
      END;
    END ExtendIter;

  (* Parse according to the given gram/env. The base should
     be the current stack level (usually 0); max should be 0.
     If parsing fails it returns failed#NIL; then Reset
     should be called, followed by either &quot;SynScan.Reset()&quot; or
     &quot;Error(failed); SynScan.SyntaxMsg(); RAISE Fail&quot; *)
  PROCEDURE <A NAME="Read1"><procedure>Read1</procedure></A>(g: T; gram: Grammar;
	base: INTEGER; VAR (*in-out*) max: INTEGER;
    	VAR (*out*) failed: Grammar; name: TEXT:=NIL): Tree
    	RAISES {Fail, SynScan.Fail, SynScan.NoReader} =
    VAR tree: Tree;
    BEGIN
      IF name = NIL THEN
        TYPECASE( gram ) OF
          | NonTerminal(node) =&gt; name := node.name ;
        ELSE
            name := &quot;toplevel&quot;;
        END;
      END;
      TRY
	(* base is in-out so the stack can be cleaned up properly
	   even on Fail exceptions occurring during parsing. *)
	tree:=Read0(g, gram, (*in-out*)base, 0, (*in-out*)max,
	  (*out*)failed, name);
      EXCEPT SynScan.Fail, Fail =&gt;
	Reset(g, base+max);
        RAISE Fail;
      END;
      RETURN tree;
    END Read1;

  PROCEDURE <A NAME="Read0"><procedure>Read0</procedure></A>(g: T; gram: Grammar;
	VAR (*in-out*) base: INTEGER;
	  (* Base of the current stack frame *)
	minWrite: INTEGER;
	  (* Min writable index in the stack frame, for Choose and Iter *)
	VAR (*in-out*) max: INTEGER;
          (* Max index used so far in the stack frame *)
    	VAR (*out*) failed: Grammar; name: TEXT:=NIL): Tree
    	RAISES {Fail, SynScan.Fail, SynScan.NoReader} =
  (*  A NIL result means that a client Build did not care about
      generating a parse grammar. *)
  BEGIN
    TYPECASE gram OF
    | NonTerminal(node) =&gt;
        VAR
          grammar: Grammar;
          args: Args;
          tree: Tree;
          saveBase, saveMax: INTEGER;
        BEGIN
          saveBase := base; saveMax := max;
          INC(base,max);
          max := 0;
          (* look up subgrammar *)
          grammar := g.Lookup(node.name,args);
          (* check bounds *)
          IF NUMBER(args^) # NUMBER(node.args^) THEN
            Fault(g, &quot;Bad argument count calling &quot;&amp;node.name);
          END;
          (* copy the arguments *)
          FOR i:= 0 TO NUMBER(node.args^)-1 DO
            g.stack[base+args^[i]] := g.stack[saveBase+node.args^[i]];
            IF args^[i] &gt; max THEN
              max := args^[i]+1;
            END;
          END;
          tree :=
            Read0(g, grammar,
                  (*in-out*)base, 0, (*in-out*) max,
                  (*out*) failed, node.name);
          FOR i:=0 TO max-1 DO g.stack[base+i]:=NIL END;
          base := saveBase; max := saveMax;
          IF failed#NIL THEN RETURN NIL; END;
          RETURN tree;
        END;
    | Storage(node) =&gt;
        VAR
          tree: Tree;
        BEGIN
	  tree :=
	    Read0(g, node.item, (*in-out*)base, 0, (*in-out*)max,
	      (*out*)failed, name);
	  IF failed#NIL THEN RETURN NIL END;
	  IF node.position&lt;0 THEN
	    Fault(g, &quot;Invalid index: _&quot; &amp; Fmt.Int(node.position));
	  END;
	  IF node.position&lt;minWrite THEN
	    Fault(g, &quot;Invalid index: _&quot; &amp; Fmt.Int(node.position) &amp;
	      &quot; is too small to be storeable within this&quot; &amp;
	      &quot; choice or iteration branch&quot;);
	  END;
	  IF g.stack[base+node.position] # NIL THEN
	    Fault(g, &quot;Redefinition of: _&quot; &amp; Fmt.Int(node.position));
	  END;
	  g.stack[base+node.position] := tree;
	  max := MAX(max, node.position+1);
	  RETURN NIL;
	END;
     | Action(node) =&gt;
        VAR
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  EVAL
	    Read0(g, node.grammar, (*in-out*)base, 0, (*in-out*)max,
	      (*out*)failed, name);
	  IF failed#NIL THEN RETURN NIL END;
	  RETURN node.Build(node, g, base, (*in*)locInfo);
	END;
     | GivenKeyword(node) =&gt;
        VAR
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.HaveTokenKey(g.sc, node.key) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, (*in*)locInfo);
	END;
     | GivenIdentifier(node) =&gt;
        VAR
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.HaveTokenIde(g.sc, node.ide) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, (*in*)locInfo);
	END;
     | GivenName(node) =&gt;
        VAR
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.HaveTokenName(g.sc, node.text) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, (*in*)locInfo);
	END;
     | GivenDelimiter(node) =&gt;
        VAR
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.HaveTokenDelim(g.sc, node.delim) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, (*in*)locInfo);
	END;
    | Identifier(node) =&gt;
        VAR
          ide: TEXT;
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.GetTokenIde(g.sc, (*out*)ide) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, ide, (*in*)locInfo);
	END;
    | Name(node) =&gt;
        VAR
          text: TEXT;
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.GetTokenName(g.sc, (*out*)text) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, text, (*in*)locInfo);
	END;
     | Eof(node) =&gt;
        VAR
          locInfo: SynLocation.Info;
        BEGIN
          SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
          IF SynScan.GetTokenEof(g.sc) THEN failed:=NIL
          ELSE failed:=gram; g.failedName:=name; RETURN NIL;
          END;
          RETURN node.Build(node, g, (*in*) locInfo);
        END;
     | QuotedChar(node) =&gt;
        VAR
          char: CHAR;
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.GetTokenChar(g.sc, (*out*)char) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, char, (*in*)locInfo);
	END;
     | Integer(node) =&gt;
        VAR
          int: INTEGER;
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.GetTokenInt(g.sc, (*out*)int) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, int, (*in*)locInfo);
	END;
     | Real(node) =&gt;
        VAR
          real: LONGREAL;
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.GetTokenReal(g.sc, (*out*)real) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, real, (*in*)locInfo);
	END;
     | QuotedString(node) =&gt;
        VAR
          string: TEXT;
          locInfo: SynLocation.Info;
        BEGIN
	  SynScan.CurrentLocationInfo(g.sc, (*out*)locInfo);
	  IF SynScan.GetTokenString(g.sc, (*out*)string) THEN failed:=NIL
	  ELSE failed:=gram; g.failedName:=name; RETURN NIL;
	  END;
	  RETURN node.Build(node, g, string, (*in*)locInfo);
	END;
     | Sequence(node) =&gt;
        VAR
          gramList: GrammarList;
        BEGIN
          gramList := node.items;
          failed := NIL;
          LOOP
            IF gramList=NIL THEN EXIT END;
            EVAL
	      Read0(g, gramList.first, (*in-out*)base, 0, (*in-out*)max,
	        (*out*)failed, name);
	    IF failed#NIL THEN EXIT END;
	    gramList := gramList.rest;
          END;
        END;
	RETURN NIL;
    | Choice(node) =&gt;
        VAR
          tree: Tree;
          list: GrammarList;
          scanPoint: INTEGER;
          saveMax: INTEGER;
        BEGIN
	  list := node.choice;
	  saveMax := max;
	  LOOP
	    IF list=NIL THEN
	      failed := gram; g.failedName:=name; RETURN NIL;
	    END;
	    scanPoint := SynScan.ScanPoint(g.sc);
	    tree :=
	      Read0(g, list.first, (*in-out*) base, saveMax, (*in-out*) max,
	        (*out*) failed, name);
	    FOR i:=saveMax TO max-1 DO g.stack[base+i]:=NIL END;
	    max := saveMax;
	    IF failed=NIL THEN RETURN tree END;
	    IF failed#NIL AND scanPoint#SynScan.ScanPoint(g.sc)
	    THEN RETURN NIL
	    END;
	    list := list.rest;
	  END;
	END;
    | Iter(node) =&gt;
        VAR
          tree: Tree;
          scanPoint: INTEGER;
          saveMax: INTEGER;
        BEGIN
          tree :=
	    Read0(g, node.base, (*in-out*)base, 0, (*in-out*)max,
	      (*out*) failed, name);
	  IF failed#NIL THEN RETURN NIL END;
	  IF node.accum THEN
	    IF node.accumPosition&lt;0 THEN
	      Fault(g, &quot;Invalid index: _&quot; &amp; Fmt.Int(node.accumPosition));
	    END;
	    IF node.accumPosition&lt;minWrite THEN
	      Fault(g, &quot;Invalid index: _&quot; &amp; Fmt.Int(node.accumPosition) &amp;
	        &quot; is too small to be storeable within this&quot; &amp;
	        &quot; choice or iteration branch&quot;);
	    END;
	    g.stack[base+node.accumPosition] := tree;
	    max := MAX(max, node.accumPosition+1);
	  END;
	  saveMax := max;
	  LOOP
	    scanPoint := SynScan.ScanPoint(g.sc);
	    tree :=
	      Read0(g, node.iter, (*in-out*)base, saveMax, (*in-out*)max,
	        (*out*)failed, name);
	    FOR i:=saveMax TO max-1 DO g.stack[base+i]:=NIL END;
	    max := saveMax;
	    IF failed#NIL AND scanPoint#SynScan.ScanPoint(g.sc)
	    THEN RETURN NIL
	    END;
	    IF failed#NIL THEN
	      failed:=NIL;
	      IF node.accum THEN
	        RETURN g.stack[base+node.accumPosition];
	      ELSE RETURN NIL;
	      END;
	    END;
	    IF node.accum THEN
	      g.stack[base+node.accumPosition] := tree;
	    END;
	  END;
	END;
    ELSE
      Fault(g, &quot;SynParse.Read0&quot;);
      &lt;*ASSERT FALSE*&gt;
   END;
  END Read0;

BEGIN
END SynParse.
</PRE><P>
<P>
      UndoAdd(name: TEXT) RAISES {Fail};
        (* Remove a definition, and give an error if not found. 

<P>  <PRE>PROCEDURE UndoAdd(g: T; name: TEXT) RAISES {Fail} =
  VAR
    value: REFANY;
  BEGIN
    IF NOT g.env.table.delete(name, (*VAR OUT*) value) THEN
      SynScan.ErrorMsg(g.sc, &quot;GrammarEnv.UndoAdd: could not find: &quot;&amp;name);
      RAISE Fail;
    END;
  END UndoAdd;

      UndoExtend(name: TEXT; grammar: Grammar) RAISES {Fail};
        (* Undo an extension, or give an error if not possible. *)

  PROCEDURE UndoExtend(g: T; name: TEXT; grammar: Grammar)
    RAISES {Fail} =
  VAR
    args: Args;
  BEGIN
    TYPECASE grammar OF
    | Choice(node) =&gt; IF node.choice=NIL THEN RETURN END
    ELSE
    END;
    TYPECASE g.Lookup(name,args) OF
    | Choice(node) =&gt;
	IF grammar # node.choice.rest.first THEN
          SynScan.ErrorMsg(g.sc, &quot;GrammarEnv.UndoExtend: bad undo: &quot;&amp;name);
          RAISE Fail;
	END;
        EVAL
          g.env.table.put(name,
                        NEW(ParGram,
                            args := args,
                            grammar := node.choice.first));
    ELSE
      SynScan.ErrorMsg(g.sc, &quot;GrammarEnv.UndoExtend failed: &quot;&amp;name);
      RAISE Fail;
    END;
  END UndoExtend;

      UndoExtendIter(name: TEXT; grammar: Grammar) RAISES {Fail};
        (* Undo an Iter extension, or give anerror if not possible. *)

  PROCEDURE UndoExtendIter(g: T; name: TEXT; grammar: Grammar)
    RAISES {Fail} =
  VAR
    args: Args;
  BEGIN
    TYPECASE g.Lookup(name,args) OF
    | Iter(iterNode) =&gt;
	TYPECASE iterNode.iter OF
	| Choice(choiceNode) =&gt;
	    IF grammar # choiceNode.choice.rest.first THEN
              SynScan.ErrorMsg(g.sc,
                               &quot;GrammarEnv.UndoExtendIter: bad undo: &quot;&amp;name);
              RAISE Fail;
	    END;
            iterNode.iter:=choiceNode.choice.first;
	ELSE
          SynScan.ErrorMsg(g.sc, &quot;GrammarEnv.UndoExtendIter failed: &quot;&amp;name);
          RAISE Fail;
	END;
    ELSE
      SynScan.ErrorMsg(g.sc, &quot;GrammarEnv.UndoExtendIter failed: &quot;&amp;name);
      RAISE Fail;
    END;
  END UndoExtendIter;

*)
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
