<HTML>
<HEAD>
<TITLE>SRC Modula-3: synex/src/SynScan.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>synex/src/SynScan.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="SynScan.m3">SynScan</A></interface>;
IMPORT <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>;
</PRE> Part of the synex package: a parser generator for extensible grammars. 

<P> This interface provides a (somewhat specialized) token scanner.
<PRE>
      
        The ascii characters are divided into a fixed number of 
        character classes which default to the following table:
      
          Blank	HT LF FF CR SP
          Reserved	&quot; ' ~ DEL
          Delimiter	( ) , . ; [ ] _ { } ? !
          Special	# $ % &amp; * + - / : = &lt; &gt; @ \ ^ |
          Digit	0..9
          Letter	A..Z <KBD> a..z
|     Illegal	all the others
|
|   Moreover, there are some </KBD>improper<KBD> character classes:
|
|     StringChar  is either any single character that is not Illegal
|                 or one of </KBD>'<KBD> </KBD>&quot;<KBD> </KBD>\<KBD>, or is one of the pairs of
|		  characters </KBD>\'<KBD> </KBD>\&quot;<KBD> </KBD>\\<KBD>.
|     Comment     is, recursively, a sequence of non-Illegal chars and
|		  Comments enclosed between </KBD>(*<KBD> and </KBD>
<PRE>`.
|     Eof	  is the end-of-file token (optionally generated)
|
|  The stream of input characters is split into &quot;lexemes&quot; by always
|  extracting the longest prefix that is a legal lexeme.
|  The following fixed set of lexemes is recognized:
|
|     Space	  a sequence of Blanks and Comments
|     AlphaNum	  a sequence of Letters and Digits starting with a Letter
|     Symbol	  a sequence of Specials
|     Char	  a single StringChars enclosed between two `'`
|     String	  a sequence of StringChars enclosed betweenn two `&quot;`
|     Nat	  a sequence of Digits
|     Int	  a Nat, possibly preceded by a single `~`
|     Real	  an Int followed by `.` and a Nat
|     Delimiter	  a single Delimiter character
|     Eof	  end-of-file (optionally generated)
|
|  Finally, the scanner produces &quot;tokens&quot; from the stream of lexemes:
|
|     - Space lexemes do not produce tokens.
|     - Char, String, Int, Real, Delimiter, and Eof lexemes are also tokens.
|     - AlphaNum and Symbol lexemes are Identifier tokens, except when
|         they have been explicitly declared to be keywoTextCrds, in which
|         case they are Keyword tokens.
|----------------------------------------------------------------------
|  Both Identifier and Keyword tokens are called Name tokens.
|  Name tokens are inserted in an internal symbol table; when they are
|  returned as texts they are unique.
|----------------------------------------------------------------------
|  The scanner scans characters out of a stack of input readers. When a reader
|  is exhausted the scanner switches to the next one in the stack; if the
|  stack is empty the scanner raises NoReader. Initially, the only reader in
|  the stack is stdin, with generateEOF=TRUE (see PushInput); use PopInput
|  right away if you want to remove this reader.
|----------------------------------------------------------------------
|  Here is a typical top-level loop for the scanner:
|
|    SynScan.SetPrompt(&quot;- &quot;, &quot;  &quot;);
|    LOOP
|      TRY
|        SynScan.FirstPrompt();
| 	 IF SynScan.GetTokenEof() THEN RAISE SynScan.NoReader END;
|	 (* ... *)
|        (* parse, execute, and print *)
|	 (* ... *)
|    	 SynWr.Flush(swr);
|      EXCEPT
|      | SynScan.Fail =&gt; (* Continue. *)
|      | SynScan.NoReader =&gt; EXIT;
|      END;
|    END;
*)

EXCEPTION Fail;

EXCEPTION NoReader;
</PRE><BLOCKQUOTE><EM> Raised when there is no reader from which to scan characters. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="SynScan.m3#T">T</A> &lt;: REFANY;
  (* A scanner. *)

  <A HREF="SynScan.m3#Keyword">Keyword</A> &lt;: ROOT;
  (* An AlphanNum or Symbol that has been declared to be a Keyword instead
     of just a Name. *)

  <A HREF="SynScan.m3#KeywordSet">KeywordSet</A> &lt;: ROOT;
  (* A set of keywords. There is a &quot;current&quot; KeywordSet used to tokenize
     the input reader. This can be changed to a different keyword
     set even on-the-fly during scanning. In the latter case one should be
     aware that there may be a single buffered token recognized according
     to the previous KeywordSet. *)

PROCEDURE <A HREF="SynScan.m3#Setup">Setup</A>();
</PRE><BLOCKQUOTE><EM> To be called before any other use of this module.
   Initializes the input stack to read from stdin. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#New">New</A>(swr: SynWr.T): T;
</PRE><BLOCKQUOTE><EM> A brand new scanner sending error messages to a writer. Use it 
   single-threaded. You can use separate scanners with separate threads, 
   concurrently. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetWriter">GetWriter</A>(sc: T): SynWr.T;
</PRE><BLOCKQUOTE><EM> Return the current writer. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#Clear">Clear</A>(sc: T);
</PRE><BLOCKQUOTE><EM> Clean up the scanner state, but preserve the input file stack. 
   Buffered characters and tokens are discarded. If scanning from
   stdin, the pending input chars (according to Rd.CharsReady)
   are discarded. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#Reset">Reset</A>(sc: T);
</PRE><BLOCKQUOTE><EM> Reinitialize the scanner state. It calls Clear and empties
   the file stack, leaving only the initial stdin input (if any).
   Reset is useful mostly to clear the scanner after
   a scanning or parsing error. </EM></BLOCKQUOTE><PRE>

TYPE
  CharacterClass =
    {IllegalCharCase, LetterCharCase, DigitCharCase, SpecialCharCase,
     DelimCharCase, ReservedCharCase, BlankCharCase, EofCase };

PROCEDURE <A HREF="SynScan.m3#SetChar">SetChar</A>(sc: T; n: CHAR; class: CharacterClass);
</PRE><BLOCKQUOTE><EM> Assign a character class to a character, for customization.
   Must not modify the Reserved character class. </EM></BLOCKQUOTE><PRE>
</PRE> === Source === 

<P><PRE>PROCEDURE <A HREF="SynScan.m3#PushInput">PushInput</A>(sc: T; fileName: TEXT; rd: Rd.T; closeReader: BOOLEAN;
  generateEOF: BOOLEAN := TRUE);
</PRE><BLOCKQUOTE><EM> Switch the scanner input to a new reader, and push the existing
   one on the input stack. Scanning from the old reader will resume from 
   the current position when the new one is exhausted. If closeReader
   is true, the reader is closed when rd is exhausted. If genereteEOF
   is true, an Eof token is generated when rd is exhausted.
   It is admissible to give stdin as <CODE>rd</CODE>, provided that its given
   fileName is <CODE></CODE>, and that it is the first reader ever pushed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#PopInput">PopInput</A>(sc: T) RAISES {NoReader};
</PRE><BLOCKQUOTE><EM> Discards the current reader and switches back to the previous 
   reader in the input stack. Raisse NoReader if there is no
   previous reader. Closes the current reader, if it was so requested
   at PushInput time. An Eof token is not generated, even if it was
   so requested at PushInput time. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#ScanPoint">ScanPoint</A>(sc: T): INTEGER;
  (* The number of tokens read so far. Useful in LL(1) parsers to detect
     illegal backtracking. *)

PROCEDURE <A HREF="SynScan.m3#CurrentLocationInfo">CurrentLocationInfo</A>(sc: T; VAR(*out*) info: SynLocation.Info);
</PRE><BLOCKQUOTE><EM> Get the fileName and position of the current input reader. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#SetCharNo">SetCharNo</A>(sc: T; charNo, lineNo, lineCharNo: INTEGER);
</PRE><BLOCKQUOTE><EM> Set the charNo counter associtated with the current input reader to the
   given number, for error reporting purposes. By default, charNo is 
   initialized to 0 when a reader is opened, and incremented every time a 
   new character is scanned. Similaraly, lineNo is incremented at each line,
   and lineCharNo is incremented at each character and reset to 0 at each 
   line. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#TopLevel">TopLevel</A>(sc: T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Whether the scanner is reading from the top level (stdin) or a file. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#FlushInput">FlushInput</A>(sc: T);
</PRE><BLOCKQUOTE><EM> Discard all the pending characters on the current reader
   (as determined by Rd.CharsReady) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#SetPrompt">SetPrompt</A>(sc: T; firstPrompt, nextPrompt: TEXT);
</PRE><BLOCKQUOTE><EM> Set the top-level interaction prompt strings. The firstPrompt will be 
   generated once, then the nextPrompt all the other times, until FirstPrompt 
   is explicitly invoked. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#FirstPrompt">FirstPrompt</A>(sc: T);
</PRE><BLOCKQUOTE><EM> Reset the first prompt (see SetPrompt). </EM></BLOCKQUOTE><PRE>
</PRE> === Keywords === 

<P><PRE>PROCEDURE <A HREF="SynScan.m3#NewKeywordSet">NewKeywordSet</A>(): KeywordSet;
</PRE><BLOCKQUOTE><EM> Create a new keywordSet. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#CopyKeywordSet">CopyKeywordSet</A>(keywordSet: KeywordSet): KeywordSet;
</PRE><BLOCKQUOTE><EM> Create a copy of keywordSet. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetKeywordSet">GetKeywordSet</A>(sc: T): KeywordSet;
</PRE><BLOCKQUOTE><EM> Get the current keyword set (initially an empty one). </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#UseKeywordSet">UseKeywordSet</A>(sc: T; keywordSet: KeywordSet);
</PRE><BLOCKQUOTE><EM> From now on, use this keywordSet for scanning. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#BeKeyword">BeKeyword</A>(ide: TEXT; keywordSet: KeywordSet): Keyword;
</PRE><BLOCKQUOTE><EM> From now on, the name <CODE>ide</CODE> is a keyword member of keywordSet.
   The (new or existing) keyword is returned. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetKeyword">GetKeyword</A>(ide: TEXT; keywordSet: KeywordSet): Keyword;
</PRE><BLOCKQUOTE><EM> Returns the keyword of name <CODE>ide</CODE> from keywordSet, or NIL
   if it does not exist. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetKeywordName">GetKeywordName</A>(key : Keyword): TEXT;
</PRE><BLOCKQUOTE><EM> Returns the name of a keyword. </EM></BLOCKQUOTE><PRE>
</PRE> === Token primitives === 

<P> All the Get and Have procedures below <CODE>eat</CODE> a token if succesful,
   and leave it (buffered) in the input stream if unsuccesful. 

<P><PRE>PROCEDURE <A HREF="SynScan.m3#IsDelimiter">IsDelimiter</A>(sc: T; char: CHAR): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Whether char is a legal Delimiter token. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#IsIdentifier">IsIdentifier</A>(sc: T; string: TEXT): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Whether string is a legal Identifier (Name or Keyword) token </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetTokenChar">GetTokenChar</A>(sc: T; VAR (*out*) char: CHAR): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Returns the value of the next (char) token (or FALSE) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetTokenNat">GetTokenNat</A>(sc: T; VAR (*out*) nat: CARDINAL): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Returns the value of the next (natural) token (or FALSE) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetTokenInt">GetTokenInt</A>(sc: T; VAR (*out*) int: INTEGER): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Returns the value of the next (integer) token (or FALSE) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetTokenReal">GetTokenReal</A>(sc: T; VAR (*ou*) real: LONGREAL): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Returns the value of the next (real) token (or FALSE) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetTokenString">GetTokenString</A>(sc: T; VAR (*out*) string: TEXT): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Returns the value of the next (string) token (or FALSE) </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetTokenIde">GetTokenIde</A>(sc: T; VAR (*ou*) ide: TEXT): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Returns the value of the next non-keyword identifier (or FALSE).
   If two calls to GetTokenIde return two texts that are <CODE>Text.Equal</CODE>,
   then they are also <CODE>=</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetTokenName">GetTokenName</A>(sc: T; VAR (*ou*) text: TEXT): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Returns the value of the next keyword or non-keyword identifier 
  (or FALSE). If two calls to GetTokenName return two texts that are 
  <CODE>Text.Equal</CODE>, then they are also <CODE>=</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#GetTokenEof">GetTokenEof</A>(sc: T; ): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Returns TRUE if we have reached the end of a file for which
   and end-of-file token was requested, FALSE otherwise </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#HaveTokenIde">HaveTokenIde</A>(sc: T; ide: TEXT): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Tests the presence of a given non-keyword identifier. 
   Returns FALSE if not found </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#HaveTokenKey">HaveTokenKey</A>(sc: T; key: TEXT): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Tests the presence of a given keyword. Returns FALSE if not found </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#HaveTokenName">HaveTokenName</A>(sc: T; text: TEXT): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Tests the presence of a given keyword or non-keyword identifer. 
   Returns FALSE if not found </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#HaveTokenDelim">HaveTokenDelim</A>(sc: T; delim: CHAR): BOOLEAN RAISES {NoReader, Fail};
</PRE><BLOCKQUOTE><EM> Tests the presence of a given delimiter. Returns FALSE if not found </EM></BLOCKQUOTE><PRE>
</PRE> === Error Messages === 

<P><PRE>TYPE ErrorReportStyle = {LinePlusChar, CharRange};
</PRE><BLOCKQUOTE><EM> Whether Syntax should report error positions by line number plus char in 
   line, or by range of characters from the beginning of file. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#PrintContext">PrintContext</A>(sc: T);
</PRE><BLOCKQUOTE><EM> Prints the current input context (a short segment of the input stream 
   following the current scanner position). This operation corrupts the
   input stream: it should be used after a syntactic error, as part
   of the error message, before resetting the scanner</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#ErrorMsg">ErrorMsg</A>(sc: T; msg: TEXT := &quot;&quot;);
</PRE><BLOCKQUOTE><EM> Prints msg (followed by newline if non-empty), and calls Reset. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynScan.m3#SyntaxMsg">SyntaxMsg</A>(sc: T; cause: TEXT := &quot;&quot;; culprit: TEXT := &quot;&quot;;
  errorReportStyle: ErrorReportStyle := ErrorReportStyle.LinePlusChar);
</PRE><BLOCKQUOTE><EM> A more elaborate version of <CODE>Error</CODE>. It uses PrintContext and
   SynLocation.PrintLocation to show the error context in a meaninglful
   way. <CODE>causes</CODE> should specify the general reason of the error, and 
   <CODE>culprit</CODE> the specific offender. Prints error positions according to 
   <CODE>errorReportStyle</CODE>. </EM></BLOCKQUOTE><PRE>

END SynScan.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
