<HTML>
<HEAD>
<TITLE>SRC Modula-3: synex/src/SynScan.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>synex/src/SynScan.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="SynScan.i3">SynScan</A></implements></module>;
IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../text/src/TextConv.i3">TextConv</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>,
  <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../fmtlex/src/Lex.i3">Lex</A>, <A HREF="#x1">FloatMode</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

&lt;* FATAL Rd.Failure, Wr.Failure, Thread.Alerted *&gt;

REVEAL
  <A NAME="Keyword">Keyword</A> =  BRANDED OBJECT name: TEXT; keyword: BOOLEAN END;
  <A NAME="KeywordSet">KeywordSet</A> = BRANDED OBJECT table: TextRefTbl.T END;

TYPE
  Symbol = Keyword;

  TokenClass =
    {IdeCase, InfixCase, CharCase, IntCase, RealCase, StringCase, DelimCase,
     EofCase };

  InputList = REF InputListBase;
  InputListBase = RECORD
    rd: Rd.T;
    fileName: TEXT;
    acceptedCharPos, acceptedLinePos, acceptedLineCharPos: INTEGER;
    acceptedTokenBegPos, acceptedTokenEndPos: INTEGER;
    generateEOF: BOOLEAN;
    closeReader: BOOLEAN;
    rest: InputList;
  END;

CONST EofChar = VAL(255, CHAR);

REVEAL <A NAME="T">T</A> =
  BRANDED REF RECORD
    swr: SynWr.T;
    scanBuffer: REF ARRAY OF CHAR;
    scanBufferSize: INTEGER;
    charTable: ARRAY CHAR OF CharacterClass;
    keySet: KeywordSet;
    lookAheadReady: BOOLEAN;
    lookAheadChar: CHAR;
    tokenReady: BOOLEAN;
    tokenClass: TokenClass;
    tokenBegPos: INTEGER;
    tokenEndPos: INTEGER;
    tokenChar: CHAR;
    tokenInt: INTEGER;
    tokenReal: LONGREAL;
    tokenString: TEXT;
    tokenDelim: CHAR;
    tokenSym: Symbol;
    input: InputList;
    scanPoint: INTEGER;
    firstPrompt, nextPrompt: TEXT;
    isFirstPrompt: BOOLEAN;
    (* The following variables are copies of &quot;input^&quot; fields, so
       that they can survive a PopInput. *)
      fileName: TEXT;
      acceptedCharPos, acceptedLinePos, acceptedLineCharPos: INTEGER;
      acceptedTokenBegPos, acceptedTokenEndPos: INTEGER;
  END;

PROCEDURE <A NAME="NewKeywordSet"><procedure>NewKeywordSet</procedure></A>(): KeywordSet =
  BEGIN
    RETURN NEW(KeywordSet, table:=NEW(TextRefTbl.Default).init(10));
  END NewKeywordSet;

PROCEDURE <A NAME="CopyKeywordSet"><procedure>CopyKeywordSet</procedure></A>(keywordSet: KeywordSet): KeywordSet =
  VAR newKeySet: KeywordSet; key: TEXT; value: REFANY;
    iterator: TextRefTbl.Iterator; symbol: Symbol;
  BEGIN
    newKeySet := NEW(KeywordSet,
      table:=NEW(TextRefTbl.Default).init(keywordSet.table.size()));
    iterator := keywordSet.table.iterate();
    WHILE iterator.next((*out*)key, (*out*)value) DO
      symbol := NARROW(value, Symbol);
      IF symbol.keyword THEN
        EVAL newKeySet.table.put(key, symbol);
      END;
    END;
    RETURN newKeySet;
  END CopyKeywordSet;

PROCEDURE <A NAME="GetKeywordSet"><procedure>GetKeywordSet</procedure></A>(sc: T): KeywordSet =
  BEGIN
    RETURN sc^.keySet;
  END GetKeywordSet;

PROCEDURE <A NAME="UseKeywordSet"><procedure>UseKeywordSet</procedure></A>(sc: T; keywordSet: KeywordSet) =
  BEGIN
    sc^.keySet := keywordSet;
  END UseKeywordSet;

PROCEDURE <A NAME="BeKeyword"><procedure>BeKeyword</procedure></A>(ide: TEXT; keywordSet: KeywordSet): Keyword =
  VAR value: REFANY; symbol: Symbol;
  BEGIN
    IF keywordSet.table.get(ide, (*VAR OUT*) value) THEN
      symbol := NARROW(value, Symbol);
      symbol.keyword := TRUE;
    ELSE
      symbol :=
        NEW(Symbol, name:=Text.Sub(ide,0,Text.Length(ide)), keyword:=TRUE);
      EVAL keywordSet.table.put(ide, symbol);
    END;
    RETURN symbol;
  END BeKeyword;

PROCEDURE <A NAME="GetKeyword"><procedure>GetKeyword</procedure></A>(ide: TEXT; keywordSet: KeywordSet): Keyword =
  VAR value: REFANY; symbol: Symbol;
  BEGIN
    IF keywordSet.table.get(ide, (*VAR OUT*) value) THEN
      symbol := NARROW(value, Symbol);
      IF symbol.keyword THEN RETURN symbol ELSE RETURN NIL END;
    ELSE RETURN NIL;
    END;
  END GetKeyword;

PROCEDURE <A NAME="IsDelimiter"><procedure>IsDelimiter</procedure></A>(sc: T; char: CHAR): BOOLEAN =
  BEGIN
    RETURN sc^.charTable[char] = CharacterClass.DelimCharCase;
  END IsDelimiter;

PROCEDURE <A NAME="IsIdentifier"><procedure>IsIdentifier</procedure></A>(sc: T; string: TEXT): BOOLEAN =
  VAR class: CharacterClass; length: INTEGER;
  BEGIN
    length := Text.Length(string);
    IF length=0 THEN RETURN FALSE END;
    IF sc^.charTable[Text.GetChar(string,0)]=CharacterClass.LetterCharCase THEN
      FOR i:=0 TO length-1 DO
	class := sc^.charTable[Text.GetChar(string,i)];
        IF (class # CharacterClass.LetterCharCase) AND
	    (class # CharacterClass.DigitCharCase) THEN RETURN FALSE END;
      END;
      RETURN TRUE;
    ELSIF sc^.charTable[Text.GetChar(string,0)]=CharacterClass.SpecialCharCase THEN
      FOR i:=0 TO length-1 DO
	class := sc^.charTable[Text.GetChar(string,i)];
        IF (class # CharacterClass.SpecialCharCase) THEN RETURN FALSE END;
      END;
      RETURN TRUE;
    ELSE RETURN FALSE;
    END;
  END IsIdentifier;

PROCEDURE <A NAME="ScanPoint"><procedure>ScanPoint</procedure></A>(sc: T): INTEGER =
  BEGIN
    RETURN sc.scanPoint;
  END ScanPoint;

PROCEDURE <A NAME="GetInputState"><procedure>GetInputState</procedure></A>(sc: T) =
  BEGIN
    WITH z = sc^ DO
      IF z.input = NIL THEN
        z.fileName := &quot;&lt;no input&gt;&quot;;
        z.acceptedCharPos := 0;
        z.acceptedLinePos := 0;
        z.acceptedLineCharPos := 0;
        z.acceptedTokenBegPos := 0;
        z.acceptedTokenEndPos := 0;
      ELSE
        z.fileName := z.input^.fileName;
        z.acceptedCharPos := z.input^.acceptedCharPos;
        z.acceptedLinePos := z.input^.acceptedLinePos;
        z.acceptedLineCharPos := z.input^.acceptedLineCharPos;
        z.acceptedTokenBegPos := z.input^.acceptedTokenBegPos;
        z.acceptedTokenEndPos := z.input^.acceptedTokenEndPos;
     END;
   END;
  END GetInputState;

PROCEDURE <A NAME="SetInputState"><procedure>SetInputState</procedure></A>(sc: T) =
  BEGIN
    WITH z = sc^ DO
      IF z.input # NIL THEN
        z.input^.acceptedCharPos := z.acceptedCharPos;
        z.input^.acceptedLinePos := z.acceptedLinePos;
        z.input^.acceptedLineCharPos := z.acceptedLineCharPos;
        z.input^.acceptedTokenBegPos := z.acceptedTokenBegPos;
        z.input^.acceptedTokenEndPos := z.acceptedTokenEndPos;
       END;
     END;
   END SetInputState;

PROCEDURE <A NAME="NewInput"><procedure>NewInput</procedure></A>(fileName: TEXT; rd: Rd.T; rest: InputList;
    closeReader: BOOLEAN; generateEOF: BOOLEAN): InputList =
  VAR res: InputList;
  BEGIN
    res := NEW(InputList);
    res^.fileName := fileName;
    res^.rd := rd;
    res^.acceptedCharPos := 0;
    res^.acceptedLinePos := 1;
    res^.acceptedLineCharPos := 0;
    res^.acceptedTokenBegPos := 0;
    res^.acceptedTokenEndPos := 0;
    res^.generateEOF := generateEOF;
    res^.closeReader := closeReader;
    res^.rest := rest;
    RETURN res;
  END NewInput;

PROCEDURE <A NAME="PushInput"><procedure>PushInput</procedure></A>(sc: T; fileName: TEXT; rd: Rd.T; closeReader: BOOLEAN;
    generateEOF: BOOLEAN := TRUE) =
  BEGIN
    SetInputState(sc);
    sc^.input := NewInput(fileName, rd, sc^.input, closeReader, generateEOF);
    GetInputState(sc);
  END PushInput;

PROCEDURE <A NAME="PopInput"><procedure>PopInput</procedure></A>(sc: T) RAISES {NoReader} =
  BEGIN
    IF sc^.input = NIL THEN RAISE NoReader
    ELSE
      IF sc^.input^.closeReader THEN Rd.Close(sc^.input^.rd) END;
      sc^.input := sc^.input^.rest;
      GetInputState(sc);
    END;
  END PopInput;

PROCEDURE <A NAME="CurrentLocationInfo"><procedure>CurrentLocationInfo</procedure></A>(sc: T; VAR(*out*) info: SynLocation.Info) =
  BEGIN
    info.fileName:=sc^.fileName;
    info.char := sc^.acceptedCharPos;
    info.line := sc^.acceptedLinePos;
    info.lineChar := sc^.acceptedLineCharPos;
  END CurrentLocationInfo;

PROCEDURE <A NAME="SetCharNo"><procedure>SetCharNo</procedure></A>(sc: T; charNo, lineNo, lineCharNo: INTEGER) =
  BEGIN
    WITH z = sc^ DO
      z.acceptedCharPos := charNo;
      z.acceptedLinePos := lineNo;
      z.acceptedLineCharPos := lineCharNo;
      z.acceptedTokenBegPos := charNo;
      z.acceptedTokenEndPos := charNo;
    END;
  END SetCharNo;

PROCEDURE <A NAME="PrintPrompt"><procedure>PrintPrompt</procedure></A>(sc: T) =
  BEGIN
    WITH z = sc^ DO
      IF z.isFirstPrompt THEN
        Wr.PutText(Stdio.stdout, z.firstPrompt);
        Wr.Flush(Stdio.stdout);
        INC(z.acceptedCharPos, Text.Length(z.firstPrompt));
        INC(z.acceptedLineCharPos, Text.Length(z.firstPrompt));
        z.isFirstPrompt := FALSE;
      ELSE
        Wr.PutText(Stdio.stdout, z.nextPrompt);
        Wr.Flush(Stdio.stdout);
        INC(z.acceptedCharPos, Text.Length(z.nextPrompt));
        INC(z.acceptedLineCharPos, Text.Length(z.nextPrompt));
      END;
    END;
  END PrintPrompt;

PROCEDURE <A NAME="LookChar"><procedure>LookChar</procedure></A>(sc: T): CHAR RAISES {NoReader} =
  VAR char: CHAR;
  BEGIN
    WITH z = sc^ DO
      IF z.lookAheadReady THEN RETURN z.lookAheadChar END;
      IF z.input=NIL THEN RAISE NoReader END;
      IF Rd.CharsReady(z.input^.rd) = 0 THEN PrintPrompt(sc); END;
      TRY
        char := Rd.GetChar(z.input^.rd);
        z.lookAheadChar := char;
        z.lookAheadReady := TRUE;
        RETURN char;
      EXCEPT Rd.EndOfFile =&gt;
        IF z.input^.generateEOF THEN
	  PopInput(sc);
	  z.lookAheadChar := EofChar;
	  z.lookAheadReady := TRUE;
	  RETURN EofChar;
        ELSE
	  PopInput(sc);
	  RETURN LookChar(sc);
        END;
      END;
    END;
  END LookChar;

PROCEDURE <A NAME="GetChar"><procedure>GetChar</procedure></A>(sc: T): CHAR RAISES {NoReader} =
  BEGIN
    WITH z = sc^ DO
      IF NOT z.lookAheadReady THEN EVAL LookChar(sc) END;
      z.lookAheadReady := FALSE;
      INC(z.acceptedCharPos);
      INC(z.acceptedLineCharPos);
      IF z.lookAheadChar='\n' THEN
        INC(z.acceptedLinePos);
        z.acceptedLineCharPos := 0;
      END;
      RETURN z.lookAheadChar;
    END;
  END GetChar;

PROCEDURE <A NAME="HaveChar"><procedure>HaveChar</procedure></A>(sc: T; char: CHAR): BOOLEAN RAISES {NoReader} =
  BEGIN
    IF char = LookChar(sc) THEN
      char := GetChar(sc);
      RETURN TRUE
    ELSE
      RETURN FALSE
    END;
  END HaveChar;

PROCEDURE <A NAME="ScanNumber"><procedure>ScanNumber</procedure></A>(sc: T): TokenClass RAISES {NoReader, Fail} =
  VAR integer: BOOLEAN; char: CHAR; buf: REF ARRAY OF CHAR;
  BEGIN
    WITH z = sc^ DO
      IF HaveChar(sc, '~') THEN
        z.scanBuffer[z.scanBufferSize]:= '-';
        INC(z.scanBufferSize);
      END;
      integer := TRUE;
      LOOP
        char := LookChar(sc);
        IF (z.charTable[char] # CharacterClass.DigitCharCase) AND
            (char # '.') AND (char # 'e') AND (char # '~') THEN
          EXIT
        END;
        char := GetChar(sc);
        IF (char = '.') OR (char = 'e') THEN integer := FALSE END;
        IF (NOT integer) AND (char = '~') THEN char := '-' END;
        z.scanBuffer[z.scanBufferSize]:= char;
        INC(z.scanBufferSize);
        IF z.scanBufferSize = NUMBER(z.scanBuffer^) THEN
          buf := NEW(REF ARRAY OF CHAR, 2*z.scanBufferSize);
          SUBARRAY(buf^, 0, z.scanBufferSize) := z.scanBuffer^;
          z.scanBuffer := buf;
        END;
      END;
      TRY
        IF integer THEN
          z.tokenInt :=
            Lex.Int(
              TextRd.New(
                Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize))));
          z.scanBufferSize := 0;
          RETURN TokenClass.IntCase
        ELSE
          z.tokenReal :=
            Lex.LongReal(
              TextRd.New(
                Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize))));
          z.scanBufferSize := 0;
          RETURN TokenClass.RealCase;
        END;
      EXCEPT Lex.Error, FloatMode.Trap, Rd.Failure, Thread.Alerted =&gt;
        SyntaxMsg(sc, &quot;Illegal numerical constant&quot;, &quot;&quot;);
        RAISE Fail;
      END;
    END;
  END ScanNumber;

PROCEDURE <A NAME="DecodeCharFromProducer"><procedure>DecodeCharFromProducer</procedure></A>(
    sc: T;
    VAR (*out*)charOut: CHAR)
    RAISES {TextConv.Fail} =
  CONST Octal01 = TextConv.CharSet{'0', '1'};
  VAR charsIn: ARRAY[0..3] OF CHAR; availIn: INTEGER;
  BEGIN
    TRY
      charsIn[0] := GetChar(sc);
      availIn := 1;
      IF charsIn[0] = TextConv.Escape THEN
        charsIn[1] := GetChar(sc);
        INC(availIn);
        IF charsIn[1] IN Octal01 THEN
          charsIn[2] := GetChar(sc);
          charsIn[3] := GetChar(sc);
          INC(availIn, 2);
        END;
      END;
    EXCEPT ELSE (* p failure *) RAISE TextConv.Fail;
    END;
    EVAL TextConv.DecodeChar(charsIn, availIn, (*out*)charOut);
  END DecodeCharFromProducer;

PROCEDURE <A NAME="DecodeChar"><procedure>DecodeChar</procedure></A>(sc: T): CHAR RAISES {NoReader, Fail} =
  VAR char: CHAR;
  BEGIN
    TRY
      DecodeCharFromProducer(sc, (*out*)char);
    EXCEPT
    | TextConv.Fail =&gt;
        SyntaxMsg(sc, &quot;ill-formed character escape sequence&quot;, &quot;&quot;);
        RAISE Fail;
    END;
    RETURN char;
  END DecodeChar;

PROCEDURE <A NAME="ScanChar"><procedure>ScanChar</procedure></A>(sc: T): CHAR RAISES {NoReader, Fail} =
  VAR char: CHAR;
  BEGIN
    char := GetChar(sc);
    char := DecodeChar(sc);
    IF GetChar(sc) # '\'' THEN
      SyntaxMsg(sc, &quot;closing \' expected&quot;, &quot;&quot;);
      RAISE Fail;
    END;
    RETURN char;
  END ScanChar;

PROCEDURE <A NAME="ScanString"><procedure>ScanString</procedure></A>(sc: T): TEXT RAISES {NoReader, Fail} =
  VAR char: CHAR; string: TEXT; buf: REF ARRAY OF CHAR;
  BEGIN
    WITH z = sc^ DO
      char := GetChar(sc);
      WHILE LookChar(sc) # '\&quot;' DO
        char := DecodeChar(sc);
        z.scanBuffer[z.scanBufferSize]:= char;
        INC(z.scanBufferSize);
        IF z.scanBufferSize = NUMBER(z.scanBuffer^) THEN
          buf := NEW(REF ARRAY OF CHAR, 2*z.scanBufferSize);
          SUBARRAY(buf^, 0, z.scanBufferSize) := z.scanBuffer^;
          z.scanBuffer := buf;
        END;
      END;
      char := GetChar(sc);
      string := Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize));
      z.scanBufferSize := 0;
      RETURN string;
    END;
  END ScanString;

PROCEDURE <A NAME="ScanAlphaNumIde"><procedure>ScanAlphaNumIde</procedure></A>(sc: T) RAISES {NoReader} =
  VAR class: CharacterClass;
  BEGIN
    WITH z = sc^ DO
      LOOP
        class := z.charTable[LookChar(sc)];
        IF (class # CharacterClass.LetterCharCase)
            AND (class # CharacterClass.DigitCharCase)
        THEN EXIT
        END;
        z.scanBuffer[z.scanBufferSize]:=GetChar(sc);
        INC(z.scanBufferSize);
      END;
    END;
  END ScanAlphaNumIde;

PROCEDURE <A NAME="ScanSpecialIde"><procedure>ScanSpecialIde</procedure></A>(sc: T) RAISES {NoReader} =
  BEGIN
    WITH z = sc^ DO
      WHILE z.charTable[LookChar(sc)] = CharacterClass.SpecialCharCase DO
        z.scanBuffer[z.scanBufferSize]:=GetChar(sc);
        INC(z.scanBufferSize);
      END;
    END;
  END ScanSpecialIde;

PROCEDURE <A NAME="ScanComment"><procedure>ScanComment</procedure></A>(sc: T) RAISES {NoReader, Fail} =
  VAR level: CARDINAL; char: CHAR;
  BEGIN
    level := 1;
    WHILE 0 &lt; level DO
      char := GetChar(sc);
      IF char=EofChar THEN
        SyntaxMsg(sc, &quot;Open comment at end of file&quot;, &quot;&quot;);
        RAISE Fail;
      END;
      IF char = '*' THEN
        IF LookChar(sc) = ')' THEN char := GetChar(sc); level := level - 1 END;
      ELSIF char = '(' THEN
        IF LookChar(sc) = '*' THEN char := GetChar(sc); level := level + 1 END;
      END;
    END
  END ScanComment;

PROCEDURE <A NAME="NextToken"><procedure>NextToken</procedure></A>(sc: T): TokenClass RAISES {NoReader, Fail} =
  VAR char: CHAR; class: CharacterClass; tokenClass1: TokenClass;
  BEGIN
    WITH z = sc^ DO
      WHILE z.charTable[LookChar(sc)] = CharacterClass.BlankCharCase DO
        char := GetChar(sc);
      END;
      z.tokenBegPos := z.acceptedCharPos;
      char := LookChar(sc);
      class := z.charTable[char];
      IF class = CharacterClass.LetterCharCase THEN
        ScanAlphaNumIde(sc);
        tokenClass1 := TokenClass.IdeCase;
      ELSIF class = CharacterClass.DelimCharCase THEN
        z.tokenDelim := GetChar(sc);
        IF (char = '(') AND (LookChar(sc) = '*') THEN
          char := GetChar(sc);
          ScanComment(sc);
          tokenClass1 := NextToken(sc);
        ELSE
          tokenClass1 := TokenClass.DelimCase;
        END;
      ELSIF class = CharacterClass.SpecialCharCase THEN
        ScanSpecialIde(sc);
        tokenClass1 := TokenClass.InfixCase;
      ELSIF (char = '~') OR (class = CharacterClass.DigitCharCase) THEN
        tokenClass1 := ScanNumber(sc);
      ELSIF char = '\'' THEN
        z.tokenChar := ScanChar(sc);
        tokenClass1 := TokenClass.CharCase;
      ELSIF char = '\&quot;' THEN
        z.tokenString := ScanString(sc);
        tokenClass1 := TokenClass.StringCase;
      ELSIF class = CharacterClass.EofCase THEN
        char := GetChar(sc);
        tokenClass1 := TokenClass.EofCase;
      ELSE
        char := GetChar(sc);
        SyntaxMsg(sc, &quot;Illegal Char&quot;, &quot;&quot;);
        RAISE Fail;
      END;
      z.tokenEndPos := z.acceptedCharPos;
      RETURN tokenClass1;
    END;
  END NextToken;

PROCEDURE <A NAME="LookToken"><procedure>LookToken</procedure></A>(sc: T): TokenClass RAISES {NoReader, Fail} =
  BEGIN
    WITH z = sc^ DO
      IF z.tokenReady THEN RETURN z.tokenClass END;
      z.tokenClass := NextToken(sc);
      z.tokenReady := TRUE;
      RETURN z.tokenClass;
    END;
  END LookToken;

PROCEDURE <A NAME="GetToken"><procedure>GetToken</procedure></A>(sc: T): TokenClass RAISES {NoReader, Fail} =
  VAR class: TokenClass;
  BEGIN
    WITH z = sc^ DO
      IF z.tokenReady THEN
        z.tokenReady := FALSE;
        class := z.tokenClass;
      ELSE
        class := NextToken(sc);
      END;
      INC(z.scanPoint);
      z.acceptedTokenBegPos := z.tokenBegPos;
      z.acceptedTokenEndPos := z.tokenEndPos;
      RETURN class;
    END;
  END GetToken;

PROCEDURE <A NAME="PrintContext"><procedure>PrintContext</procedure></A>(sc: T) =
  VAR string: TEXT;
  BEGIN
    WITH z = sc^ DO
      SynWr.Text(sc.swr, &quot; just before: &quot;, loud:=TRUE);
      CASE z.tokenClass OF
      | TokenClass.IdeCase, TokenClass.InfixCase =&gt;
          string :=
            Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize));
          z.scanBufferSize := 0;
          SynWr.Text(sc.swr, string, loud:=TRUE);
      | TokenClass.CharCase =&gt; SynWr.Char(sc.swr, z.tokenChar, loud:=TRUE);
      | TokenClass.IntCase =&gt;
          SynWr.Text(sc.swr, Fmt.Int(z.tokenInt), loud:=TRUE);
      | TokenClass.RealCase =&gt;
          SynWr.Text(sc.swr, Fmt.LongReal(z.tokenReal), loud:=TRUE);
      | TokenClass.StringCase =&gt;
          SynWr.Char(sc.swr, '\&quot;', loud:=TRUE);
          SynWr.Text(sc.swr, z.tokenString, loud:=TRUE);
          SynWr.Char(sc.swr, '\&quot;', loud:=TRUE);
      | TokenClass.DelimCase =&gt; SynWr.Char(sc.swr, z.tokenDelim, loud:=TRUE);
      | TokenClass.EofCase =&gt; SynWr.Text(sc.swr, &quot;&lt;EndOfInput&gt;&quot;, loud:=TRUE);
      END;
      SynWr.Flush(sc.swr, loud:=TRUE);
    END;
  END PrintContext;

PROCEDURE <A NAME="PrintSequel"><procedure>PrintSequel</procedure></A>(sc: T) =
  VAR n: INTEGER; ch: CHAR;
  BEGIN
    IF sc^.input = NIL THEN RETURN END;
    n := 40;
    WHILE (0 &lt; n) AND (Rd.CharsReady(sc^.input^.rd) &gt; 0) DO
      ch:=GetChar(sc); &lt;* NOWARN *&gt;
      IF sc^.input = NIL THEN RETURN END;
      IF (Rd.CharsReady(sc^.input^.rd)&gt;0) OR (ch#'\n') THEN
        SynWr.Char(sc.swr, ch, loud:=TRUE);
      END;
      n := n - 1;
    END;
    IF Rd.CharsReady(sc^.input^.rd) &gt; 0 THEN
      SynWr.Text(sc.swr, &quot; ...&quot;, loud:=TRUE);
    END;
  END PrintSequel;

PROCEDURE <A NAME="FlushInput"><procedure>FlushInput</procedure></A>(sc: T) =
  BEGIN
    IF sc^.input = NIL THEN RETURN END;
    WHILE Rd.CharsReady(sc^.input^.rd) &gt; 0 DO
      EVAL GetChar(sc); &lt;* NOWARN *&gt;
      IF sc^.input = NIL THEN RETURN END;
    END;
  END FlushInput;

PROCEDURE <A NAME="ErrorMsg"><procedure>ErrorMsg</procedure></A>(sc: T; msg: TEXT := &quot;&quot;) =
  BEGIN
    IF NOT Text.Empty(msg) THEN
      SynWr.Text(sc.swr, msg, loud:=TRUE);
      SynWr.Char(sc.swr, '\n', loud:=TRUE);
      SynWr.Flush(sc.swr, loud:=TRUE);
    END;
    Reset(sc);
  END ErrorMsg;

PROCEDURE <A NAME="SyntaxMsg"><procedure>SyntaxMsg</procedure></A>(sc: T; cause: TEXT := &quot;&quot;; culprit: TEXT := &quot;&quot;;
    errorReportStyle: ErrorReportStyle := ErrorReportStyle.LinePlusChar) =
  VAR info: SynLocation.Info;
  BEGIN
    CurrentLocationInfo(sc, (*out*)info);
    SynWr.Text(sc.swr, &quot;Syntax error just before: &quot;, loud:=TRUE);
    PrintSequel(sc);
    IF (NOT Text.Empty(cause)) OR (NOT Text.Empty(culprit)) THEN
      SynWr.Char(sc.swr, '\n', loud:=TRUE);
      SynWr.Text(sc.swr, &quot;  &quot;, loud:=TRUE);
      SynWr.Text(sc.swr, cause, loud:=TRUE);
      SynWr.Char(sc.swr, ' ', loud:=TRUE);
      SynWr.Text(sc.swr, culprit, loud:=TRUE);
    END;
    SynWr.Char(sc.swr, '\n', loud:=TRUE);
    SynWr.Text(sc.swr, &quot;Error detected &quot;, loud:=TRUE);
    CASE errorReportStyle OF
    | ErrorReportStyle.LinePlusChar =&gt;
        IF Text.Empty(info.fileName) THEN
          SynLocation.PrintLineDifference(sc.swr,
            SynLocation.NewLineLocation(info), info.line);
        ELSE
          SynLocation.PrintLocation(sc.swr,
            SynLocation.NewLineLocation(info));
        END;
    | ErrorReportStyle.CharRange =&gt;
        SynLocation.PrintLocation(sc.swr,
            SynLocation.NewCharLocation(info, info));
    END;
    SynWr.Char(sc.swr, '\n', loud:=TRUE);
    SynWr.Flush(sc.swr, loud:=TRUE);
    Reset(sc);
  END SyntaxMsg;

PROCEDURE <A NAME="GetTokenChar"><procedure>GetTokenChar</procedure></A>(sc: T; VAR (*out*) char: CHAR): BOOLEAN
RAISES {NoReader, Fail} =
  BEGIN
    IF LookToken(sc) = TokenClass.CharCase THEN
      EVAL(GetToken(sc));
      char := sc^.tokenChar;
      RETURN TRUE;
    ELSE RETURN FALSE;
    END;
  END GetTokenChar;

PROCEDURE <A NAME="GetTokenNat"><procedure>GetTokenNat</procedure></A>(sc: T; VAR (*out*) nat: CARDINAL): BOOLEAN
RAISES {NoReader, Fail} =
  BEGIN
    IF LookToken(sc) = TokenClass.IntCase THEN
      IF sc^.tokenInt &gt;= 0 THEN
	EVAL(GetToken(sc));
        nat := sc^.tokenInt;
	RETURN TRUE;
      ELSE
        RETURN FALSE;
      END;
    ELSE RETURN FALSE;
    END;
  END GetTokenNat;

PROCEDURE <A NAME="GetTokenInt"><procedure>GetTokenInt</procedure></A>(sc: T; VAR (*out*) int: INTEGER): BOOLEAN
RAISES {NoReader, Fail} =
  BEGIN
    IF LookToken(sc) = TokenClass.IntCase THEN
      EVAL(GetToken(sc));
      int := sc^.tokenInt;
      RETURN TRUE;
    ELSE
      RETURN FALSE;
    END;
  END GetTokenInt;

PROCEDURE <A NAME="GetTokenReal"><procedure>GetTokenReal</procedure></A>(sc: T; VAR (*ou*) real: LONGREAL): BOOLEAN
RAISES {NoReader, Fail} =
  BEGIN
    IF LookToken(sc) = TokenClass.RealCase THEN
      EVAL(GetToken(sc));
      real := sc^.tokenReal;
      RETURN TRUE;
    ELSE RETURN FALSE;
    END;
  END GetTokenReal;

PROCEDURE <A NAME="GetTokenString"><procedure>GetTokenString</procedure></A>(sc: T; VAR (*out*) string: TEXT): BOOLEAN
RAISES {NoReader, Fail} =
  BEGIN
    IF LookToken(sc) = TokenClass.StringCase THEN
      EVAL(GetToken(sc));
      string := sc^.tokenString;
      RETURN TRUE;
    ELSE RETURN FALSE;
    END;
  END GetTokenString;

PROCEDURE <A NAME="GetTokenIde"><procedure>GetTokenIde</procedure></A>(sc: T; VAR (*ou*) ide: TEXT): BOOLEAN
RAISES {NoReader, Fail} =
  VAR class: TokenClass; name: TEXT; value: REFANY;
  BEGIN
    WITH z = sc^ DO
      class := LookToken(sc);
      IF (class = TokenClass.IdeCase) OR (class = TokenClass.InfixCase) THEN
        IF z.scanBufferSize # 0 THEN
          name := Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize));
	  IF z.keySet.table.get(name, (*VAR OUT*) value) THEN
	    z.tokenSym := NARROW(value, Symbol);
	  ELSE
	    z.tokenSym := NEW(Symbol, name:=name, keyword:=FALSE);
	    EVAL z.keySet.table.put(name, z.tokenSym);
	  END;
          z.scanBufferSize := 0;
        END;
        IF z.tokenSym.keyword THEN RETURN FALSE END;
        EVAL(GetToken(sc));
        ide := z.tokenSym.name;
        RETURN TRUE;
      ELSE RETURN FALSE;
      END;
    END;
  END GetTokenIde;

PROCEDURE <A NAME="GetTokenName"><procedure>GetTokenName</procedure></A>(sc: T; VAR (*ou*) text: TEXT): BOOLEAN
RAISES {NoReader, Fail} =
  VAR class: TokenClass; name: TEXT; value: REFANY;
  BEGIN
    WITH z = sc^ DO
      class := LookToken(sc);
      IF (class = TokenClass.IdeCase) OR (class = TokenClass.InfixCase) THEN
        IF z.scanBufferSize # 0 THEN
	  name := Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize));
	  IF z.keySet.table.get(name, (*VAR OUT*) value) THEN
	    z.tokenSym := NARROW(value, Symbol);
	  ELSE
	    z.tokenSym := NEW(Symbol, name:=name, keyword:=FALSE);
	    EVAL z.keySet.table.put(name, z.tokenSym);
	  END;
          z.scanBufferSize := 0;
        END;
        EVAL(GetToken(sc));
        text := z.tokenSym.name;
        RETURN TRUE;
      ELSE RETURN FALSE;
      END;
    END;
  END GetTokenName;

PROCEDURE <A NAME="GetTokenEof"><procedure>GetTokenEof</procedure></A>(sc: T): BOOLEAN
RAISES {NoReader, Fail} =
  VAR class : TokenClass ;
  BEGIN
    class := LookToken(sc);
    IF class = TokenClass.EofCase THEN
      EVAL GetToken(sc);
      RETURN TRUE;
    ELSE
      RETURN FALSE ;
    END;
  END GetTokenEof;

PROCEDURE <A NAME="HaveTokenIde"><procedure>HaveTokenIde</procedure></A>(sc: T; ide: TEXT): BOOLEAN
RAISES {NoReader, Fail} =
  VAR class: TokenClass; name: TEXT; value: REFANY;
  BEGIN
    WITH z = sc^ DO
      class := LookToken(sc);
      IF (class = TokenClass.IdeCase) OR (class = TokenClass.InfixCase) THEN
        IF z.scanBufferSize # 0 THEN
	  name := Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize));
	  IF z.keySet.table.get(name, (*VAR OUT*) value) THEN
	    z.tokenSym := NARROW(value, Symbol);
	  ELSE
	    z.tokenSym := NEW(Symbol, name:=name, keyword:=FALSE);
	    EVAL z.keySet.table.put(name, z.tokenSym);
	  END;
          z.scanBufferSize := 0;
        END;
        IF z.tokenSym.keyword THEN RETURN FALSE END;
        IF NOT Text.Equal(ide, z.tokenSym.name) THEN RETURN FALSE END;
        EVAL(GetToken(sc));
        RETURN TRUE;
      ELSE RETURN FALSE;
      END;
    END;
  END HaveTokenIde;

PROCEDURE <A NAME="HaveTokenName"><procedure>HaveTokenName</procedure></A>(sc: T; text: TEXT): BOOLEAN
RAISES {NoReader, Fail} =
  VAR class: TokenClass; name: TEXT; value: REFANY;
  BEGIN
    WITH z = sc^ DO
      class := LookToken(sc);
      IF (class = TokenClass.IdeCase) OR (class = TokenClass.InfixCase) THEN
        IF z.scanBufferSize # 0 THEN
	  name := Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize));
	  IF z.keySet.table.get(name, (*VAR OUT*) value) THEN
	    z.tokenSym := NARROW(value, Symbol);
	  ELSE
	    z.tokenSym := NEW(Symbol, name:=name, keyword:=FALSE);
	    EVAL z.keySet.table.put(name, z.tokenSym);
	  END;
          z.scanBufferSize := 0;
        END;
        IF NOT Text.Equal(text, z.tokenSym.name) THEN RETURN FALSE END;
        EVAL(GetToken(sc));
        RETURN TRUE;
     ELSE RETURN FALSE;
     END;
    END;
  END HaveTokenName;

PROCEDURE <A NAME="HaveTokenKey"><procedure>HaveTokenKey</procedure></A>(sc: T; key: TEXT): BOOLEAN RAISES {NoReader, Fail} =
  VAR class: TokenClass; name: TEXT; value: REFANY;
  BEGIN
    WITH z = sc^ DO
      class := LookToken(sc);
      IF (class = TokenClass.IdeCase) OR (class = TokenClass.InfixCase) THEN
        IF z.scanBufferSize # 0 THEN
	  name := Text.FromChars(SUBARRAY(z.scanBuffer^, 0, z.scanBufferSize));
	  IF z.keySet.table.get(name, (*VAR OUT*) value) THEN
	    z.tokenSym := NARROW(value, Symbol);
	  ELSE
	    z.tokenSym := NEW(Symbol, name:=name, keyword:=FALSE);
	    EVAL z.keySet.table.put(name, z.tokenSym);
	  END;
          z.scanBufferSize := 0;
        END;
        IF NOT z.tokenSym.keyword THEN RETURN FALSE END;
        IF NOT Text.Equal(key, z.tokenSym.name) THEN RETURN FALSE END;
        EVAL(GetToken(sc));
        RETURN TRUE;
      ELSE RETURN FALSE;
      END;
    END;
  END HaveTokenKey;

PROCEDURE <A NAME="HaveTokenDelim"><procedure>HaveTokenDelim</procedure></A>(sc: T; delim: CHAR): BOOLEAN
RAISES {NoReader, Fail} =
  BEGIN
    IF LookToken(sc) = TokenClass.DelimCase THEN
      IF delim # sc^.tokenDelim THEN RETURN FALSE END;
      EVAL(GetToken(sc));
      RETURN TRUE;
    ELSE RETURN FALSE;
    END;
  END HaveTokenDelim;

PROCEDURE <A NAME="SetChar"><procedure>SetChar</procedure></A>(sc: T; n: CHAR; class: CharacterClass) =
  BEGIN sc^.charTable[n] := class; END SetChar;

PROCEDURE <A NAME="SetRange"><procedure>SetRange</procedure></A>(sc: T; n: CHAR; m: CHAR; class: CharacterClass) =
  BEGIN
    FOR i := ORD(n) TO ORD(m) DO sc^.charTable[VAL(i, CHAR)] := class; END;
  END SetRange;

PROCEDURE <A NAME="TopLevel"><procedure>TopLevel</procedure></A>(sc: T): BOOLEAN =
  BEGIN RETURN Text.Empty(sc^.fileName); END TopLevel;

PROCEDURE <A NAME="SetPrompt"><procedure>SetPrompt</procedure></A>(sc: T; newFirstPrompt, newNextPrompt: TEXT) =
  BEGIN
    sc^.firstPrompt := newFirstPrompt;
    sc^.nextPrompt := newNextPrompt;
    sc^.isFirstPrompt := TRUE;
  END SetPrompt;

PROCEDURE <A NAME="FirstPrompt"><procedure>FirstPrompt</procedure></A>(sc: T) = BEGIN sc^.isFirstPrompt := TRUE; END FirstPrompt;

PROCEDURE <A NAME="Clear"><procedure>Clear</procedure></A>(sc: T) =
  VAR ch: CHAR; class: TokenClass;
  BEGIN
    IF TopLevel(sc) THEN FlushInput(sc) END;
    IF sc^.lookAheadReady THEN ch:=GetChar(sc) END; &lt;* NOWARN *&gt;
    IF sc^.tokenReady THEN class:=GetToken(sc) END; &lt;* NOWARN *&gt;
    sc^.scanBufferSize := 0;
  END Clear;

PROCEDURE <A NAME="Reset"><procedure>Reset</procedure></A>(sc: T) =
  BEGIN
    Clear(sc);
    WHILE (sc^.input#NIL) AND NOT(Text.Empty(sc^.input^.fileName)) DO
      PopInput(sc); &lt;* NOWARN *&gt;
    END;
  END Reset;

PROCEDURE <A NAME="GetKeywordName"><procedure>GetKeywordName</procedure></A>(key : Keyword): TEXT =
BEGIN
 RETURN key.name ;
END GetKeywordName;

PROCEDURE <A NAME="GetWriter"><procedure>GetWriter</procedure></A>(sc: T): SynWr.T =
BEGIN
  RETURN sc.swr;
END GetWriter;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(swr: SynWr.T): T =
  VAR sc: T;
  BEGIN
    sc := NEW(T);

    sc.swr := swr;

    sc^.scanPoint := 0;
    sc^.scanBuffer := NEW(REF ARRAY OF CHAR, 256);

    sc^.keySet := NewKeywordSet();

    sc^.lookAheadReady := FALSE;
    sc^.tokenReady := FALSE;
    sc^.scanBufferSize := 0;
    sc^.input := NIL;

    SetPrompt(sc, &quot;&quot;, &quot;&quot;);

    SetRange(sc, VAL(9, CHAR), VAL(10, CHAR), CharacterClass.BlankCharCase);
    SetRange(sc, VAL(12, CHAR), VAL(13, CHAR), CharacterClass.BlankCharCase);
    SetChar(sc, ' ', CharacterClass.BlankCharCase);
    SetChar(sc, '!', CharacterClass.DelimCharCase);
    SetChar(sc, '\&quot;', CharacterClass.ReservedCharCase);
    SetRange(sc, '#', '&amp;', CharacterClass.SpecialCharCase);
    SetChar(sc, '\'', CharacterClass.ReservedCharCase);
    SetRange(sc, '(', ')', CharacterClass.DelimCharCase);
    SetRange(sc, '*', '+', CharacterClass.SpecialCharCase);
    SetChar(sc, ',', CharacterClass.DelimCharCase);
    SetChar(sc, '-', CharacterClass.SpecialCharCase);
    SetChar(sc, '.', CharacterClass.DelimCharCase);
    SetChar(sc, '/', CharacterClass.SpecialCharCase);
    SetRange(sc, '0', '9', CharacterClass.DigitCharCase);
    SetChar(sc, ':', CharacterClass.SpecialCharCase);
    SetChar(sc, ';', CharacterClass.DelimCharCase);
    SetChar(sc, '&lt;', CharacterClass.SpecialCharCase);
    SetChar(sc, '=', CharacterClass.SpecialCharCase);
    SetChar(sc, '&gt;', CharacterClass.SpecialCharCase);
    SetChar(sc, '?', CharacterClass.DelimCharCase);
    SetChar(sc, '@', CharacterClass.SpecialCharCase);
    SetRange(sc, 'A', 'Z', CharacterClass.LetterCharCase);
    SetChar(sc, '[', CharacterClass.DelimCharCase);
    SetChar(sc, '\\', CharacterClass.SpecialCharCase);
    SetChar(sc, ']', CharacterClass.DelimCharCase);
    SetChar(sc, '^', CharacterClass.SpecialCharCase);
    SetChar(sc, '_', CharacterClass.DelimCharCase);
    SetChar(sc, '`', CharacterClass.LetterCharCase);
    SetRange(sc, 'a', 'z', CharacterClass.LetterCharCase);
    SetChar(sc, '{', CharacterClass.DelimCharCase);
    SetChar(sc, '|', CharacterClass.DelimCharCase);
    SetChar(sc, '}', CharacterClass.DelimCharCase);
    SetChar(sc, '~', CharacterClass.ReservedCharCase);
    SetChar(sc, EofChar, CharacterClass.EofCase);

    RETURN sc;

  END New;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
  END Setup;

BEGIN
END SynScan.
</PRE> An old version of ScanNumber that does not depend on Lex.
<P>
PROCEDURE ScanNat(sc: T): CARDINAL RAISES {NoReader, Fail} =
  VAR nat: INTEGER;
  BEGIN
    nat := 0;
    WHILE sc^.charTable[LookChar(sc)] = CharacterClass.DigitCharCase DO
      nat := (10 * nat) + (ORD(GetChar(sc)) - ORD('0'));
      IF (nat &lt; 0) OR (nat &gt; LAST(CARDINAL)) THEN
        SyntaxMsg(sc, <CODE>Integer constant is too big</CODE>, <CODE></CODE>);
        RAISE Fail;
      END;
    END;
    RETURN nat;
  END ScanNat;
<P>
PROCEDURE ScanNeg(sc: T): INTEGER RAISES {NoReader, Fail} =
  VAR neg: INTEGER;
  BEGIN
    neg := 0;
    WHILE sc^.charTable[LookChar(sc)] = CharacterClass.DigitCharCase DO
      neg := (10 * neg) - (ORD(GetChar(sc)) - ORD('0'));
      IF neg &gt; 0 THEN
        SyntaxMsg(sc, <CODE>Integer constant is too big</CODE>, <CODE></CODE>);
        RAISE Fail;
      END;
    END;
    RETURN neg;
  END ScanNeg;
<P>
PROCEDURE ScanInt(): INTEGER RAISES {NoReader, Fail} =
  BEGIN
    IF HaveChar('~') THEN RETURN ScanNeg() ELSE RETURN ScanNat() END;
  END ScanInt;
<P>
PROCEDURE ScanNumber(sc: T): TokenClass RAISES {NoReader, Fail} =
  VAR negative: BOOLEAN; int: INTEGER; real, quot: LONGREAL; ch: CHAR;
  BEGIN
    WITH z = sc^ DO
      negative := HaveChar(sc, '~');
      IF negative THEN int := ScanNeg(sc) ELSE int := ScanNat(sc) END;
      IF LookChar(sc) = '.' THEN
        ch := GetChar(sc);
        real := FLOAT(int, LONGREAL);
        quot := 1.0d0;
        WHILE z.charTable[LookChar(sc)] = CharacterClass.DigitCharCase DO
          quot := quot * 10.0d0;
          IF negative THEN
            real := real - 
              (FLOAT((ORD(GetChar(sc)) - ORD('0')), LONGREAL) / quot);
          ELSE
            real := real + 
              (FLOAT((ORD(GetChar(sc)) - ORD('0')), LONGREAL) / quot);
          END;
        END;
        z.tokenReal := real;
        RETURN TokenClass.RealCase;
      ELSE
        z.tokenInt := int;
        RETURN TokenClass.IntCase
      END;
    END;
  END ScanNumber;
<P>


</inModule>
<HR>
<A NAME="x1">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
