<HTML>
<HEAD>
<TITLE>SRC Modula-3: synloc/src/SynLocation.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>synloc/src/SynLocation.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="SynLocation.m3">SynLocation</A></interface>;
IMPORT <A HREF="SynWr.i3">SynWr</A>;

TYPE
  <A HREF="SynLocation.m3#T">T</A> &lt;: ROOT;
  (* &quot;Location.T&quot; represents a location in a source file where an error
     may occur. Line numbers and character numbers start at 1.
     There are two styles of error reporting and two
     corresponding styles of locations: (1) &quot;line-style&quot;, which
     reports the file name, the line position within the file, and
     the character position within the line; (2) &quot;selection-style&quot;,
     which reports the file name and two character positions within
     the file. The choice between these styles is made by using
     either (1) the NewLineLocation or (2) the NewCharLocation
     procedure below.
  *)

  Located =
    BRANDED &quot;Located&quot; OBJECT
      location: T := NIL;
    END;
  (* A located object, to be subtyped. *)

  Info =
    RECORD
      fileName: TEXT;
      char: INTEGER;
      line, lineChar: INTEGER;
    END;
</PRE><BLOCKQUOTE><EM> <CODE>Info</CODE> represents a location in a file. <CODE>char</CODE> is the character 
   position within the file. <CODE>line</CODE> is  the line position within the file, 
   and <CODE>lineChar</CODE> is the character position within that line. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynLocation.m3#PackageSetup">PackageSetup</A>();
</PRE><BLOCKQUOTE><EM> To be called at least once before any other use of the synloc package. </EM></BLOCKQUOTE><PRE>

VAR (*READONLY*) noLocation: T;
</PRE><BLOCKQUOTE><EM> No particular location. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynLocation.m3#NewLocation">NewLocation</A>(where: TEXT): T;
</PRE><BLOCKQUOTE><EM> The location is described simply by the parameter <CODE>where</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynLocation.m3#NewLineLocation">NewLineLocation</A>(READONLY info: Info): T;
</PRE><BLOCKQUOTE><EM> Creates a new <CODE>line-style</CODE> error location from a Info that
   specifyies <CODE>fileName</CODE>, <CODE>line</CODE>, and <CODE>lineChar</CODE>; <CODE>char</CODE> is not used.
   If <CODE>fileName</CODE> is empty, this indicates <CODE>top-level</CODE> interaction, and
   the position information is relative to the beginning of the 
   interactive session. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynLocation.m3#NewCharLocation">NewCharLocation</A>(READONLY begInfo, endInfo: Info):  T;
</PRE><BLOCKQUOTE><EM> Creates a new <CODE>selection-style</CODE> error location from a pair of Info
   each specifying <CODE>fileName</CODE>, and <CODE>char</CODE>; <CODE>line</CODE>, and <CODE>lineChar</CODE> are not used.
   If <CODE>fileName</CODE> is empty, this indicates <CODE>top-level</CODE> interaction, and
   the position information is relative to the beginning of the 
   interactive session. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynLocation.m3#PrintLocation">PrintLocation</A>(swr: SynWr.T; location: T);
</PRE><BLOCKQUOTE><EM> Prints the location of an error, in <CODE>line-style</CODE> or <CODE>selection-style</CODE>
   as determined by <CODE>location</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SynLocation.m3#PrintLineDifference">PrintLineDifference</A>(swr: SynWr.T; location: T; currentLine: INTEGER);
</PRE><BLOCKQUOTE><EM> This is used only for <CODE>line-style</CODE> errors that occur during top-level 
   interaction; <CODE>currentLine</CODE> should provide the current line number from 
   the beginning of the interactive session. Then, PrintLineDifference 
   generates location messages such as <CODE>last input line</CODE> or <CODE>input line -5</CODE>. </EM></BLOCKQUOTE><PRE>

END SynLocation.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
