<HTML>
<HEAD>
<TITLE>SRC Modula-3: synloc/src/SynLocation.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>synloc/src/SynLocation.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="SynLocation.i3">SynLocation</A></implements></module>;
IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="SynWr.i3">SynWr</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>;

VAR setupDone := FALSE;

PROCEDURE <A NAME="PackageSetup"><procedure>PackageSetup</procedure></A>() =
  BEGIN
    IF NOT setupDone THEN
      setupDone := TRUE;
      SynWr.Setup();
      Setup();
    END;
  END PackageSetup;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    noLocation := NEW(NoLocation);
  END Setup;

REVEAL
  <A NAME="T">T</A> = BRANDED &quot;Location&quot; OBJECT END;

TYPE
  NoLocation =
    T BRANDED OBJECT END;

  SomeLocation =
    T BRANDED OBJECT
      where: TEXT;
    END;

  LineLocation =
    T BRANDED OBJECT
      fileName: TEXT;
      line, char: INTEGER;
    END;

  CharLocation =
    T BRANDED OBJECT
      fileName: TEXT;
      begChar, endChar: INTEGER;
    END;

PROCEDURE <A NAME="NewLocation"><procedure>NewLocation</procedure></A>(where: TEXT): T =
  BEGIN
    RETURN NEW(SomeLocation, where:=where);
  END NewLocation;

PROCEDURE <A NAME="NewCharLocation"><procedure>NewCharLocation</procedure></A>(READONLY begInfo, endInfo: Info): T =
  BEGIN
    RETURN
      NEW(CharLocation, fileName:=begInfo.fileName,
	begChar:=begInfo.char, endChar:=endInfo.char);
  END NewCharLocation;

PROCEDURE <A NAME="NewLineLocation"><procedure>NewLineLocation</procedure></A>(READONLY info: Info): T =
  BEGIN
    RETURN NEW(LineLocation, fileName:=info.fileName,
	line:=info.line, char:=info.lineChar);
  END NewLineLocation;

PROCEDURE <A NAME="PrintLocation"><procedure>PrintLocation</procedure></A>(swr: SynWr.T; location: T) =
  BEGIN
    TYPECASE location OF
    | NULL =&gt;
    | NoLocation =&gt;
    | SomeLocation(loc) =&gt;
      IF NOT Text.Empty(loc.where) THEN
        SynWr.Text(swr, &quot;(&quot; &amp; loc.where &amp; &quot;)&quot;, loud:=TRUE);
      END;
    | CharLocation(loc) =&gt;
      IF Text.Empty(loc.fileName) THEN
        IF loc.begChar=loc.endChar THEN
          SynWr.Text(swr, &quot;(char &quot; &amp; Fmt.Int(loc.begChar) &amp; &quot;)&quot;, loud:=TRUE);
        ELSE
          SynWr.Text(swr, &quot;(chars &quot; &amp; Fmt.Int(loc.begChar)
	  &amp; &quot;..&quot; &amp; Fmt.Int(loc.endChar) &amp; &quot;)&quot;, loud:=TRUE);
	END;
      ELSE
        SynWr.Text(swr, &quot;(file &quot; &amp; loc.fileName, loud:=TRUE);
        IF loc.begChar=loc.endChar THEN
          SynWr.Text(swr, &quot;) (char &quot; &amp; Fmt.Int(loc.begChar) &amp; &quot;)&quot;, loud:=TRUE);
        ELSE
          SynWr.Text(swr, &quot;) (chars &quot; &amp; Fmt.Int(loc.begChar)
	  &amp; &quot;..&quot; &amp; Fmt.Int(loc.endChar) &amp; &quot;)&quot;, loud:=TRUE);
	END;
      END;
    | LineLocation(loc) =&gt;
      IF Text.Empty(loc.fileName) THEN
        SynWr.Text(swr,
          &quot;(input line &quot; &amp; Fmt.Int(loc.line)
	  &amp; &quot;, char &quot; &amp; Fmt.Int(loc.char) &amp; &quot;)&quot;, loud:=TRUE);
      ELSE
        SynWr.Text(swr, &quot;(file &quot; &amp; loc.fileName
            &amp; &quot;) (line &quot; &amp; Fmt.Int(loc.line)
	    &amp; &quot;, char &quot; &amp; Fmt.Int(loc.char) &amp; &quot;)&quot;, loud:=TRUE);
      END;
    ELSE SynWr.Text(swr, &quot;&lt;unknown location style&gt;&quot;, loud:=TRUE);
    END;
  END PrintLocation;

PROCEDURE <A NAME="PrintLineDifference"><procedure>PrintLineDifference</procedure></A>(swr: SynWr.T; location: T;
    currentLine: INTEGER) =
  VAR relLine: INTEGER;
  BEGIN
    TYPECASE location OF
    | NULL =&gt;
    | LineLocation(loc) =&gt;
        IF Text.Empty(loc.fileName) THEN
	  relLine := loc.line-(currentLine+1);
	  IF relLine=-1 THEN
            SynWr.Text(swr, &quot;(last input line, char &quot;
	      &amp; Fmt.Int(loc.char) &amp; &quot;)&quot;, loud:=TRUE);
	  ELSE
            SynWr.Text(swr, &quot;(input line &quot; &amp; Fmt.Int(relLine)
	      &amp; &quot;, char &quot; &amp; Fmt.Int(loc.char) &amp; &quot;)&quot;, loud:=TRUE);
	  END;
        END;
    ELSE SynWr.Text(swr, &quot;&lt;unknown location style&gt;&quot;, loud:=TRUE);
    END;
  END PrintLineDifference;

BEGIN
END SynLocation.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
