<HTML>
<HEAD>
<TITLE>SRC Modula-3: synloc/src/SynWr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>synloc/src/SynWr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="SynWr.i3">SynWr</A></implements></module>;
IMPORT <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../formatter/src/Formatter.i3">Formatter</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

VAR setupDone := FALSE;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    IF NOT setupDone THEN
      setupDone := TRUE;
      out := New(Stdio.stdout, 75);
      err := New(Stdio.stderr, 75);
    END;
  END Setup;

REVEAL <A NAME="T">T</A> =
  BRANDED OBJECT
    mu: Thread.Mutex;
    nesting: INTEGER;
    fmt: Formatter.T;
    silent: INTEGER;
    open: BOOLEAN;
  END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(wr: Wr.T; width: CARDINAL:=75): T =
  BEGIN
    RETURN NEW(T, mu:=NEW(Thread.Mutex), nesting := 0,
               fmt:=Formatter.New(wr, width), silent:=0, open:=TRUE);
  END New;

&lt;* FATAL Wr.Failure *&gt;

PROCEDURE <A NAME="Beg"><procedure>Beg</procedure></A>(swr: T; indent: INTEGER:=0; loud:=FALSE) =
BEGIN
  LOCK swr.mu DO
    IF swr.open AND ((swr.silent = 0) OR loud) THEN
      Formatter.Begin(swr.fmt, indent);
      INC(swr.nesting);
    END;
  END;
END Beg;

PROCEDURE <A NAME="Break"><procedure>Break</procedure></A>(swr: T; loud:=FALSE) =
BEGIN
  LOCK swr.mu DO
    IF swr.open AND ((swr.silent = 0) OR loud) THEN
      Formatter.UnitedBreak(swr.fmt);
    END;
  END;
END Break;

PROCEDURE <A NAME="FlatBreak"><procedure>FlatBreak</procedure></A>(swr: T; loud:=FALSE) =
BEGIN
  LOCK swr.mu DO
    IF swr.open AND ((swr.silent = 0) OR loud) THEN
      Formatter.Break(swr.fmt);
    END;
  END;
END FlatBreak;

PROCEDURE <A NAME="End"><procedure>End</procedure></A>(swr: T; loud:=FALSE) =
BEGIN
  LOCK swr.mu DO
    IF swr.open AND ((swr.silent = 0) OR loud) THEN
      IF swr.nesting &gt; 0 THEN
        DEC(swr.nesting);
        Formatter.End(swr.fmt);
      END;
    END;
  END;
END End;

PROCEDURE <A NAME="Char"><procedure>Char</procedure></A>(swr: T; c: CHAR; loud:=FALSE) =
BEGIN
  LOCK swr.mu DO
    IF swr.open AND ((swr.silent = 0) OR loud) THEN
      Formatter.PutChar(swr.fmt, c);
   END;
  END;
END Char;

PROCEDURE <A NAME="Text"><procedure>Text</procedure></A>(swr: T; t: TEXT; loud:=FALSE) =
BEGIN
  LOCK swr.mu DO
    IF swr.open AND ((swr.silent = 0) OR loud) THEN
      Formatter.PutText(swr.fmt, t);
    END;
  END;
END Text;

PROCEDURE <A NAME="NewLine"><procedure>NewLine</procedure></A>(swr: T; loud:=FALSE) =
BEGIN
  LOCK swr.mu DO
    IF swr.open AND ((swr.silent = 0) OR loud) THEN
      Formatter.NewLine(swr.fmt);
    END;
  END;
END NewLine;

PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A>(swr: T; loud:=FALSE) =
BEGIN
  LOCK swr.mu DO
    IF swr.open AND ((swr.silent = 0) OR loud) THEN
      Formatter.Flush(swr.fmt);
      swr.nesting := 0;
    END;
  END;
END Flush;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(swr: T) =
BEGIN
  LOCK swr.mu DO
    swr.open := FALSE;
    swr.nesting := 0;
    Formatter.Close(swr.fmt);
  END;
END Close;

PROCEDURE <A NAME="PushSilence"><procedure>PushSilence</procedure></A>(swr: T) =
  BEGIN
    LOCK swr.mu DO
      INC(swr.silent);
    END;
  END PushSilence;

PROCEDURE <A NAME="PopSilence"><procedure>PopSilence</procedure></A>(swr: T) =
  BEGIN
    LOCK swr.mu DO
      swr.silent := MAX(swr.silent-1, 0);
    END;
  END PopSilence;

BEGIN
END SynWr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
