<HTML>
<HEAD>
<TITLE>SRC Modula-3: table-list/src/TableList.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>table-list/src/TableList.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

GENERIC MODULE <genericModule><A HREF="TableList.ig">TableList</A></genericModule>(Key, Value, KeyValueTable);
</PRE> Where <CODE>Key.T</CODE> and <CODE>Value.T</CODE> are types that are not open array types
   and <CODE>Key</CODE> contains
<P>
<PRE>
      PROCEDURE Equal(k1, k2: Key.T): BOOLEAN;
</PRE>
   and <CODE>KeyValueTableList</CODE> is the instantiation of the generic interface
   <CODE>TableList</CODE> with the interfaces <CODE>Key</CODE> and <CODE>Value</CODE>.
<P>
   <CODE>Equal</CODE> must be an equivalence relation.
<P>
   <CODE>Equal</CODE> may be declared with a parameter mode of either <CODE>VALUE</CODE> or
   <CODE>READONLY</CODE>, but not <CODE>VAR</CODE>.


<P><PRE>IMPORT <A HREF="../../libm3/derived/RefList.i3">RefList</A>;

REVEAL
  <A NAME="T">T</A> = KeyValueTable.T OBJECT
   METHODS
    init(): T;
    keyEqual(READONLY k1, k2: Key.T): BOOLEAN
  END BRANDED OBJECT
    list: RefList.T; (* An association list. *)
    sz: CARDINAL;
   OVERRIDES
    get := Get;
    put := Put;
    delete := Delete;
    size := Size;
    iterate := Iterate;
    init := Init;
    keyEqual := KeyEqual;
  END (* OBJECT *);

TYPE
  ListIter = KeyValueTable.Iterator OBJECT
    list: RefList.T;
   OVERRIDES
    next := Next;
  END (* OBJECT *);

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>(tbl: T): T =
  BEGIN tbl.list := NIL; tbl.sz := 0; RETURN tbl END Init;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(tbl: T; READONLY key: Key.T; VAR val: Value.T): BOOLEAN =
  VAR l := tbl.list; BEGIN
    WHILE l # NIL DO
      VAR pair: RefList.T := l.head; BEGIN
        IF Key.Equal(pair.head, key) THEN
          val := pair.tail.head;
          RETURN TRUE
        END (* IF *)
      END (* BEGIN *);
      l := l.tail
    END (* WHILE *);
    RETURN FALSE
  END Get;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A>(tbl: T; READONLY key: Key.T; READONLY val: Value.T): BOOLEAN =
  VAR l := tbl.list; BEGIN
    WHILE l # NIL DO
      VAR pair: RefList.T := l.head; BEGIN
        IF Key.Equal(pair.head, key) THEN
          pair.tail.head := val;
          RETURN TRUE
        END (* IF *)
      END;
      l := l.tail
    END (* WHILE *);
    tbl.list := RefList.Cons(RefList.List2(key, val), tbl.list);
    INC(tbl.sz);
    RETURN FALSE
  END Put;

PROCEDURE <A NAME="Delete"><procedure>Delete</procedure></A>(tbl: T; READONLY key: Key.T; VAR val: Value.T): BOOLEAN =
  VAR l := tbl.list; prev: RefList.T := NIL; BEGIN
    WHILE l # NIL DO
      VAR pair: RefList.T := l.head; BEGIN
        IF Key.Equal(pair.head, key) THEN
          val := pair.tail.head;
          IF prev = NIL THEN
	    tbl.list := l.tail
	  ELSE
	    prev.tail := l.tail
          END (* IF *);
          DEC(tbl.sz);
          RETURN TRUE
        END (* IF *)
      END (* BEGIN *);
      prev := l;
      l := l.tail
    END (* WHILE *);
    RETURN FALSE
  END Delete;

PROCEDURE <A NAME="Size"><procedure>Size</procedure></A>(tbl: T): CARDINAL =
  BEGIN RETURN tbl.sz END Size;

PROCEDURE <A NAME="Iterate"><procedure>Iterate</procedure></A>(tbl: T): KeyValueTable.Iterator =
  BEGIN RETURN NEW(ListIter, list := tbl.list)
  END Iterate;

PROCEDURE <A NAME="KeyEqual"><procedure>KeyEqual</procedure></A>(&lt;*UNUSED*&gt; tbl: T; READONLY k1, k2: Key.T): BOOLEAN =
  BEGIN RETURN Key.Equal(k1, k2) END KeyEqual;
</PRE>******************
 Iterator methods 
******************

<P><PRE>PROCEDURE <A NAME="Next"><procedure>Next</procedure></A>(i: ListIter; VAR key: Key.T; VAR val: Value.T): BOOLEAN =
  BEGIN
    IF i.list = NIL THEN
      RETURN FALSE
    ELSE
      VAR pair: RefList.T := i.list.head; BEGIN
        key := pair.head;
        val := pair.tail.head
      END (* BEGIN *);
      i.list := i.list.tail;
      RETURN TRUE
    END (* IF *)
  END Next;

BEGIN
END TableList.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
