<HTML>
<HEAD>
<TITLE>SRC Modula-3: table/src/Table.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>table/src/Table.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Table</CODE> is a generic interface defining partial maps that support
   update and iteration.
   \index{map!updatable}


<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="Table.mg">Table</A></genericInterface>(Key, Value);
</PRE><BLOCKQUOTE><EM> Where <CODE>Key.T</CODE> and <CODE>Value.T</CODE> are types that are not open array types, both
   <CODE>Key</CODE> and <CODE>Value</CODE> contain
<P>
<PRE>
      CONST Brand = &lt;text-constant&gt;;
</PRE>
   and <CODE>Key</CODE> additionally contains
<P>
<PRE>
      PROCEDURE Equal(k1, k2: Key.T): BOOLEAN;
      PROCEDURE Hash(k: Key.T): Word.T;
</PRE>
   <CODE>Brand</CODE> must be a text constant. It will be used to construct a brand for
   the opaque type <CODE>Table.Default</CODE> and any generic types instantiated with the
   <CODE>Table</CODE> interface. For a non-generic interface, we recommend choosing the
   name of the interface.
<P>
   <CODE>Equal</CODE> must be an equivalence relation and <CODE>Hash</CODE> must respect
   that equivalence relation, in other words, if <CODE>Equal(k1, k2)</CODE>, then
   <CODE>Hash(k1)=Hash(k2)</CODE>.
<P>
   <CODE>Hash</CODE> and <CODE>Equal</CODE> may be declared with a parameter mode of either
   <CODE>VALUE</CODE> or <CODE>READONLY</CODE>, but not <CODE>VAR</CODE>.
</EM></BLOCKQUOTE><PRE>

IMPORT <A HREF="../../word/src/Word.i3">Word</A>;

CONST
  Brand = &quot;(Table &quot; &amp; Key.Brand &amp; &quot; &quot; &amp; Value.Brand &amp; &quot;)&quot;;
  DefaultBrand = &quot;(Default &quot; &amp; Brand &amp; &quot;)&quot;;
  (* A &quot;Table.Default&quot; is revealed to have the brand &quot;DefaultBrand&quot;. *)

TYPE
  T = OBJECT METHODS
    get(READONLY k: Key.T; VAR v: Value.T): BOOLEAN;
    put(READONLY k: Key.T; READONLY v: Value.T): BOOLEAN;
    delete(READONLY k: Key.T; VAR v: Value.T): BOOLEAN;
    size(): CARDINAL;
    iterate(): Iterator
  END;
  Iterator = OBJECT METHODS
    next(VAR k: Key.T; VAR v: Value.T): BOOLEAN
  END;
  <A HREF="Table.mg#Default">Default</A> &lt;: T OBJECT METHODS
    init(sizeHint: CARDINAL := 0): Default;
    keyEqual(READONLY k1, k2: Key.T): BOOLEAN;
    keyHash(READONLY k: Key.T): Word.T
  END;
END Table.
</PRE> A <CODE>Table(Key, Value).T</CODE>, or table, is a partial map from <CODE>Key.T</CODE>s
   to <CODE>Value.T</CODE>s.  Actually, it turns out to be useful for a table to
   treat two different keys as if they are the same whenever they are
   equivalent according to some specified equivalence relation.  For
   example, if you are creating a table with a <CODE>Key.T</CODE> of <CODE>TEXT</CODE>, you
   are likely to want <CODE>Text.Equal</CODE> as the equivalence relation.
<P>
   Formally, a table <CODE>tbl</CODE> has the components:
<P>
<PRE>
      canon(tbl) <KBD>a map on elements of </KBD>Key.T<KBD></KBD>
      map(tbl)   <KBD>a map from elements of </KBD>Key.T<KBD> to elements of </KBD>Value.T<KBD></KBD>
</PRE>
   <CODE>canon(tbl)</CODE> represents an equivalence relation: <CODE>canon(tbl)(k)</CODE> is
   the {\em canonical representative} of all the keys that are
   equivalent to <CODE>k</CODE>.  The domain of <CODE>map(tbl)</CODE> includes only
   canonical representatives, that is, elements in the range of
   <CODE>canon(tbl)</CODE>.  The equivalence relation underlying <CODE>canon(tbl)</CODE>
   must be time-invariant.  For example, it can't depend on the values
   of particular references since some garbage collectors move <CODE>REF</CODE>
   values.
<P>
   The methods of an object <CODE>tbl</CODE> of type <CODE>Table.T</CODE> have the following
   specifications:
<P>
   The call <CODE>tbl.get(k, v)</CODE> sets <CODE>v</CODE> to <CODE>map(tbl)(canon(tbl)(k))</CODE> and
   returns <CODE>TRUE</CODE> if <CODE>canon(tbl)(k)</CODE> is in <CODE>dom(map(tbl))</CODE>.  Otherwise,
   it returns <CODE>FALSE</CODE> without changing <CODE>v</CODE>.
<P>
   The call <CODE>tbl.put(k, v)</CODE> changes <CODE>map(tbl)(canon(tbl)(k))</CODE> to <CODE>v</CODE>
   and returns <CODE>TRUE</CODE> if <CODE>canon(k)</CODE> is in <CODE>dom(map(tbl))</CODE>.  Otherwise,
   it sets the value of <CODE>map(tbl)(canon(tbl)(k))</CODE> to <CODE>v</CODE>, and returns
   <CODE>FALSE</CODE>.
<P>
   The call <CODE>tbl.delete(k, v)</CODE> sets <CODE>v</CODE> to <CODE>map(tbl)(canon(tbl)(k))</CODE>,
   removes <CODE>(canon(tbl)(k), v)</CODE> from <CODE>map(tbl)</CODE>, and returns <CODE>TRUE</CODE> if
   <CODE>canon(tbl)(k)</CODE> is in <CODE>dom(map(tbl))</CODE>.  Otherwise, it returns
   <CODE>FALSE</CODE> without changing <CODE>v</CODE>.
<P>
   The call <CODE>tbl.size()</CODE> returns the size of <CODE>dom(map(tbl))</CODE>, that is,
   the number of entries in <CODE>tbl</CODE>.
<P>
   The call <CODE>tbl.iterate()</CODE> returns an iterator, which is an object
   that can be used to iterate over the key-value pairs in <CODE>tbl</CODE>.  See
   the definition of the type <CODE>Iterator</CODE> below.
<P>
   If <CODE>i</CODE> is the result of the call <CODE>tbl.iterate()</CODE>, then the call
   <CODE>it.next(k, v)</CODE> selects an entry from <CODE>tbl</CODE> that has not already
   been returned by <CODE>i</CODE>, sets <CODE>k</CODE> and <CODE>v</CODE> to its key and value, and
   returns <CODE>TRUE</CODE>.  If no entries remain, the call returns <CODE>FALSE</CODE>
   without setting <CODE>k</CODE> or <CODE>v</CODE>.  It is a checked runtime error to call
   <CODE>next</CODE> after it has returned <CODE>FALSE</CODE>.  The client must ensure that
   while an iterator is in use, the parent table is not modified.
<P>
   The type <CODE>Default</CODE> is an implementation of <CODE>T</CODE> using chained
   hashing.  The methods specific to an object <CODE>dflt</CODE> of type
   <CODE>Default</CODE> have the following specifications:
<P>
   The call <CODE>dflt.init(sizeHint)</CODE> returns <CODE>dflt</CODE> after initializing it
   to a table with an empty <CODE>map(dflt)</CODE>.  If <CODE>sizeHint</CODE> is greater
   than 0, <CODE>init</CODE> assumes that <CODE>put</CODE> will subsequently be called with
   at least <CODE>sizeHint</CODE> different keys; these calls on <CODE>put</CODE> may
   execute somewhat faster than if <CODE>sizeHint</CODE> was 0.  The <CODE>init</CODE>
   method has side-effects on the table.
<P>
   The call <CODE>dflt.keyEqual(k1, k2)</CODE> returns <CODE>Key.Equal(k1, k2)</CODE> and
   the call <CODE>dflt.keyHash(k)</CODE> returns <CODE>Key.Hash(k)</CODE>.  The other
   methods call <CODE>keyEqual</CODE> and <CODE>keyHash</CODE> whenever they need to consult
   the table's equivalence relation. This means a subtype of <CODE>Default</CODE>
   can determine the equivalence relation by overriding <CODE>keyEqual</CODE> and
   <CODE>keyHash</CODE>, providing <CODE>keyEqual</CODE> implements an equivalence relation
   and <CODE>keyHash</CODE> respects that relation.
<P>
   For efficiency, tables and their iterators are not monitored, so a
   client accessing a table from multiple threads must ensure that if
   two operations are active concurrently, then neither of them has
   side effects on the same table or iterator.  The <CODE>T.put</CODE>,
   <CODE>T.delete</CODE>, and <CODE>Default.init</CODE> methods are the only ones with side
   effects on the table.  An iterator's <CODE>next</CODE> method has side-effects
   on the iterator.


<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
