<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcl/src/Tcl.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcl/src/Tcl.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="Tcl.m3">Tcl</A></interface>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>;

TYPE
  ErrorCode = {Error, Return, Break, Continue};

EXCEPTION
  Error (ErrorCode);

TYPE
  Args = ARRAY OF Text.T;

  CmdClosure = OBJECT METHODS
                 apply (interp: T; args: Args) RAISES {Error};
                 delete () := DoNothing; END;

  CmdTraceClosure = OBJECT METHODS
                     trace (interp: T;
                            level: INTEGER;
                            command: Text.T;
                            args: Args); END;
  <A HREF="Tcl.m3#CmdTraceHandle">CmdTraceHandle</A> &lt;: REFANY;

  VarTraceClosure = OBJECT METHODS
                      trace (interp: T;
                             name1, name2: Text.T;
                             flags: VarTraceFlags): Text.T; END;
  <A HREF="Tcl.m3#VarTraceHandle">VarTraceHandle</A> &lt;: REFANY;
  VarTraceFlag  = {GlobalOnly, Reads, Writes, Unsets};
  VarTraceFlags = SET OF VarTraceFlag;

  VarSetFlag  = {GlobalOnly, LeaveErrMsg, AppendValue, ListElement, NoSpace};
  VarSetFlags = SET OF VarSetFlag;

  <A HREF="Tcl.m3#T">T</A> &lt;: PublicT;

  PublicT = OBJECT METHODS
    new (): T;
    delete ();

    addErrorInfo (msg: Text.T);
    setErrorCode (s: ARRAY OF Text.T);
    unixError (): Text.T;

    createCommand (name: Text.T; closure: CmdClosure);
    deleteCommand (name: Text.T): BOOLEAN;

    createTrace (level: INTEGER; closure: CmdTraceClosure): CmdTraceHandle;
    deleteTrace (h: CmdTraceHandle);

    traceVar  (name: Text.T; flags: VarTraceFlags;
               cl: VarTraceClosure): VarTraceHandle RAISES {Error};
    traceVar2 (name1, name2: Text.T; flags: VarTraceFlags;
               cl: VarTraceClosure): VarTraceHandle RAISES {Error};
    deleteTraceVar (h: VarTraceHandle);

    eval (cmd: Text.T; stopOnBracket: BOOLEAN) RAISES {Error};
    varEval (s: ARRAY OF Text.T) RAISES {Error};
    evalFile (fileName: Text.T) RAISES {Error};

    exprInt (string: Text.T): INTEGER RAISES {Error};
    exprDouble (string: Text.T): LONGREAL RAISES {Error};
    exprBoolean (string: Text.T): BOOLEAN RAISES {Error};
    exprString (string: Text.T) RAISES {Error};

    getInt (string: Text.T): INTEGER RAISES {Error};
    getDouble (string: Text.T): LONGREAL RAISES {Error};
    getBoolean (string: Text.T): BOOLEAN RAISES {Error};

    initHistory ();
    recordAndEval (cmd: Text.T;
                   stopOnBracket, recordOnly: BOOLEAN := FALSE) RAISES {Error};

    setResult (string: Text.T);
    getResult (): Text.T;
    appendResult (s: ARRAY OF Text.T);
    appendElement (string: Text.T; noSep: BOOLEAN);
    resetResult ();
    freeResult ();

    setVar  (varName, newValue: Text.T;
             flags: VarSetFlags) RAISES {Error};
    setVar2 (name1, name2, newValue: Text.T;
             flags: VarSetFlags) RAISES {Error};
    getVar  (varName: Text.T;
             flags: VarSetFlags): Text.T RAISES {Error};
    getVar2 (name1, name2: Text.T;
             flags: VarSetFlags): Text.T RAISES {Error};
    unsetVar  (varName: Text.T;
               flags: VarSetFlags) RAISES {Error};
    unsetVar2 (name1, name2: Text.T;
               flags: VarSetFlags) RAISES {Error}; END;

PROCEDURE <A HREF="Tcl.m3#DoNothing">DoNothing</A> (self: CmdClosure);
</PRE>---------------------------------------------------------------------------

<P><PRE>TYPE
  <A HREF="Tcl.m3#CmdBuf">CmdBuf</A> &lt;: OBJECT METHODS
              new (): CmdBuf;
              delete ();
              assemble (s: Text.T): Text.T; END;
</PRE>---------------------------------------------------------------------------

<P><PRE>PROCEDURE <A HREF="Tcl.m3#SplitList">SplitList</A> (interp: T; list: Text.T): REF Args RAISES {Error};
PROCEDURE <A HREF="Tcl.m3#Merge">Merge</A> (args: Args): Text.T;

END Tcl.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
