<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcl/src/TclC.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcl/src/TclC.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                         </EM></BLOCKQUOTE><PRE>
</PRE> Version 6.2 of TCL 

<P> This file is derived from tcl.h, covered by the following copyright:
<P>
 * Copyright 1987, 1990 Regents of the University of California
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided <CODE>as is</CODE> without
 * express or implied warranty.
 

<P><PRE>UNSAFE INTERFACE <interface><A HREF="TclC.m3">TclC</A></interface>;

FROM <A HREF="../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char_star, int_star, int, char,
                   double_star, int_star_star, long_star;
IMPORT <A HREF="../../word/src/Word.i3">Word</A>;

CONST
  TCL_OK       = 0;
  TCL_ERROR    = 1;
  TCL_RETURN   = 2;
  TCL_BREAK    = 3;
  TCL_CONTINUE = 4;

  TCL_RESULT_SIZE = 199;

  BRACKET_TERM  = 1;
  DONT_USE_BRACES = 1;
  NO_EVAL       = -1;

VAR (* READONLY *)
  volatile,  static,  dynamic: FreeProc;

CONST
  GLOBAL_ONLY =      1;
  APPEND_VALUE =     2;
  LIST_ELEMENT =     4;
  NO_SPACE =         8;
  TRACE_READS =      16_10;
  TRACE_WRITES =     16_20;
  TRACE_UNSETS =     16_40;
  TRACE_DESTROYED =  16_80;
  INTERP_DESTROYED = 16_100;
  LEAVE_ERR_MSG	=    16_200;

  VARIABLE_UNDEFINED = 8;

TYPE
  FreeProc = PROCEDURE (blockPtr: char_star);

  Interp = RECORD
             result: char_star;
             freeProc: FreeProc;
             errorLine: int; END;

  Interp_star = UNTRACED REF Interp;

  ClientData = Word.T;

  Argv = UNTRACED REF ARRAY [0..255] OF char_star;
  Argv_star = UNTRACED REF Argv;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_AddErrorInfo *&gt;
PROCEDURE AddErrorInfo (interp: Interp_star; message: char_star);

&lt;*EXTERNAL Tcl_SetErrorCode *&gt;
PROCEDURE SetErrorCode (interp: Interp_star;
                        s1, s2, s3, s4, s5: char_star := NIL);

&lt;*EXTERNAL Tcl_UnixError *&gt;
PROCEDURE UnixError (interp: Interp_star): char_star;
</PRE>---------------------------------------------------------------------------

<P><PRE>TYPE
  CmdBuf = int_star;

&lt;*EXTERNAL Tcl_CreateCmdBuf *&gt;
PROCEDURE CreateCmdBuf (): CmdBuf;

&lt;*EXTERNAL Tcl_DeleteCmdBuf *&gt;
PROCEDURE DeleteCmdBuf (buffer: CmdBuf);

&lt;*EXTERNAL Tcl_AssembleCmd *&gt;
PROCEDURE AssembleCmd (buffer: CmdBuf; string: char_star): char_star;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_Backslash *&gt;
PROCEDURE Backslash (src: char_star; count: int_star): char;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_Concat *&gt;
PROCEDURE Concat (argc: int; argv: Argv): char_star;
</PRE>---------------------------------------------------------------------------

<P><PRE>TYPE
  CmdProc = PROCEDURE (clientData: ClientData;
                       interp: Interp_star;
                       argc:   int;
                       argv:   Argv): int;

  CmdDeleteProc  = PROCEDURE (clientData: ClientData);

&lt;*EXTERNAL Tcl_CreateCommand *&gt;
PROCEDURE CreateCommand (interp: Interp_star;
                         cmdName: char_star;
                         proc: CmdProc;
                         clientData: ClientData;
                         deleteProc: CmdDeleteProc);

&lt;*EXTERNAL Tcl_DeleteCommand *&gt;
PROCEDURE DeleteCommand (interp: Interp_star;
                         cmdName: char_star): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_CreateInterp *&gt;
PROCEDURE CreateInterp (): Interp_star;

&lt;*EXTERNAL Tcl_DeleteInterp *&gt;
PROCEDURE DeleteInterp (interp: Interp_star);
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_CreatePipeline *&gt;
PROCEDURE CreatePipeline (interp: Interp_star;
                          argc: int;
                          argv: Argv;
                          pidArrayPtr: int_star_star;
                          inPipePtr: char_star;
                          outPipePtr: char_star;
                          errFilePr: char_star): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>TYPE
  CmdTraceProc = PROCEDURE (clientData: ClientData;
                            interp: Interp_star;
                            level: int;
                            command: char_star;
                            cmdProc: CmdProc;
                            cmdClientData: ClientData;
                            argc: int;
                            argv: Argv);
  Trace = int_star;

&lt;*EXTERNAL Tcl_CreateTrace *&gt;
PROCEDURE CreateTrace (interp: Interp_star;
                       level: int;
                       proc: CmdTraceProc;
                       clientData: ClientData): Trace;

&lt;*EXTERNAL Tcl_DeleteTrace *&gt;
PROCEDURE DeleteTrace (interp: Interp_star; trace: Trace);
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_Eval *&gt;
PROCEDURE Eval (interp: Interp_star;
                cmd: char_star;
                flags: int;
                termPtr: Argv): int;

&lt;*EXTERNAL Tcl_VarEval *&gt;
PROCEDURE VarEval (interp: Interp_star;
                   s1, s2, s3, s4, s5: char_star := NIL): int;

&lt;*EXTERNAL Tcl_EvalFile *&gt;
PROCEDURE EvalFile (interp: Interp_star;
                    fileName: char_star): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_ExprLong *&gt;
PROCEDURE ExprLong (interp: Interp_star;
                    string: char_star; longPtr: long_star): int;

&lt;*EXTERNAL Tcl_ExprDouble *&gt;
PROCEDURE ExprDouble (interp: Interp_star;
                      string: char_star; doublePtr: double_star): int;

&lt;*EXTERNAL Tcl_ExprBoolean *&gt;
PROCEDURE ExprBoolean (interp: Interp_star;
                       string: char_star; booleanPtr: int_star): int;

&lt;*EXTERNAL Tcl_ExprString *&gt;
PROCEDURE ExprString (interp: Interp_star;
                      string: char_star): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_Fork *&gt;
PROCEDURE Fork (): int;

&lt;*EXTERNAL Tcl_WaitPids *&gt;
PROCEDURE WaitPids (numPids: int; pidPtr, statusPtr: int_star): int;

&lt;*EXTERNAL Tcl_DetachPids *&gt;
PROCEDURE DetachPids (numPids: int; pidPtr: int_star): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_GetInt *&gt;
PROCEDURE GetInt (interp: Interp_star;
                  string: char_star; intPtr: int_star): int;

&lt;*EXTERNAL Tcl_GetDouble *&gt;
PROCEDURE GetDouble (interp: Interp_star;
		     string: char_star; doublePtr: double_star): int;

&lt;*EXTERNAL Tcl_GetBoolean *&gt;
PROCEDURE GetBoolean (interp: Interp_star;
		      string: char_star; boolPtr: int_star): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>TYPE
  HashEntry = RECORD
                nextPtr: HashEntry_star;
                tablePtr: HashTable_star;
                bucketPtr: HashEntry_star_star;
                clientData: ClientData;
                key: Word.T; END;
  HashEntry_star = UNTRACED REF HashEntry;
  HashEntry_star_star = UNTRACED REF HashEntry_star;

CONST
  SMALL_HASH_TABLE = 4;

TYPE
  HashTable = RECORD
                buckets: HashEntry_star_star;
                staticBuckets: ARRAY [0..SMALL_HASH_TABLE-1] OF HashEntry_star;
                numBuckets: int;
                numEntries: int;
                rebuildSize: int;
                downShift: int;
                mask: int;
                keyType: int;
                findProc: PROCEDURE (tablePtr: HashTable_star;
                                     key: char_star): HashEntry_star;
                createProc: PROCEDURE (tablePtr: HashTable_star;
                                     key: char_star;
                                     newPtr: int_star): HashEntry_star; END;

  HashTable_star = UNTRACED REF HashTable;

  HashSearch = RECORD
                 tablePtr: HashTable_star;
                 nextIndex: int;
                 nextEntryPtr: HashEntry_star; END;

  HashSearch_star = UNTRACED REF HashSearch;

&lt;*EXTERNAL Tcl_InitHashTable *&gt;
PROCEDURE InitHashTable (tablePtr: HashTable_star; keyType: int);

&lt;*EXTERNAL Tcl_DeleteHashTable *&gt;
PROCEDURE DeleteHashTable (tablePtr: HashTable_star);

&lt;*EXTERNAL Tcl_CreateHashEntry *&gt;
PROCEDURE CreateHashEntry (tablePtr: HashTable_star;
                           key: char_star; newPtr: int_star): HashEntry_star;

&lt;*EXTERNAL Tcl_DeleteHashEntry *&gt;
PROCEDURE DeleteHashEntry (entryPtr: HashEntry_star);

&lt;*EXTERNAL Tcl_FindHashEntry *&gt;
PROCEDURE FindHashEntry (tablePtr: HashTable_star;
                         key: char_star): HashEntry_star;

&lt;*EXTERNAL Tcl_GetHashValue *&gt;
PROCEDURE GetHashValue (entryPtr: HashEntry_star): ClientData;

&lt;*EXTERNAL Tcl_SetHashValue *&gt;
PROCEDURE SetHashValue (entryPtr: HashEntry_star; value: ClientData);

&lt;*EXTERNAL Tcl_GetHashKey *&gt;
PROCEDURE GetHashKey (tablePtr: HashTable_star;
                      entryPtr: HashEntry_star): char_star;

&lt;*EXTERNAL Tcl_FirstHashEntry *&gt;
PROCEDURE FirstHashEntry (tablePtr: HashTable_star;
                          searchPtr: HashSearch_star): HashEntry_star;

&lt;*EXTERNAL Tcl_NextHashEntry *&gt;
PROCEDURE NextHashEntry (searchPtr: HashSearch_star): HashEntry_star;

&lt;*EXTERNAL Tcl_HashStats *&gt;
PROCEDURE HashStats (tablePtr: HashTable_star): char_star;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_InitHistory *&gt;
PROCEDURE InitHistory (interp: Interp_star);

&lt;*EXTERNAL Tcl_RecordAndEval *&gt;
PROCEDURE RecordAndEval (interp: Interp_star;
                         cmd: char_star; flags: char): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_SetResult *&gt;
PROCEDURE SetResult (interp: Interp_star;
                     string: char_star; freeProc: FreeProc);

&lt;*EXTERNAL Tcl_AppendResult *&gt;
PROCEDURE AppendResult (interp: Interp_star;
			s1, s2, s3, s4, s5: char_star := NIL);

&lt;*EXTERNAL Tcl_AppendElement *&gt;
PROCEDURE AppendElement (interp: Interp_star; string: char_star; noSep: int);

&lt;*EXTERNAL Tcl_ResetResult *&gt;
PROCEDURE ResetResult (interp: Interp_star);

PROCEDURE <A HREF="TclC.m3#FreeResult">FreeResult</A> (interp: Interp_star);
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_SetVar *&gt;
PROCEDURE SetVar (interp: Interp_star;
                  varName, newValue: char_star; flags: int): char_star;

&lt;*EXTERNAL Tcl_SetVar2 *&gt;
PROCEDURE SetVar2 (interp: Interp_star;
                   name1, name2, newValue: char_star; flags: int): char_star;

&lt;*EXTERNAL Tcl_GetVar *&gt;
PROCEDURE GetVar (interp: Interp_star;
		  varName: char_star; flags: int): char_star;

&lt;*EXTERNAL Tcl_GetVar2 *&gt;
PROCEDURE GetVar2 (interp: Interp_star;
		   name1, name2: char_star; flags: int): char_star;

&lt;*EXTERNAL Tcl_UnsetVar *&gt;
PROCEDURE UnsetVar (interp: Interp_star;
	  	    varName: char_star; flags: int): int;

&lt;*EXTERNAL Tcl_UnsetVar2 *&gt;
PROCEDURE UnsetVar2 (interp: Interp_star;
	  	     name1, name2: char_star; flags: int): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_SplitList *&gt;
PROCEDURE SplitList (interp: Interp_star;
 		     list: char_star;
		     argcPtr: int_star;
		     argvPtr: Argv_star): int;

&lt;*EXTERNAL Tcl_Merge *&gt;
PROCEDURE Merge (argc: int; argv: Argv): char_star;

&lt;*EXTERNAL Tcl_ScanElement *&gt;
PROCEDURE ScanElement (src: char_star; flagsPtr: int_star): int;

&lt;*EXTERNAL Tcl_ConvertElement *&gt;
PROCEDURE ConvertElement (src, dst: char_star; flags: int): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_StringMatch *&gt;
PROCEDURE StringMatch (string, pattern: char_star): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>&lt;*EXTERNAL Tcl_TildeSubst *&gt;
PROCEDURE TildeSubst (interp: Interp_star; name: char_star): char_star;
</PRE>---------------------------------------------------------------------------

<P><PRE>TYPE
  VarTraceProc = PROCEDURE (clientData: ClientData;
                            interp: Interp_star;
			    name1, name2: char_star;
                            flags: int): char_star;

&lt;*EXTERNAL Tcl_TraceVar *&gt;
PROCEDURE TraceVar (interp: Interp_star;
		    varName: char_star;
		    flags: int;
		    proc: VarTraceProc;
		    clientData: ClientData): int;

&lt;*EXTERNAL Tcl_TraceVar2 *&gt;
PROCEDURE TraceVar2 (interp: Interp_star;
		     name1, name2: char_star;
		     flags: int;
		     proc: VarTraceProc;
		     clientData: ClientData): int;

&lt;*EXTERNAL Tcl_UnTraceVar *&gt;
PROCEDURE UnTraceVar (interp: Interp_star;
                      varName: char_star;
                      flags: int;
                      proc: VarTraceProc;
  		      clientData: ClientData);

&lt;*EXTERNAL Tcl_UnTraceVar2 *&gt;
PROCEDURE UnTraceVar2 (interp: Interp_star;
                       name1, name2: char_star;
                       flags: int;
                       proc: VarTraceProc;
  		       clientData: ClientData);

&lt;*EXTERNAL Tcl_VarTraceInfo *&gt;
PROCEDURE VarTraceInfo (interp: Interp_star;
			varName: char_star;
			flags: int;
			proc: VarTraceProc;
			prevClientData: ClientData): int;

&lt;*EXTERNAL Tcl_VarTraceInfo2 *&gt;
PROCEDURE VarTraceInfo2 (interp: Interp_star;
			 name1, name2: char_star;
 			 flags: int;
			 proc: VarTraceProc;
			 prevClientData: ClientData): int;
</PRE>---------------------------------------------------------------------------

<P><PRE>END TclC.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
