<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcp/src/POSIX/IP.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcp/src/POSIX/IP.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created on Sat Jan 11 15:49:00 PST 1992 by gnelson </EM></BLOCKQUOTE><PRE>
</PRE> Last modified onFri Jan  7 13:31:07 PST 1994by msm    

<P><PRE>UNSAFE MODULE <module><implements><A HREF="../common/IP.i3">IP</A></implements></module>;

IMPORT <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="Herrno.i3">Herrno</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="../../../text/src/TextF.i3">TextF</A>,
       <A HREF="#x1">Unetdb</A>, <A HREF="#x2">Usocket</A>, <A HREF="#x3">Unix</A>, <A HREF="#x4">Uin</A>, <A HREF="#x5">Utypes</A>;

EXCEPTION FatalError; &lt;*FATAL FatalError*&gt;

VAR mu := NEW(MUTEX);

PROCEDURE <A NAME="GetHostByName"><procedure>GetHostByName</procedure></A>(nm: TEXT; VAR (*out*) res: Address): BOOLEAN
    RAISES {Error} =
  BEGIN
    LOCK mu DO
      VAR h := Unetdb.gethostbyname(ADR(nm[0])); BEGIN
        IF h = NIL THEN InterpretError(); RETURN FALSE; END;
        res := GetAddress(h);
      END;
    END;
    RETURN TRUE;
  END GetHostByName;

PROCEDURE <A NAME="GetCanonicalByName"><procedure>GetCanonicalByName</procedure></A>(nm: TEXT): TEXT RAISES {Error} =
  BEGIN
    LOCK mu DO
      VAR h := Unetdb.gethostbyname(ADR(nm[0])); BEGIN
        IF h # NIL THEN
          RETURN M3toC.CopyStoT(h.h_name);
        END;
      END;
    END;
    InterpretError();
    RETURN NIL;
  END GetCanonicalByName;

PROCEDURE <A NAME="GetCanonicalByAddr"><procedure>GetCanonicalByAddr</procedure></A>(addr: Address): TEXT RAISES {Error} =
  VAR ua: Uin.struct_in_addr;
  BEGIN
    ua.s_addr := LOOPHOLE(addr, Utypes.u_int);
    LOCK mu DO
      VAR h := Unetdb.gethostbyaddr(
                   ADR(ua), BYTESIZE(ua), Usocket.AF_INET);
      BEGIN
        IF h # NIL THEN
          RETURN M3toC.CopyStoT(h.h_name);
        END;
      END;
    END;
    InterpretError();
    RETURN NIL;
  END GetCanonicalByAddr;

PROCEDURE <A NAME="GetAddress"><procedure>GetAddress</procedure></A> (ent: Unetdb.struct_hostent_star): Address =
  VAR ua: Uin.struct_in_addr;
  BEGIN
    &lt;* ASSERT ent.h_length &lt;= BYTESIZE(Address) *&gt;
    ua := LOOPHOLE(ent.h_addr_list,
                    UNTRACED REF UNTRACED REF Uin.struct_in_addr)^^;
    RETURN LOOPHOLE(ua.s_addr, Address);
  END GetAddress;

PROCEDURE <A NAME="GetHostAddr"><procedure>GetHostAddr</procedure></A>(): Address =
  VAR hname: ARRAY [0..255] OF CHAR;
  BEGIN
    LOCK mu DO
      IF Unix.gethostname(ADR(hname[0]), BYTESIZE(hname)) # 0 THEN
        RAISE FatalError;
      END;
      RETURN GetAddress(Unetdb.gethostbyname(ADR(hname[0])));
    END;
  END GetHostAddr;

PROCEDURE <A NAME="InterpretError"><procedure>InterpretError</procedure></A>() RAISES {Error} =
  BEGIN
    CASE Herrno.h_errno OF
    | Unetdb.TRY_AGAIN, Unetdb.NO_RECOVERY, Unetdb.NO_ADDRESS =&gt;
        RAISE Error(AtomList.List1(LookupFailure));
    ELSE
    END;
  END InterpretError;

BEGIN
  LookupFailure := Atom.FromText(&quot;IP.LookupFailure&quot;);
  Unreachable := Atom.FromText(&quot;IP.Unreachable&quot;);
  PortBusy := Atom.FromText(&quot;IP.PortBusy&quot;);
  NoResources := Atom.FromText(&quot;IP.NoResources&quot;);
END IP.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Unetdb is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unetdb.i3#0TOP0">unix/src/aix-3-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unetdb.i3#0TOP0">unix/src/aix-ps2-1-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unetdb.i3#0TOP0">unix/src/freebsd-1/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unetdb.i3#0TOP0">unix/src/freebsd-2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unetdb.i3#0TOP0">unix/src/hpux-7-0/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unetdb.i3#0TOP0">unix/src/ibm-4-3/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unetdb.i3#0TOP0">unix/src/irix-5.2/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/linux/Unetdb.i3#0TOP0">unix/src/linux/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Unetdb.i3#0TOP0">unix/src/osf-1.generic/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unetdb.i3#0TOP0">unix/src/solaris-2-x/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unetdb.i3#0TOP0">unix/src/sunos-4-x/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unetdb.i3#0TOP0">unix/src/sysv-4.0/Unetdb.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Unetdb.i3#0TOP0">unix/src/ultrix-3-1.generic/Unetdb.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Usocket is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Usocket.i3#0TOP0">unix/src/aix-3-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Usocket.i3#0TOP0">unix/src/aix-ps2-1-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Usocket.i3#0TOP0">unix/src/freebsd-1/Usocket.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Usocket.i3#0TOP0">unix/src/freebsd-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Usocket.i3#0TOP0">unix/src/hpux-7-0/Usocket.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Usocket.i3#0TOP0">unix/src/ibm-4-3/Usocket.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Usocket.i3#0TOP0">unix/src/irix-5.2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/linux/Usocket.i3#0TOP0">unix/src/linux/Usocket.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Usocket.i3#0TOP0">unix/src/osf-1.generic/Usocket.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Usocket.i3#0TOP0">unix/src/solaris-2-x/Usocket.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Usocket.i3#0TOP0">unix/src/sunos-4-x/Usocket.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Usocket.i3#0TOP0">unix/src/sysv-4.0/Usocket.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Usocket.i3#0TOP0">unix/src/ultrix-3-1.generic/Usocket.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x4">interface Uin is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uin.i3#0TOP0">unix/src/aix-3-2/Uin.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uin.i3#0TOP0">unix/src/aix-ps2-1-2/Uin.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uin.i3#0TOP0">unix/src/freebsd-1/Uin.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uin.i3#0TOP0">unix/src/freebsd-2/Uin.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uin.i3#0TOP0">unix/src/hpux-7-0/Uin.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uin.i3#0TOP0">unix/src/ibm-4-3/Uin.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uin.i3#0TOP0">unix/src/irix-5.2/Uin.i3</A>
<LI><A HREF="../../../unix/src/linux/Uin.i3#0TOP0">unix/src/linux/Uin.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Uin.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Uin.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Uin.i3#0TOP0">unix/src/osf-1.DS3100/Uin.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uin.i3#0TOP0">unix/src/solaris-2-x/Uin.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uin.i3#0TOP0">unix/src/sunos-4-x/Uin.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uin.i3#0TOP0">unix/src/sysv-4.0/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Uin.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Uin.i3#0TOP0">unix/src/ultrix-3-1.ARM/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Uin.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Uin.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Uin.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Uin.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Uin.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Uin.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Uin.i3#0TOP0">unix/src/ultrix-3-1.VAX/Uin.i3</A>
</UL>
<P>
<HR>
<A NAME="x5">interface Utypes is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../../../unix/src/linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
