<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcp/src/POSIX/TCP.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcp/src/POSIX/TCP.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created on Sat Jan 11 15:49:00 PST 1992 by gnelson </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>TCP</module> EXPORTS <A HREF="../common/TCP.i3"><implements>TCP</A></implements>, <A HREF="../common/TCPSpecial.i3"><implements>TCPSpecial</A></implements>, <A HREF="#x1"><implements>Uin</A></implements>;

IMPORT <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../common/ConnFD.i3">ConnFD</A>, <A HREF="../common/IP.i3">IP</A>, <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
IMPORT <A HREF="#x2">Usocket</A>, <A HREF="../../../C/src/Common/Cerrno.i3">Cerrno</A>, <A HREF="#x3">Uerror</A>, <A HREF="#x1">Uin</A>, <A HREF="#x4">Unix</A>, <A HREF="#x5">Uuio</A>, <A HREF="#x6">Utypes</A>,
       <A HREF="TCPHack.i3">TCPHack</A>, <A HREF="TCPPosix.i3">TCPPosix</A>, <A HREF="../../../thread/src/POSIX/SchedulerPosix.i3">SchedulerPosix</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../word/src/Word.i3">Word</A>;
FROM <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A> IMPORT char;

REVEAL
  <A NAME="Connector">Connector</A> = MUTEX BRANDED &quot;TCP.Connector&quot; OBJECT
    fd: INTEGER;       (*CONST*)
    ep: IP.Endpoint;   (*CONST*)
    closed: BOOLEAN := FALSE;
  END;

REVEAL
  <A NAME="T">T</A> = TCPPosix.Public BRANDED &quot;TCP.T&quot; OBJECT
    ep: IP.Endpoint;
    error: AtomList.T := NIL;
  OVERRIDES
    get := GetBytesFD;
    put := PutBytesFD;
    shutdownIn := ShutdownIn;
    shutdownOut := ShutdownOut;
    close := Close;
  END;

TYPE SockAddrIn = Uin.struct_sockaddr_in;

CONST TCP_NODELAY = 1;

CONST Sin_Zero = ARRAY [0 .. 7] OF char{VAL(0, char), ..};

VAR Unexpected: Atom.T;
    ClosedErr: AtomList.T;

PROCEDURE <A NAME="NewConnector"><procedure>NewConnector</procedure></A> (ep: IP.Endpoint): Connector RAISES {IP.Error} =
  VAR
    res                := NEW(Connector, ep := ep);
    name  : SockAddrIn;
    status: INTEGER;
    True               := 1;
  BEGIN
    res.fd := Usocket.socket(Usocket.AF_INET, Usocket.SOCK_STREAM, 0 (* TCP*));
    IF res.fd = -1 THEN
      IF Cerrno.errno = Uerror.EMFILE OR Cerrno.errno = Uerror.ENFILE THEN
        Raise(IP.NoResources);
      ELSE
        RaiseUnexpected();
      END
    END;
    MakeNonBlocking (res.fd);
    EVAL Usocket.setsockopt(
           res.fd, Usocket.SOL_SOCKET, Usocket.SO_REUSEADDR, ADR(True),
           BYTESIZE(True));
    name.sin_family := Usocket.AF_INET;
    name.sin_port := Uin.htons(ep.port);
    name.sin_addr.s_addr := LOOPHOLE(ep.addr, Utypes.u_int);
    name.sin_zero := Sin_Zero;
    status := Usocket.bind(res.fd, ADR(name), BYTESIZE(SockAddrIn));
    IF status # 0 THEN
      IF Cerrno.errno = Uerror.EADDRINUSE THEN
        Raise(IP.PortBusy);
      ELSE
        RaiseUnexpected();
      END
    END;
    IF Usocket.listen(res.fd, 8) # 0 THEN RaiseUnexpected(); END;
    RETURN res
  END NewConnector;

PROCEDURE <A NAME="GetEndPoint"><procedure>GetEndPoint</procedure></A>(c: Connector): IP.Endpoint =
  VAR
    namelen  : INTEGER;
    name  : SockAddrIn;
  BEGIN
    IF c.ep.addr = IP.NullAddress THEN
      c.ep.addr := IP.GetHostAddr();
    END;
    IF c.ep.port = IP.NullPort THEN
      namelen := BYTESIZE(SockAddrIn);
      IF Usocket.getsockname(c.fd, ADR(name), ADR(namelen)) # 0 THEN
        Die()
      END;
      c.ep.port := Uin.ntohs(name.sin_port);
    END;
    RETURN c.ep
  END GetEndPoint;

PROCEDURE <A NAME="Connect"><procedure>Connect</procedure></A> (ep: IP.Endpoint): T
    RAISES {IP.Error, Thread.Alerted} =
  VAR
    t := StartConnect(ep);
    ok := FALSE;
  BEGIN
    TRY
      EVAL FinishConnect(t);
      ok := TRUE;
    FINALLY
     IF NOT ok THEN Close(t); END;
    END;
    RETURN t;
  END Connect;

PROCEDURE <A NAME="StartConnect"><procedure>StartConnect</procedure></A>(ep: IP.Endpoint): T
    RAISES {IP.Error} =
  VAR
    fd: INTEGER;
    ok := FALSE;
  BEGIN
    fd := Usocket.socket(Usocket.AF_INET, Usocket.SOCK_STREAM, 0 (* TCP*));
    IF fd &lt; 0 THEN
      IF Cerrno.errno = Uerror.EMFILE OR Cerrno.errno = Uerror.ENFILE THEN
        Raise(IP.NoResources);
      ELSE
        RaiseUnexpected();
      END;
    END;
    InitFD(fd);
    TRY
      EVAL CheckConnect(fd, ep);
      ok := TRUE;
    FINALLY
      IF NOT ok THEN EVAL Unix.close(fd); END;
    END;
    RETURN NEW(T, fd := fd, ep := ep);
  END StartConnect;

PROCEDURE <A NAME="FinishConnect"><procedure>FinishConnect</procedure></A>(t: T; timeout: LONGREAL := -1.0D0): BOOLEAN
    RAISES {IP.Error, Thread.Alerted} =
  BEGIN
    LOOP
      EVAL SchedulerPosix.IOAlertWait(t.fd, FALSE, timeout);
      LOCK t DO
        IF t.error # NIL THEN RAISE IP.Error(t.error); END;
        IF CheckConnect(t.fd, t.ep) THEN EXIT; END;
      END;
      IF timeout &gt;= 0.0D0 THEN RETURN FALSE; END;
    END;
    RETURN TRUE;
  END FinishConnect;

VAR seenBadFBug: BOOLEAN := FALSE;

PROCEDURE <A NAME="CheckConnect"><procedure>CheckConnect</procedure></A>(fd: INTEGER; ep: IP.Endpoint) : BOOLEAN
    RAISES {IP.Error} =
  VAR
    name: SockAddrIn;
    status: INTEGER;
  BEGIN
    name.sin_family := Usocket.AF_INET;
    name.sin_port := Uin.htons(ep.port);
    name.sin_addr.s_addr := LOOPHOLE(ep.addr, Utypes.u_int);
    name.sin_zero := Sin_Zero;
    status := Usocket.connect(fd, ADR(name), BYTESIZE(SockAddrIn));
    IF status = 0 THEN RETURN TRUE; END;
    IF Cerrno.errno = Uerror.EINVAL THEN
      (* special hack to try to get real errno, hidden due to NBIO bug in connect *)
      EVAL TCPHack.RefetchError(fd);
    ELSIF Cerrno.errno = Uerror.EBADF THEN
      (* we'll try the same for EBADF, which we've seen on Alpha *)
      IF TCPHack.RefetchError(fd) THEN seenBadFBug := TRUE END;
    END;
    CASE Cerrno.errno OF
    | Uerror.EISCONN =&gt; RETURN TRUE;
    | Uerror.EADDRNOTAVAIL,  Uerror.ECONNREFUSED, Uerror.EINVAL,
               Uerror.ECONNRESET, Uerror.EBADF =&gt;
        Raise(Refused);
    | Uerror.ETIMEDOUT =&gt;
        Raise(Timeout);
    | Uerror.ENETUNREACH, Uerror.EHOSTUNREACH,  Uerror.EHOSTDOWN, Uerror.ENETDOWN =&gt;
        Raise(IP.Unreachable);
    | Uerror.EWOULDBLOCK, Uerror.EAGAIN,  Uerror.EINPROGRESS, Uerror.EALREADY =&gt;
    ELSE RaiseUnexpected();
    END;
    RETURN FALSE;
  END CheckConnect;

PROCEDURE <A NAME="Accept"><procedure>Accept</procedure></A> (c: Connector): T
    RAISES {IP.Error, Thread.Alerted} =
  VAR
    name                 : SockAddrIn;
    nameSize             : INTEGER      := BYTESIZE(name);
    fd                   : INTEGER;
  BEGIN
    LOOP
      LOCK c DO
        IF c.closed THEN RaiseNoEC(Closed); END;
        fd := Usocket.accept(c.fd, ADR(name), ADR(nameSize));
      END;
      IF fd &gt;= 0 THEN
        EXIT
      ELSIF Cerrno.errno = Uerror.EMFILE OR Cerrno.errno = Uerror.ENFILE THEN
        Raise(IP.NoResources);
      ELSIF
        Cerrno.errno = Uerror.EWOULDBLOCK OR Cerrno.errno = Uerror.EAGAIN
        THEN
        EVAL SchedulerPosix.IOAlertWait(c.fd, TRUE);
      ELSE
        RaiseUnexpected();
      END
    END;
    InitFD(fd);
    RETURN NEW(T, fd := fd, ep := IP.NullEndPoint);
  END Accept;

PROCEDURE <A NAME="CloseConnector"><procedure>CloseConnector</procedure></A>(&lt;*UNUSED*&gt; c: Connector) =
  BEGIN
    Die();
  END CloseConnector;

PROCEDURE <A NAME="EOF"><procedure>EOF</procedure></A>(t: T) : BOOLEAN =
  VAR
    status, charsToRead: INTEGER;
  BEGIN
    LOCK t DO
      IF SchedulerPosix.IOWait(t.fd, TRUE, 0.0D0) =
                            SchedulerPosix.WaitResult.Ready THEN
        status := Unix.ioctl(t.fd, Unix.FIONREAD, ADR(charsToRead));
        RETURN (status = 0) AND (charsToRead = 0);
      END;
    END;
    RETURN FALSE;
  END EOF;
</PRE> methods of TCP.T 

<P>
VAR SysSendBufSize: INTEGER := 65535;
VAR SysRcvBufSize: INTEGER := 65535;


<P><PRE>PROCEDURE <A NAME="InitFD"><procedure>InitFD</procedure></A>(fd: CARDINAL) =
  (* We assume that the runtime ignores SIGPIPE signals *)
  VAR
    one := 1;
    linger := Usocket.struct_linger{1, 1};
  BEGIN
</PRE><BLOCKQUOTE><EM><P>
    EVAL Usocket.setsockopt(fd, Usocket.SOL_SOCKET, Usocket.SO_SNDBUF,
                            ADR(SysSendBufSize), BYTESIZE(SysSendBufSize));
    EVAL Usocket.setsockopt(fd, Usocket.SOL_SOCKET, Usocket.SO_RCVBUF,
                            ADR(SysRcvBufSize), BYTESIZE(SysRcvBufSize));
</EM></BLOCKQUOTE><PRE>
    EVAL Usocket.setsockopt(fd, Usocket.SOL_SOCKET, Usocket.SO_LINGER,
                            ADR(linger), BYTESIZE(linger));
    EVAL Usocket.setsockopt(
           fd, Uin.IPPROTO_TCP, TCP_NODELAY, ADR(one), BYTESIZE(one));
    EVAL Usocket.setsockopt(fd, Usocket.SOL_SOCKET, Usocket.SO_LINGER,
                            ADR(linger), BYTESIZE(linger));
    EVAL Usocket.setsockopt(
           fd, Uin.IPPROTO_TCP, TCP_NODELAY, ADR(one), BYTESIZE(one));
    MakeNonBlocking (fd);
  END InitFD;

PROCEDURE <A NAME="MakeNonBlocking"><procedure>MakeNonBlocking</procedure></A>(fd: INTEGER) =
  BEGIN
    IF Unix.fcntl(fd, Unix.F_SETFL,
        Word.Or(Unix.fcntl(fd, Unix.F_GETFL, 0), Unix.M3_NONBLOCK)) # 0
    THEN
      Die();
    END;
  END MakeNonBlocking;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A>(t: T) =
  BEGIN
    LOCK t DO
      IF NOT t.closed THEN
        EVAL Unix.close(t.fd);
        t.closed := TRUE;
        t.error := ClosedErr;
      END;
    END;
  END Close;

PROCEDURE <A NAME="GetBytesFD"><procedure>GetBytesFD</procedure></A>(
    t: T; VAR arr: ARRAY OF CHAR; timeout: LONGREAL) : CARDINAL
    RAISES {Rd.Failure, ConnFD.TimedOut, Thread.Alerted} =
  VAR
    len: INTEGER;
  BEGIN
    LOOP
      LOCK t DO
        IF t.error # NIL THEN RAISE Rd.Failure(t.error); END;
        len := Uuio.read(t.fd, ADR(arr[0]), NUMBER(arr));
      END;
      IF len &gt;= 0 THEN
        RETURN len;
      ELSE
        CASE Cerrno.errno OF
        | Uerror.ECONNRESET =&gt; RETURN 0;
        | Uerror.EPIPE, Uerror.ENETRESET =&gt; SetError(t,ConnLost);
        | Uerror.ETIMEDOUT =&gt; SetError(t,Timeout);
        | Uerror.ENETUNREACH, Uerror.EHOSTUNREACH,
             Uerror.EHOSTDOWN, Uerror.ENETDOWN =&gt; SetError(t,IP.Unreachable);
        | Uerror.EWOULDBLOCK, Uerror.EAGAIN =&gt;
            IF timeout = 0.0D0 OR
                   SchedulerPosix.IOAlertWait(t.fd, TRUE, timeout) =
                       SchedulerPosix.WaitResult.Timeout THEN
              RAISE ConnFD.TimedOut;
            END;
        ELSE
            SetError(t,Unexpected);
        END;
      END;
    END;
  END GetBytesFD;

PROCEDURE <A NAME="PutBytesFD"><procedure>PutBytesFD</procedure></A>(t: T; VAR arr: ARRAY OF CHAR)
    RAISES {Wr.Failure, Thread.Alerted} =
  VAR pos := 0;
      len: INTEGER;
  BEGIN
    WHILE pos # NUMBER(arr) DO
      LOCK t DO
        IF t.error # NIL THEN RAISE Wr.Failure(t.error); END;
        len := Uuio.write(t.fd, ADR(arr[pos]), NUMBER(arr)-pos);
      END;
      IF len &gt;= 0 THEN
        INC(pos, len)
      ELSE
        CASE Cerrno.errno OF
        | Uerror.EPIPE, Uerror.ECONNRESET, Uerror.ENETRESET =&gt; SetError(t,ConnLost);
        | Uerror.ETIMEDOUT =&gt; SetError(t,Timeout);
        | Uerror.ENETUNREACH, Uerror.EHOSTUNREACH,
             Uerror.EHOSTDOWN, Uerror.ENETDOWN =&gt; SetError(t,IP.Unreachable);
        | Uerror.EWOULDBLOCK, Uerror.EAGAIN =&gt;
             EVAL SchedulerPosix.IOAlertWait(t.fd, FALSE);
             (* IF Thread.TestAlert() THEN RAISE Thread.Alerted END *)
        ELSE
            SetError(t,Unexpected);
        END
      END
    END;
  END PutBytesFD;

VAR lastErrorMu := NEW(MUTEX);
    lastErrors: ARRAY [0..19] OF INTEGER;
    lastErrorPos: CARDINAL := 0;

PROCEDURE <A NAME="SetError"><procedure>SetError</procedure></A>(t: T; atom: Atom.T) =
  BEGIN
    LOCK t DO
      t.error := AtomList.List2(atom, Atom.FromText(Fmt.Int(Cerrno.errno)));
      LOCK lastErrorMu DO
        lastErrors[lastErrorPos] := Cerrno.errno;
        INC(lastErrorPos);
        IF lastErrorPos &gt;= NUMBER(lastErrors) THEN lastErrorPos := 0; END;
      END;
    END;
  END SetError;

PROCEDURE <A NAME="ShutdownIn"><procedure>ShutdownIn</procedure></A>(t: T) RAISES {Rd.Failure} =
  BEGIN
    LOCK t DO
      IF t.error # NIL THEN RAISE Rd.Failure(t.error); END;
      EVAL Usocket.shutdown(t.fd, 0);
    END;
  END ShutdownIn;

PROCEDURE <A NAME="ShutdownOut"><procedure>ShutdownOut</procedure></A>(t: T) RAISES {Wr.Failure} =
  BEGIN
    LOCK t DO
      IF t.error # NIL THEN RAISE Wr.Failure(t.error); END;
      EVAL Usocket.shutdown(t.fd, 1);
    END;
  END ShutdownOut;

PROCEDURE <A NAME="Raise"><procedure>Raise</procedure></A>(a: Atom.T) RAISES {IP.Error} =
  BEGIN
    RAISE IP.Error(AtomList.List2(a, Atom.FromText(Fmt.Int(Cerrno.errno))));
  END Raise;

PROCEDURE <A NAME="RaiseUnexpected"><procedure>RaiseUnexpected</procedure></A>() RAISES {IP.Error} =
  BEGIN
    Raise(Unexpected);
  END RaiseUnexpected;

 PROCEDURE <A NAME="RaiseNoEC"><procedure>RaiseNoEC</procedure></A>(a: Atom.T) RAISES {IP.Error} =
  BEGIN
    RAISE IP.Error(AtomList.List1(a));
  END RaiseNoEC;

EXCEPTION FatalError;

PROCEDURE <A NAME="Die"><procedure>Die</procedure></A>() RAISES {} =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Die;

BEGIN
  Refused := Atom.FromText(&quot;TCP.Refused&quot;);
  Closed := Atom.FromText(&quot;TCP.Closed&quot;);
  Timeout := Atom.FromText(&quot;TCP.Timeout&quot;);
  ConnLost := Atom.FromText(&quot;TCP.ConnLost&quot;);
  Unexpected := Atom.FromText(&quot;TCP.Unexpected&quot;);
  ClosedErr := AtomList.List1(Closed);
END TCP.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Uin is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uin.i3#0TOP0">unix/src/aix-3-2/Uin.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uin.i3#0TOP0">unix/src/aix-ps2-1-2/Uin.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uin.i3#0TOP0">unix/src/freebsd-1/Uin.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uin.i3#0TOP0">unix/src/freebsd-2/Uin.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uin.i3#0TOP0">unix/src/hpux-7-0/Uin.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uin.i3#0TOP0">unix/src/ibm-4-3/Uin.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uin.i3#0TOP0">unix/src/irix-5.2/Uin.i3</A>
<LI><A HREF="../../../unix/src/linux/Uin.i3#0TOP0">unix/src/linux/Uin.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Uin.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Uin.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Uin.i3#0TOP0">unix/src/osf-1.DS3100/Uin.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uin.i3#0TOP0">unix/src/solaris-2-x/Uin.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uin.i3#0TOP0">unix/src/sunos-4-x/Uin.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uin.i3#0TOP0">unix/src/sysv-4.0/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Uin.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Uin.i3#0TOP0">unix/src/ultrix-3-1.ARM/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Uin.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Uin.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Uin.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Uin.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Uin.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Uin.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Uin.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Uin.i3#0TOP0">unix/src/ultrix-3-1.VAX/Uin.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Usocket is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Usocket.i3#0TOP0">unix/src/aix-3-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Usocket.i3#0TOP0">unix/src/aix-ps2-1-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Usocket.i3#0TOP0">unix/src/freebsd-1/Usocket.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Usocket.i3#0TOP0">unix/src/freebsd-2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Usocket.i3#0TOP0">unix/src/hpux-7-0/Usocket.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Usocket.i3#0TOP0">unix/src/ibm-4-3/Usocket.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Usocket.i3#0TOP0">unix/src/irix-5.2/Usocket.i3</A>
<LI><A HREF="../../../unix/src/linux/Usocket.i3#0TOP0">unix/src/linux/Usocket.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Usocket.i3#0TOP0">unix/src/osf-1.generic/Usocket.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Usocket.i3#0TOP0">unix/src/solaris-2-x/Usocket.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Usocket.i3#0TOP0">unix/src/sunos-4-x/Usocket.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Usocket.i3#0TOP0">unix/src/sysv-4.0/Usocket.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Usocket.i3#0TOP0">unix/src/ultrix-3-1.generic/Usocket.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface Uerror is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uerror.i3#0TOP0">unix/src/aix-3-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uerror.i3#0TOP0">unix/src/aix-ps2-1-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uerror.i3#0TOP0">unix/src/freebsd-1/Uerror.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uerror.i3#0TOP0">unix/src/freebsd-2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uerror.i3#0TOP0">unix/src/hpux-7-0/Uerror.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uerror.i3#0TOP0">unix/src/ibm-4-3/Uerror.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uerror.i3#0TOP0">unix/src/irix-5.2/Uerror.i3</A>
<LI><A HREF="../../../unix/src/linux/Uerror.i3#0TOP0">unix/src/linux/Uerror.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uerror.i3#0TOP0">unix/src/osf-1.generic/Uerror.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uerror.i3#0TOP0">unix/src/solaris-2-x/Uerror.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uerror.i3#0TOP0">unix/src/sunos-4-x/Uerror.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uerror.i3#0TOP0">unix/src/sysv-4.0/Uerror.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uerror.i3#0TOP0">unix/src/ultrix-3-1.generic/Uerror.i3</A>
</UL>
<P>
<HR>
<A NAME="x4">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x5">interface Uuio is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Uuio.i3#0TOP0">unix/src/aix-3-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Uuio.i3#0TOP0">unix/src/aix-ps2-1-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Uuio.i3#0TOP0">unix/src/freebsd-1/Uuio.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Uuio.i3#0TOP0">unix/src/freebsd-2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Uuio.i3#0TOP0">unix/src/hpux-7-0/Uuio.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Uuio.i3#0TOP0">unix/src/ibm-4-3/Uuio.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Uuio.i3#0TOP0">unix/src/irix-5.2/Uuio.i3</A>
<LI><A HREF="../../../unix/src/linux/Uuio.i3#0TOP0">unix/src/linux/Uuio.i3</A>
<LI><A HREF="../../../unix/src/osf-1.generic/Uuio.i3#0TOP0">unix/src/osf-1.generic/Uuio.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Uuio.i3#0TOP0">unix/src/solaris-2-x/Uuio.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Uuio.i3#0TOP0">unix/src/sunos-4-x/Uuio.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Uuio.i3#0TOP0">unix/src/sysv-4.0/Uuio.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Uuio.i3#0TOP0">unix/src/ultrix-3-1.generic/Uuio.i3</A>
</UL>
<P>
<HR>
<A NAME="x6">interface Utypes is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Utypes.i3#0TOP0">unix/src/aix-3-2/Utypes.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Utypes.i3#0TOP0">unix/src/aix-ps2-1-2/Utypes.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Utypes.i3#0TOP0">unix/src/freebsd-1/Utypes.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Utypes.i3#0TOP0">unix/src/freebsd-2/Utypes.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Utypes.i3#0TOP0">unix/src/hpux-7-0/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Utypes.i3#0TOP0">unix/src/ibm-4-3/Utypes.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Utypes.i3#0TOP0">unix/src/irix-5.2/Utypes.i3</A>
<LI><A HREF="../../../unix/src/linux/Utypes.i3#0TOP0">unix/src/linux/Utypes.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Utypes.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utypes.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Utypes.i3#0TOP0">unix/src/osf-1.DS3100/Utypes.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Utypes.i3#0TOP0">unix/src/solaris-2-x/Utypes.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Utypes.i3#0TOP0">unix/src/sunos-4-x/Utypes.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Utypes.i3#0TOP0">unix/src/sysv-4.0/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Utypes.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Utypes.i3#0TOP0">unix/src/ultrix-3-1.ARM/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Utypes.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Utypes.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Utypes.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Utypes.i3#0TOP0">unix/src/ultrix-3-1.VAX/Utypes.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
