<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcp/src/common/ConnFD.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcp/src/common/ConnFD.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created on Sat Jan 11 15:49:00 PST 1992 by gnelson </EM></BLOCKQUOTE><PRE>

INTERFACE <interface>ConnFD</interface>;

IMPORT <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;

TYPE T = TRep;
</PRE> A <CODE>T</CODE> is a bi-directional communications channel (for example
   a TCP channel).  Given an <CODE>T</CODE>, a client can initialize a
   paired reader and writer whose source and target are the channel. 
       
<P> ultimately, the type above will be a subtype of <CODE>File.T</CODE> 

<P><PRE>EXCEPTION TimedOut;

TYPE
  TRep = MUTEX OBJECT METHODS
    get(VAR arr: ARRAY OF CHAR; waitFor: LONGREAL := -1.0D0) : CARDINAL
        RAISES {Rd.Failure, Thread.Alerted, TimedOut};
    put(VAR arr: ARRAY OF CHAR)
        RAISES {Wr.Failure, Thread.Alerted};
    shutdownIn() RAISES {Rd.Failure};
    shutdownOut() RAISES {Wr.Failure};
    close();
  END;

  (* Get method:
        If &quot;timeout&quot; is negative, &quot;get&quot; will block forever.
        Otherwise, it will block for a maximum of of &quot;waitFor&quot;
        seconds. *)

END ConnFD.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
