<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcp/src/common/ConnRW.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcp/src/common/ConnRW.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created on Sat Jan 11 15:49:00 PST 1992 by gnelson </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ConnRW.i3">ConnRW</A></implements></module>;

IMPORT <A HREF="ConnFD.i3">ConnFD</A>, <A HREF="../../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../rw/src/Common/RdClass.i3">RdClass</A>, <A HREF="../../../rw/src/Common/WrClass.i3">WrClass</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
   RdT = Rd.T BRANDED OBJECT
    fd: ConnFD.T;
  OVERRIDES
    seek := RdSeek;
    close := RdClose
  END;

  WrT = Wr.T BRANDED OBJECT
    fd: ConnFD.T;
  OVERRIDES
    seek := WrSeek;
    flush := WrFlush;
    close := WrClose
  END;

CONST BufferSize = 8192;

PROCEDURE <A NAME="NewRd"><procedure>NewRd</procedure></A>(fd: ConnFD.T) : Rd.T =
  BEGIN
    RETURN NEW(RdT, fd := fd,
        buff := NEW(REF ARRAY OF CHAR, BufferSize),
        st := 0,
        lo := 0,
        hi := 0,
        cur := 0,
        intermittent := TRUE,
        seekable := FALSE,
        closed := FALSE);
  END NewRd;

PROCEDURE <A NAME="NewWr"><procedure>NewWr</procedure></A>(fd: ConnFD.T) : Wr.T =
  BEGIN
    RETURN NEW(WrT, fd := fd,
        buff := NEW(REF ARRAY OF CHAR, BufferSize),
        st := 0,
        lo := 0,
        hi := 0,
        cur := 0,
        buffered := TRUE,
        seekable := FALSE,
        closed := FALSE);
  END NewWr;

PROCEDURE <A NAME="RdSeek"><procedure>RdSeek</procedure></A>(rd: RdT; &lt;*UNUSED*&gt; pos: CARDINAL;
                 dontBlock: BOOLEAN): RdClass.SeekResult
  RAISES {Rd.Failure, Thread.Alerted} =
  VAR
    len: CARDINAL;
    timer: LONGREAL;
  BEGIN
    IF dontBlock THEN timer := 0.0D0; ELSE timer := -1.0D0; END;
    TRY
      len := rd.fd.get(rd.buff^, timer);
    EXCEPT
    | ConnFD.TimedOut =&gt; RETURN RdClass.SeekResult.WouldBlock;
    (* | ConnFD.Error =&gt; RETURN RdClass.SeekResult.Eof; *)
    END;
    IF len &gt; 0 THEN
      rd.lo := rd.cur;
      rd.hi := rd.cur + len;
      RETURN RdClass.SeekResult.Ready
    ELSE
      RETURN RdClass.SeekResult.Eof;
    END;
  END RdSeek;

PROCEDURE <A NAME="RdClose"><procedure>RdClose</procedure></A>(rd: RdT) RAISES {Rd.Failure} =
  BEGIN
    rd.buff := NIL;
    rd.fd.shutdownIn();
  END RdClose;

PROCEDURE <A NAME="WrSeek"><procedure>WrSeek</procedure></A>(wr: WrT; &lt;*UNUSED*&gt; n: CARDINAL)
  RAISES {Wr.Failure, Thread.Alerted} =
  BEGIN WrFlush(wr) END WrSeek;

PROCEDURE <A NAME="WrFlush"><procedure>WrFlush</procedure></A>(wr: WrT) RAISES {Wr.Failure, Thread.Alerted} =
  BEGIN
    wr.fd.put(SUBARRAY(wr.buff^, 0, wr.cur-wr.lo));
    wr.lo := wr.cur;
    wr.hi := wr.lo + NUMBER(wr.buff^);
  END WrFlush;

PROCEDURE <A NAME="WrClose"><procedure>WrClose</procedure></A>(wr: WrT) RAISES {Wr.Failure} =
  BEGIN
    wr.buff := NIL;
    wr.fd.shutdownOut();
  END WrClose;

BEGIN END ConnRW.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
