<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcp/src/common/IP.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcp/src/common/IP.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created on Sat Jan 11 15:49:00 PST 1992 by gnelson </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="../POSIX/IP.m3">IP</A></interface>;

IMPORT <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="../../../libm3/derived/AtomList.i3">AtomList</A>;
</PRE> This interface defines the addresses used for communicating
   with the internet protocol family. 
   <P>
   An IP ``endpoint'' identifies a running program in a way that allows
   other programs to communicate with it.
<P>
   An endpoint consists of an ``address'', which identifies the
   host machine on which the program is running, together with
   a ``port'', which distinguishes the program from other programs
   running on the same host.
<P>
   The host operating system guarantees that the same port is never
   in use by more than one program running on the host simultaneously.
   The same program may be identified by several ports.  Similarly, the
   internet police (try to) guarantee that the same address is never
   in use simultaneously by more than one machine in the world, but
   the same machine may be identified by several addresses.
   <P>
   Port numbers and host addresses can be recycled: the operating system 
   can reuse a port number of a program that has exited or explicitly
   freed the port, and the internet police will reassign addresses 
   from old hosts to new ones. 

<P><PRE>TYPE EC = AtomList.T;

EXCEPTION Error(EC);
</PRE> An IP implementation (or a layered IP protocolimplementation), can raise
   <CODE>Error</CODE> with error lists including, but not limited to, the following
   atoms: 

<P><PRE>VAR
  LookupFailure, Unreachable, PortBusy, NoResources: Atom.T;
</PRE> <CODE>LookupFailure</CODE> indicates that a call to <CODE>GetHostByName</CODE> could
   not determine whether the argument name exists.
<P>
   The following errors codes can arise from implementations of protocols
   which are layered on IP:
<P>
   <CODE>Unreachable</CODE> indicates that the destination protocol address is
   not reachable from the local node.  This is typically occurs
   in layered protocols (e.g. TCP) during connection establishment.
<P>
   <CODE>PortBusy</CODE> indicates that the caller attempted to use a port
   which is already in use.
<P>
   <CODE>NoResources</CODE> indicates an OS-dependent resource shortage (such
   as <CODE>no more sockets</CODE>).  The remainder of the error list may detail
   the failure.


<P>
<P><PRE>TYPE
  Port = [0..65535];
  Address = RECORD a: ARRAY [0..3] OF BITS 8 FOR [0..255]; END;
  Endpoint = RECORD addr: Address; port: Port END;
</PRE> The type <CODE>Address</CODE> is an IP address is network byte order.
   The type <CODE>Port</CODE> is an IP port number in host byte order.


<P><PRE>CONST
  NullPort: Port = 0;
  NullAddress = Address{a := ARRAY OF BITS 8 FOR [0..255] {0,0,0,0}};
  NullEndPoint = Endpoint{NullAddress, NullPort};

PROCEDURE <A HREF="../POSIX/IP.m3#GetHostByName">GetHostByName</A>(nm: TEXT; VAR (*out*) res: Address): BOOLEAN
     RAISES {Error};
</PRE><BLOCKQUOTE><EM> If a host named <CODE>nm</CODE> is found, <CODE>GetHostByName</CODE> sets <CODE>res</CODE> to its
   address and returns <CODE>TRUE</CODE>.  If <CODE>nm</CODE> is not found, <CODE>GetHostByName</CODE>
   returns <CODE>FALSE</CODE>.  If the lookup cannot complete then <CODE>Error</CODE> is
   raised with <CODE>LookupFailure</CODE> in the error list. </EM></BLOCKQUOTE><PRE>
</PRE> For example, 
<P>
<PRE>
      GetHostByName(&quot;gatekeeper.dec.com&quot;, addr) 
</PRE>
  returns the address of the machine ``gatekeeper'' at DEC SRC.
    <P>
  Different systems use different algorithms for
  implementing <CODE>GetHostByName</CODE>. 

<P><PRE>PROCEDURE <A HREF="../POSIX/IP.m3#GetCanonicalByName">GetCanonicalByName</A>(nm: TEXT): TEXT RAISES {Error};
</PRE><BLOCKQUOTE><EM> If a host named <CODE>nm</CODE> is found, <CODE>GetCanonicalByName</CODE> returns the
   canonical, full-qualified name for the host <CODE>nm</CODE>.  If <CODE>nm</CODE> is not found,
   <CODE>GetCanonicalByName</CODE> returns <CODE>NIL</CODE>.  If the lookup cannot complete
   then <CODE>Error</CODE> is raised with <CODE>LookupFailure</CODE> in the error list. </EM></BLOCKQUOTE><PRE>
</PRE> For example, 
<P>
<PRE>
      GetCanonicalName(&quot;gatekeeper.pa.dec.com&quot;)
</PRE>
  returns <CODE>gatekeeper.dec.com. 

<P><PRE>PROCEDURE <A HREF="../POSIX/IP.m3#GetCanonicalByAddr">GetCanonicalByAddr</A>(addr: Address): TEXT RAISES {Error};
</PRE><BLOCKQUOTE><EM> <CODE>GetCanonicalByAddr</CODE> is has the same semantics as <CODE>GetCanonicalByName</CODE>
   except that it takes an address rather than a name. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../POSIX/IP.m3#GetHostAddr">GetHostAddr</A>(): Address;
</PRE><BLOCKQUOTE><EM> Return an address of the machine executing the call to <CODE>GetHostAddr</CODE>. </EM></BLOCKQUOTE><PRE>

END IP.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
