<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcp/src/common/TCP.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcp/src/common/TCP.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Created on Sat Jan 11 15:49:00 PST 1992 by gnelson </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="../POSIX/TCP.m3">TCP</A></interface>;
</PRE> A TCP connection is a bidirectional byte stream between two
   programs, implemented using internet protocols.
<P>
   Connections are symmetric, but the protocol for establishing a
   connection is asymmetric.  One of the programs (which we will call
   the ``server'') creates a ``connector'' associated with some IP port.
   Another program (which we will call the ``client'') creates a
   connection to the server by specifying the endpoint of the connector.
   The server should fork threads that block waiting to accept
   connections.
   <P>
   In general the connector contains a queue of server threads waiting
   to accept connections and a queue of client threads waiting to 
   make connections.  In the idle state one of these queues is empty.
   Whenever both queues are non-empty, the client and server threads
   at the heads of their queues are unblocked and a connection is 
   created between them. 

<P><PRE>IMPORT <A HREF="../../../atom/src/Atom.i3">Atom</A>, <A HREF="ConnFD.i3">ConnFD</A>, <A HREF="IP.i3">IP</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  <A HREF="../POSIX/TCP.m3#Connector">Connector</A> &lt;: ROOT;
  <A HREF="../POSIX/TCP.m3#T">T</A> &lt;: ConnFD.T;
</PRE> The TCP implementation produces a <CODE>ConnFD.T</CODE> which raises
   <CODE>Rd.Failure</CODE> and <CODE>Wr.Failure</CODE> errors with the same atom lists
   used for <CODE>IP.Error</CODE>.  TCP procedures can raise <CODE>IP.Error</CODE> with
   atom lists including those atoms described in <CODE>IP.i3</CODE>, plus the
   following atoms: 

<P><PRE>VAR
  Refused, Closed, Timeout, ConnLost: Atom.T;
</PRE> <CODE>Refused</CODE> indicates that the destination endpoint does not
   exist, or has been closed.
<P>
   <CODE>Closed</CODE> indicates an attempt to access a closed <CODE>T</CODE> or aa
   closed <CODE>Connector</CODE>.
<P>
   <CODE>Timeout</CODE> indicates that a read or write failed due to
   a connection timeout.
<P>
   <CODE>ConnLost</CODE> indicates a broken TCP connection.


<P>
<P> procedures 

<P><PRE>PROCEDURE <A HREF="../POSIX/TCP.m3#NewConnector">NewConnector</A>(ep: IP.Endpoint): Connector RAISES {IP.Error};
</PRE><BLOCKQUOTE><EM> Allocate and return a connector with the endpoint <CODE>ep</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The value of <CODE>ep.addr</CODE> must be null or one of the caller's IP
   addresses.  If <CODE>ep.addr</CODE> is null then the connector will accept
   connections on any of the caller's addresses.
<P>
   If <CODE>ep.port # IP.NullPort</CODE>, then the connector offers connections on 
   <CODE>ep.port</CODE>.  In this case the procedure raises <CODE>IP.Error</CODE> with
   <CODE>IP.PortBusy</CODE> if <CODE>ep.port</CODE> is not available.
   <P>
   If <CODE>ep.port = IP.NullPort</CODE>, then the operating system selects some
   available port and assigns it to the connector, which will then
   accept connections only on that port.  You can find out which port
   was assigned by using the <CODE>GetEndPoint</CODE> procedure below.  If no ports
   are available, the procedure raises <CODE>IP.Error</CODE> with <CODE>IP.NoResources</CODE>.
   <P>
   Initially the connector returned has no server or client threads
   waiting on it. 

<P><PRE>PROCEDURE <A HREF="../POSIX/TCP.m3#GetEndPoint">GetEndPoint</A>(c: Connector): IP.Endpoint;
</PRE><BLOCKQUOTE><EM> Return the endpoint of <CODE>c</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../POSIX/TCP.m3#CloseConnector">CloseConnector</A>(c: Connector);
</PRE><BLOCKQUOTE><EM> Close the connector <CODE>c</CODE>.  Not yet implemented. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../POSIX/TCP.m3#Connect">Connect</A> (ep: IP.Endpoint): T
    RAISES {IP.Error, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Create and return a connection to the endpoint <CODE>ep</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The procedure <CODE>Connect</CODE> raises <CODE>IP.Error</CODE> with <CODE>Refused</CODE> if no connector
   exists with the given endpoint or if the connector with that endpoint
   is closed.  Otherwise the thread calling <CODE>Connect</CODE> is blocked on the
   queue of clients waiting to make connections on that connector. When
   it reaches the head of the queue and the queue of server  threads is
   non-empty, a connection is created between it and the server thread;
   the connection is returned by <CODE>Connect</CODE>.
<P>
   <CODE>Connect</CODE> raises <CODE>IP.Error</CODE> with <CODE>TimeOut</CODE> or <CODE>IP.Unreachable</CODE>
   if the endpoint is crashed or if communication fails. It raises <CODE>IP.Error</CODE>
   with <CODE>Refused</CODE> if the connector is closed while the thread is blocked.
<P>
   If <CODE>ep.addr</CODE> is null, <CODE>Connect</CODE> connects to the calling machine
   itself. 

<P><PRE>PROCEDURE <A HREF="../POSIX/TCP.m3#Accept">Accept</A>(c: Connector): T
    RAISES {IP.Error, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Block and wait until some process connects to <CODE>c</CODE>, and
   return a connection to that process.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Accept</CODE> is the server-side analog of <CODE>Connect</CODE>: the thread calling
   <CODE>Accept</CODE> is blocked on the queue of threads waiting to service
   connectins on <CODE>c</CODE>.  When the thread reaches the head of the queue
   and the queue of client threads is non-empty, a connection is created
   between it and the client thread; the connection is returned by
   <CODE>Accept</CODE>.v
<P>
   <CODE>Accept</CODE> raises <CODE>IP.Error</CODE> with an list including <CODE>Closed</CODE>
   if the connector is closed or becomes closed while the thread is
   blocked.  

<P><PRE>PROCEDURE <A HREF="../POSIX/TCP.m3#Close">Close</A>(t: T);
</PRE><BLOCKQUOTE><EM> Close the connection <CODE>t</CODE> and free all related resources. </EM></BLOCKQUOTE><PRE>

END TCP.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
