<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcp/src/common/TCPSpecial.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcp/src/common/TCPSpecial.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="../POSIX/TCP.m3">TCPSpecial</A></interface>;

IMPORT <A HREF="TCP.i3">TCP</A>, <A HREF="IP.i3">IP</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;
</PRE> procedures 

<P><PRE>PROCEDURE <A HREF="../POSIX/TCP.m3#EOF">EOF</A>(t: TCP.T) : BOOLEAN;
</PRE> Returns <CODE>TRUE</CODE> if and only if there are no more bytes to be read from
   this connection, and the connection indicates end-of-file (e.g.
   the other side closed it. 

<P><PRE>PROCEDURE <A HREF="../POSIX/TCP.m3#StartConnect">StartConnect</A>(ep: IP.Endpoint) : TCP.T
    RAISES {IP.Error};
</PRE> <CODE>StartConnect</CODE> initiates a request to connect to the destination
   specified by <CODE>ep</CODE>.  If <CODE>msgT</CODE> is <CODE>TRUE</CODE> then the results reader
   and writer fields are of type <CODE>MsgRd.T</CODE> and <CODE>MsgWr.T</CODE>.  Otherwise,
   they are a normal reader and writer.  The resulting <CODE>T</CODE> can be used
   to make read and write calls, but these may result in errors if
   in fact the connection attempt is not successful.  

<P><PRE>PROCEDURE <A HREF="../POSIX/TCP.m3#FinishConnect">FinishConnect</A>(
    t: TCP.T; waitFor: LONGREAL := -1.0D0) : BOOLEAN
    RAISES {IP.Error, Thread.Alerted};
</PRE> <CODE>FinishConnect</CODE> returns a <CODE>BOOLEAN</CODE> to indicate if a connection
   request initiated via <CODE>StartConnect</CODE> has successfully completed.
   A result of <CODE>TRUE</CODE> indicates that it has.  <CODE>FALSE</CODE> means that the
   connection request is still outstanding.  If <CODE>waitFor</CODE> is negative,
   then <CODE>FinishConnect</CODE> waits indefinitely until the operation completes,
   otherwise it waits for a maximum of <CODE>waitFor</CODE> seconds.  The caller
   should continue to call this procedure until it either returns <CODE>TRUE</CODE>
   or raises an error. 

<P><PRE>END TCPSpecial.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
