<HTML>
<HEAD>
<TITLE>SRC Modula-3: tcpnetobj/src/TCPNetObj.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tcpnetobj/src/TCPNetObj.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> TCPNetObj.m3                                            </EM></BLOCKQUOTE><PRE>

MODULE <module>TCPNetObj</module> EXPORTS <A HREF="TCPNetObj.i3"><implements>TCPNetObj</A></implements>, <A HREF="TCPTransport.i3"><implements>TCPTransport</A></implements>;

IMPORT <A HREF="../../netobjrt/src/NetObj.i3">NetObj</A>, <A HREF="../../tcp/src/common/IP.i3">IP</A>, <A HREF="../../tcp/src/common/TCP.i3">TCP</A>, <A HREF="../../tcp/src/common/TCPSpecial.i3">TCPSpecial</A>, <A HREF="../../netobjrt/src/Transport.i3">Transport</A>, <A HREF="../../tcp/src/POSIX/TCPPosix.i3">TCPPosix</A>;
IMPORT <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../convert/src/Convert.i3">Convert</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../time/src/Common/Time.i3">Time</A>;
IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../weakref/src/WeakRef.i3">WeakRef</A>, <A HREF="HeaderOps.i3">HeaderOps</A>, <A HREF="../../tcp/src/common/ConnFD.i3">ConnFD</A>, <A HREF="../../tcp/src/common/ConnMsgRW.i3">ConnMsgRW</A>, <A HREF="../../netobjrt/src/TransportUtils.i3">TransportUtils</A>;
IMPORT <A HREF="../../os/src/Common/Process.i3">Process</A>, <A HREF="../../netobjrt/src/NetObjNotifier.i3">NetObjNotifier</A>, <A HREF="../../netobjrt/src/StubLib.i3">StubLib</A>;
IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../time/src/Common/FmtTime.i3">FmtTime</A>, <A HREF="../../runtime/src/common/RTParams.i3">RTParams</A>;

CONST
   DefaultAgentPort = 9783;   (* random!!! *)
   UniqueEndpointProtocolName = &quot;TCPV2-U&quot;;
   KnownEndpointProtocolName  = &quot;TCPV2-K&quot;;

   InitPingCycles = 1;
   MaxPingCycles = 10;

TYPE
  T = Transport.T OBJECT
    mu: MUTEX;
    locationTbl: TextRefTbl.T := NIL;
    listener: ListenerClosure := NIL;
  OVERRIDES
    fromEndpoint := LocationFromEndpoint;
    toEndpoint := ListenerEndpoint;
    (* TransportUtils.Public *)
    enumerateLocs := EnumerateLocs;
  END;

  ConnT = StubLib.Conn OBJECT
    fd: ConnFD.T;
    nextConn: ConnT := NIL;
    nextFree: ConnT := NIL;
    thread: Thread.T := NIL;    (* server-side only *)
  METHODS
    close() := CloseConnT;
  END;

  Location = Transport.Location OBJECT
    mu: MUTEX;
    t: T;
    e: Transport.Endpoint;
    ep: IP.Endpoint;
    knownEP: BOOLEAN;
    activity: BOOLEAN := FALSE;
    reported: BOOLEAN := FALSE;
    connList: ConnT := NIL;
    freeList: ConnT := NIL;
    nCached: CARDINAL := 0;
    pingCount: CARDINAL := InitPingCycles;
    pingCycles: CARDINAL := InitPingCycles;
  OVERRIDES
    new := NewConnection;
    free := FreeConnection;
    (* TransportUtils.LocationP *)
    getInfo := GetInfo;
    getEp := GetEp;
  END;

  ListenerClosure = Thread.SizedClosure OBJECT
    t: T;
    ep: IP.Endpoint;
    c: TCP.Connector;
    rep: NetObj.Address;
  OVERRIDES
    apply := Listener;
  END;

  ScavengerClosure = Thread.Closure OBJECT
    t: T;
    pingQ: PingRQ := NIL;
    killQ: ConnT := NIL;
  OVERRIDES
    apply := Scavenger;
  END;

  PingRQ = Thread.Closure OBJECT
    next: PingRQ;
    loc: Location;
    conn: TCP.T := NIL;
    start: Time.T := 0.0D0;
    try: CARDINAL := 0;
  OVERRIDES
    apply := ProcessPing;
  END;

  WR = REF WeakRef.T;

CONST MaxCachedConnections = 2;

VAR (*CONST*) thisTransport: T;
VAR (*CONST*) logging: BOOLEAN;
</PRE> exported to TCPTransport 

<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A>() : Transport.T =
  BEGIN
    &lt;* ASSERT thisTransport = NIL *&gt;
    thisTransport := NEW(T, mu := NEW(MUTEX));
    RETURN thisTransport;
  END New;
</PRE> exported to TCPNetObj 

<P><PRE>PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A> (ep: IP.Endpoint) : NetObj.Address =
  BEGIN
    (* might want to cache the local ip address in IP.m3 *)
    IF ep.addr = IP.NullAddress THEN ep.addr := IP.GetHostAddr(); END;
    IF ep.port = IP.NullPort THEN ep.port := DefaultAgentPort; END;
    RETURN TCPEndpointToAddr(ep, FALSE);
  END Locate;

PROCEDURE <A NAME="Listen"><procedure>Listen</procedure></A> (port: IP.Port) : NetObj.Address RAISES {Failed} =
  VAR l: ListenerClosure;
  BEGIN
    (* assign well-known port for listening *)
    IF port = IP.NullPort THEN port := DefaultAgentPort; END;
    TRY
      l := DoListen(thisTransport, port);
    EXCEPT
    | IP.Error =&gt; RAISE Failed;
    END;
    RETURN l.rep;
  END Listen;

PROCEDURE <A NAME="DoListen"><procedure>DoListen</procedure></A>(t: T; port: IP.Port) : ListenerClosure RAISES {IP.Error} =
  VAR l: ListenerClosure;
  BEGIN
    l := NEW(ListenerClosure,
           t := t, stackSize := 2 * Thread.GetDefaultStackSize(),
           c := TCP.NewConnector(IP.Endpoint{IP.NullAddress, port}));
    l.ep := TCP.GetEndPoint(l.c);
    l.rep := TCPEndpointToAddr(l.ep, TRUE);
    LOCK t.mu DO t.listener := l; END;
    EVAL Thread.Fork(l);
    RETURN l;
  END DoListen;
</PRE> transport T methods 

<P><PRE>PROCEDURE <A NAME="LocationFromEndpoint"><procedure>LocationFromEndpoint</procedure></A>(
    t: T; e: Transport.Endpoint) : Transport.Location =
  VAR ep: IP.Endpoint;
  VAR loc: Location := NIL;
  VAR r: REFANY;
  VAR wr: WR;
  BEGIN
    LOCK t.mu DO
      IF t.locationTbl = NIL THEN
        t.locationTbl := NEW(TextRefTbl.Default).init();
        EVAL Thread.Fork(NEW(ScavengerClosure, t := t));
      END;
      IF t.locationTbl.get(e, r) THEN
        loc := WeakRef.ToRef(NARROW(r, WR)^);
        IF loc # NIL THEN RETURN loc; END;
      END;
      IF TCPEndpointFromText(e, ep) THEN
        loc := NEW(Location,
          mu := NEW(MUTEX), t := t, e := e,
          knownEP := KnownEndpoint(e), ep := ep);
        wr := NEW(WR);
        wr^ := WeakRef.FromRef(loc, LocationCleanup);
        EVAL t.locationTbl.put(e, wr);
      END;
    END;
    RETURN loc;
  END LocationFromEndpoint;

PROCEDURE <A NAME="LocationCleanup"><procedure>LocationCleanup</procedure></A>(&lt;*UNUSED*&gt; READONLY wr: WeakRef.T; r: REFANY) =
  VAR loc := NARROW(r, Location);
      t := loc.t;
      cc: ConnT;
      x: REFANY;
  BEGIN
    LOCK t.mu DO
      IF t.locationTbl.get(loc.e, x) THEN
        IF WeakRef.ToRef(NARROW(x, WR)^) = NIL THEN
          EVAL t.locationTbl.delete(loc.e, x);
        END;
      END;
    END;
    LOCK loc.mu DO
      cc := loc.connList;
      loc.connList := NIL;
      loc.freeList := NIL;
      loc.nCached := 0;
    END;
    LogLocationCleanup(loc);
    WHILE cc # NIL DO
      cc.close();
      cc := cc.nextConn;
    END;
  END LocationCleanup;

PROCEDURE <A NAME="ListenerEndpoint"><procedure>ListenerEndpoint</procedure></A>(t: T) : Transport.Endpoint =
    &lt;* FATAL IP.Error *&gt;
  VAR l: ListenerClosure;
  BEGIN
    LOCK t.mu DO l := t.listener; END;
    IF l = NIL THEN l := DoListen(t, IP.NullPort); END;
    RETURN l.rep[0];
  END ListenerEndpoint;

PROCEDURE <A NAME="EnumerateLocs"><procedure>EnumerateLocs</procedure></A> (t:T; p: TransportUtils.EnumProc; cl: REFANY := NIL) =
  VAR
    waste: TEXT;
    r: REFANY;
    it: TextRefTbl.Iterator;
    loc: Location;
  BEGIN
    LOCK t.mu DO
      it := t.locationTbl.iterate();
      WHILE it.next(waste, r) DO
        loc := WeakRef.ToRef(NARROW(r, WR)^);
        IF loc # NIL THEN
          IF p(loc, cl) THEN RETURN; END;
        END;
      END;
    END;
  END EnumerateLocs;
</PRE> locations methods 

<P><PRE>PROCEDURE <A NAME="NewConnection"><procedure>NewConnection</procedure></A>(loc: Location) : StubLib.Conn
    RAISES {NetObj.Error, Thread.Alerted} =
  VAR conn: TCP.T := NIL;
  VAR cc: ConnT;
  VAR ec: AtomList.T;
  BEGIN
    LOCK loc.mu DO
      cc := loc.freeList;
      IF cc # NIL THEN
        loc.freeList := cc.nextFree;
        DEC(loc.nCached);
        IF NARROW(cc.fd, TCP.T).closed THEN Die(); END;
        RETURN cc;
      END;
    END;
    TRY
      conn := TCP.Connect(loc.ep);
    EXCEPT
    | IP.Error(ipErr) =&gt;
        IF ipErr.head = IP.NoResources THEN
          ec := AtomList.Cons(NetObj.NoResources, ipErr);
        ELSE
          ec := AtomList.Cons(NetObj.CommFailure, ipErr);
        END;
        RAISE NetObj.Error(ec);
    END;
    TRY
      HeaderOps.Send(
        conn, HeaderOps.Op.Connect,
        loc.e, ListenerEndpoint(loc.t));
    EXCEPT
    | Thread.Alerted =&gt;
        TCP.Close(conn);
        RAISE Thread.Alerted;
    | Wr.Failure(ec) =&gt;
        TCP.Close(conn);
        RAISE NetObj.Error(AtomList.Cons(NetObj.CommFailure, ec));
    END;
    RETURN NewConnT(loc, conn);
  END NewConnection;

PROCEDURE <A NAME="FreeConnection"><procedure>FreeConnection</procedure></A>(loc: Location; c: StubLib.Conn; reUse: BOOLEAN) =
  VAR cc := NARROW(c, ConnT);
  BEGIN
    LOCK loc.mu DO
      IF reUse THEN
        loc.activity := TRUE;
        IF loc.nCached &lt; MaxCachedConnections THEN
          cc.nextFree := loc.freeList;
          loc.freeList := cc;
          INC(loc.nCached);
          RETURN;
        END;
      END;
    END;
    KillConnT(cc);
  END FreeConnection;

PROCEDURE <A NAME="NewConnT"><procedure>NewConnT</procedure></A>(loc: Location; fd: TCP.T) : ConnT =
  VAR cc := NEW(ConnT, fd := fd, loc := loc,
                   rd := ConnMsgRW.NewRd(fd),
                   wr := ConnMsgRW.NewWr(fd));
  BEGIN
    LOCK loc.mu DO cc.nextConn := loc.connList; loc.connList := cc; END;
    RETURN cc;
  END NewConnT;

PROCEDURE <A NAME="CloseConnT"><procedure>CloseConnT</procedure></A>(cc: ConnT) =
  BEGIN
    TCP.Close(cc.fd);
  END CloseConnT;

PROCEDURE <A NAME="KillConnT"><procedure>KillConnT</procedure></A>(cc: ConnT) =
  VAR try, last: ConnT := NIL;
  VAR loc := NARROW(cc.loc, Location);
  BEGIN
    cc.close();
    LOCK loc.mu DO
            (* prune old dead connections from list *)
      try := loc.connList;
      WHILE try # NIL AND cc # try DO
        last := try;
        try := try.nextConn;
      END;
      IF try # NIL THEN
        IF last = NIL THEN
          loc.connList := cc.nextConn;
        ELSE
          last.nextConn := cc.nextConn;
        END;
      END;
    END;
    (* help the GC *)
    cc.loc := NIL;
  END KillConnT;

PROCEDURE <A NAME="GetInfo"><procedure>GetInfo</procedure></A> (loc: Location): TEXT =
  BEGIN
    (* could get DNS name from loc.ep here *)
    RETURN loc.e; (* never written =&gt; loc.mu not needed *)
  END GetInfo;

PROCEDURE <A NAME="GetEp"><procedure>GetEp</procedure></A> (loc: Location): Transport.Endpoint =
  BEGIN
    RETURN loc.e; (* never written =&gt; loc.mu not needed *)
  END GetEp;
</PRE> main listener loop 

<P><PRE>PROCEDURE <A NAME="Listener"><procedure>Listener</procedure></A>(l: ListenerClosure) : REFANY =
  VAR conn: TCP.T := NIL;
      cc: ConnT := NIL;
      loc: Location := NIL;
      me, him: TEXT;
      op: HeaderOps.Op;
  BEGIN
    TRY
      LOOP
        TRY
          conn := TCP.Accept(l.c);
          EXIT;
        EXCEPT
        | IP.Error(x) =&gt; IF x.head # IP.NoResources THEN EXIT; END;
        END;
        (* loop and retry if no file descriptors right now *)
        Thread.Pause(1.0D0);
      END;
      EVAL Thread.Fork(l);    (* fork another listener *)
      op := HeaderOps.Receive(conn, -1.0D0, me, him);
      IF Text.Equal(me, l.rep^[0]) OR KnownEndpoint(me) THEN
            (* this guy's talking to me *)
        loc := LocationFromEndpoint(l.t, him);
      END;
      IF op = HeaderOps.Op.Ping THEN
        IF loc # NIL THEN
          LOCK loc.mu DO loc.activity := TRUE; END;
        END;
        IF loc # NIL THEN
          HeaderOps.Send(conn, HeaderOps.Op.PingAck);
        ELSE
          HeaderOps.Send(conn, HeaderOps.Op.PingError);
        END;
      ELSIF (loc # NIL) AND (op = HeaderOps.Op.Connect) THEN
        cc := NewConnT(loc, conn);
        cc.thread := Thread.Self();
        WHILE cc.rd.nextMsg() DO
          LOCK loc.mu DO loc.activity := TRUE; END;
          IF NOT l.t.serviceCall(cc) THEN EXIT; END;
        END;
      END;
    EXCEPT
    | ConnFD.TimedOut =&gt;
    | Thread.Alerted, Rd.Failure, Wr.Failure =&gt;
    END;
    IF cc # NIL THEN
      KillConnT(cc);
    ELSIF conn # NIL THEN
      TCP.Close(conn);
    END;
    (* help GC *)
    loc := NIL;
    cc := NIL;
    RETURN NIL;
  END Listener;
</PRE> location scavenger 

<P><PRE>CONST ScavengerSleepSeconds = 6.0d1;

PROCEDURE <A NAME="Scavenger"><procedure>Scavenger</procedure></A>(sc: ScavengerClosure) : REFANY =
  BEGIN
    LOOP (* forever *)
      Thread.Pause(ScavengerSleepSeconds);
      EnumerateLocs(sc.t, ScavengeLocation, sc);
      WHILE sc.killQ # NIL DO
        KillConnT(sc.killQ);
        sc.killQ := sc.killQ.nextFree;
      END;
      WHILE sc.pingQ # NIL DO
        EVAL ProcessPing(sc.pingQ);
        sc.pingQ := sc.pingQ.next;
      END;
    END;
    &lt;*NOWARN*&gt; RETURN NIL;
  END Scavenger;

PROCEDURE <A NAME="ScavengeLocation"><procedure>ScavengeLocation</procedure></A> (l: Transport.Location; cl: REFANY) : BOOLEAN =
  VAR sc := NARROW(cl, ScavengerClosure);
      loc := NARROW(l, Location);
      try: ConnT;
  BEGIN
    LOCK loc.mu DO
      (* kill the entire free queue *)
      try := loc.freeList;
      IF try # NIL THEN
        loc.nCached := 0;
        loc.freeList := NIL;
        IF sc.killQ = NIL THEN
          sc.killQ := try;
        ELSE
          VAR kQTail := sc.killQ; BEGIN
            WHILE kQTail.nextFree # NIL DO kQTail := kQTail.nextFree; END;
            kQTail.nextFree := try;
          END;
        END;
      END;
      (* check all server threads *)
      try := loc.connList;
      WHILE try # NIL DO
        IF try.thread # NIL THEN
          IF TCPSpecial.EOF(try.fd) THEN Thread.Alert(try.thread); END;
        END;
        try := try.nextConn;
      END;

      IF NOT loc.activity THEN
        (* If there has been no completed activity since the last visit,
           then ping the other side if there are outstanding connections
           (e.g. incoming or outgoing calls).  Otherwise, only ping
           unique endpoints that we aren't listening on, that haven't been
           reported &quot;dead&quot;, and that have been visited &quot;pingCycles&quot; times
           since the last ping. *)
        IF loc.connList # NIL THEN
          sc.pingQ := NEW(PingRQ, next := sc.pingQ, loc := loc);
        ELSIF (NOT loc.reported) AND (NOT loc.knownEP) AND
              (loc.ep # sc.t.listener.ep) THEN
          DEC(loc.pingCount);
          IF loc.pingCount = 0 THEN
            sc.pingQ := NEW(PingRQ, next := sc.pingQ, loc := loc);
            IF loc.pingCycles # MaxPingCycles THEN INC(loc.pingCycles); END;
            loc.pingCount := loc.pingCycles;
          END;
        END;
      ELSE
        loc.reported := FALSE;
        loc.activity := FALSE;
        loc.pingCycles := InitPingCycles;
        loc.pingCount := InitPingCycles;
      END;
    END;
    RETURN FALSE;
  END ScavengeLocation;
</PRE> connection establishment/ping protocol 

<P><PRE>CONST
  FastPingInterval = 5.0D0;    (* max time we'll wait in main thread *)
  SlowPingInterval = 6.0D1;    (* max time we'll wait in forked thread *)
  MaxPingTries     = 3;

PROCEDURE <A NAME="ProcessPing"><procedure>ProcessPing</procedure></A>(ping: PingRQ) : REFANY =
  VAR readInterval := FastPingInterval;
      loc := ping.loc;
      dead := FALSE;
      state := NetObjNotifier.OwnerState.Failed;
      x: TEXT;
      cc: ConnT;
      doIt, retry: BOOLEAN;
  BEGIN
    REPEAT
      retry := FALSE;
      TRY
        (* check that we still haven't seen activity *)
        LOCK loc.mu DO doIt := NOT loc.activity; END;
        IF doIt THEN
          IF ping.conn = NIL THEN
            ping.start := Time.Now();
            ping.conn := TCPSpecial.StartConnect(loc.ep);
            IF NOT TCPSpecial.FinishConnect(ping.conn, FastPingInterval) THEN
              EVAL Thread.Fork(ping);
              loc := NIL;
              RETURN NIL;
            END;
          ELSE
            readInterval := SlowPingInterval;
            EVAL TCPSpecial.FinishConnect(ping.conn);
            HeaderOps.Send(
               ping.conn, HeaderOps.Op.Ping,
               loc.e, ListenerEndpoint(loc.t));
            IF HeaderOps.Receive(
               ping.conn, readInterval, x, x) = HeaderOps.Op.PingError THEN
              (* definitive answer -- wrong instance iff PingError *)
              LogPingFailure(ping, NIL, &quot;WrongInstance&quot;, TRUE);
              state := NetObjNotifier.OwnerState.Dead;
              dead := TRUE;
            END;
          END;
        END;
      EXCEPT
      | Rd.Failure(x) =&gt;
          LogPingFailure(ping, x, &quot;Rd.Failure&quot;);
      | Wr.Failure(x) =&gt;
          LogPingFailure(ping, x, &quot;Wr.Failure&quot;);
      | ConnFD.TimedOut =&gt;
          LogPingFailure(ping, NIL, &quot;ConnFD.TimedOut&quot;);
      | Thread.Alerted =&gt;
          LogPingFailure(ping, NIL, &quot;Thread.Alerted&quot;);
      | IP.Error(ec) =&gt;
          IF ec.head = TCP.Refused THEN
            (* this is dicey .. refused might mean &quot;stopped&quot; ?? *)
            state := NetObjNotifier.OwnerState.Dead;
            dead := TRUE;
          ELSIF ec.head # IP.NoResources THEN
            (* Eventually, we'll try to differentiate failure from
             death, but for now, all faiures imply transient death. *)
            INC(ping.try);
            IF ping.try &lt; MaxPingTries THEN
              retry := TRUE;
            ELSE
              dead := TRUE;
            END;
          END;
          LogPingFailure(ping, ec, &quot;IP.Error&quot;, dead);
      END;
      IF ping.conn # NIL THEN TCP.Close(ping.conn); ping.conn := NIL; END;
    UNTIL dead OR NOT retry;
    IF dead THEN
      LOCK loc.mu DO
        loc.reported := TRUE;
        loc.freeList := NIL;
        cc := loc.connList;
        loc.connList := NIL;
      END;
      WHILE cc # NIL DO
        IF cc.thread # NIL THEN
          Thread.Alert(cc.thread);
        END;
        cc.close();
        cc := cc.nextConn;
      END;
      loc.dead(state);
    END;
    ping.loc := NIL;
    loc := NIL;
    RETURN NIL;
  END ProcessPing;

PROCEDURE <A NAME="LogLocationCleanup"><procedure>LogLocationCleanup</procedure></A>(loc: Location) =
    &lt;* FATAL Thread.Alerted *&gt;
  BEGIN
    IF NOT logging THEN RETURN; END;
    TRY
      Wr.PutText(Stdio.stdout,
        Fmt.F(&quot;%s: NetObj location cleanup -- %s\n&quot;,
                 FmtTime.Short(Time.Now()), loc.e));
    EXCEPT
    | Wr.Failure =&gt;
    END;
  END LogLocationCleanup;

PROCEDURE <A NAME="LogPingFailure"><procedure>LogPingFailure</procedure></A>(ping: PingRQ; a: AtomList.T; txt: TEXT;
                         targetDead: BOOLEAN := FALSE) =
  VAR type: TEXT;
    &lt;* FATAL Thread.Alerted *&gt;
  BEGIN
    IF NOT logging THEN RETURN; END;
    IF targetDead THEN
      type := &quot;died&quot;;
    ELSE
      type := &quot;failed&quot;;
    END;
    TRY
      Wr.PutText(Stdio.stdout,
        Fmt.F(&quot;%s: NetObj location %s (%s) after %s seconds -- %s\n&quot;,
                 FmtTime.Short(Time.Now()),
                 type, IPAddrText(ping.loc.ep),
                 Fmt.Int(ROUND(Time.Now() - ping.start)),
                 txt &amp; ErrorList(a)));
    EXCEPT
    | Wr.Failure =&gt;
    END;
  END LogPingFailure;

PROCEDURE <A NAME="ErrorList"><procedure>ErrorList</procedure></A>(a: AtomList.T): TEXT =
  BEGIN
    IF a = NIL THEN RETURN &quot;&quot;; END;
    IF a.head = NIL THEN RETURN ErrorList(a.tail); END;
    RETURN &quot;(&quot; &amp; Atom.ToText(a.head) &amp; ErrorList(a.tail) &amp; &quot;)&quot;;
  END ErrorList;
</PRE> conversion to/from text representations 

<P><PRE>PROCEDURE <A NAME="TCPEndpointToAddr"><procedure>TCPEndpointToAddr</procedure></A>(
    ep: IP.Endpoint; unique: BOOLEAN) : NetObj.Address =
  VAR addr := NEW(NetObj.Address, 1);
  BEGIN
    IF unique THEN
      addr[0] := Fmt.F(&quot;%s:%s@%s.%s&quot;,
         UniqueEndpointProtocolName, IPAddrText(ep),
         Fmt.Unsigned(Process.GetMyID()),
         Fmt.Unsigned(ROUND(Time.Now())));
    ELSE
      addr[0] := KnownEndpointProtocolName &amp; &quot;:&quot; &amp; IPAddrText(ep);
    END;
    RETURN addr;
  END TCPEndpointToAddr;

PROCEDURE <A NAME="IPAddrText"><procedure>IPAddrText</procedure></A>(ep: IP.Endpoint) : TEXT =
  BEGIN
    RETURN Fmt.F(&quot;%s.%s.%s.%s.%s&quot;,
      Fmt.Int(ep.addr.a[0]), Fmt.Int(ep.addr.a[1]),
      Fmt.Int(ep.addr.a[2]), Fmt.Int(ep.addr.a[3]),
      Fmt.Int(ep.port));
  END IPAddrText;

PROCEDURE <A NAME="TCPEndpointFromText"><procedure>TCPEndpointFromText</procedure></A>(name: TEXT; VAR ipEP: IP.Endpoint): BOOLEAN =
  VAR
    buf: ARRAY [0..63] OF CHAR;
    pos, used, x: INTEGER;
    prot: TEXT;
    len := Text.Length(name);
  BEGIN
    IF len &gt;= BYTESIZE(buf) THEN RETURN FALSE; END;
    pos := Text.FindChar(name, ':');
    IF pos = -1 THEN RETURN FALSE; END;
    prot := Text.Sub(name, 0, pos);
    IF NOT (Text.Equal(prot, KnownEndpointProtocolName) OR
           Text.Equal(prot, UniqueEndpointProtocolName)) THEN
      RETURN FALSE;
    END;
    INC(pos);
    Text.SetChars (buf, name);
    FOR i := 0 TO 4 DO
      x := Convert.ToUnsigned (SUBARRAY(buf, pos, len-pos), used, 10);
      INC(pos, used);
      IF x &lt; 0 OR used = 0 THEN RETURN FALSE; END;
      IF i # 4 THEN
        IF x &gt; 255 OR buf[pos] # '.' THEN RETURN FALSE; END;
        ipEP.addr.a[i] := x;
      ELSE
        IF x &gt; LAST(IP.Port) THEN RETURN FALSE; END;
        ipEP.port := x;
      END;
      INC(pos);
    END;
    RETURN TRUE;
  END TCPEndpointFromText;

PROCEDURE <A NAME="KnownEndpoint"><procedure>KnownEndpoint</procedure></A>(me: TEXT) : BOOLEAN =
  VAR
    pos: INTEGER;
    prot: TEXT;
  BEGIN
    pos := Text.FindChar(me, ':');
    IF pos = -1 THEN RETURN FALSE; END;
    prot := Text.Sub(me, 0, pos);
    RETURN Text.Equal(prot, KnownEndpointProtocolName);
  END KnownEndpoint;

EXCEPTION FatalError;

PROCEDURE <A NAME="Die"><procedure>Die</procedure></A>() RAISES {} =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Die;

BEGIN
  logging := RTParams.IsPresent(&quot;netobjlog&quot;);
END TCPNetObj.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
