<HTML>
<HEAD>
<TITLE>SRC Modula-3: tempfiles/src/TempFiles.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tempfiles/src/TempFiles.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>
</PRE> Lectern: a user interface for viewing documents stored as images 
 Temp-file management 

<P><PRE>INTERFACE <interface><A HREF="TempFiles.m3">TempFiles</A></interface>;

IMPORT <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>;
</PRE> 
 This module keeps track of a list of temp files, and uses the Process
   cleanup mechanism to ensure that they get deleted on program exit,
   including termination by control-C.  It also will choose a temp file
   name for you, if you want. 
 

<P> 
 temp file names 
 

<P><PRE>PROCEDURE <A HREF="TempFiles.m3#DefaultPrefix">DefaultPrefix</A>(prefix: Pathname.T);
  (* Use the given prefix as default for future temp file names generated by
     calls of Get.  Before the first call of DefaultPrefix,
     a call of Get with defaulted prefix would use a default prefix
     (/tmp on U*ix systems).  The notion of &quot;prefix&quot; is as specified in the
     Pathname interface.  *)

PROCEDURE <A HREF="TempFiles.m3#Get">Get</A>(prefix: TEXT := NIL; part: TEXT := &quot;,&quot;; ext: TEXT := NIL): TEXT;
  (* Returns an almost-certainly-unique file name, using prefix provided,
     (or by default the prefix as specified by the Init procedure), and
     a suffix composed of &quot;part&quot; concatenated
     with a manufactured string, and the given extension.  The notions
     of &quot;prefix&quot; and &quot;extension&quot; are as specified for the Pathname.Join
     procedure.  Does not call Note - that's up to you to do.
     For example, on U*x with the default prefix, Get(&quot;,x-&quot;, &quot;y&quot;)
     returns a string of the form &quot;/tmp/,x-*.y&quot; *)
</PRE> 
 Temp file list 
 

<P><PRE>PROCEDURE <A HREF="TempFiles.m3#Note">Note</A>(t: TEXT);
  (* Adds &quot;t&quot; to the list of files to be deleted on program exit.  There
     is no attempt to detect duplicates.  It's probably best to call this
     after creating the file, to avoid spurious warnings about failure to
     delete it (but at the risk of not deleting it, of course). *)

PROCEDURE <A HREF="TempFiles.m3#Forget">Forget</A>(t: TEXT);
  (* Removes &quot;t&quot; from the list of files to be delete on program exit.  Fails
     silently if &quot;t&quot; isn't on the list.  It's probably best to call this
     before deleting or renaming the file, to avoid spurious warnings about
     failure to delete it (but at the risk of not deleting it, of course). *)

END TempFiles.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
