<HTML>
<HEAD>
<TITLE>SRC Modula-3: tempfiles/src/TempFiles.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>tempfiles/src/TempFiles.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                            </EM></BLOCKQUOTE><PRE>

MODULE <module>TempFiles</module> EXPORTS <A HREF="TempFiles.i3"><implements>TempFiles</A></implements>;

IMPORT <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../os/src/Common/FS.i3">FS</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../os/src/Common/Process.i3">Process</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>,
       <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../libm3/derived/TextList.i3">TextList</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../time/src/Common/Time.i3">Time</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

VAR mu := NEW(Thread.Mutex);
</PRE> 
 temp file names 
 

<P><PRE>VAR tempFilePrefix: Pathname.T := NIL;
  (* Prefix (i.e. directory) for temp file names *)

PROCEDURE <A NAME="DefaultPrefix"><procedure>DefaultPrefix</procedure></A>(prefix: Pathname.T) =
  BEGIN
    LOCK mu DO tempFilePrefix := prefix END;
  END DefaultPrefix;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(prefix: TEXT := NIL; part: TEXT := &quot;&quot;; ext: TEXT := NIL): TEXT =
  BEGIN
    LOCK mu DO
      IF prefix = NIL THEN
        IF tempFilePrefix = NIL THEN
          tempFilePrefix := Pathname.Prefix(&quot;/tmp/foo&quot;);
        END;
        prefix := tempFilePrefix;
      END;
      RETURN Pathname.Join(prefix,
                           Text.Cat(part, Fmt.LongReal(Time.Now())),
                           ext);
    END;
  END Get;
</PRE> 
 Temp file list 
 

<P><PRE>VAR tempFileList: TextList.T := NIL;
  (* List of files to be deleted at process exit *)

PROCEDURE <A NAME="InitTempFiles"><procedure>InitTempFiles</procedure></A>() =
  (* Ensure that we will clean up temp files on process exit *)
  BEGIN
    Process.RegisterExitor(Cleanup);
  END InitTempFiles;

PROCEDURE <A NAME="Note"><procedure>Note</procedure></A>(t: TEXT) =
  (* Add &quot;t&quot; to the list of files to be deleted at process exit *)
  BEGIN
    LOCK mu DO
      tempFileList := NEW(TextList.T, head := t, tail := tempFileList);
    END;
  END Note;

PROCEDURE <A NAME="Forget"><procedure>Forget</procedure></A>(t: TEXT) =
  (* Remove &quot;t&quot; from the list of files to be deleted at process exit *)
  VAR
    this, prev: TextList.T := NIL;
  BEGIN
    LOCK mu DO
      this := tempFileList;
      WHILE this # NIL AND NOT Text.Equal(this.head, t) DO
         prev := this; this := this.tail;
     END;
      IF this # NIL THEN
        IF prev = NIL THEN
          tempFileList := this.tail
        ELSE
          prev.tail := this.tail;
        END;
      END;
    END;
  END Forget;

PROCEDURE <A NAME="Cleanup"><procedure>Cleanup</procedure></A>() =
  (* Called at process exit, from within &quot;Process&quot; module.  Deletes files
     recorded by &quot;NoteTempFile&quot;. *)
  (* DON'T lock &quot;mu&quot; - it might be held!  Rely on atomic REF assignments. *)
  BEGIN
    WHILE tempFileList # NIL DO
      VAR t: TEXT := tempFileList.head;
      BEGIN
        TRY
          tempFileList := tempFileList.tail;
          FS.DeleteFile(t);
        EXCEPT OSError.E =&gt;
          TRY
            Wr.PutText(Stdio.stderr,
                       &quot;Warning: failed to delete \&quot;&quot; &amp; t &amp; &quot;\&quot;\n&quot;);
          EXCEPT Wr.Failure, Thread.Alerted =&gt;
          END;
        END;
      END;
    END;
  END Cleanup;

BEGIN
  InitTempFiles();
END TempFiles.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
