<HTML>
<HEAD>
<TITLE>SRC Modula-3: text/src/TextConv.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>text/src/TextConv.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="TextConv.m3">TextConv</A></interface>;
</PRE> A collection of text routines for the handling of escape sequences
   and separators. 

<P><PRE>TYPE CharSet = SET OF CHAR;

CONST
  Escape = '\\';
  NonPrinting = CharSet{'\000'..'\037', '\177'};
  Quotes = CharSet{'\'', '\&quot;'};
</PRE> Given the constants above, we have the following mapping for
   special characters that may appear in a text:
<P>
  encoded   decoded
    \\        \
    \'        '
    \<CODE>        </CODE>
    \n        LF
    \r        CR
    \t        HT
    \f        FF
    \0xx      0xx        where 0xx is an octal 000..077.
    \1xx      1xx        where 1xx is an octal 100..177.
    \x        x          where x is any other character.


<P> Summary.
<P>
  The Encode routine converts text with special characters into text 
  with excape sequences that encode those special characters. 
  The Decode routine act as a semi-inverse.
<P>
  The Explode routine segments texts in base of the occurrence of 
  delimiter characters (such as blanks). The Implode routine acts
  as a semi-inverse).
<P>


<P><PRE>EXCEPTION Fail;
</PRE> ==== ENCODING ==== 

<P><PRE>PROCEDURE <A HREF="TextConv.m3#Encode">Encode</A>(textIn: TEXT; quoted: BOOLEAN:=TRUE): TEXT;
</PRE><BLOCKQUOTE><EM> Return a text that is the encoding of textIn. If quoted is TRUE,
   a double quote is added at the beginning an one at the end. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextConv.m3#EncodedCharSize">EncodedCharSize</A>(charIn: CHAR): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the size of the encoding of charIn; either 1, 2, or 4. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextConv.m3#EncodeChar">EncodeChar</A>(
    charIn: CHAR;
    VAR (*out*)charsOut: ARRAY[0..3] OF CHAR)
    : INTEGER;
</PRE><BLOCKQUOTE><EM> Write the encoding of charIn to charsOut; the result is the number of 
   significant elements of charsOut, either 1, 2, or 4.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextConv.m3#EncodedCharsSize">EncodedCharsSize</A>(
    READONLY charsIn: ARRAY OF CHAR): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the sum of the sizes of the encodings of all the characters
   in charIn. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextConv.m3#EncodeChars">EncodeChars</A>(
    READONLY charsIn: ARRAY OF CHAR;
    VAR (*out*)charsOut: ARRAY OF CHAR)
    : INTEGER;
</PRE><BLOCKQUOTE><EM> Write the encoding of charsIn to charsOut; charsOut must be at least of
   EncodedCharsSize(charsIn) size, which is also given as result. </EM></BLOCKQUOTE><PRE>
</PRE> ==== DECODING ==== 

<P><PRE>PROCEDURE <A HREF="TextConv.m3#Decode">Decode</A>(textIn: TEXT; quoted: BOOLEAN:=TRUE): TEXT RAISES {Fail};
</PRE><BLOCKQUOTE><EM> Return a text that is the decoding of textIn. If quoted is TRUE, it
   strips the first and last character of textIn before decoding the rest.
   Fails if the escape sequences in textIn are ill-formed (e.g. if the last 
   char of textIn is \ ), or, when quoted is TRUE, if Length(textIn)&lt;2 or 
   if the first and last characters are not double quotes. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextConv.m3#DecodeChar">DecodeChar</A>(
    READONLY charsIn: ARRAY[0..3] OF CHAR; availIn: INTEGER;
    VAR (*out*)charOut: CHAR)
    : INTEGER RAISES {Fail};
</PRE><BLOCKQUOTE><EM> Decode the sequence charsIn (of which availIn are provided) as a character,
   and write it to charOut. Fail if not enough characters are available in 
   charsIn for the decoding of a single character, or if octal encodings are
   ill-formed. Return the number of characters of charsIn actually used. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextConv.m3#DecodedCharsSize">DecodedCharsSize</A>(
    READONLY charsIn: ARRAY OF CHAR)
    : INTEGER RAISES {Fail};
</PRE><BLOCKQUOTE><EM> Apply DecodeChar repeatedly to charsIn until exhausted, and return the number
   of calls to DecodeChar. Fail if any of the DecodeChar calls fail. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextConv.m3#DecodeChars">DecodeChars</A>(
    READONLY charsIn: ARRAY OF CHAR;
    VAR (*out*)charsOut: ARRAY OF CHAR)
    : INTEGER RAISES {Fail};
</PRE><BLOCKQUOTE><EM> Apply DecodeChar repeatedly to charsIn until exhausted, and place the results
   in charsOut; charsOut must be at least of DecodedCharsSize(charsIn) size, 
   which is also given as result. Fail if any of the calls to DecodeChar fail. </EM></BLOCKQUOTE><PRE>
</PRE> ==== EXPLODING ==== 

<P><PRE>PROCEDURE <A HREF="TextConv.m3#Explode">Explode</A>(text: TEXT; VAR(*out*) array: ARRAY OF TEXT;
    READONLY sep: SET OF CHAR);
</PRE><BLOCKQUOTE><EM> Split an input text into a similarly ordered array of texts, each a 
   maximal subsequence of the input not containing sep chars. The empty
   text is exploded as a singleton array of the empty text.
   Each sep char in the input produces a break, so the size of the result 
   is 1 + the number of sep chars in the text.
   Implode(Explode(text,{ch}),ch) is the identity.
</EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="TextConv.m3#ExplodedSize">ExplodedSize</A>(text: TEXT; READONLY sep: SET OF CHAR): INTEGER;
</PRE><BLOCKQUOTE><EM> Return the length of the array needed by Explode on the same input;
   always &gt; 0. </EM></BLOCKQUOTE><PRE>
</PRE> ==== IMPLODING ==== 

<P><PRE>PROCEDURE <A HREF="TextConv.m3#Implode">Implode</A>(READONLY array: ARRAY OF TEXT; sep: CHAR): TEXT;
</PRE><BLOCKQUOTE><EM> Concatenate an array of texts into a single text, separating the pieces 
   by a single sep char.  A zero-length array is imploded as an empty text.
   Explode(Implode(array,ch),{ch}) is the identity provided that
   array has positive size and sep does not occur in array. </EM></BLOCKQUOTE><PRE>

END TextConv.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
