<HTML>
<HEAD>
<TITLE>SRC Modula-3: thread/src/Common/Thread.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>thread/src/Common/Thread.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">Thread</A></interface>;

TYPE
  <A HREF="#x2">T</A> &lt;: ROOT;
  Mutex = MUTEX;
  <A HREF="#x3">Condition</A> &lt;: ROOT;
</PRE> A <CODE>Thread.T</CODE> is a handle on a thread.  A <CODE>Mutex</CODE> is locked by some
   thread, or unlocked.  A <CODE>Condition</CODE> is a set of waiting threads.  A
   newly-allocated <CODE>Mutex</CODE> is unlocked; a newly-allocated <CODE>Condition</CODE>
   is empty.  It is a checked runtime error to pass the <CODE>NIL</CODE> <CODE>Mutex</CODE>,
   <CODE>Condition</CODE>, or <CODE>T</CODE> to any procedure in this interface. 

<P><PRE>TYPE Closure = OBJECT METHODS apply(): REFANY END;

PROCEDURE <A HREF="#x4">Fork</A>(cl: Closure): T;
</PRE><BLOCKQUOTE><EM> Return a handle on a newly-created thread executing <CODE>cl.apply()</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x5">Join</A>(t: T): REFANY;
</PRE><BLOCKQUOTE><EM> Wait until <CODE>t</CODE> has terminated and return its result. It is a
   checked runtime error to call this more than once for any <CODE>t</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x6">Wait</A>(m: Mutex; c: Condition);
</PRE><BLOCKQUOTE><EM> The calling thread must have <CODE>m</CODE> locked. Atomically unlocks <CODE>m</CODE> and
   waits on <CODE>c</CODE>.  Then relocks <CODE>m</CODE> and returns. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x7">Acquire</A>(m: Mutex);
</PRE><BLOCKQUOTE><EM> Wait until <CODE>m</CODE> is unlocked and then lock it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x8">Release</A>(m: Mutex);
</PRE><BLOCKQUOTE><EM> The calling thread must have <CODE>m</CODE> locked.  Unlocks <CODE>m</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x9">Broadcast</A>(c: Condition);
</PRE><BLOCKQUOTE><EM> All threads waiting on <CODE>c</CODE> become eligible to run. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x10">Signal</A>(c: Condition);
</PRE><BLOCKQUOTE><EM> One or more threads waiting on <CODE>c</CODE> become eligible to run. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x11">Pause</A>(n: LONGREAL);
</PRE><BLOCKQUOTE><EM> Wait for <CODE>n</CODE> seconds to elapse. </EM></BLOCKQUOTE><PRE>
</PRE> To wait until a specified point in time in the future, say <CODE>t</CODE>,
   you can use the call
<P>
<PRE>
      Pause(t - Time.Now())


<P><PRE>PROCEDURE <A HREF="#x12">Self</A>(): T;
</PRE><BLOCKQUOTE><EM> Return the handle of the calling thread. </EM></BLOCKQUOTE><PRE>

EXCEPTION Alerted;
</PRE><BLOCKQUOTE><EM> Used to approximate asynchronous interrupts. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x13">Alert</A>(t: T);
</PRE><BLOCKQUOTE><EM> Mark <CODE>t</CODE> as an alerted thread. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x14">TestAlert</A>(): BOOLEAN;
</PRE><BLOCKQUOTE><EM> If the calling thread has been marked alerted, return <CODE>TRUE</CODE> and
   unmark it. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x15">AlertWait</A>(m: Mutex; c: Condition) RAISES {Alerted};
</PRE><BLOCKQUOTE><EM> Like <CODE>Wait</CODE>, but if the thread is marked alerted at the time of
   call or sometime during the wait, lock <CODE>m</CODE> and raise <CODE>Alerted</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x16">AlertJoin</A>(t: T): REFANY RAISES {Alerted};
</PRE><BLOCKQUOTE><EM> Like <CODE>Join</CODE>, but if the thread is marked alerted at the time of
   call or sometime during the wait, raise <CODE>Alerted</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x17">AlertPause</A>(n: LONGREAL) RAISES {Alerted};
</PRE><BLOCKQUOTE><EM> Like <CODE>Pause</CODE>, but if the thread is marked alerted at the time of
   the call or sometime during the wait, raise <CODE>Alerted</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \paragraph*{Specifying thread stack size.} Normally <CODE>Fork</CODE> uses a
   default value for the size of the stack of the new thread.  It is
   possible to change the default value, and also to specify the value
   used for a particular call to <CODE>Fork</CODE> by supplying a <CODE>SizedClosure</CODE>
   rather than a <CODE>Closure</CODE>.  Stack sizes are given as a number of
   <CODE>Word.T</CODE>s.


<P><PRE>PROCEDURE <A HREF="#x18">GetDefaultStackSize</A>(): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return the current default stack size for new threads. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x19">MinDefaultStackSize</A>(min: CARDINAL);
</PRE><BLOCKQUOTE><EM> Change the default stack size for newly forked threads to the
   greater of <CODE>min</CODE> and the current default stack size. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x20">IncDefaultStackSize</A>(inc: CARDINAL);
</PRE><BLOCKQUOTE><EM> Increment the default stack size for newly forked threads by <CODE>inc</CODE>.
   </EM></BLOCKQUOTE><PRE>

TYPE
  SizedClosure = Closure OBJECT stackSize: CARDINAL := 0 END;

END Thread.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Thread's implementation  is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#0TOP0">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#0TOP0">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#0TOP0">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">opaque type Thread.T is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#T">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#T">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#T">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">opaque type Thread.Condition is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Condition">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Condition">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Condition">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Thread.Fork is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Fork">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Fork">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Fork">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure Thread.Join is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Join">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Join">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Join">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure Thread.Wait is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Wait">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Wait">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Wait">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure Thread.Acquire is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Acquire">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Acquire">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Acquire">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure Thread.Release is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Release">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Release">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Release">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x9">procedure Thread.Broadcast is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Broadcast">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Broadcast">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Broadcast">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x10">procedure Thread.Signal is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Signal">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Signal">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Signal">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x11">procedure Thread.Pause is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Pause">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Pause">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Pause">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x12">procedure Thread.Self is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Self">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Self">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Self">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x13">procedure Thread.Alert is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#Alert">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#Alert">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#Alert">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x14">procedure Thread.TestAlert is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#TestAlert">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#TestAlert">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#TestAlert">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x15">procedure Thread.AlertWait is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#AlertWait">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#AlertWait">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#AlertWait">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x16">procedure Thread.AlertJoin is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#AlertJoin">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#AlertJoin">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#AlertJoin">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x17">procedure Thread.AlertPause is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#AlertPause">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#AlertPause">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#AlertPause">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x18">procedure Thread.GetDefaultStackSize is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#GetDefaultStackSize">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#GetDefaultStackSize">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#GetDefaultStackSize">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x19">procedure Thread.MinDefaultStackSize is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#MinDefaultStackSize">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#MinDefaultStackSize">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#MinDefaultStackSize">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x20">procedure Thread.IncDefaultStackSize is in:
</A><UL>
<LI><A HREF="../NOOP/Thread.m3#IncDefaultStackSize">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#IncDefaultStackSize">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#IncDefaultStackSize">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
