<HTML>
<HEAD>
<TITLE>SRC Modula-3: thread/src/NOOP/ThreadF.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>thread/src/NOOP/ThreadF.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">ThreadF</A></interface>;

IMPORT <A HREF="#x2">FloatMode</A>, <A HREF="../Common/Thread.i3">Thread</A>;
</PRE>------------------------------------------------------ compiler support ---

<P><PRE>&lt;*EXTERNAL &quot;_M3__bottom_of_stack&quot;*&gt; VAR bottom_of_stack: ADDRESS;
&lt;*EXTERNAL &quot;_M3__stack_grows_down&quot;*&gt;VAR stack_grows_down: INTEGER;
&lt;*EXTERNAL &quot;_M3__handlers&quot;*&gt;        VAR currentHandlers: ADDRESS;
&lt;*EXTERNAL &quot;_M3__stackLimit&quot;*&gt;      VAR currentStackLimit: ADDRESS;
</PRE> these variables are read and written directly by compiler generated code.
   Changing their names, types or values is very dangerous. 

<P>--------------------------------------------- exception handling support --

<P><PRE>PROCEDURE <A HREF="#x3">GetCurrentHandlers</A>(): ADDRESS;
</PRE><BLOCKQUOTE><EM> == RETURN currentHandlers </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x4">SetCurrentHandlers</A>(h: ADDRESS);
</PRE><BLOCKQUOTE><EM> == currentHandlers := h </EM></BLOCKQUOTE><PRE>
</PRE>--------------------------------------------- garbage collector support ---

<P><PRE>PROCEDURE <A HREF="#x5">ProcessStacks</A> (p: PROCEDURE (start, stop: ADDRESS));
</PRE><BLOCKQUOTE><EM> This procedure apply p to each stack, with start and stop being the limits
   of the stack. It is there mainly for the benefit of the garbage collector.
   </EM></BLOCKQUOTE><PRE>
</PRE>------------------------------------------------ floating point support ---

<P><PRE>PROCEDURE <A HREF="#x6">MyFPState</A> (): UNTRACED REF FloatMode.ThreadState;
</PRE><BLOCKQUOTE><EM> returns the saved floating point state for the current thread.
   WARNING: the return value is an untraced pointer to a traced Thread.T!!  </EM></BLOCKQUOTE><PRE>
</PRE>-------------------------------------------------- showthreads support ---

<P><PRE>TYPE
  State = {
        alive    (* can run *),
        waiting  (* waiting for a condition via Wait *),
        locking  (* waiting for a mutex to be unlocked *),
        pausing  (* waiting until some time is arrived *),
        blocking (* waiting for some IO *),
        dying    (* done, but not yet joined *),
        dead     (* done and joined *)
	};

TYPE
  Id = INTEGER;
</PRE>--------------------------------------------------------- hooks support ---

<P> PRIVATE VAR hooks: Hooks := NIL 

<P><PRE>TYPE
  Hooks = OBJECT METHODS
    fork (t: Thread.T);  (* called with RT0u.inCritical &gt; 0 *)
    die  (t: Thread.T);  (* called with RT0u.inCritical &gt; 0 *)
  END;

PROCEDURE <A HREF="#x7">RegisterHooks</A> (h: Hooks; init := TRUE): Hooks RAISES {};
</PRE><BLOCKQUOTE><EM> return current hooks and set hooks := h.   If init is true, 
   call hooks.fork (t) for every thread t in the ring in a single
   critical section. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x8">MyId</A>(): Id RAISES {};
</PRE><BLOCKQUOTE><EM> return Id of caller </EM></BLOCKQUOTE><PRE>

END ThreadF.
</PRE>
</inInterface>
<HR>
<A NAME="x1">ThreadF's implementation  is in:
</A><UL>
<LI><A HREF="Thread.m3#0TOP0">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#0TOP0">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#0TOP0">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure ThreadF.GetCurrentHandlers is in:
</A><UL>
<LI><A HREF="Thread.m3#GetCurrentHandlers">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#GetCurrentHandlers">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#GetCurrentHandlers">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure ThreadF.SetCurrentHandlers is in:
</A><UL>
<LI><A HREF="Thread.m3#SetCurrentHandlers">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#SetCurrentHandlers">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#SetCurrentHandlers">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure ThreadF.ProcessStacks is in:
</A><UL>
<LI><A HREF="Thread.m3#ProcessStacks">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#ProcessStacks">thread/src/POSIX/ThreadPosix.m3</A>
<LI><A HREF="../WIN32/ThreadWin32.m3#ProcessStacks">thread/src/WIN32/ThreadWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure ThreadF.MyFPState is in:
</A><UL>
<LI><A HREF="Thread.m3#MyFPState">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#MyFPState">thread/src/POSIX/ThreadPosix.m3</A>
</UL>
<P>
<HR>
<A NAME="x7">procedure ThreadF.RegisterHooks is in:
</A><UL>
<LI><A HREF="Thread.m3#RegisterHooks">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#RegisterHooks">thread/src/POSIX/ThreadPosix.m3</A>
</UL>
<P>
<HR>
<A NAME="x8">procedure ThreadF.MyId is in:
</A><UL>
<LI><A HREF="Thread.m3#MyId">thread/src/NOOP/Thread.m3</A>
<LI><A HREF="../POSIX/ThreadPosix.m3#MyId">thread/src/POSIX/ThreadPosix.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
