<HTML>
<HEAD>
<TITLE>SRC Modula-3: thread/src/POSIX/SchedulerPosix.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>thread/src/POSIX/SchedulerPosix.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="ThreadPosix.m3">SchedulerPosix</A></interface>;

IMPORT <A HREF="../Common/Thread.i3">Thread</A>;

TYPE
  WaitResult = {Ready, Error, FDError, Timeout};

PROCEDURE <A HREF="ThreadPosix.m3#IOWait">IOWait</A>(fd: INTEGER; read: BOOLEAN;
                  timeoutInterval: LONGREAL := -1.0D0): WaitResult;

PROCEDURE <A HREF="ThreadPosix.m3#IOAlertWait">IOAlertWait</A>(fd: INTEGER; read: BOOLEAN;
                  timeoutInterval: LONGREAL := -1.0D0): WaitResult
                  RAISES {Thread.Alerted};
</PRE> These procedures are functionally equivalent to calling <CODE>select(2)</CODE>
   with a single file descriptor.  The major difference is that calls
   on <CODE>IOWait</CODE> and <CODE>IOAlertWait</CODE> do not prevent other threads from
   running.  If <CODE>read</CODE> is <CODE>TRUE</CODE>, then the <CODE>readfds</CODE> and <CODE>exceptfds</CODE>
   arguments to <CODE>select</CODE> are the singleton set containing <CODE>fd</CODE>, and
   <CODE>writefds</CODE> is the empty set.  Otherwise, the <CODE>writefds</CODE> and
   <CODE>exceptfds</CODE> are non-empty, and <CODE>readfds</CODE> is empty.
<P>
   The return value from <CODE>IOWait</CODE> and <CODE>IOAlertWait</CODE> indicates that
   <CODE>fd</CODE> was found to be ready for I/O, or that the caller's timeout
   interval expired, or that an error occured:
<P>
     -- <CODE>Ready</CODE> indicates that <CODE>fd</CODE> was found to be ready for I/O
        (according to the value of the <CODE>read</CODE> argument).  In other
        words, a subsequent I/O operation might succeed.  If <CODE>fd</CODE> is
        persistently in such a state, then <CODE>IOWait</CODE> and <CODE>IOAlertWait</CODE>
        will return <CODE>Ready</CODE>.
<P>
     -- <CODE>Error</CODE> indicates that a <CODE>select</CODE> call executed on behalf
        of the caller failed, for instance the supplied <CODE>fd</CODE> is not
        valid.
<P>
     -- <CODE>FDError</CODE> indicates that <CODE>fd</CODE> is valid, but it exhibits an
        exceptional condition.
<P>
     -- <CODE>Timeout</CODE> indicates that the caller's timeout expired.  The
        file descriptor will have been tested at least once before
        this result is returned.
<P>
   <CODE>IOWait</CODE> and <CODE>IOAlertWait</CODE> block until the argument <CODE>fd</CODE> is in a
   reportable state, or until <CODE>timeoutInterval</CODE> seconds have passed.
   If <CODE>timeoutInterval</CODE> is negative, an indefinite wait is indicated,
<P>
   As usual, <CODE>IOAlertWait</CODE> is the alertable version, <CODE>IOWait</CODE> is the
   non-alertable version.   
<P>
   A <CODE>Ready</CODE> result from <CODE>IOWait</CODE> and <CODE>IOAlertWait</CODE> does not guarantee
   that I/O is currently possible on <CODE>fd</CODE>.  For example, any other
   thread may preempt during the return sequence and issue a read on
   <CODE>fd</CODE>.
<P>
   A standard technique for using these procedures is as follows.
   First make reads non-blocking on the file descriptor <CODE>fd</CODE>, and then
   use a loop of the form:
<P>
      LOOP
	status := read (fd, buf, n);
        IF status = -1 AND errno # EWOULDBLOCK THEN
	  (* error to be handled 
        <PRE>ELSIF status = 0 THEN
          (* eof reached *)
        ELSIF status &gt; 0 THEN
          (* status chars available in buf *)
        END;

        EVAL SchedulerPosix.IOWait(fd, TRUE);
      END;
*)

PROCEDURE <A HREF="ThreadPosix.m3#DisableSwitching">DisableSwitching</A> ();
PROCEDURE <A HREF="ThreadPosix.m3#EnableSwitching">EnableSwitching</A> ();
</PRE><BLOCKQUOTE><EM> Increment/decrement the counter that controls whether thread
   switches may occur.  The counter is initialized to zero.  If
   the counter is greater than zero, switching is disabled.  It's
   a checked runtime error to use any thread primitives (e.g. LOCK,
   Wait, Signal, Yield, ...) that would result in thread switches
   while switching is disabled. </EM></BLOCKQUOTE><PRE>

END SchedulerPosix.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
