<HTML>
<HEAD>
<TITLE>SRC Modula-3: thread/src/POSIX/ThreadPosix.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>thread/src/POSIX/ThreadPosix.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM><PRE>
                                                               
</EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>ThreadPosix</module> EXPORTS <A HREF="../Common/Thread.i3"><implements>Thread</A></implements>, <A HREF="#x1"><implements>ThreadF</A></implements>, <A HREF="../Common/Scheduler.i3"><implements>Scheduler</A></implements>, <A HREF="SchedulerPosix.i3"><implements>SchedulerPosix</A></implements>,
    <A HREF="../../../runtime/src/common/RTThreadInit.i3"><implements>RTThreadInit</A></implements>, <A HREF="../../../runtime/src/common/RTHooks.i3"><implements>RTHooks</A></implements>;

IMPORT <A HREF="../../../C/src/Common/Cerrno.i3">Cerrno</A>, <A HREF="#x2">Cstring</A>, <A HREF="#x3">FloatMode</A>,
       <A HREF="#x4">RT0u</A>, <A HREF="../../../runtime/src/common/RTMisc.i3">RTMisc</A>, <A HREF="../../../runtime/src/common/RTParams.i3">RTParams</A>, <A HREF="#x5">RTPerfTool</A>, <A HREF="../../../runtime/src/common/RTProcedureSRC.i3">RTProcedureSRC</A>, <A HREF="../../../runtime/src/common/RTProcess.i3">RTProcess</A>,
       <A HREF="../../../runtime/src/POSIX/RTThread.i3">RTThread</A>, <A HREF="../../../runtime/src/common/RTIO.i3">RTIO</A>, <A HREF="ThreadEvent.i3">ThreadEvent</A>, <A HREF="../../../time/src/Common/Time.i3">Time</A>, <A HREF="../../../time/src/POSIX/TimePosix.i3">TimePosix</A>,
       <A HREF="#x6">Unix</A>, <A HREF="#x7">Usignal</A>, <A HREF="#x8">Utime</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

REVEAL
  (* Remember, the report (p 43-44) says that MUTEX is predeclared and &lt;: ROOT;
     just pretend that we have &quot;TYPE MUTEX &lt;: ROOT&quot; in our interface.
     The sem field is where we store the semaphore that implements the mutual
     exclusion and waitingForMe is the head of the list of threads that are
     waiting for the mutex to be released so that they can acquire it (the list
     is continued in the nextWaitingForMutex field of the threads) *)

  <A NAME="MUTEX">MUTEX</A> = BRANDED &quot;Mutex Posix-1.0&quot; OBJECT
    holder       : T := NIL;
    waitingForMe : T := NIL;
  END;

  (* Threads that wait on a condition are inserted in the waitingForMe list,
     which is continued in the nextWaitingForCondition field of the waiting
     threads. *)

  <A NAME="Condition">Condition</A> = BRANDED &quot;Thread.Condition Posix-1.0&quot; OBJECT
                waitingForMe: T := NIL; END;

TYPE SelectRec = RECORD
        fd: CARDINAL := 0;
        read: BOOLEAN := FALSE;
        waitResult: WaitResult := WaitResult.Ready;
        (* fields relevant for new and old implementation *)
        timeout := UTime{0, 0};
        hasTimeout: BOOLEAN := FALSE;
        errno: INTEGER := 0;
        index: CARDINAL := 0;
        set: FDSet := FDSet{};
      END;
</PRE> The debugger, m3gdb, depends on these pieces of the thread implementation:
<P>
<PRE>
           &quot;Thread.T&quot; is a record or object type with fields:
              &quot;id&quot;                  an integer,
              &quot;state&quot;               an enumeration (with fixed known values),
              &quot;next&quot;                a pointer to a &quot;Thread.T&quot;
              &quot;waitingForCondition&quot; a pointer
              &quot;waitingForMutex&quot;     a pointer
              &quot;waitingForTime&quot;      a &quot;time&quot;
              &quot;context&quot;             a record with a field named &quot;buf&quot; which is
                                       a jump buffer.
</PRE>
   Eric Muller, 3/16/94

<PRE>REVEAL
  <A NAME="T">T</A> = BRANDED &quot;Thread.T Posix-1.6&quot; OBJECT
        state: State;
	id: Id;

        (* our work and its result *)
        closure : Closure;
        result : REFANY := NIL;

        (* the threads are organized in a circular list *)
        previous, next: T;

        (* next thread that waits for:
             CASE state OF
             | waiting  =&gt; the same condition;
             | locking  =&gt; the same mutex;
             | pausing  =&gt; a specified time;
             | blocking =&gt; some IO; *)
        nextWaiting: T;

        (* if state = waiting, the condition on which we wait *)
        waitingForCondition: Condition;
        waitingForMutex:     Mutex;

	(* if state = pausing, the time at which we can restart *)
        waitingForTime : UTime;

        (* true if we are waiting during an AlertWait or AlertJoin
	   or AlertPause *)
        alertable: BOOLEAN := FALSE;

        (* true if somebody alerted us and we did not TestAlert *)
        alertPending : BOOLEAN := FALSE;

        (* This condition is signaled then the thread terminates;
           other threads that want to join can just wait for it *)
        endCondition: Condition;

        (* where we carry our work. The first thread runs on the
           original C program stack and its context.stack is NIL *)
        context : Context;

	(* if state = blocking, the descriptors we are waiting on *)
        select : SelectRec := SelectRec{};

        (* state that is available to the floating point routines *)
        floatState : FloatMode.ThreadState;
      END;

TYPE
  IntPtr = UNTRACED REF INTEGER;
</PRE>------------------------------------------------------- Unix time hack! ---

<P><PRE>TYPE
  UTime = Utime.struct_timeval;
  TimeZone = Utime.struct_timezone;

PROCEDURE <A NAME="UTimeNow"><procedure>UTimeNow</procedure></A> (): UTime =
  VAR tv: UTime;  tz: TimeZone;
  BEGIN
    EVAL Utime.gettimeofday (tv, tz);
    RETURN tv;
  END UTimeNow;

PROCEDURE <A NAME="Time_Add"><procedure>Time_Add</procedure></A> (READONLY t1, t2: UTime): UTime =
  VAR res: UTime;
  BEGIN
    res.tv_sec  := t1.tv_sec + t2.tv_sec;
    res.tv_usec := t1.tv_usec + t2.tv_usec;
    IF res.tv_usec &gt; 1000000 THEN
      DEC (res.tv_usec, 1000000);
      INC (res.tv_sec, 1);
    END;
    RETURN res;
  END Time_Add;

PROCEDURE <A NAME="Time_Subtract"><procedure>Time_Subtract</procedure></A> (READONLY t1, t2: UTime): UTime =
  VAR res: UTime;
  BEGIN
    res.tv_sec := t1.tv_sec - t2.tv_sec;
    res.tv_usec := t1.tv_usec - t2.tv_usec;
    IF res.tv_usec &lt; 0 THEN
      INC (res.tv_usec, 1000000);
      DEC (res.tv_sec, 1);
    END;
    RETURN res;
  END Time_Subtract;

PROCEDURE <A NAME="Time_Compare"><procedure>Time_Compare</procedure></A> (READONLY t1, t2: UTime): [-1 .. 1] =
  BEGIN
    IF    t1.tv_sec &gt; t2.tv_sec   THEN RETURN 1;
    ELSIF t1.tv_sec &lt; t2.tv_sec   THEN RETURN -1;
    ELSIF t1.tv_usec = t2.tv_usec THEN RETURN 0;
    ELSIF t1.tv_usec &gt; t2.tv_usec THEN RETURN 1;
    ELSE                               RETURN -1;
    END;
  END Time_Compare;
</PRE>--------------------------------------------------------------- globals ---

<P><PRE>VAR
  preemption: BOOLEAN;

  (* this is really a constant, but we need to take its address *)
  ZeroTimeout := UTime{0, 0};

VAR
  (* we start the heavy machinery only when we have more than one thread *)
  multipleThreads: BOOLEAN := FALSE;

  topThread: T;       (* the thread in which Main runs *)
  pausedThreads : T;
  selected_interval:= UTime{0, 100 * 1000};

  defaultStackSize := 3000;

  stack_grows_down: BOOLEAN;

VAR
  stats: RECORD
           n_forks := 0;
           n_dead  := 0;
           n_joins := 0;
         END;

EXCEPTION InternalError;
&lt;*FATAL InternalError*&gt;

CONST ForkYieldRatio = 5;

VAR
  nextId: Id := 1;

VAR
  dead_stacks: T := NIL;
  (* dead threads waiting to have their stacks disposed *)
</PRE>------------------------------------------------- user-level procedures ---

<P><PRE>PROCEDURE <A NAME="GetDefaultStackSize"><procedure>GetDefaultStackSize</procedure></A> (): CARDINAL =
  BEGIN
    RETURN defaultStackSize;
  END GetDefaultStackSize;

PROCEDURE <A NAME="MinDefaultStackSize"><procedure>MinDefaultStackSize</procedure></A> (new_min: CARDINAL) =
  BEGIN
    INC (RT0u.inCritical);
      defaultStackSize := MAX (defaultStackSize, new_min);
    DEC (RT0u.inCritical);
  END MinDefaultStackSize;

PROCEDURE <A NAME="IncDefaultStackSize"><procedure>IncDefaultStackSize</procedure></A> (inc: CARDINAL) =
  BEGIN
    INC (RT0u.inCritical);
      INC (defaultStackSize, inc);
    DEC (RT0u.inCritical);
  END IncDefaultStackSize;

PROCEDURE <A NAME="Fork"><procedure>Fork</procedure></A> (cl: Closure): T =
  VAR t: T;  stack_size: CARDINAL;
  BEGIN
    (* make sure that thread switching keeps up with thread creation *)
    INC (stats.n_forks);
    IF (stats.n_forks MOD ForkYieldRatio) = 0 THEN Yield () END;

    INC (RT0u.inCritical);

      IF NOT multipleThreads THEN
        (* this is the first time we have more than one thread; we can start to
           consider switching *)
        multipleThreads := TRUE;
        StartSwitching (); END;

      t := NEW (T, closure := cl, id := nextId);
      INC (nextId);

      (* determine the size of the stack for this thread *)
      stack_size := defaultStackSize;
      TYPECASE cl OF
      | SizedClosure (scl) =&gt; IF scl.stackSize # 0 THEN
                                stack_size := scl.stackSize;
                              END;
      ELSE (*skip*)
      END;

      (* allocate a condition variable for this thread *)
      t.endCondition := NEW (Condition);

      (* link the thread into the global ring *)
      t.next := self.next;
      t.previous := self;
      self.next.previous := t;
      self.next := t;

      InitContext (t.context, stack_size);
      CanRun (t);

      IF hooks # NIL THEN hooks.fork (t) END;
    DEC (RT0u.inCritical);
    RETURN t;
  END Fork;

PROCEDURE <A NAME="Join"><procedure>Join</procedure></A> (t: T): REFANY RAISES {} =
  &lt;*FATAL Alerted*&gt;
  BEGIN
    self.alertable := FALSE;
    RETURN XJoin (t);
  END Join;

PROCEDURE <A NAME="AlertJoin"><procedure>AlertJoin</procedure></A> (t: T): REFANY RAISES {Alerted} =
  BEGIN
    self.alertable := TRUE;
    RETURN XJoin (t);
  END AlertJoin;

PROCEDURE <A NAME="XJoin"><procedure>XJoin</procedure></A> (t: T): REFANY RAISES {Alerted} =
  VAR c: Condition;
  BEGIN
    INC (RT0u.inCritical);
      WHILE (t.state # State.dying) AND (t.state # State.dead) DO
        (*** INLINE Wait (RT0u.inCritical, t.endCondition) ***)
        c := t.endCondition;
        ICannotRun (State.waiting);
        self.waitingForCondition := c;
        self.nextWaiting := c.waitingForMe;
        c.waitingForMe := self;
        DEC (RT0u.inCritical);
          InternalYield ();
        INC (RT0u.inCritical);
      END;
      t.state := State.dead;
      IF perfOn THEN PerfChanged (t.id, State.dead); END;
      INC (stats.n_joins);
    DEC (RT0u.inCritical);
    RETURN t.result;
  END XJoin;

PROCEDURE <A NAME="Wait"><procedure>Wait</procedure></A> (m: Mutex; c: Condition) =
  &lt;*FATAL Alerted*&gt;
  BEGIN
    self.alertable := FALSE;
    XWait (m, c);
  END Wait;

PROCEDURE <A NAME="AlertWait"><procedure>AlertWait</procedure></A> (m: Mutex; c: Condition) RAISES {Alerted} =
  BEGIN
    self.alertable := TRUE;
    XWait (m, c);
  END AlertWait;

PROCEDURE <A NAME="XWait"><procedure>XWait</procedure></A> (m: Mutex; c: Condition) RAISES {Alerted} =
  BEGIN
    TRY
      INC (RT0u.inCritical);
        EVAL XRelease (m);
        ICannotRun (State.waiting);
        self.waitingForCondition := c;
        self.nextWaiting := c.waitingForMe;
        c.waitingForMe := self;
      DEC (RT0u.inCritical);
      InternalYield ();
    FINALLY
      LockMutex (m);
    END;
  END XWait;

PROCEDURE <A NAME="Signal"><procedure>Signal</procedure></A> (c: Condition) =
  BEGIN
    XSignal (c, 1);
  END Signal;

PROCEDURE <A NAME="Broadcast"><procedure>Broadcast</procedure></A> (c: Condition) =
  BEGIN
    XSignal (c, -1);
  END Broadcast;

PROCEDURE <A NAME="XSignal"><procedure>XSignal</procedure></A> (c: Condition; limit: INTEGER) =
  VAR t: T;
  BEGIN
    INC (RT0u.inCritical);
      LOOP
        t := c.waitingForMe;
        IF (t = NIL) THEN EXIT END;
        c.waitingForMe := t.nextWaiting;
        CanRun (t);
        DEC (limit);
        IF limit = 0 THEN EXIT END;
      END;
    DEC (RT0u.inCritical);
  END XSignal;

PROCEDURE <A NAME="Alert"><procedure>Alert</procedure></A> (t: T) =
  BEGIN
    INC (RT0u.inCritical);
      t.alertPending := TRUE;
    DEC (RT0u.inCritical);
  END Alert;

PROCEDURE <A NAME="TestAlert"><procedure>TestAlert</procedure></A> (): BOOLEAN =
  VAR result: BOOLEAN;
  BEGIN
    INC (RT0u.inCritical);
      result := self.alertPending;
      self.alertPending := FALSE;
    DEC (RT0u.inCritical);
    RETURN result;
  END TestAlert;

PROCEDURE <A NAME="Yield"><procedure>Yield</procedure></A> () =
  &lt;*FATAL Alerted*&gt;
  BEGIN
    self.alertable := FALSE;
    InternalYield ();
  END Yield;

PROCEDURE <A NAME="Self"><procedure>Self</procedure></A> (): T =
  BEGIN
    RETURN self;
  END Self;
</PRE>--------------------------------------------------------------- MUTEXes ---
 Note: RTHooks.{Unlock,Lock}Mutex are the routines called directly by
   the compiler.  Acquire and Release are the routines exported through
   the Thread interface 
         
<P><PRE>PROCEDURE <A NAME="Acquire"><procedure>Acquire</procedure></A> (m: Mutex) =
  BEGIN
    LockMutex (m);
  END Acquire;

PROCEDURE <A NAME="Release"><procedure>Release</procedure></A> (m: Mutex) =
  BEGIN
    UnlockMutex (m);
  END Release;

PROCEDURE (*RTHooks.*)<A NAME="LockMutex"><procedure>LockMutex</procedure></A> (m: Mutex) =
  &lt;*FATAL Alerted*&gt;
  BEGIN
    LOOP
      INC (RT0u.inCritical);
        IF m.holder = NIL THEN
          &lt;* ASSERT self # NIL *&gt;
          m.holder := self;
          DEC (RT0u.inCritical);
          RETURN;
        END;
        ICannotRun (State.locking);
        self.waitingForMutex := m;
        self.nextWaiting := m.waitingForMe;
        self.alertable := FALSE;
        m.waitingForMe := self;
      DEC (RT0u.inCritical);
      InternalYield ();
    END;
  END LockMutex;

PROCEDURE (*RTHooks.*)<A NAME="UnlockMutex"><procedure>UnlockMutex</procedure></A> (m: Mutex) =
  &lt;*FATAL Alerted*&gt;
  VAR waiters: BOOLEAN;
  BEGIN
    INC (RT0u.inCritical);
      waiters := XRelease (m);
    DEC (RT0u.inCritical);
    IF waiters THEN
      self.alertable := FALSE;
      InternalYield ();
    END;
  END UnlockMutex;

PROCEDURE <A NAME="XRelease"><procedure>XRelease</procedure></A> (m: Mutex): BOOLEAN =
  (* called while inCritical *)
  VAR t, last_t: T;
  BEGIN
    IF m.holder # self THEN SleazyRelease (m) END;
    m.holder := NIL;

    t := m.waitingForMe;
    IF (t = NIL) THEN RETURN FALSE END;

    (* search for the end:  t == last thread, last_t == second to last one *)
    last_t := NIL;
    WHILE (t.nextWaiting # NIL) DO last_t := t;  t := t.nextWaiting  END;

    IF (last_t # NIL)
      THEN last_t.nextWaiting := NIL; (* multiple threads are waiting *)
      ELSE m.waitingForMe := NIL;     (* only one thread is waiting *)
    END;
    t.nextWaiting := NIL;
    CanRun (t);
    RETURN TRUE;
  END XRelease;

PROCEDURE <A NAME="SleazyRelease"><procedure>SleazyRelease</procedure></A> (m: Mutex) =
  BEGIN
    DumpEverybody ();
    OutT (&quot;*** Mutex &quot;);
    OutA (m, 0);
    IF m.holder = NIL THEN
      OutT (&quot; is not locked.\n&quot;);
    ELSE
      OutT (&quot; is held by thread #&quot;);
      OutI (m.holder.id, 0);
      OutT (&quot;.\n&quot;);
    END;
    RTMisc.FatalError (&quot;Thread.m3&quot;, 381, &quot;illegal Thread.Release&quot;);
  END SleazyRelease;
</PRE>--------------------------------------------- exception handling support --

<P><PRE>PROCEDURE <A NAME="GetCurrentHandlers"><procedure>GetCurrentHandlers</procedure></A> (): ADDRESS=
  BEGIN
    RETURN RTThread.handlerStack;
  END GetCurrentHandlers;

PROCEDURE <A NAME="SetCurrentHandlers"><procedure>SetCurrentHandlers</procedure></A> (h: ADDRESS)=
  BEGIN
    RTThread.handlerStack := h;
  END SetCurrentHandlers;

PROCEDURE <A NAME="PushEFrame"><procedure>PushEFrame</procedure></A> (frame: ADDRESS) =
  TYPE Frame = UNTRACED REF RECORD next: ADDRESS END;
  VAR f := LOOPHOLE (frame, Frame);
  BEGIN
    f.next := RTThread.handlerStack;
    RTThread.handlerStack := f;
  END PushEFrame;

PROCEDURE <A NAME="PopEFrame"><procedure>PopEFrame</procedure></A> (frame: ADDRESS) =
  BEGIN
    RTThread.handlerStack := frame;
  END PopEFrame;
</PRE>--------------------------------------------- garbage collector support ---

<P><PRE>PROCEDURE <A NAME="SuspendOthers"><procedure>SuspendOthers</procedure></A> () =
  BEGIN
    INC(RT0u.inCritical);
  END SuspendOthers;

PROCEDURE <A NAME="ResumeOthers"><procedure>ResumeOthers</procedure></A> () =
  BEGIN
    DEC(RT0u.inCritical);
  END ResumeOthers;

PROCEDURE <A NAME="ProcessStacks"><procedure>ProcessStacks</procedure></A> (p: PROCEDURE (start, stop: ADDRESS)) =
  VAR t:= self; start, stop: ADDRESS;
  BEGIN
    (* save my state *)
    EVAL RTThread.Save (self.context.buf);

    REPEAT
      Tos (t.context, start, stop);	 (* process the stack *)
      p (start, stop);
      WITH z = t.context.buf DO		 (* process the registers *)
        p (ADR (z), ADR (z) + ADRSIZE (z))
      END;
      t := t.next;
    UNTIL t = self;
  END ProcessStacks;
</PRE>------------------------------------------------- I/O and Timer support ---

<P><PRE>PROCEDURE <A NAME="Pause"><procedure>Pause</procedure></A>(n: LONGREAL)=
  &lt;*FATAL Alerted*&gt;
  VAR until := TimePosix.ToUtime (n + Time.Now ());
  BEGIN
    XPause(until, FALSE);
  END Pause;

PROCEDURE <A NAME="AlertPause"><procedure>AlertPause</procedure></A>(n: LONGREAL) RAISES {Alerted}=
  VAR until := TimePosix.ToUtime (n + Time.Now ());
  BEGIN
    XPause(until, TRUE);
  END AlertPause;

PROCEDURE <A NAME="XPause"><procedure>XPause</procedure></A> (READONLY until: UTime; alertable := FALSE) RAISES {Alerted} =
  BEGIN
    INC (RT0u.inCritical);
      self.waitingForTime := until;
      self.alertable := alertable;
      ICannotRun (State.pausing);
    DEC (RT0u.inCritical);
    InternalYield ();
  END XPause;

CONST FDSetSize = BITSIZE(INTEGER);

TYPE
  FDSet = SET OF [0 .. FDSetSize-1];
  FDS = REF ARRAY OF FDSet;

VAR
  gMaxActiveFDSet, gMaxFDSet: CARDINAL := 1;
  gReadFDS, gWriteFDS, gExceptFDS: FDS := NEW(FDS, 1);

  (* gMaxFDSet is NUMBER(gReadFDS^) *)
  (* gReadFDS, gWriteFDS, and gExceptFDS all have the same length *)
  (* gMaxActiveFDSet &lt;= gMaxFDSet, gMaxActiveFDSet * FDSetSize &gt; nFD,
     where nFD is the maximum fd active in any call to XIOWait *)
  (* gMaxFDSet never decreases *)

  (* note that using a FD beyond the range of legal FDs produces
     a checked runtime error *)

PROCEDURE <A NAME="IOWait"><procedure>IOWait</procedure></A>(fd: INTEGER; read: BOOLEAN;
                  timeoutInterval: LONGREAL := -1.0D0): WaitResult =
  &lt;*FATAL Alerted*&gt;
  BEGIN
    self.alertable := FALSE;
    RETURN XIOWait(fd, read, timeoutInterval);
  END IOWait;

PROCEDURE <A NAME="IOAlertWait"><procedure>IOAlertWait</procedure></A>(fd: INTEGER; read: BOOLEAN;
                  timeoutInterval: LONGREAL := -1.0D0): WaitResult
                  RAISES {Alerted} =
  BEGIN
    self.alertable := TRUE;
    RETURN XIOWait(fd, read, timeoutInterval);
  END IOAlertWait;

PROCEDURE <A NAME="XIOWait"><procedure>XIOWait</procedure></A> (fd: CARDINAL; read: BOOLEAN; interval: LONGREAL): WaitResult
    RAISES {Alerted} =
  VAR res: INTEGER;
      fdindex := fd DIV FDSetSize;
      fdset := FDSet{fd MOD FDSetSize};
  BEGIN
    (* If we are in a single-threaded program do just what the user wants *)
    IF NOT multipleThreads THEN
      self.alertable := FALSE;
      IF fdindex &gt;= gMaxActiveFDSet THEN
        gMaxActiveFDSet := fdindex + 1;
        IF gMaxFDSet &lt; gMaxActiveFDSet THEN
          gReadFDS := NEW(FDS, gMaxActiveFDSet);
          gWriteFDS := NEW(FDS, gMaxActiveFDSet);
          gExceptFDS := NEW(FDS, gMaxActiveFDSet);
          gMaxFDSet := gMaxActiveFDSet;
        END;
      END;
      ZeroFDS();
      IF read
        THEN gReadFDS[fdindex] := fdset;
        ELSE gWriteFDS[fdindex] := fdset;
      END;
      IF interval &gt;= 0.0D0 THEN
        VAR utimeout := UTimeFromTime(interval); BEGIN
          res := CallSelect(fd+1, ADR(utimeout));
        END;
      ELSE
        res := CallSelect(fd+1, NIL);
      END;
      IF    res &gt; 0 THEN RETURN TestFDS(fdindex, fdset, read);
      ELSIF res = 0 THEN RETURN WaitResult.Timeout;
      ELSE               RETURN WaitResult.Error;
      END;
    ELSE
      (* This thing blocks, schedule it for later *)
      VAR newRead, newWrite, newExcept: FDS := NIL;
      BEGIN
        IF fdindex &gt;= gMaxFDSet THEN
          (* must do alloc in non-critical *)
          newRead := NEW(FDS, fdindex+1);
          newWrite := NEW(FDS, fdindex+1);
          newExcept := NEW(FDS, fdindex+1);
        END;
        INC (RT0u.inCritical);
          IF fdindex &gt;= gMaxActiveFDSet THEN
            gMaxActiveFDSet := fdindex + 1;
            IF gMaxFDSet &lt; gMaxActiveFDSet THEN
              gReadFDS := newRead;
              gWriteFDS := newWrite;
              gExceptFDS := newExcept;
              gMaxFDSet := gMaxActiveFDSet;
            END;
          END;
          self.select.fd := fd;
          self.select.read := read;
          self.select.index := fdindex;
          self.select.set := fdset;
          self.select.hasTimeout := (interval &gt;= 0.0D0);
          IF interval &gt;= 0.0D0 THEN
            self.select.timeout :=
                Time_Add(UTimeNow(), UTimeFromTime(interval));
          END;
          ICannotRun (State.blocking);
        DEC (RT0u.inCritical);
      END;
      InternalYield ();
      Cerrno.errno := self.select.errno;
      RETURN self.select.waitResult;
    END;
  END XIOWait;

PROCEDURE <A NAME="ZeroFDS"><procedure>ZeroFDS</procedure></A>() =
  BEGIN
    FOR i := 0 TO gMaxActiveFDSet-1 DO
      gReadFDS[i] := FDSet{};
      gWriteFDS[i] := FDSet{};
    END;
  END ZeroFDS;
</PRE><P>
PROCEDURE InclFDS(fd: CARDINAL; read: BOOLEAN) =
  VAR set := fd DIV FDSetSize;
      sset := FDSet{fd MOD FDSetSize};
  BEGIN
    IF read
      THEN gReadFDS[set] := gReadFDS[set] + sset;
      ELSE gWriteFDS[set] := gWriteFDS[set] + sset;
    END;
  END InclFDS;


<P><PRE>PROCEDURE <A NAME="TestFDS"><procedure>TestFDS</procedure></A>(index: CARDINAL; set: FDSet; read: BOOLEAN): WaitResult =
  BEGIN
    IF (set * gExceptFDS[index]) # FDSet{} THEN
      IF read THEN
        IF (set * gReadFDS[index]) # FDSet{} THEN
          RETURN WaitResult.Ready;
        END;
        IF (set * gWriteFDS[index]) = FDSet{} THEN
          RETURN WaitResult.FDError;
        END;
      ELSE
        IF (set * gWriteFDS[index]) # FDSet{} THEN
          RETURN WaitResult.Ready;
        END;
        IF (set * gReadFDS[index]) = FDSet{} THEN
          RETURN WaitResult.FDError;
        END;
      END;
    END;
    RETURN WaitResult.Timeout;
  END TestFDS;

PROCEDURE <A NAME="CallSelect"><procedure>CallSelect</procedure></A>(nfd: CARDINAL; timeout: UNTRACED REF UTime): INTEGER =
  TYPE FDSPtr = UNTRACED REF Unix.FDSet;
  VAR res: INTEGER;
  BEGIN
    FOR i := 0 TO gMaxActiveFDSet-1 DO
      gExceptFDS[i] := gReadFDS[i] + gWriteFDS[i];
    END;
    res := Unix.select(nfd, LOOPHOLE (ADR(gReadFDS[0]), FDSPtr),
                            LOOPHOLE (ADR(gWriteFDS[0]), FDSPtr),
                            LOOPHOLE (ADR(gExceptFDS[0]), FDSPtr), timeout);
    IF res &gt; 0 THEN
      FOR i := 0 TO gMaxActiveFDSet-1 DO
        gExceptFDS[i] := gExceptFDS[i] + gReadFDS[i] + gWriteFDS[i];
      END;
    END;
    RETURN res;
  END CallSelect;

PROCEDURE <A NAME="UTimeFromTime"><procedure>UTimeFromTime</procedure></A>(time: Time.T): UTime =
  VAR floor := FLOOR(time);
  BEGIN
    RETURN UTime{floor, FLOOR(1.0D6 * (time - FLOAT(floor, LONGREAL)))};
  END UTimeFromTime;
</PRE>------------------------------------------------ timer-based preemption ---

<P><PRE>PROCEDURE <A NAME="DisableSwitching"><procedure>DisableSwitching</procedure></A> () =
  BEGIN
    INC (RT0u.inCritical);
  END DisableSwitching;

PROCEDURE <A NAME="EnableSwitching"><procedure>EnableSwitching</procedure></A> () =
  BEGIN
    DEC (RT0u.inCritical);
  END EnableSwitching;

PROCEDURE <A NAME="StartSwitching"><procedure>StartSwitching</procedure></A> () =
</PRE><BLOCKQUOTE><EM> set the SIGVTALRM timer and handler; can be called to change the 
   switching interval </EM></BLOCKQUOTE><PRE>
  VAR it, oit: Utime.struct_itimerval;
  BEGIN
    IF preemption THEN
      RTThread.setup_sigvtalrm (LOOPHOLE(switch_thread,Usignal.SignalHandler));
      it.it_interval := selected_interval;
      it.it_value    := selected_interval;
      IF Utime.setitimer (Utime.ITIMER_VIRTUAL, it, oit) # 0 THEN
        RAISE InternalError;
      END;
      RTThread.allow_sigvtalrm ();
    END;
  END StartSwitching;

TYPE SignalData = UNTRACED REF Usignal.struct_sigcontext;

PROCEDURE <A NAME="switch_thread"><procedure>switch_thread</procedure></A> (&lt;*UNUSED*&gt; sig, code: INTEGER;
                         &lt;*UNUSED*&gt; scp: SignalData) RAISES {Alerted} =
  BEGIN
    RTThread.allow_sigvtalrm ();
    IF RT0u.inCritical = 0 THEN InternalYield () END;
  END switch_thread;
</PRE>****** DEPRECATED *****************************
PROCEDURE SetSwitchingInterval (READONLY i: UTime) =
  BEGIN
    selected_interval := i;
    IF multipleThreads THEN StartSwitching () END;
  END SetSwitchingInterval;
************************************************

<P>------------------------------------------------------------- scheduler ---

<P><PRE>PROCEDURE <A NAME="CanRun"><procedure>CanRun</procedure></A> (t: T) =
  BEGIN
    t.state := State.alive;
    t.nextWaiting := NIL;
    t.waitingForCondition := NIL;
    t.waitingForMutex := NIL;
    IF perfOn THEN PerfChanged (t.id, State.alive); END;
  END CanRun;

PROCEDURE <A NAME="ICannotRun"><procedure>ICannotRun</procedure></A> (newState: State) =
  BEGIN
    self.state := newState;
    IF perfOn THEN PerfChanged (self.id, newState); END;
  END ICannotRun;

PROCEDURE <A NAME="InternalYield"><procedure>InternalYield</procedure></A> () RAISES {Alerted} =
VAR t, from: T;
    blockingNfds: CARDINAL;
    scanned := FALSE;
    (* scanned =&gt; gReadFDS, ... gExceptFDS have been
       set by a select call that includes the masks of all
       blocked threads in the prefix up the thread list
       up to the first runnable thread, or the whole list
       if there is no runnable thread.
       INVARIANT: scanned OR (selectResult = 0) *)

    somePausing, someBlocking: BOOLEAN;
    now          : UTime;
    earliest     : UTime;
    selectResult := 0;
    do_alert     : BOOLEAN;
    did_delete   : BOOLEAN;

BEGIN
  INC (RT0u.inCritical);
  &lt;*ASSERT RT0u.inCritical = 1 *&gt;

  from := self.next; (* remember where we started *)
  now            := UTimeNow ();

  LOOP
    t              := from;
    IF NOT scanned OR selectResult &lt; 0 THEN ZeroFDS(); END;
    blockingNfds   := 0;
    did_delete     := FALSE;
    somePausing    := FALSE;
    someBlocking   := FALSE;

    LOOP
      CASE t.state OF
        | State.waiting =&gt;
            IF t.alertable AND t.alertPending THEN
              WITH c = t.waitingForCondition DO
                IF c.waitingForMe = t THEN
                  c.waitingForMe := t.nextWaiting;
                ELSE
                  VAR tt := c.waitingForMe; BEGIN
                    WHILE tt.nextWaiting # t DO tt := tt.nextWaiting; END;
                    tt.nextWaiting := t.nextWaiting; END; END; END;
              CanRun (t);
              EXIT; END;

        | State.locking =&gt;
            &lt;*ASSERT NOT t.alertable*&gt;

        | State.pausing  =&gt;
            IF t.alertable AND t.alertPending THEN
              CanRun (t);
              EXIT;

            ELSIF Time_Compare (t.waitingForTime, now) &lt;= 0 THEN
              CanRun (t);
              EXIT;

            ELSIF NOT somePausing THEN
              earliest := t.waitingForTime;
              somePausing := TRUE;

            ELSIF Time_Compare (t.waitingForTime, earliest) &lt; 0 THEN
              earliest := t.waitingForTime; END;

        | State.blocking =&gt;
            IF t.alertable AND t.alertPending THEN
              CanRun (t);
              EXIT;

            ELSIF NOT scanned THEN
              blockingNfds := MAX (blockingNfds, t.select.fd + 1);
              IF t.select.read THEN
                gReadFDS[t.select.index] :=
                   gReadFDS[t.select.index] + t.select.set;
              ELSE
                gWriteFDS[t.select.index] :=
                   gWriteFDS[t.select.index] + t.select.set;
              END;
              someBlocking := TRUE
            ELSE
              (* scanned is TRUE *)
              IF selectResult &lt; 0 THEN
                IF t.select.read THEN
                  gReadFDS[t.select.index] := t.select.set;
                ELSE
                  gWriteFDS[t.select.index] := t.select.set;
                END;
                VAR n := CallSelect(t.select.fd+1, ADR(ZeroTimeout)); BEGIN
                  IF n &gt; 0 THEN
                    t.select.waitResult :=
                          TestFDS(t.select.index, t.select.set, t.select.read);
                    CanRun(t);
                    EXIT;
                  ELSIF n &lt; 0 THEN
                    t.select.errno  := Cerrno.errno;
                    t.select.waitResult := WaitResult.Error;
                    CanRun(t);
                    EXIT;
                  END;
                END;
              ELSIF selectResult &gt; 0 THEN
                VAR
                  res := TestFDS(t.select.index, t.select.set, t.select.read);
                BEGIN
                  IF res # WaitResult.Timeout THEN
                    t.select.waitResult := res;
                    CanRun(t);
                    EXIT;
                  END;
                END;
              END;

              (* Not runnable, but its timer may have expired *)
              IF t.select.hasTimeout
                  AND Time_Compare (t.select.timeout, now) &lt;= 0 THEN
                t.select.errno  := 0;
                t.select.waitResult := WaitResult.Timeout;
                CanRun (t);
                EXIT;
              END;
            END;

            IF t.select.hasTimeout THEN
              IF NOT somePausing THEN
                earliest := t.select.timeout;
                somePausing := TRUE;
              ELSIF Time_Compare (t.select.timeout, earliest) &lt; 0 THEN
                earliest := t.select.timeout;
              END
            END

        | State.dying, State.dead =&gt;
            (* remove this guy from the ring *)
            IF perfOn THEN PerfDeleted (t.id); END;
      	    IF hooks # NIL THEN hooks.die (t) END;
            VAR tmp := t.previous; BEGIN
              IF (t = from) THEN from := tmp END;
              t.next.previous := tmp;
              tmp.next := t.next;
              t.previous := NIL;
              t.next := dead_stacks;
              dead_stacks := t;
              t := tmp;
              did_delete := TRUE;
            END;
        | State.alive =&gt;
            EXIT;
        END; (* case *)

      t := t.next;
      IF t = from THEN
        IF NOT scanned THEN
          gMaxActiveFDSet := 1 + ((blockingNfds-1) DIV FDSetSize);
        END;
        EXIT;
      END;
    END;

    IF t.state = State.alive AND (scanned OR NOT someBlocking) THEN
      IF perfOn THEN PerfRunning (t.id); END;
      (* At least one thread wants to run; transfer to it *)
      Transfer (self.context, t.context, t);
      IF (dead_stacks # NIL) THEN FreeDeadStacks () END;
      do_alert := self.alertable AND self.alertPending;
      self.alertable := FALSE;
      IF do_alert THEN self.alertPending := FALSE END;
      DEC (RT0u.inCritical);
      IF do_alert THEN RAISE Alerted END;
      RETURN;

    ELSIF did_delete THEN
      (* run through the ring one more time before we block
         waiting for I/O, pause for a timer or declare deadlock. *)
      scanned := FALSE;
      selectResult := 0;

    ELSIF (selectResult &lt; 0) THEN
      (* the initial select call failed (ie. erred or was interrupted)
         and none of the subsequent select calls is responsible.*)
      scanned := FALSE;
      selectResult := 0;

    ELSIF somePausing OR someBlocking THEN
      IF perfOn THEN PerfRunning (-1); END;
      IF t.state = State.alive OR
               somePausing AND Time_Compare(earliest, now) &lt;= 0 THEN
        selectResult := CallSelect(blockingNfds, ADR(ZeroTimeout));
      ELSIF somePausing THEN
        VAR timeout := Time_Subtract (earliest, now); BEGIN
          selectResult := CallSelect(blockingNfds, ADR(timeout));
        END;
      ELSE
        selectResult := CallSelect(blockingNfds, NIL);
      END;
      IF selectResult &lt;= 0 THEN now := UTimeNow(); END;
      scanned := TRUE
    ELSE
      IF perfOn THEN PerfRunning (-1); END;
      DumpEverybody ();
      RTMisc.FatalError (NIL, 0, &quot;Deadlock !&quot;);
    END;
  END;
END InternalYield;

PROCEDURE <A NAME="FreeDeadStacks"><procedure>FreeDeadStacks</procedure></A> () =
  (* blow away any dead stacks *)
  VAR x: T;  t: T := dead_stacks;
  BEGIN
    WHILE (t # NIL) DO
      &lt;*ASSERT t # self*&gt;
      IF (t.context.stack.words # NIL) THEN
        RTThread.FreeStack (t.context.stack);
        t.context.stack.words := NIL;
      END;
      x := t;
      t := t.next;
      x.next := NIL;
    END;
  END FreeDeadStacks;
</PRE>-------------------------------------------------- low-level coroutines ---

<P><PRE>CONST
  seal = 123456;

TYPE
  Context = RECORD
    stack:       RTThread.Stack;
    stackTop:    ADDRESS;
    stackBottom: ADDRESS;
    handlers:    ADDRESS;
    errno:       INTEGER;
    buf:         RTThread.State;
  END;

VAR
  self: T;  (* the currently running thread *)

VAR
  modelFrame: UNTRACED REF ARRAY OF Word.T;
  modelFrameLoc: ADDRESS;
  modelSP : ADDRESS;
  modelBuf : RTThread.State;
</PRE> The general strategy is:
   - at initialization time, get an idea of what the stack frame and 
     environment for a routine is; this is done by 
     InitTopContext/DetermineContext. This context is stored in
     the  <CODE>model</CODE> variables.
<P>
   - when a new thread is forked, its stack is initialized from the 
     model stack, and the environment is restored after modifying the 
     entries that depend on the stack position (eg. SP, AP, FP)
     running in that new context will send us in DetermineContext that
     will execute the thread closure (actually a shell that runs that
     closure).


<P><PRE>PROCEDURE <A NAME="InitTopContext"><procedure>InitTopContext</procedure></A> (VAR c: Context) =
  VAR env: RTThread.State;
  BEGIN
    (* The first thread runs on the original stack, we don't want any checks *)
    c.stack.words := NIL;
    c.stack.first := top_of_stack;
    c.stack.last  := bottom_of_stack;
    c.stackTop    := top_of_stack;
    c.stackBottom := bottom_of_stack;
    c.handlers    := NIL;
    c.errno       := 0;

    (* determine what should go in the stack of future threads *)
    WITH i = RTThread.Save (env) DO
      &lt;* ASSERT i = 0 *&gt; END;
    DetermineContext (RTThread.SP (env));

  END InitTopContext;

PROCEDURE <A NAME="DetermineContext"><procedure>DetermineContext</procedure></A> (oldSP: ADDRESS) =
  (* This routine looks at the stack frame for this call and takes
     it as a model for the frame to put in the stacks of forked
     threads. It also saves the jmp_buf at the beginning of the
     call in a global; that jmp_buf will be (after updating the
     stack pointer) for forked threads *)
  &lt;*FATAL Alerted*&gt;
  BEGIN

    IF (RTThread.Save (modelBuf) = 0) THEN
      (* first time through; this part is executed only once to determine
         the model *)

      modelSP := RTThread.SP (modelBuf);

      (* Copy the frame (plus pad) to modelStack and
         remember where that should go in the new stacks *)

      RTThread.FlushStackCache ();

      modelFrame := NEW (UNTRACED REF ARRAY OF Word.T,
                         ABS (modelSP - oldSP) DIV ADRSIZE (Word.T)
                         + 1 + RTThread.FramePadBottom + RTThread.FramePadTop);

      IF stack_grows_down THEN
        (* &lt;* ASSERT oldSP &gt; modelSP *&gt; *)
        modelFrameLoc := modelSP - RTThread.FramePadTop * ADRSIZE(Word.T);
      ELSE
        (* &lt;* ASSERT oldSP &lt; modelSP *&gt; *)
        modelFrameLoc := oldSP - RTThread.FramePadBottom * ADRSIZE (Word.T);
      END;

      EVAL Cstring.memcpy (ADR (modelFrame [0]), modelFrameLoc,
                           NUMBER (modelFrame^) * BYTESIZE (Word.T));

    ELSE
      (* we are starting the execution of a forked thread *)
      RTThread.handlerStack := self.context.handlers;
      top_of_stack := self.context.stackTop;
      Cerrno.errno := self.context.errno;
      RTThread.allow_sigvtalrm ();
      DEC (RT0u.inCritical);

      FloatMode.InitThread (self.floatState);
      self.result := self.closure.apply ();

      INC (RT0u.inCritical);
      Broadcast (self.endCondition);
      ICannotRun (State.dying);
      INC (stats.n_dead);
      DEC (RT0u.inCritical);
      InternalYield ();
      &lt;* ASSERT FALSE *&gt; END;
  END DetermineContext;

PROCEDURE <A NAME="InitContext"><procedure>InitContext</procedure></A> (VAR c: Context;  size: INTEGER) =
  VAR
    offset, SPinFrame: INTEGER;
    frameLoad: ADDRESS;
  BEGIN
    (* allocate a new stack *)
    RTThread.GetStack (size, c.stack);

    (* initialize the context fields *)
    IF stack_grows_down THEN
      c.stackTop    := c.stack.first;
      c.stackBottom := c.stack.last - ADRSIZE (Word.T);
    ELSE
      c.stackTop    := c.stack.last - ADRSIZE (Word.T);
      c.stackBottom := c.stack.first;
    END;
    c.handlers    := NIL;
    c.errno       := Cerrno.errno;

    (* mark the ends of the stack for a sanity check *)
    LOOPHOLE (c.stackTop, IntPtr)^ := seal;
    LOOPHOLE (c.stackBottom, IntPtr)^ := seal;

    IF stack_grows_down THEN
      SPinFrame := RTThread.FramePadTop * ADRSIZE (Word.T);
      frameLoad := RTMisc.Align (c.stack.last - 2 * ADRSIZE (Word.T)
                       - NUMBER (modelFrame^) * ADRSIZE (Word.T)
                       - RTThread.StackFrameAlignment + 1 + SPinFrame,
                       RTThread.StackFrameAlignment) - SPinFrame;
    ELSE
      SPinFrame := (NUMBER (modelFrame^) - RTThread.FramePadBottom)
                       * ADRSIZE (Word.T);
      frameLoad := RTMisc.Align (c.stack.first + ADRSIZE (Word.T) + SPinFrame,
                                 RTThread.StackFrameAlignment) - SPinFrame;
    END;
    offset := (frameLoad + SPinFrame) - modelSP;
    EVAL Cstring.memcpy (frameLoad, ADR (modelFrame [0]),
                         NUMBER (modelFrame^) * BYTESIZE (Word.T));
    RTThread.UpdateFrameForNewSP (frameLoad + SPinFrame, offset);

    c.buf := modelBuf;
    RTThread.UpdateStateForNewSP (c.buf, offset);
  END InitContext;

PROCEDURE <A NAME="Transfer"><procedure>Transfer</procedure></A> (VAR from, to: Context;  new_self: T) =
  BEGIN
    &lt;* ASSERT (from.stack.words = NIL)
                OR (LOOPHOLE (from.stackTop, IntPtr)^ = seal
                AND LOOPHOLE (from.stackBottom, IntPtr)^ = seal) *&gt;

    &lt;* ASSERT (to.stack.words = NIL)
                OR (LOOPHOLE (to.stackTop, IntPtr)^ = seal
                AND LOOPHOLE (to.stackBottom, IntPtr)^ = seal) *&gt;

    IF (ADR (from) # ADR (to)) THEN
      RTThread.disallow_sigvtalrm ();
      from.handlers := RTThread.handlerStack;
      from.errno := Cerrno.errno;
      self := new_self;
      myId := new_self.id;
      RTThread.Transfer (from.buf, to.buf);
      top_of_stack := from.stackTop;
      RTThread.handlerStack := from.handlers;
      Cerrno.errno := from.errno;
      RTThread.allow_sigvtalrm ();
    END;
  END Transfer;

PROCEDURE <A NAME="Tos"><procedure>Tos</procedure></A> (READONLY c: Context; VAR start, stop: ADDRESS) =
  BEGIN
    IF stack_grows_down THEN
      start := RTThread.SP (c.buf);
      stop  := c.stackBottom - ADRSIZE (Word.T);
    ELSE
      start := c.stackBottom + ADRSIZE (Word.T);
      stop  := RTThread.SP (c.buf);
    END;
  END Tos;

PROCEDURE <A NAME="MyFPState"><procedure>MyFPState</procedure></A> (): UNTRACED REF FloatMode.ThreadState =
  BEGIN
    RETURN ADR (self.floatState);
  END MyFPState;
</PRE>----------------------------------------------------- debugging support ---

<P><PRE>CONST
  WaitTag = ARRAY State OF TEXT {
    &quot;*ready*&quot;,
    &quot;condition &quot;,
    &quot;mutex &quot;,
    &quot;timer &quot;,
    &quot;I/O &quot;,
    &quot;*dying*&quot;,
    &quot;*dead*&quot;
  };

PROCEDURE <A NAME="DumpEverybody"><procedure>DumpEverybody</procedure></A> () =
  VAR t: T;
  BEGIN
    INC (RT0u.inCritical);
      OutT (&quot;\n\n*****************************&quot;);
      OutT (&quot;**********************************\n&quot;);
      OutT (&quot;  id    Thread.T     closure root&quot;);
      OutT (&quot;                A* waiting for\n&quot;);
      t := self;
      REPEAT
        IF (t = NIL) THEN
          OutT (&quot;!!! NIL thread in ring !!!\n&quot;);
          EXIT;
        END;
        DumpThread (t);
        t := t.next;
      UNTIL (t = self);
      OutT (&quot;*****************************&quot;);
      OutT (&quot;**********************************\n&quot;);
      RTIO.Flush ();
    DEC (RT0u.inCritical);
  END DumpEverybody;

PROCEDURE <A NAME="DumpThread"><procedure>DumpThread</procedure></A> (t: T) =
  TYPE ClosureMethods = UNTRACED REF ARRAY [0..1] OF ADDRESS;
  TYPE ClosureObject  = UNTRACED REF ClosureMethods;
  VAR
    pc, proc: ADDRESS;
    m: MUTEX;
    co: ClosureObject;
    name: RTProcedureSRC.Name;
    file: RTProcedureSRC.Name;
  BEGIN
    IF (t = self)
      THEN OutT (&quot;&gt;&quot;);
      ELSE OutT (&quot; &quot;);
    END;

    (* thread ID *)
    OutI (t.id, 3);

    (* Thread.T *)
    OutA (t, 12);

    (* closure *)
    OutA (t.closure, 12);

    (* inital PC *)
    OutT (&quot; &quot;);
    pc := NIL;
    co := LOOPHOLE (t.closure, ClosureObject);
    IF (co # NIL) AND (co^ # NIL) THEN pc := co^^[1] END;
    IF (co = NIL) THEN
      OutT (&quot;*main program*      &quot;);
    ELSE
      RTProcedureSRC.FromPC (pc, proc, file, name);
      IF (proc = NIL) OR (proc # pc) THEN
        OutA (LOOPHOLE (pc, REFANY), 20);
      ELSE
        RTIO.PutString (name);
        Pad (20, Cstring.strlen (name));
      END;
    END;

    (* alert status *)
    IF (t.alertable)
      THEN OutT (&quot;A&quot;);
      ELSE OutT (&quot; &quot;);
    END;
    IF (t.alertPending)
      THEN OutT (&quot;* &quot;);
      ELSE OutT (&quot;  &quot;);
    END;

    (* state *)
    OutT (WaitTag [t.state]);
    CASE t.state OF
    | State.alive =&gt;
        (* nothing *)
    | State.waiting =&gt;
        OutA (t.waitingForCondition, 0);
    | State.locking =&gt;
        m := t.waitingForMutex;
        OutA (m, 0);
        IF (m # NIL) THEN
          IF (m.holder = NIL) THEN
            OutT (&quot; (unlocked)&quot;);
          ELSE
            OutT (&quot; (held by #&quot;);
            OutI (m.holder.id, 0);
            OutT (&quot;)&quot;);
          END;
        END;
    | State.blocking =&gt;
        (* nothing *)
    | State.pausing =&gt;
        (* nothing *)
    | State.dying =&gt;
        (* nothing *)
    | State.dead =&gt;
        (* nothing *)
    END;

    OutT (&quot;\n&quot;);
  END DumpThread;

PROCEDURE <A NAME="OutT"><procedure>OutT</procedure></A> (t: TEXT) =
  BEGIN
    RTIO.PutText (t);
  END OutT;

PROCEDURE <A NAME="OutI"><procedure>OutI</procedure></A> (i: INTEGER;  width: INTEGER) =
  BEGIN
    RTIO.PutInt (i, width);
  END OutI;

PROCEDURE <A NAME="OutA"><procedure>OutA</procedure></A> (a: REFANY;  width: INTEGER) =
  BEGIN
    RTIO.PutHex (LOOPHOLE (a, INTEGER), width);
  END OutA;

VAR pad := ARRAY [0..20] OF CHAR { ' ', .. };

PROCEDURE <A NAME="Pad"><procedure>Pad</procedure></A> (min, used: INTEGER) =
  BEGIN
    IF (used &lt; min) THEN
      RTIO.PutChars (ADR (pad[0]), min - used);
    END;
  END Pad;
</PRE>------------------------------------------------------ ShowThread hooks ---

<P><PRE>VAR
  perfW  : RTPerfTool.Handle;
  perfOn : BOOLEAN := FALSE;

PROCEDURE <A NAME="PerfStart"><procedure>PerfStart</procedure></A> () =
  BEGIN
    IF RTPerfTool.Start (&quot;showthread&quot;, perfW) THEN
      perfOn := TRUE;
      RTProcess.RegisterExitor (PerfStop);
    END;
  END PerfStart;

PROCEDURE <A NAME="PerfStop"><procedure>PerfStop</procedure></A> () =
  BEGIN
    (* UNSAFE, but needed to prevent deadlock if we're crashing! *)
    RTPerfTool.Close (perfW);
  END PerfStop;

CONST
  EventSize = (BITSIZE(ThreadEvent.T) + BITSIZE(CHAR) - 1) DIV BITSIZE(CHAR);

TYPE
  TE = ThreadEvent.Kind;

PROCEDURE <A NAME="PerfChanged"><procedure>PerfChanged</procedure></A> (id: Id; s: State) =
  VAR e := ThreadEvent.T {kind := TE.Changed, id := id, state := s};
  BEGIN
    perfOn := RTPerfTool.Send (perfW, ADR (e), EventSize);
  END PerfChanged;

PROCEDURE <A NAME="PerfDeleted"><procedure>PerfDeleted</procedure></A> (id: Id) =
  VAR e := ThreadEvent.T {kind := TE.Deleted, id := id};
  BEGIN
    perfOn := RTPerfTool.Send (perfW, ADR (e), EventSize);
  END PerfDeleted;

PROCEDURE <A NAME="PerfRunning"><procedure>PerfRunning</procedure></A> (id: Id) =
  VAR e := ThreadEvent.T {kind := TE.Running, id := id};
  BEGIN
    perfOn := RTPerfTool.Send (perfW, ADR (e), EventSize);
  END PerfRunning;
</PRE>--------------------------------------------------------- ThreadF hooks ---

<P><PRE>VAR
  hooks: Hooks := NIL;

PROCEDURE <A NAME="RegisterHooks"><procedure>RegisterHooks</procedure></A>(h: Hooks; init := TRUE): Hooks RAISES {}=
  VAR
    oldHooks: Hooks;
    t: T;
  BEGIN
    INC (RT0u.inCritical);
      oldHooks := hooks;
      hooks := h;
      IF init AND hooks # NIL THEN
      	t := self;
      	REPEAT
      	  hooks.fork (t);
      	  t := t.next;
      	UNTIL (t = self);
      END;
    DEC (RT0u.inCritical);
    RETURN oldHooks;
  END RegisterHooks;

PROCEDURE <A NAME="MyId"><procedure>MyId</procedure></A>(): Id RAISES {}=
  BEGIN
    RETURN self.id;
  END MyId;
</PRE>-------------------------------------------------------- initialization ---
<PRE>PROCEDURE <A NAME="Init"><procedure>Init</procedure></A>()=
  VAR xx: INTEGER;
  BEGIN
    RT0u.inCritical := 1;
      topThread := NEW (T, state := State.alive, id := nextId);
      FloatMode.InitThread (topThread.floatState);

      INC (nextId);

      stack_grows_down := ADR (xx) &gt; QQ();
      InitTopContext (topThread.context);
      self := topThread;
      myId := self.id;

      pausedThreads := NIL;

      topThread.next := topThread;
      topThread.previous := topThread;
    RT0u.inCritical := 0;

    PerfStart ();
    preemption := NOT RTParams.IsPresent (&quot;nopreemption&quot;);
  END Init;

PROCEDURE <A NAME="QQ"><procedure>QQ</procedure></A>(): ADDRESS =
  VAR xx: INTEGER;
  BEGIN
    RETURN ADR (xx);
  END QQ;

BEGIN
END ThreadPosix.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface ThreadF is in:
</A><UL>
<LI><A HREF="../NOOP/ThreadF.i3#0TOP0">thread/src/NOOP/ThreadF.i3</A>
<LI><A HREF="ThreadF.i3#0TOP0">thread/src/POSIX/ThreadF.i3</A>
<LI><A HREF="../WIN32/ThreadF.i3#0TOP0">thread/src/WIN32/ThreadF.i3</A>
</UL>
<P>
<HR>
<A NAME="x2">interface Cstring is in:
</A><UL>
<LI><A HREF="../../../C/src/AIX386/Cstring.i3#0TOP0">C/src/AIX386/Cstring.i3</A>
<LI><A HREF="../../../C/src/ALPHA_OSF/Cstring.i3#0TOP0">C/src/ALPHA_OSF/Cstring.i3</A>
<LI><A HREF="../../../C/src/AP3000/Cstring.i3#0TOP0">C/src/AP3000/Cstring.i3</A>
<LI><A HREF="../../../C/src/ARM/Cstring.i3#0TOP0">C/src/ARM/Cstring.i3</A>
<LI><A HREF="../../../C/src/DS3100/Cstring.i3#0TOP0">C/src/DS3100/Cstring.i3</A>
<LI><A HREF="../../../C/src/FreeBSD/Cstring.i3#0TOP0">C/src/FreeBSD/Cstring.i3</A>
<LI><A HREF="../../../C/src/FreeBSD2/Cstring.i3#0TOP0">C/src/FreeBSD2/Cstring.i3</A>
<LI><A HREF="../../../C/src/HP300/Cstring.i3#0TOP0">C/src/HP300/Cstring.i3</A>
<LI><A HREF="../../../C/src/HPPA/Cstring.i3#0TOP0">C/src/HPPA/Cstring.i3</A>
<LI><A HREF="../../../C/src/IBMR2/Cstring.i3#0TOP0">C/src/IBMR2/Cstring.i3</A>
<LI><A HREF="../../../C/src/IBMRT/Cstring.i3#0TOP0">C/src/IBMRT/Cstring.i3</A>
<LI><A HREF="../../../C/src/IRIX5/Cstring.i3#0TOP0">C/src/IRIX5/Cstring.i3</A>
<LI><A HREF="../../../C/src/LINUX/Cstring.i3#0TOP0">C/src/LINUX/Cstring.i3</A>
<LI><A HREF="../../../C/src/LINUXELF/Cstring.i3#0TOP0">C/src/LINUXELF/Cstring.i3</A>
<LI><A HREF="../../../C/src/NEXT/Cstring.i3#0TOP0">C/src/NEXT/Cstring.i3</A>
<LI><A HREF="../../../C/src/NT386/Cstring.i3#0TOP0">C/src/NT386/Cstring.i3</A>
<LI><A HREF="../../../C/src/OKI/Cstring.i3#0TOP0">C/src/OKI/Cstring.i3</A>
<LI><A HREF="../../../C/src/SEQUENT/Cstring.i3#0TOP0">C/src/SEQUENT/Cstring.i3</A>
<LI><A HREF="../../../C/src/SOLgnu/Cstring.i3#0TOP0">C/src/SOLgnu/Cstring.i3</A>
<LI><A HREF="../../../C/src/SOLsun/Cstring.i3#0TOP0">C/src/SOLsun/Cstring.i3</A>
<LI><A HREF="../../../C/src/SPARC/Cstring.i3#0TOP0">C/src/SPARC/Cstring.i3</A>
<LI><A HREF="../../../C/src/SUN3/Cstring.i3#0TOP0">C/src/SUN3/Cstring.i3</A>
<LI><A HREF="../../../C/src/SUN386/Cstring.i3#0TOP0">C/src/SUN386/Cstring.i3</A>
<LI><A HREF="../../../C/src/UMAX/Cstring.i3#0TOP0">C/src/UMAX/Cstring.i3</A>
<LI><A HREF="../../../C/src/VAX/Cstring.i3#0TOP0">C/src/VAX/Cstring.i3</A>
</UL>
<P>
<HR>
<A NAME="x3">interface FloatMode is in:
</A><UL>
<LI><A HREF="../../../float/src/DS3100/FloatMode.i3#0TOP0">float/src/DS3100/FloatMode.i3</A>
<LI><A HREF="../../../float/src/IEEE-default/FloatMode.i3#0TOP0">float/src/IEEE-default/FloatMode.i3</A>
<LI><A HREF="../../../float/src/IRIX5/FloatMode.i3#0TOP0">float/src/IRIX5/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SOLsun/FloatMode.i3#0TOP0">float/src/SOLsun/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SPARC/FloatMode.i3#0TOP0">float/src/SPARC/FloatMode.i3</A>
<LI><A HREF="../../../float/src/SUN386/FloatMode.i3#0TOP0">float/src/SUN386/FloatMode.i3</A>
<LI><A HREF="../../../float/src/VAX/FloatMode.i3#0TOP0">float/src/VAX/FloatMode.i3</A>
</UL>
<P>
<HR>
<A NAME="x4">interface RT0u is in:
</A><UL>
<LI><A HREF="../../../runtime/src/POSIX/RT0u.i3#0TOP0">runtime/src/POSIX/RT0u.i3</A>
<LI><A HREF="../../../runtime/src/WIN32/RT0u.i3#0TOP0">runtime/src/WIN32/RT0u.i3</A>
</UL>
<P>
<HR>
<A NAME="x5">interface RTPerfTool is in:
</A><UL>
<LI><A HREF="../../../runtime/src/POSIX/RTPerfTool.i3#0TOP0">runtime/src/POSIX/RTPerfTool.i3</A>
<LI><A HREF="../../../runtime/src/WIN32/RTPerfTool.i3#0TOP0">runtime/src/WIN32/RTPerfTool.i3</A>
</UL>
<P>
<HR>
<A NAME="x6">interface Unix is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Unix.i3#0TOP0">unix/src/aix-3-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Unix.i3#0TOP0">unix/src/aix-ps2-1-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Unix.i3#0TOP0">unix/src/freebsd-1/Unix.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Unix.i3#0TOP0">unix/src/freebsd-2/Unix.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Unix.i3#0TOP0">unix/src/hpux-7-0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Unix.i3#0TOP0">unix/src/ibm-4-3/Unix.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Unix.i3#0TOP0">unix/src/irix-5.2/Unix.i3</A>
<LI><A HREF="../../../unix/src/linux/Unix.i3#0TOP0">unix/src/linux/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Unix.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Unix.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Unix.i3#0TOP0">unix/src/osf-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Unix.i3#0TOP0">unix/src/solaris-2-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Unix.i3#0TOP0">unix/src/sunos-4-x/Unix.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Unix.i3#0TOP0">unix/src/sysv-4.0/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Unix.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Unix.i3#0TOP0">unix/src/ultrix-3-1.ARM/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Unix.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Unix.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Unix.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Unix.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Unix.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Unix.i3#0TOP0">unix/src/ultrix-3-1.VAX/Unix.i3</A>
</UL>
<P>
<HR>
<A NAME="x7">interface Usignal is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Usignal.i3#0TOP0">unix/src/aix-3-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Usignal.i3#0TOP0">unix/src/aix-ps2-1-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Usignal.i3#0TOP0">unix/src/freebsd-1/Usignal.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Usignal.i3#0TOP0">unix/src/freebsd-2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Usignal.i3#0TOP0">unix/src/hpux-7-0/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Usignal.i3#0TOP0">unix/src/ibm-4-3/Usignal.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Usignal.i3#0TOP0">unix/src/irix-5.2/Usignal.i3</A>
<LI><A HREF="../../../unix/src/linux/Usignal.i3#0TOP0">unix/src/linux/Usignal.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Usignal.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Usignal.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Usignal.i3#0TOP0">unix/src/osf-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Usignal.i3#0TOP0">unix/src/solaris-2-x/Usignal.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Usignal.i3#0TOP0">unix/src/sunos-4-x/Usignal.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Usignal.i3#0TOP0">unix/src/sysv-4.0/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.AP3000/Usignal.i3#0TOP0">unix/src/ultrix-3-1.AP3000/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.ARM/Usignal.i3#0TOP0">unix/src/ultrix-3-1.ARM/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.DS3100/Usignal.i3#0TOP0">unix/src/ultrix-3-1.DS3100/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.NEXT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.NEXT/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SEQUENT/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SEQUENT/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN3/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN3/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.SUN386/Usignal.i3#0TOP0">unix/src/ultrix-3-1.SUN386/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.UMAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.UMAX/Usignal.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.VAX/Usignal.i3#0TOP0">unix/src/ultrix-3-1.VAX/Usignal.i3</A>
</UL>
<P>
<HR>
<A NAME="x8">interface Utime is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Utime.i3#0TOP0">unix/src/aix-3-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Utime.i3#0TOP0">unix/src/aix-ps2-1-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Utime.i3#0TOP0">unix/src/freebsd-1/Utime.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Utime.i3#0TOP0">unix/src/freebsd-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Utime.i3#0TOP0">unix/src/hpux-7-0/Utime.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Utime.i3#0TOP0">unix/src/ibm-4-3/Utime.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Utime.i3#0TOP0">unix/src/irix-5.2/Utime.i3</A>
<LI><A HREF="../../../unix/src/linux/Utime.i3#0TOP0">unix/src/linux/Utime.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Utime.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utime.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Utime.i3#0TOP0">unix/src/osf-1.DS3100/Utime.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Utime.i3#0TOP0">unix/src/solaris-2-x/Utime.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Utime.i3#0TOP0">unix/src/sunos-4-x/Utime.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Utime.i3#0TOP0">unix/src/sysv-4.0/Utime.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Utime.i3#0TOP0">unix/src/ultrix-3-1.generic/Utime.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
