<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/Common/Date.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/Common/Date.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>Date.T</CODE> is a moment in time, expressed according to the standard
   (Gregorian) calendar, as observed in some time zone.  A
   <CODE>Date.TimeZone</CODE> (or just a time zone) is an object that encapsulates
   the rules for converting from UTC (universal coordinated time,
   sometimes known as Greenwich mean time) to local time within a
   particular jurisdiction, taking into account daylight time when
   appropriate.
   \index{calendar date}
   \index{local time}
   \index{time!local}
   \index{time zone}
   \index{time!zone}
   \index{universal coordinated time}
   \index{time!UTC (universal coordinated time)}
   \index{Greenwich mean time}
   \index{time!Greenwich mean time}
   \index{time!Date interface@{\tt Date} interface}


<P><PRE>INTERFACE <interface><A HREF="#x1">Date</A></interface>;

IMPORT <A HREF="Time.i3">Time</A>;

TYPE
  T = RECORD
    year: CARDINAL; (* e.g., 1992 *)
    month: Month;
    day: [1 .. 31];
    hour: [0 .. 23];
    minute: [0 .. 59];
    second: [0 .. 59];
    offset: INTEGER;
    zone: TEXT;
    weekDay: WeekDay
  END;
  Month = {Jan, Feb, Mar, Apr, May, Jun, Jul,
            Aug, Sep, Oct, Nov, Dec};
  WeekDay = {Sun, Mon, Tue, Wed, Thu, Fri, Sat};
</PRE> A date's <CODE>offset</CODE> field specifies the difference in the readings of
   two clocks, one set to UTC and one set to local time, at the moment
   the date occurred, and thus reflects daylight time when
   appropriate.  This difference is specified in seconds, with
   positive values corresponding to local zones behind (west of) UTC.
   A date's <CODE>zone</CODE> field specifies a name (often a three-letter
   abbreviation) for the time zone in which the date is observed, for
   example, ``PDT'' for Pacific Daylight Time. 

<P><PRE>TYPE <A HREF="#x2">TimeZone</A> &lt;: REFANY;

VAR Local, UTC: TimeZone;
</PRE><BLOCKQUOTE><EM> <CODE>Local</CODE> is initialized to the time zone in which the computer
   running this program is located.  <CODE>UTC</CODE> is initialized to the time
   zone for universal coordinated time.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x3">FromTime</A>(t: Time.T; z: TimeZone := NIL): T;
</PRE><BLOCKQUOTE><EM> Return the date corresponding to <CODE>t</CODE>, as observed in the time zone
   <CODE>z</CODE>. If <CODE>z</CODE> is <CODE>NIL</CODE>, <CODE>Local</CODE> is used. </EM></BLOCKQUOTE><PRE>

EXCEPTION Error;

PROCEDURE <A HREF="#x4">ToTime</A>(READONLY d: T): Time.T RAISES {Error};
</PRE><BLOCKQUOTE><EM> Return the time corresponding to the date <CODE>d</CODE>, using the field
   <CODE>offset</CODE> rather than <CODE>zone</CODE> and ignoring the field <CODE>weekDay</CODE>. Raise
   <CODE>Error</CODE> if <CODE>d</CODE> cannot be represented as a <CODE>Time.T</CODE>. </EM></BLOCKQUOTE><PRE>

END Date.
</PRE> On POSIX systems, <CODE>FromTime(t, Local)</CODE> calls <CODE>localtime(3)</CODE>.  On
   Win32 systems, it calls <CODE>GetTimeZoneInformation</CODE>.  Some systems
   keep local time instead of UTC, and typically don't record the
   identity of the local time zone.  On such a system, <CODE>FromTime(t,
   Local)</CODE> always returns a result with <CODE>offset</CODE> equal to zero and
   <CODE>zone</CODE> equal to {\tt "[Unknown zone]"}, and <CODE>UTC</CODE> is
   <CODE>NIL</CODE>.


</inInterface>
<HR>
<A NAME="x1">Date's implementation  is in:
</A><UL>
<LI><A HREF="../POSIX/DateBsd.m3#0TOP0">time/src/POSIX/DateBsd.m3</A>
<LI><A HREF="../POSIX/DateLinux.m3#0TOP0">time/src/POSIX/DateLinux.m3</A>
<LI><A HREF="../POSIX/DatePosix.m3#0TOP0">time/src/POSIX/DatePosix.m3</A>
<LI><A HREF="../WIN32/DateWin32.m3#0TOP0">time/src/WIN32/DateWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">opaque type Date.TimeZone is in:
</A><UL>
<LI><A HREF="../POSIX/DateBsd.m3#TimeZone">time/src/POSIX/DateBsd.m3</A>
<LI><A HREF="../POSIX/DateLinux.m3#TimeZone">time/src/POSIX/DateLinux.m3</A>
<LI><A HREF="../POSIX/DatePosix.m3#TimeZone">time/src/POSIX/DatePosix.m3</A>
<LI><A HREF="../WIN32/DateWin32.m3#TimeZone">time/src/WIN32/DateWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure Date.FromTime is in:
</A><UL>
<LI><A HREF="../POSIX/DateBsd.m3#FromTime">time/src/POSIX/DateBsd.m3</A>
<LI><A HREF="../POSIX/DateLinux.m3#FromTime">time/src/POSIX/DateLinux.m3</A>
<LI><A HREF="../POSIX/DatePosix.m3#FromTime">time/src/POSIX/DatePosix.m3</A>
<LI><A HREF="../WIN32/DateWin32.m3#FromTime">time/src/WIN32/DateWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Date.ToTime is in:
</A><UL>
<LI><A HREF="../POSIX/DateBsd.m3#ToTime">time/src/POSIX/DateBsd.m3</A>
<LI><A HREF="../POSIX/DateLinux.m3#ToTime">time/src/POSIX/DateLinux.m3</A>
<LI><A HREF="../POSIX/DatePosix.m3#ToTime">time/src/POSIX/DatePosix.m3</A>
<LI><A HREF="../WIN32/DateWin32.m3#ToTime">time/src/WIN32/DateWin32.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
