<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/Common/FmtTime.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/Common/FmtTime.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> <CODE>FmtTime</CODE> is an interface for formatting dates and times like
   the default format of the Unix date(1) command. 

<P><PRE>INTERFACE <interface><A HREF="FmtTime.m3">FmtTime</A></interface>;

IMPORT <A HREF="Date.i3">Date</A>, <A HREF="Time.i3">Time</A>;

PROCEDURE <A HREF="FmtTime.m3#Long">Long</A>(t: Time.T; z: Date.TimeZone := NIL): TEXT;
</PRE><BLOCKQUOTE><EM> Equivalent to <CODE>RETURN DateLong(Date.FromTime(t, z))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FmtTime.m3#Short">Short</A>(t: Time.T; z: Date.TimeZone := NIL): TEXT;
</PRE><BLOCKQUOTE><EM> Equivalent to <CODE>RETURN DateShort(Date.FromTime(t, z))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FmtTime.m3#DateLong">DateLong</A>(READONLY d: Date.T): TEXT;
</PRE><BLOCKQUOTE><EM> Return a string of the form: <CODE>DDD MMM dd hh:mm:ss zzz yyyy</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="FmtTime.m3#DateShort">DateShort</A>(READONLY d: Date.T): TEXT;
</PRE><BLOCKQUOTE><EM> Return a string of the form: <CODE>MMM dd hh:mm</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>d</CODE> is a date, the components of the values returned by
   <CODE>Long(d)</CODE> and <CODE>Short(d)</CODE> are defined as follows:
<P>
<PRE>
      DDD <KBD>is</KBD> WeekDay[d.weekDay]
      MMM <KBD>is</KBD> Month[d.month]
      dd  <KBD>is</KBD> Fmt.Pad(Fmt.Int(d.day), 2)
      hh  <KBD>is</KBD> Fmt.Pad(Fmt.Int(d.hour), 2, '0')
      mm  <KBD>is</KBD> Fmt.Pad(Fmt.Int(d.minute), 2, '0')
      ss  <KBD>is</KBD> Fmt.Pad(Fmt.Int(d.second), 2, '0')
      zz  <KBD>is</KBD> d.zone
      yyyy <KBD>is</KBD> Fmt.Pad(Fmt.Int(d.year), 4)
</PRE>


<P><PRE>CONST
  Month = ARRAY Date.Month OF TEXT {
    &quot;Jan&quot;, &quot;Feb&quot;, &quot;Mar&quot;, &quot;Apr&quot;, &quot;May&quot;, &quot;Jun&quot;,
    &quot;Jul&quot;, &quot;Aug&quot;, &quot;Sep&quot;, &quot;Oct&quot;, &quot;Nov&quot;, &quot;Dec&quot;};
  WeekDay = ARRAY Date.WeekDay OF TEXT {
    &quot;Sun&quot;, &quot;Mon&quot;, &quot;Tue&quot;, &quot;Wed&quot;, &quot;Thu&quot;, &quot;Fri&quot;, &quot;Sat&quot;};

END FmtTime.
</PRE> To print the current date and time, as observed in the local time
   zone, write
<P>
<PRE>
       IO.Put(&quot;The time is &quot; &amp; FmtTime.Long(Time.Now()) &amp; &quot;\n&quot;)
</PRE>


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
