<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/Common/FmtTime.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/Common/FmtTime.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="FmtTime.i3">FmtTime</A></implements></module>;

IMPORT <A HREF="Date.i3">Date</A>, <A HREF="Time.i3">Time</A>, <A HREF="../../../convert/src/Convert.i3">Convert</A>, <A HREF="../../../text/src/Text.i3">Text</A>;

CONST
  MaxBuf = 4  (* WeekDay *)
         + 4  (* Month *)
         + 3  (* date *)
         + 3  (* hour *)
         + 3  (* minutes *)
         + 3  (* seconds *)
         + 40 (* time zone *)
         + 5  (* year *)
         ;

TYPE
  Buffer = RECORD
    len: INTEGER;
    buf: ARRAY [0..MaxBuf] OF CHAR;
  END;

PROCEDURE <A NAME="Long"><procedure>Long</procedure></A>(t: Time.T; z: Date.TimeZone := NIL): TEXT =
  BEGIN
    RETURN DateLong(Date.FromTime(t, z))
  END Long;

PROCEDURE <A NAME="Short"><procedure>Short</procedure></A>(t: Time.T; z: Date.TimeZone := NIL): TEXT =
  BEGIN
    RETURN DateShort(Date.FromTime(t, z))
  END Short;

PROCEDURE <A NAME="DateLong"><procedure>DateLong</procedure></A>(READONLY d: Date.T): TEXT =
  VAR b: Buffer;
  BEGIN
    b.len := 0;
    AddText (b, WeekDay[d.weekDay]);
    AddText (b, Month[d.month]);
    AddInt  (b, d.day,    2, ' ', ' ');
    AddInt  (b, d.hour,   2, '0', ':');
    AddInt  (b, d.minute, 2, '0', ':');
    AddInt  (b, d.second, 2, '0', ' ');
    AddText (b, d.zone);
    AddInt  (b, d.year,   4, ' ', ' ');
    RETURN Text.FromChars (SUBARRAY (b.buf, 0, b.len-1));
  END DateLong;

PROCEDURE <A NAME="DateShort"><procedure>DateShort</procedure></A>(READONLY d: Date.T): TEXT =
  VAR b: Buffer;
  BEGIN
    b.len := 0;
    AddText (b, Month[d.month]);
    AddInt  (b, d.day,    2, ' ', ' ');
    AddInt  (b, d.hour,   2, '0', ':');
    AddInt  (b, d.minute, 2, '0', ' ');
    RETURN Text.FromChars (SUBARRAY (b.buf, 0, b.len-1));
  END DateShort;

PROCEDURE <A NAME="AddText"><procedure>AddText</procedure></A> (VAR b: Buffer;  txt: TEXT) =
  BEGIN
    Text.SetChars (SUBARRAY (b.buf, b.len, NUMBER (b.buf) - b.len), txt);
    INC (b.len, Text.Length (txt));
    b.buf[b.len] := ' ';  INC (b.len);
  END AddText;

PROCEDURE <A NAME="AddInt"><procedure>AddInt</procedure></A> (VAR b: Buffer;  value, width: INTEGER;  pre, post: CHAR) =
  &lt;*FATAL Convert.Failed*&gt;
  VAR
    buf : ARRAY [0..BITSIZE(INTEGER)] OF CHAR;
    len := Convert.FromInt (buf, value);
  BEGIN
    WHILE (width &gt; len) DO
      b.buf[b.len] := pre;  INC (b.len);
      DEC (width);
    END;
    FOR i := 0 TO len-1 DO
      b.buf[b.len] := buf[i];  INC (b.len);
    END;
    b.buf[b.len] := post;  INC (b.len);
  END AddInt;

BEGIN
END FmtTime.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
