<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/Common/Tick.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/Common/Tick.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> A <CODE>Tick.T</CODE> represents a value of a clock with subsecond resolution.
   The exact resolution differs from implementation to implementation
   and is typically one sixtieth of a second or smaller.
   \index{time!elapsed}
   \index{elapsed time}
   \index{time!Tick interface@{\tt Tick} interface}


<P><PRE>INTERFACE <interface><A HREF="#x1">Tick</A></interface>;

IMPORT <A HREF="../../../word/src/Word.i3">Word</A>;

TYPE T = Word.T;

PROCEDURE <A HREF="#x2">Now</A>(): T;
</PRE><BLOCKQUOTE><EM> Return the current reading of the tick clock. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="#x3">ToSeconds</A>(t: Word.T): LONGREAL;
</PRE><BLOCKQUOTE><EM> Return the number of seconds in <CODE>t</CODE> ticks. </EM></BLOCKQUOTE><PRE>

EXCEPTION Overflow;

PROCEDURE <A HREF="#x4">FromSeconds</A>(s: LONGREAL): Word.T RAISES {Overflow};
</PRE><BLOCKQUOTE><EM> Return the number of ticks equivalent to <CODE>s</CODE> seconds, rounded to
   the nearest whole number, or raise <CODE>Overflow</CODE> if <CODE>s</CODE> is negative or
   the result would not be less than <CODE>2^Word.Size</CODE>.  </EM></BLOCKQUOTE><PRE>

END Tick.
</PRE> If <CODE>t0</CODE> is a reading of the tick clock and <CODE>t1</CODE> is another reading
   taken less than $\hbox<CODE>2</CODE>^{\hbox<CODE>Word.Size</CODE>}$ ticks after <CODE>t0</CODE>,
   then the number of ticks between <CODE>t0</CODE> and <CODE>t1</CODE> is <CODE>Word.Minus(t1,
   t0)</CODE>.
<P>
   The values returned by <CODE>Tick.Now()</CODE> and <CODE>Time.Now()</CODE> typically
   won't stay synchronized for long periods of time.  The purpose of
   <CODE>Tick.Now()</CODE> is to provide accurate measurements of short
   intervals.  The purpose of <CODE>Time.Now()</CODE> is to provide ``wall
   clock'' time, preferably synchronized with UTC (coordinated
   universal time).
<P>


</inInterface>
<HR>
<A NAME="x1">Tick's implementation  is in:
</A><UL>
<LI><A HREF="../POSIX/TickPosix.m3#0TOP0">time/src/POSIX/TickPosix.m3</A>
<LI><A HREF="../Portable/TickPortable.m3#0TOP0">time/src/Portable/TickPortable.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Tick.Now is in:
</A><UL>
<LI><A HREF="../POSIX/TickPosix.m3#Now">time/src/POSIX/TickPosix.m3</A>
<LI><A HREF="../Portable/TickPortable.m3#Now">time/src/Portable/TickPortable.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure Tick.ToSeconds is in:
</A><UL>
<LI><A HREF="../POSIX/TickPosix.m3#ToSeconds">time/src/POSIX/TickPosix.m3</A>
<LI><A HREF="../Portable/TickPortable.m3#ToSeconds">time/src/Portable/TickPortable.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure Tick.FromSeconds is in:
</A><UL>
<LI><A HREF="../POSIX/TickPosix.m3#FromSeconds">time/src/POSIX/TickPosix.m3</A>
<LI><A HREF="../Portable/TickPortable.m3#FromSeconds">time/src/Portable/TickPortable.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
