<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/Common/Time.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/Common/Time.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>      Modified on Thu Oct 11 22:04:09 1990 by muller </EM></BLOCKQUOTE><PRE>
</PRE> Based on the Modula-2+ Time.def, designed by Roy Levin. 

<P> A <CODE>Time.T</CODE> represents a moment in time, reckoned as a number of
   seconds since some epoch or starting point.
   \index{time!of day}
   \index{time!Time interface@{\tt Time} interface}


<P><PRE>INTERFACE <interface><A HREF="#x1">Time</A></interface>;

TYPE T = LONGREAL;

PROCEDURE <A HREF="#x2">Now</A>(): T;
</PRE><BLOCKQUOTE><EM> Return the current moment in time. </EM></BLOCKQUOTE><PRE>

VAR (*CONST*) Grain: LONGREAL;
</PRE><BLOCKQUOTE><EM> If a thread performs <CODE>t0 := Time.Now(); t1 := Time.Now()</CODE>, then
   either <CODE>t1 = t0</CODE> or <CODE>t1 &gt;= t0 + Time.Grain</CODE>.  <CODE>Grain</CODE> always lies
   in the half-open interval <CODE>(0..1]</CODE> and is usually no larger than
   one sixtieth of a second.  </EM></BLOCKQUOTE><PRE>

END Time.
</PRE> There are a variety of timekeeping needs, and <CODE>Time.Now</CODE> may not
   satisfy all of them.  It is intended to be useful for recording times
   and measuring intervals arising during the execution of computer
   programs with a resolution comparable to human reaction times.
<P>
   The epoch for a <CODE>Time.T</CODE> varies from one operating system to
   another.  To determine the epoch, call <CODE>Date.FromTime(0.0D0,
   Date.UTC)</CODE>.  Note that communicating a <CODE>Time.T</CODE> between systems,
   say via remote procedure call or pickles, is likely to be a bad
   idea.
   \index{epoch}
<P>
   In many computers, <CODE>Time.Now</CODE> is implemented with the technology 
   of an inexpensive wristwatch, and is therefore likely to suffer 
   from similar errors: the rate may vary, and the value may be changed 
   by a human operator. 
<P>
   The <CODE>Thread</CODE> interface contains procedures that delay the execution
   of the calling thread for a specified duration.  The <CODE>Tick</CODE>
   interface provides access to a clock with subsecond resolution.
<P>


</inInterface>
<HR>
<A NAME="x1">Time's implementation  is in:
</A><UL>
<LI><A HREF="../POSIX/TimePosix.m3#0TOP0">time/src/POSIX/TimePosix.m3</A>
<LI><A HREF="../WIN32/TimeWin32.m3#0TOP0">time/src/WIN32/TimeWin32.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">procedure Time.Now is in:
</A><UL>
<LI><A HREF="../POSIX/TimePosix.m3#Now">time/src/POSIX/TimePosix.m3</A>
<LI><A HREF="../WIN32/TimeWin32.m3#Now">time/src/WIN32/TimeWin32.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
