<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/POSIX/DateLinux.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/POSIX/DateLinux.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                          </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>DateLinux</module> EXPORTS <A HREF="../Common/Date.i3"><implements>Date</A></implements>;

IMPORT <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../Common/Time.i3">Time</A>, <A HREF="#x1">Utime</A>, <A HREF="TimePosix.i3">TimePosix</A>;

VAR mu := NEW(Thread.Mutex);
</PRE><BLOCKQUOTE><EM> Protect the static storage used by <CODE>Utime.localtime</CODE> and <CODE>Utime.gmtime</CODE>
   (see the localtime(3) manpage). </EM></BLOCKQUOTE><PRE>

REVEAL <A NAME="TimeZone">TimeZone</A> = BRANDED &quot;Date.TimeZone&quot; REF INTEGER;

CONST Unknown = &quot;[Unknown zone]&quot;;

PROCEDURE <A NAME="FromTime"><procedure>FromTime</procedure></A>(t: Time.T; z: TimeZone := NIL): T =
  VAR
    date : T;
    tv   : Utime.struct_timeval;
    tm   : Utime.struct_tm_star;
  BEGIN
    tv := TimePosix.ToUtime(t);
    LOCK mu DO
      IF (z = NIL) OR (z^ = 0)
        THEN tm := Utime.localtime(ADR(tv.tv_sec));
        ELSE tm := Utime.gmtime(ADR(tv.tv_sec));
      END;
      date.year    := tm.tm_year + 1900;
      date.month   := VAL(tm.tm_mon, Month);
      date.day     := tm.tm_mday;
      date.hour    := tm.tm_hour;
      date.minute  := tm.tm_min;
      date.second  := tm.tm_sec;
      date.weekDay := VAL(tm.tm_wday, WeekDay);
      date.offset  := 0; (* Linux doesn't support time zones yet... *)
      date.zone    := Unknown;
    END;
    RETURN date;
  END FromTime;

PROCEDURE <A NAME="ToTime"><procedure>ToTime</procedure></A>(READONLY d: T): Time.T RAISES {Error} =
  VAR
    tm: Utime.struct_tm;
    time: Utime.time_t;
    t: Time.T;
  BEGIN
    tm.tm_sec    := d.second;
    tm.tm_min    := d.minute;
    tm.tm_hour   := d.hour;
    tm.tm_mday   := d.day;
    tm.tm_mon    := ORD(d.month);
    tm.tm_year   := d.year - 1900;
    (* tm.tm_wday ignored *)
    tm.tm_isdst  := 0; (* tell mktime that DST is not in effect *)
    time := Utime.mktime(ADR(tm));
    IF time = -1 THEN RAISE Error END;
    t := FLOAT(time, LONGREAL);
    RETURN t;
  END ToTime;

BEGIN
  Local := NEW(TimeZone);  Local^ := 0;
  UTC   := NEW(TimeZone);  UTC^   := 1;
END DateLinux.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Utime is in:
</A><UL>
<LI><A HREF="../../../unix/src/aix-3-2/Utime.i3#0TOP0">unix/src/aix-3-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/aix-ps2-1-2/Utime.i3#0TOP0">unix/src/aix-ps2-1-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/freebsd-1/Utime.i3#0TOP0">unix/src/freebsd-1/Utime.i3</A>
<LI><A HREF="../../../unix/src/freebsd-2/Utime.i3#0TOP0">unix/src/freebsd-2/Utime.i3</A>
<LI><A HREF="../../../unix/src/hpux-7-0/Utime.i3#0TOP0">unix/src/hpux-7-0/Utime.i3</A>
<LI><A HREF="../../../unix/src/ibm-4-3/Utime.i3#0TOP0">unix/src/ibm-4-3/Utime.i3</A>
<LI><A HREF="../../../unix/src/irix-5.2/Utime.i3#0TOP0">unix/src/irix-5.2/Utime.i3</A>
<LI><A HREF="../../../unix/src/linux/Utime.i3#0TOP0">unix/src/linux/Utime.i3</A>
<LI><A HREF="../../../unix/src/osf-1.ALPHA_OSF/Utime.i3#0TOP0">unix/src/osf-1.ALPHA_OSF/Utime.i3</A>
<LI><A HREF="../../../unix/src/osf-1.DS3100/Utime.i3#0TOP0">unix/src/osf-1.DS3100/Utime.i3</A>
<LI><A HREF="../../../unix/src/solaris-2-x/Utime.i3#0TOP0">unix/src/solaris-2-x/Utime.i3</A>
<LI><A HREF="../../../unix/src/sunos-4-x/Utime.i3#0TOP0">unix/src/sunos-4-x/Utime.i3</A>
<LI><A HREF="../../../unix/src/sysv-4.0/Utime.i3#0TOP0">unix/src/sysv-4.0/Utime.i3</A>
<LI><A HREF="../../../unix/src/ultrix-3-1.generic/Utime.i3#0TOP0">unix/src/ultrix-3-1.generic/Utime.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
