<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/Portable/TickPortable.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/Portable/TickPortable.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module>TickPortable</module> EXPORTS <A HREF="../Common/Tick.i3"><implements>Tick</A></implements>;
</PRE> This implementation works in terms of the <CODE>Time</CODE> interface.
   <CODE>SecondsPerTick</CODE> is defined as <CODE>Time.Grain</CODE>. 

<P><PRE>IMPORT <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../Common/Time.i3">Time</A>;

TYPE
  TickRange  = [-16_7fffffff-1 .. 16_7fffffff]; (* 32-bit ticks *)
CONST
  IntModulus = FLOAT(LAST(TickRange), LONGREAL) + 1.0D0;
  WordModulus = 2.0D0 * IntModulus;
  IntModulusAsWord = Word.Plus(LAST(TickRange), 1);

VAR (*CONST*) SecondsPerTick: LONGREAL;

PROCEDURE <A NAME="Now"><procedure>Now</procedure></A>(): T=
  VAR t: LONGREAL := Time.Now() / SecondsPerTick MOD WordModulus;
  BEGIN
    IF t &lt; IntModulus THEN
      RETURN TRUNC(t)
    ELSE
      RETURN Word.Plus(IntModulusAsWord, TRUNC(t-IntModulus))
    END
  END Now;

PROCEDURE <A NAME="ToSeconds"><procedure>ToSeconds</procedure></A>(t: Word.T): LONGREAL=
  BEGIN
    IF Word.LT(t, IntModulusAsWord) THEN
      RETURN FLOAT(t, LONGREAL) * SecondsPerTick
    ELSE
      RETURN (FLOAT(Word.Minus(t, IntModulusAsWord), LONGREAL) + IntModulus)
             * SecondsPerTick
    END
  END ToSeconds;

PROCEDURE <A NAME="FromSeconds"><procedure>FromSeconds</procedure></A>(s: LONGREAL): Word.T RAISES {Overflow}=
  BEGIN
    WITH d = s / SecondsPerTick DO
      IF d &lt; IntModulus THEN
        RETURN TRUNC(d)
      ELSIF d &lt; WordModulus THEN
        RETURN Word.Plus(IntModulusAsWord, TRUNC(d-IntModulus))
      ELSE
        RAISE Overflow
      END
    END
  END FromSeconds;

BEGIN
  SecondsPerTick := Time.Grain;
END TickPortable.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
