<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/WIN32/DateWin32.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/WIN32/DateWin32.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                          </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>DateWin32</module> EXPORTS <A HREF="../Common/Date.i3"><implements>Date</A></implements>;

IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../Common/Time.i3">Time</A>;
IMPORT <A HREF="../../../win32/src/WinDef.i3">WinDef</A>, <A HREF="../../../win32/src/WinBase.i3">WinBase</A>, <A HREF="../../../win32/src/WinNT.i3">WinNT</A>, <A HREF="TimeWin32.i3">TimeWin32</A>;

REVEAL <A NAME="TimeZone">TimeZone</A> = BRANDED OBJECT METHODS fromTime(t: Time.T): T END;

PROCEDURE <A NAME="FromTimeLocal"><procedure>FromTimeLocal</procedure></A>(&lt;*UNUSED*&gt; z: TimeZone; t: Time.T): T =
  VAR
    ft, lft: WinBase.FILETIME;
    st: WinBase.SYSTEMTIME;
    d: T;
    tz: WinBase.TIME_ZONE_INFORMATION;
    tzrc: WinDef.DWORD;
    status: INTEGER;
  BEGIN
    ft := TimeWin32.ToFileTime(t);
    status := WinBase.FileTimeToLocalFileTime(ADR(ft), ADR(lft));
    &lt;*ASSERT status # 0*&gt;
    status := WinBase.FileTimeToSystemTime(ADR(lft), ADR(st));
    &lt;*ASSERT status # 0*&gt;
    d := FromSystemTime(st);
    d.offset := ROUND(t - TimeWin32.FromFileTime(lft));
    tzrc := WinBase.GetTimeZoneInformation(ADR(tz));
    &lt;*ASSERT tzrc # -1 *&gt;
    CASE tzrc OF &lt;*NOWARN*&gt;
    | 0 (* TIME_ZONE_ID_UNKNOWN *) =&gt;
        d.zone := &quot;\&quot;Unknown zone\&quot;&quot;;
    | 1 (* TIME_ZONE_ID_STANDARD *) =&gt;
        d.zone := CopyTimeZoneName(tz.StandardName);
    | 2 (* TIME_ZONE_ID_DAYLIGHT *) =&gt;
        d.zone := CopyTimeZoneName(tz.DaylightName);
    END;
    RETURN d;
  END FromTimeLocal;

PROCEDURE <A NAME="CopyTimeZoneName"><procedure>CopyTimeZoneName</procedure></A>(
    READONLY name: ARRAY [0 .. 31] OF WinNT.WCHAR): TEXT=
  VAR chars: ARRAY [0..31] OF CHAR; j := 0;
  BEGIN
    FOR i := 0 TO LAST(name) DO
      WITH char = VAL(name[i], CHAR) DO
        IF char = '\000' THEN EXIT
        ELSE
          chars[j] := char; INC(j);
        END;
      END;
    END;
    RETURN Text.FromChars(SUBARRAY(chars, 0, j));
  END CopyTimeZoneName;

PROCEDURE <A NAME="FromTimeUTC"><procedure>FromTimeUTC</procedure></A>(&lt;*UNUSED*&gt; z: TimeZone; t: Time.T): T =
  VAR d: T; st: WinBase.SYSTEMTIME; ft: WinBase.FILETIME;  status: INTEGER;
  BEGIN
    ft := TimeWin32.ToFileTime(t);
    status := WinBase.FileTimeToSystemTime(ADR(ft), ADR(st));
    &lt;*ASSERT status # 0 *&gt;
    d := FromSystemTime(st);
    d.offset := 0;
    d.zone := &quot;UT&quot;;
    RETURN d
  END FromTimeUTC;

PROCEDURE <A NAME="FromSystemTime"><procedure>FromSystemTime</procedure></A>(st: WinBase.SYSTEMTIME): T =
</PRE><BLOCKQUOTE><EM> Set all fields of <CODE>d</CODE> except <CODE>offset</CODE> and <CODE>zone</CODE>, from <CODE>st</CODE>. </EM></BLOCKQUOTE><PRE>
  VAR d: T;
  BEGIN
    d.year := st.wYear;
    d.month := VAL(st.wMonth-1, Month);
    d.day := st.wDay;
    d.hour := st.wHour;
    d.minute := st.wMinute;
    d.second := st.wSecond;
    d.weekDay := VAL(st.wDayOfWeek, WeekDay);
    RETURN d
  END FromSystemTime;

PROCEDURE <A NAME="FromTime"><procedure>FromTime</procedure></A>(t: Time.T; z: TimeZone := NIL): T =
  BEGIN
    IF z = NIL THEN z := Local END;
    RETURN z.fromTime(t)
  END FromTime;

PROCEDURE <A NAME="ToTime"><procedure>ToTime</procedure></A>(READONLY d: T): Time.T =
  VAR
    st: WinBase.SYSTEMTIME;
    ft: WinBase.FILETIME;
    t: Time.T;
    status: INTEGER;
  BEGIN
    st.wYear := d.year;
    st.wMonth := ORD(d.month)+1;
    (* st.wDayOfWeek ignored *)
    st.wDay := d.day;
    st.wHour := d.hour;
    st.wMinute := d.minute;
    st.wSecond := d.second;
    st.wMilliseconds := 0;
    status := WinBase.SystemTimeToFileTime(ADR(st), ADR(ft));
    &lt;*ASSERT status # 0*&gt;
    t := TimeWin32.FromFileTime(ft);
    RETURN t + FLOAT(d.offset, LONGREAL)
  END ToTime;

BEGIN
  Local := NEW(TimeZone, fromTime := FromTimeLocal);
  UTC := NEW(TimeZone, fromTime := FromTimeUTC)
END DateWin32.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
