<HTML>
<HEAD>
<TITLE>SRC Modula-3: time/src/WIN32/TimeWin32.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>time/src/WIN32/TimeWin32.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>TimeWin32</module> EXPORTS <A HREF="../Common/Time.i3"><implements>Time</A></implements>, <A HREF="TimeWin32.i3"><implements>TimeWin32</A></implements>;

IMPORT <A HREF="../../../win32/src/WinBase.i3">WinBase</A>, <A HREF="../../../word/src/Word.i3">Word</A>;
IMPORT <A HREF="../Common/Time.i3">Time</A>;

CONST
  H = FLOAT(LAST(INTEGER), LONGREAL) + 1.0d0;
  H2 = 2.0d0 * H;
  I = Word.Plus(LAST(INTEGER), 1);

PROCEDURE <A NAME="ToFileTime"><procedure>ToFileTime</procedure></A>(n: Time.T): WinBase.FILETIME=
  VAR low: LONGREAL;
    fileTime: WinBase.FILETIME;
  BEGIN
    n := n * 1.0D7;
    fileTime.dwHighDateTime := TRUNC(n/H2);
    low := n - FLOAT(fileTime.dwHighDateTime, LONGREAL) * H2;
    IF low &gt;= H THEN
      fileTime.dwLowDateTime := Word.Plus(ROUND(low - H), I);
    ELSE
       fileTime.dwLowDateTime := ROUND(low)
    END;
    RETURN fileTime;
  END ToFileTime;

PROCEDURE <A NAME="FromFileTime"><procedure>FromFileTime</procedure></A> (fileTime: WinBase.FILETIME): Time.T =
  VAR low, high: LONGREAL;
  BEGIN
    IF fileTime.dwLowDateTime &lt; 0 THEN
      low := H + FLOAT(Word.And(fileTime.dwLowDateTime, LAST(INTEGER)),
                       LONGREAL);
    ELSE
      low := FLOAT(fileTime.dwLowDateTime, LONGREAL);
    END;
    high := FLOAT(fileTime.dwHighDateTime, LONGREAL) * H2;
    RETURN (low + high) / 1.0D7;
  END FromFileTime;

PROCEDURE <A NAME="Now"><procedure>Now</procedure></A>(): T=
  VAR
    systemTime: WinBase.SYSTEMTIME;
    fileTime: WinBase.FILETIME;
    status: INTEGER;
  BEGIN
    WinBase.GetSystemTime(ADR(systemTime));
    status := WinBase.SystemTimeToFileTime(ADR(systemTime), ADR(fileTime));
    &lt;*ASSERT status # 0*&gt;
    RETURN FromFileTime(fileTime);
  END Now;

VAR t0, t1: T;
BEGIN
  (* Determine value of &quot;Grain&quot; experimentally.  Note that
     this will fail if this thread is descheduled for a tick during the
     loop below. *)
  (* Grain := 0.0075D0
     SCG - 21 Sep. 93 - This does have problems, use experimental value
     From WindowsNT 3.1 (final) release running on DEC 466ST (486 based)
     SCG - 22 Sep. 93 - Turns out the problem was in Now() - try again
  *)
  t0 := Now();
  REPEAT t1 := Now() UNTIL t1 # t0;
  Grain := t1-t0
END TimeWin32.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
