<HTML>
<HEAD>
<TITLE>SRC Modula-3: trestle_by_example/src/checkbox/Checkbox.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>trestle_by_example/src/checkbox/Checkbox.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>Checkbox</module> EXPORTS <A HREF="../../../main/src/Main.i3"><implements>Main</A></implements>;

IMPORT <A HREF="../../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../../ui/src/split/RigidVBT.i3">RigidVBT</A>, <A HREF="../../../lego/src/Shadow.i3">Shadow</A>, <A HREF="../../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../../lego/src/BooleanVBT.i3">BooleanVBT</A>;
IMPORT <A HREF="../../../lego/src/SwitchVBT.i3">SwitchVBT</A>, <A HREF="../../../lego/src/BiFeedbackVBT.i3">BiFeedbackVBT</A>, <A HREF="../../../lego/src/ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>, <A HREF="../../../lego/src/MarginFeedbackVBT.i3">MarginFeedbackVBT</A>;
FROM <A HREF="../common/Colors.i3">Colors</A> IMPORT lblue, dblue;

CONST
  shsize  = 8.0;                 (* shadow size in points *)
  times14 = &quot;-*-times-*-r-*-*-14-*-*-*-*-*-*-*&quot;;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (v: BooleanVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    IF BooleanVBT.Get(v) THEN
      TextVBT.Put(text, &quot;Uncheck&quot;);
    ELSE
      TextVBT.Put(text, &quot;Check&quot;);
    END;
  END Check;

VAR
  font   := Font.FromName(ARRAY OF TEXT{times14});
  sh     := Shadow.New(size := shsize, light := lblue, dark := dblue);
  text   := TextVBT.New(&quot; Check &quot;, fnt := font);
  v      := RigidVBT.FromHV(text, 20.0, 10.0);
  sfb    := NEW(ShadowedFeedbackVBT.T).init(ch := v, shadow := sh);
  mfb    := MarginFeedbackVBT.NewBox(ch := sfb);
  bfb    := NEW(BiFeedbackVBT.T).init(ch := mfb);
  switch := NEW(SwitchVBT.T).init(bfb);
  main   := NEW(BooleanVBT.T, callback := Check).init(switch);
BEGIN
  Trestle.Install(main);
  Trestle.AwaitDelete(main)
END Checkbox.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
