<HTML>
<HEAD>
<TITLE>SRC Modula-3: trestle_by_example/src/confirm/Confirm.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>trestle_by_example/src/confirm/Confirm.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>Confirm</module> EXPORTS <A HREF="../../../main/src/Main.i3"><implements>Main</A></implements>;

IMPORT <A HREF="../../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../../ui/src/split/RigidVBT.i3">RigidVBT</A>, <A HREF="../../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../../ui/src/split/HVSplit.i3">HVSplit</A>;
IMPORT <A HREF="../../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>;
IMPORT <A HREF="ConfirmVBT.i3">ConfirmVBT</A>;

PROCEDURE <A NAME="Yes"><procedure>Yes</procedure></A> (self: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    Trestle.Delete(main);
  END Yes;

PROCEDURE <A NAME="QuitAction"><procedure>QuitAction</procedure></A> (self: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  VAR
    msg     := &quot;Do you really wish to quit?&quot;;
    confirm := ConfirmVBT.New(msg, Yes);
  BEGIN
    Trestle.Install(confirm)
  END QuitAction;

CONST
  (* sizes for the RigidVBT *)
  horz = 30.0;
  vert = 10.0;                   (* size in millimeters *)
  (* border size for text and button *)
  bsize = 1.5;                   (* size in millimeters *)

VAR
  blue  := PaintOp.FromRGB(0.0, 0.0, 1.0);
  green := PaintOp.FromRGB(0.0, 1.0, 0.0);
  text  := RigidVBT.FromHV(TextVBT.New(&quot;Confirm demo&quot;), horz, vert);
  top := BorderedVBT.New(
           text, size := bsize, op := blue, txt := Pixmap.Solid);
  button := ButtonVBT.New(TextVBT.New(&quot;Quit&quot;), QuitAction);
  bottom := BorderedVBT.New(
              button, size := bsize, op := green, txt := Pixmap.Gray);
  main := HVSplit.Cons(Axis.T.Ver, top, bottom);

BEGIN
  Trestle.Install(main);
  Trestle.AwaitDelete(main)
END Confirm.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
