<HTML>
<HEAD>
<TITLE>SRC Modula-3: trestle_by_example/src/confirm/ConfirmVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>trestle_by_example/src/confirm/ConfirmVBT.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="ConfirmVBT.i3">ConfirmVBT</A></implements></module>;

IMPORT <A HREF="../../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../../ui/src/split/Split.i3">Split</A>;
IMPORT <A HREF="../../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>;

CONST
  bsize1 = 5.0;                  (* Border Size in millimeters *)
  bsize2 = 1.5;                  (* Border Size in millimeters *)
</PRE> Delete the dialog box under the assumption it has been installed. 
<PRE>PROCEDURE <A NAME="DeleteDialog"><procedure>DeleteDialog</procedure></A> (v: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    Trestle.Delete(VBT.Parent(VBT.Parent(VBT.Parent(VBT.Parent(v)))));
  END DeleteDialog;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self   : T;
                message: TEXT;
                yaction         := DeleteDialog;
                caction         := DeleteDialog  ): T =
  VAR
    red := PaintOp.FromRGB(1.0, 0.0, 0.0);
    ch0 := BorderedVBT.New(TextVBT.New(message), size := bsize1,
                           txt := Pixmap.Solid, op := PaintOp.Bg);
    split := HVSplit.Cons(
               Axis.T.Hor,
               BorderedVBT.New(ButtonVBT.New(TextVBT.New(&quot;Yes&quot;), yaction)),
               BorderedVBT.New(
                 ButtonVBT.New(TextVBT.New(&quot;Cancel&quot;), caction)));
    ch1 := BorderedVBT.New(
             split, size := bsize2, op := red, txt := Pixmap.Solid);
  BEGIN
    EVAL HVSplit.T.init(self, Axis.T.Ver);
    Split.AddChild(self, ch0, ch1);
    RETURN self;
  END Init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (message: TEXT;
               yaction         := DeleteDialog;
               caction         := DeleteDialog  ): T =
  BEGIN
    RETURN Init(NEW(T), message, yaction, caction)
  END New;

BEGIN
END ConfirmVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
