<HTML>
<HEAD>
<TITLE>SRC Modula-3: trestle_by_example/src/drag/Drag.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>trestle_by_example/src/drag/Drag.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>Drag</module> EXPORTS <A HREF="../../../main/src/Main.i3"><implements>Main</A></implements>;

IMPORT <A HREF="../../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../../ui/src/split/RigidVBT.i3">RigidVBT</A>, <A HREF="../../../lego/src/ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>, <A HREF="../../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../../ui/src/split/HVBar.i3">HVBar</A>;
IMPORT <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../lego/src/Shadow.i3">Shadow</A>, <A HREF="../../../lego/src/DragSwitchVBT.i3">DragSwitchVBT</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>;
FROM <A HREF="../common/Colors.i3">Colors</A> IMPORT lblue, dblue;

CONST
  shsize = 5.0;                  (* shadow size in points *)
  min    = 20.0;                 (* size of demo area in millimeters *)

TYPE
  SF = ShadowedFeedbackVBT.T;
  DS = DragSwitchVBT.T OBJECT
       OVERRIDES
         callback := Callback;
         during   := During
       END;

PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> (v: DS; READONLY cd: VBT.MouseRec) =
  BEGIN
    TextVBT.Put(display, &quot;callback called&quot;);
  END Callback;

PROCEDURE <A NAME="During"><procedure>During</procedure></A> (v: DS; READONLY cd: VBT.PositionRec) =
  VAR
    point := cd.cp.pt;
    txt := &quot;current position (&quot; &amp; Fmt.Int(point.h) &amp; &quot;,&quot; &amp; Fmt.Int(point.v)
             &amp; &quot;)&quot;;
  BEGIN
    TextVBT.Put(display, txt);
  END During;

VAR
  shadow := Shadow.New(size := shsize, light := lblue, dark := dblue);
  switch := NEW(SF).init(ch := TextVBT.New(&quot;DragSwitch&quot;), shadow := shadow);
  drag    := NEW(DS).init(switch);
  display := TextVBT.New(&quot;&quot;);
  work    := RigidVBT.FromHV(TextVBT.New(&quot;Drag Demo&quot;), 2.0 * min, min);
  main := HVSplit.Cons(
            Axis.T.Ver, drag, HVBar.New(), display, HVBar.New(), work);

BEGIN
  Trestle.Install(main);
  Trestle.AwaitDelete(main)
END Drag.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
